/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.ApplyCreditMemoRequest;
import com.zuora.model.AsyncApplyCreditMemoRequest;
import com.zuora.model.AsyncOperationResponse;
import com.zuora.model.AsyncUnapplyCreditMemoRequest;
import com.zuora.model.BillingDocumentStatus;
import com.zuora.model.BulkCreateCreditMemosRequest;
import com.zuora.model.BulkCreditMemosResponse;
import com.zuora.model.BulkUpdateCreditMemosRequest;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreateCreditMemoFromChargeRequest;
import com.zuora.model.CreateCreditMemoFromInvoiceRequest;
import com.zuora.model.CreateCreditMemoTaxationItemsRequest;
import com.zuora.model.CreditMemoItemResponse;
import com.zuora.model.CreditMemoItemsResponse;
import com.zuora.model.CreditMemoResponse;
import com.zuora.model.CreditMemosResponse;
import com.zuora.model.EmailBillingDocumentRequest;
import com.zuora.model.GetCreditMemoItemPartResponse;
import com.zuora.model.GetCreditMemoItemPartsResponse;
import com.zuora.model.GetCreditMemoPartResponse;
import com.zuora.model.GetCreditMemoPartsResponse;
import com.zuora.model.GetCreditMemoPdfStatusBatchResponse;
import com.zuora.model.GetTaxationItemsOfCreditMemoItemResponse;
import com.zuora.model.GetTaxationItemsResponse;
import com.zuora.model.InvoiceSettlementAsyncJobResponse;
import com.zuora.model.PostCreditMemoRequest;
import com.zuora.model.RefundCreditMemoRequest;
import com.zuora.model.RefundCreditMemoResponse;
import com.zuora.model.ReverseCreditMemoRequest;
import com.zuora.model.ReverseCreditMemoResponse;
import com.zuora.model.UnapplyCreditMemoRequest;
import com.zuora.model.UpdateCreditMemoRequest;
import com.zuora.model.UploadFileResponse;
import com.zuora.model.WriteOffCreditMemoRequest;
import com.zuora.model.WriteOffCreditMemoResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CreditMemosApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CreditMemosApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CreditMemosApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call applyCreditMemoCall(String creditMemoKey, ApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ApplyCreditMemoRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/apply".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyCreditMemoValidateBeforeCall(String creditMemoKey, ApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling applyCreditMemo(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applyCreditMemo(Async)");
        }
        return this.applyCreditMemoCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoResponse applyCreditMemo(String creditMemoKey, ApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoResponse> localVarResp = this.applyCreditMemoWithHttpInfo(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoResponse> applyCreditMemoWithHttpInfo(String creditMemoKey, ApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.applyCreditMemoValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call applyCreditMemoAsync(String creditMemoKey, ApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.applyCreditMemoValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ApplyCreditMemoApi applyCreditMemoApi(String creditMemoKey, ApplyCreditMemoRequest body) {
        return new ApplyCreditMemoApi(creditMemoKey, body);
    }

    private Call applyCreditMemoAsyncCall(String creditMemoKey, AsyncApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AsyncApplyCreditMemoRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/apply-async".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyCreditMemoAsyncValidateBeforeCall(String creditMemoKey, AsyncApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling applyCreditMemoAsync(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling applyCreditMemoAsync(Async)");
        }
        return this.applyCreditMemoAsyncCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected InvoiceSettlementAsyncJobResponse applyCreditMemoAsync(String creditMemoKey, AsyncApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<InvoiceSettlementAsyncJobResponse> localVarResp = this.applyCreditMemoAsyncWithHttpInfo(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<InvoiceSettlementAsyncJobResponse> applyCreditMemoAsyncWithHttpInfo(String creditMemoKey, AsyncApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.applyCreditMemoAsyncValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<InvoiceSettlementAsyncJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call applyCreditMemoAsyncAsync(String creditMemoKey, AsyncApplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<InvoiceSettlementAsyncJobResponse> _callback) throws ApiException {
        Call localVarCall = this.applyCreditMemoAsyncValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<InvoiceSettlementAsyncJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ApplyCreditMemoAsyncApi applyCreditMemoAsyncApi(String creditMemoKey, AsyncApplyCreditMemoRequest body) {
        return new ApplyCreditMemoAsyncApi(creditMemoKey, body);
    }

    private Call bulkCreateCreditMemosCall(BulkCreateCreditMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BulkCreateCreditMemosRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/bulk";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bulkCreateCreditMemosValidateBeforeCall(BulkCreateCreditMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling bulkCreateCreditMemos(Async)");
        }
        return this.bulkCreateCreditMemosCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected BulkCreditMemosResponse bulkCreateCreditMemos(BulkCreateCreditMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<BulkCreditMemosResponse> localVarResp = this.bulkCreateCreditMemosWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<BulkCreditMemosResponse> bulkCreateCreditMemosWithHttpInfo(BulkCreateCreditMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.bulkCreateCreditMemosValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BulkCreditMemosResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call bulkCreateCreditMemosAsync(BulkCreateCreditMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<BulkCreditMemosResponse> _callback) throws ApiException {
        Call localVarCall = this.bulkCreateCreditMemosValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BulkCreditMemosResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public BulkCreateCreditMemosApi bulkCreateCreditMemosApi(BulkCreateCreditMemosRequest body) {
        return new BulkCreateCreditMemosApi(body);
    }

    private Call bulkUpdateCreditMemosCall(BulkUpdateCreditMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BulkUpdateCreditMemosRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/bulk";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bulkUpdateCreditMemosValidateBeforeCall(BulkUpdateCreditMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling bulkUpdateCreditMemos(Async)");
        }
        return this.bulkUpdateCreditMemosCall(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected BulkCreditMemosResponse bulkUpdateCreditMemos(BulkUpdateCreditMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<BulkCreditMemosResponse> localVarResp = this.bulkUpdateCreditMemosWithHttpInfo(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<BulkCreditMemosResponse> bulkUpdateCreditMemosWithHttpInfo(BulkUpdateCreditMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.bulkUpdateCreditMemosValidateBeforeCall(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BulkCreditMemosResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call bulkUpdateCreditMemosAsync(BulkUpdateCreditMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<BulkCreditMemosResponse> _callback) throws ApiException {
        Call localVarCall = this.bulkUpdateCreditMemosValidateBeforeCall(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BulkCreditMemosResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public BulkUpdateCreditMemosApi bulkUpdateCreditMemosApi(BulkUpdateCreditMemosRequest body) {
        return new BulkUpdateCreditMemosApi(body);
    }

    private Call cancelAsyncCreditMemoCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/cancel-async".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelAsyncCreditMemoValidateBeforeCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling cancelAsyncCreditMemo(Async)");
        }
        return this.cancelAsyncCreditMemoCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected AsyncOperationResponse cancelAsyncCreditMemo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<AsyncOperationResponse> localVarResp = this.cancelAsyncCreditMemoWithHttpInfo(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<AsyncOperationResponse> cancelAsyncCreditMemoWithHttpInfo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelAsyncCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<AsyncOperationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelAsyncCreditMemoAsync(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<AsyncOperationResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelAsyncCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<AsyncOperationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelAsyncCreditMemoApi cancelAsyncCreditMemoApi(String creditMemoKey) {
        return new CancelAsyncCreditMemoApi(creditMemoKey);
    }

    private Call cancelCreditMemoCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/cancel".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelCreditMemoValidateBeforeCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling cancelCreditMemo(Async)");
        }
        return this.cancelCreditMemoCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoResponse cancelCreditMemo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoResponse> localVarResp = this.cancelCreditMemoWithHttpInfo(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoResponse> cancelCreditMemoWithHttpInfo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelCreditMemoAsync(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelCreditMemoApi cancelCreditMemoApi(String creditMemoKey) {
        return new CancelCreditMemoApi(creditMemoKey);
    }

    private Call createCreditMemoFromChargeCall(CreateCreditMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateCreditMemoFromChargeRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCreditMemoFromChargeValidateBeforeCall(CreateCreditMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createCreditMemoFromCharge(Async)");
        }
        return this.createCreditMemoFromChargeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoResponse createCreditMemoFromCharge(CreateCreditMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoResponse> localVarResp = this.createCreditMemoFromChargeWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoResponse> createCreditMemoFromChargeWithHttpInfo(CreateCreditMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createCreditMemoFromChargeValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createCreditMemoFromChargeAsync(CreateCreditMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.createCreditMemoFromChargeValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateCreditMemoFromChargeApi createCreditMemoFromChargeApi(CreateCreditMemoFromChargeRequest body) {
        return new CreateCreditMemoFromChargeApi(body);
    }

    private Call createCreditMemoFromInvoiceCall(String invoiceKey, CreateCreditMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateCreditMemoFromInvoiceRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/invoice/{invoiceKey}".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCreditMemoFromInvoiceValidateBeforeCall(String invoiceKey, CreateCreditMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling createCreditMemoFromInvoice(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createCreditMemoFromInvoice(Async)");
        }
        return this.createCreditMemoFromInvoiceCall(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoResponse createCreditMemoFromInvoice(String invoiceKey, CreateCreditMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoResponse> localVarResp = this.createCreditMemoFromInvoiceWithHttpInfo(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoResponse> createCreditMemoFromInvoiceWithHttpInfo(String invoiceKey, CreateCreditMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createCreditMemoFromInvoiceValidateBeforeCall(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createCreditMemoFromInvoiceAsync(String invoiceKey, CreateCreditMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.createCreditMemoFromInvoiceValidateBeforeCall(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateCreditMemoFromInvoiceApi createCreditMemoFromInvoiceApi(String invoiceKey, CreateCreditMemoFromInvoiceRequest body) {
        return new CreateCreditMemoFromInvoiceApi(invoiceKey, body);
    }

    private Call createCreditMemoTaxationItemsCall(String creditMemoKey, CreateCreditMemoTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateCreditMemoTaxationItemsRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/taxation-items".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCreditMemoTaxationItemsValidateBeforeCall(String creditMemoKey, CreateCreditMemoTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling createCreditMemoTaxationItems(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createCreditMemoTaxationItems(Async)");
        }
        return this.createCreditMemoTaxationItemsCall(creditMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetTaxationItemsResponse createCreditMemoTaxationItems(String creditMemoKey, CreateCreditMemoTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetTaxationItemsResponse> localVarResp = this.createCreditMemoTaxationItemsWithHttpInfo(creditMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetTaxationItemsResponse> createCreditMemoTaxationItemsWithHttpInfo(String creditMemoKey, CreateCreditMemoTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createCreditMemoTaxationItemsValidateBeforeCall(creditMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetTaxationItemsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createCreditMemoTaxationItemsAsync(String creditMemoKey, CreateCreditMemoTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetTaxationItemsResponse> _callback) throws ApiException {
        Call localVarCall = this.createCreditMemoTaxationItemsValidateBeforeCall(creditMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetTaxationItemsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateCreditMemoTaxationItemsApi createCreditMemoTaxationItemsApi(String creditMemoKey, CreateCreditMemoTaxationItemsRequest body) {
        return new CreateCreditMemoTaxationItemsApi(creditMemoKey, body);
    }

    private Call deleteCreditMemoCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCreditMemoValidateBeforeCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling deleteCreditMemo(Async)");
        }
        return this.deleteCreditMemoCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse deleteCreditMemo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.deleteCreditMemoWithHttpInfo(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> deleteCreditMemoWithHttpInfo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call deleteCreditMemoAsync(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteCreditMemoApi deleteCreditMemoApi(String creditMemoKey) {
        return new DeleteCreditMemoApi(creditMemoKey);
    }

    private Call emailCreditMemoCall(String creditMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EmailBillingDocumentRequest localVarPostBody = request;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/emails".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call emailCreditMemoValidateBeforeCall(String creditMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling emailCreditMemo(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling emailCreditMemo(Async)");
        }
        return this.emailCreditMemoCall(creditMemoKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse emailCreditMemo(String creditMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.emailCreditMemoWithHttpInfo(creditMemoKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> emailCreditMemoWithHttpInfo(String creditMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.emailCreditMemoValidateBeforeCall(creditMemoKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call emailCreditMemoAsync(String creditMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.emailCreditMemoValidateBeforeCall(creditMemoKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public EmailCreditMemoApi emailCreditMemoApi(String creditMemoKey, EmailBillingDocumentRequest request) {
        return new EmailCreditMemoApi(creditMemoKey, request);
    }

    private Call generateCreditMemoPdfCall(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/pdfs".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call generateCreditMemoPdfValidateBeforeCall(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling generateCreditMemoPdf(Async)");
        }
        return this.generateCreditMemoPdfCall(creditMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse generateCreditMemoPdf(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.generateCreditMemoPdfWithHttpInfo(creditMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> generateCreditMemoPdfWithHttpInfo(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.generateCreditMemoPdfValidateBeforeCall(creditMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call generateCreditMemoPdfAsync(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.generateCreditMemoPdfValidateBeforeCall(creditMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GenerateCreditMemoPdfApi generateCreditMemoPdfApi(String creditMemoKey) {
        return new GenerateCreditMemoPdfApi(creditMemoKey);
    }

    private Call getApplyCreditMemoAsyncJobCall(String applyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/apply-async-jobs/{applyAsyncJobId}".replace("{applyAsyncJobId}", this.localVarApiClient.escapeString(applyAsyncJobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getApplyCreditMemoAsyncJobValidateBeforeCall(String applyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (applyAsyncJobId == null) {
            throw new ApiException("Missing the required parameter 'applyAsyncJobId' when calling getApplyCreditMemoAsyncJob(Async)");
        }
        return this.getApplyCreditMemoAsyncJobCall(applyAsyncJobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected InvoiceSettlementAsyncJobResponse getApplyCreditMemoAsyncJob(String applyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<InvoiceSettlementAsyncJobResponse> localVarResp = this.getApplyCreditMemoAsyncJobWithHttpInfo(applyAsyncJobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<InvoiceSettlementAsyncJobResponse> getApplyCreditMemoAsyncJobWithHttpInfo(String applyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getApplyCreditMemoAsyncJobValidateBeforeCall(applyAsyncJobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<InvoiceSettlementAsyncJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getApplyCreditMemoAsyncJobAsync(String applyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<InvoiceSettlementAsyncJobResponse> _callback) throws ApiException {
        Call localVarCall = this.getApplyCreditMemoAsyncJobValidateBeforeCall(applyAsyncJobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<InvoiceSettlementAsyncJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetApplyCreditMemoAsyncJobApi getApplyCreditMemoAsyncJobApi(String applyAsyncJobId) {
        return new GetApplyCreditMemoAsyncJobApi(applyAsyncJobId);
    }

    private Call getCreditMemoCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoValidateBeforeCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling getCreditMemo(Async)");
        }
        return this.getCreditMemoCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoResponse getCreditMemo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoResponse> localVarResp = this.getCreditMemoWithHttpInfo(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoResponse> getCreditMemoWithHttpInfo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoAsync(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoApi getCreditMemoApi(String creditMemoKey) {
        return new GetCreditMemoApi(creditMemoKey);
    }

    private Call getCreditMemoItemCall(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/items/{creditMemoItemId}".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString())).replace("{creditMemoItemId}", this.localVarApiClient.escapeString(creditMemoItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoItemValidateBeforeCall(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling getCreditMemoItem(Async)");
        }
        if (creditMemoItemId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoItemId' when calling getCreditMemoItem(Async)");
        }
        return this.getCreditMemoItemCall(creditMemoKey, creditMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoItemResponse getCreditMemoItem(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoItemResponse> localVarResp = this.getCreditMemoItemWithHttpInfo(creditMemoKey, creditMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoItemResponse> getCreditMemoItemWithHttpInfo(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoItemValidateBeforeCall(creditMemoKey, creditMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoItemResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoItemAsync(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoItemResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoItemValidateBeforeCall(creditMemoKey, creditMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoItemApi getCreditMemoItemApi(String creditMemoKey, String creditMemoItemId) {
        return new GetCreditMemoItemApi(creditMemoKey, creditMemoItemId);
    }

    private Call getCreditMemoItemPartCall(String partId, String itemPartId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/parts/{partId}/item-parts/{itemPartId}".replace("{partId}", this.localVarApiClient.escapeString(partId.toString())).replace("{itemPartId}", this.localVarApiClient.escapeString(itemPartId.toString())).replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoItemPartValidateBeforeCall(String partId, String itemPartId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (partId == null) {
            throw new ApiException("Missing the required parameter 'partId' when calling getCreditMemoItemPart(Async)");
        }
        if (itemPartId == null) {
            throw new ApiException("Missing the required parameter 'itemPartId' when calling getCreditMemoItemPart(Async)");
        }
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling getCreditMemoItemPart(Async)");
        }
        return this.getCreditMemoItemPartCall(partId, itemPartId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetCreditMemoItemPartResponse getCreditMemoItemPart(String partId, String itemPartId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetCreditMemoItemPartResponse> localVarResp = this.getCreditMemoItemPartWithHttpInfo(partId, itemPartId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetCreditMemoItemPartResponse> getCreditMemoItemPartWithHttpInfo(String partId, String itemPartId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoItemPartValidateBeforeCall(partId, itemPartId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetCreditMemoItemPartResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoItemPartAsync(String partId, String itemPartId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetCreditMemoItemPartResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoItemPartValidateBeforeCall(partId, itemPartId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetCreditMemoItemPartResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoItemPartApi getCreditMemoItemPartApi(String partId, String itemPartId, String creditMemoKey) {
        return new GetCreditMemoItemPartApi(partId, itemPartId, creditMemoKey);
    }

    private Call getCreditMemoItemPartsCall(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/parts/{partId}/item-parts".replace("{partId}", this.localVarApiClient.escapeString(partId.toString())).replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoItemPartsValidateBeforeCall(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (partId == null) {
            throw new ApiException("Missing the required parameter 'partId' when calling getCreditMemoItemParts(Async)");
        }
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling getCreditMemoItemParts(Async)");
        }
        return this.getCreditMemoItemPartsCall(partId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetCreditMemoItemPartsResponse getCreditMemoItemParts(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetCreditMemoItemPartsResponse> localVarResp = this.getCreditMemoItemPartsWithHttpInfo(partId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetCreditMemoItemPartsResponse> getCreditMemoItemPartsWithHttpInfo(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoItemPartsValidateBeforeCall(partId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetCreditMemoItemPartsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoItemPartsAsync(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetCreditMemoItemPartsResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoItemPartsValidateBeforeCall(partId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetCreditMemoItemPartsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoItemPartsApi getCreditMemoItemPartsApi(String partId, String creditMemoKey) {
        return new GetCreditMemoItemPartsApi(partId, creditMemoKey);
    }

    private Call getCreditMemoItemsCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal appliedAmount, String createdById, OffsetDateTime createdDate, String id, BigDecimal refundAmount, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/items".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (appliedAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("appliedAmount", appliedAmount));
        }
        if (createdById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdById", createdById));
        }
        if (createdDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdDate", createdDate));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (refundAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("refundAmount", refundAmount));
        }
        if (serviceEndDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("serviceEndDate", serviceEndDate));
        }
        if (serviceStartDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("serviceStartDate", serviceStartDate));
        }
        if (sku != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sku", sku));
        }
        if (skuName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skuName", skuName));
        }
        if (sourceItemId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sourceItemId", sourceItemId));
        }
        if (subscriptionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subscriptionId", subscriptionId));
        }
        if (updatedById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedById", updatedById));
        }
        if (updatedDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedDate", updatedDate));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoItemsValidateBeforeCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal appliedAmount, String createdById, OffsetDateTime createdDate, String id, BigDecimal refundAmount, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling getCreditMemoItems(Async)");
        }
        return this.getCreditMemoItemsCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, amount, appliedAmount, createdById, createdDate, id, refundAmount, serviceEndDate, serviceStartDate, sku, skuName, sourceItemId, subscriptionId, updatedById, updatedDate, sort, zuoraOrgIds, _callback);
    }

    protected CreditMemoItemsResponse getCreditMemoItems(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal appliedAmount, String createdById, OffsetDateTime createdDate, String id, BigDecimal refundAmount, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoItemsResponse> localVarResp = this.getCreditMemoItemsWithHttpInfo(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, amount, appliedAmount, createdById, createdDate, id, refundAmount, serviceEndDate, serviceStartDate, sku, skuName, sourceItemId, subscriptionId, updatedById, updatedDate, sort, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoItemsResponse> getCreditMemoItemsWithHttpInfo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal appliedAmount, String createdById, OffsetDateTime createdDate, String id, BigDecimal refundAmount, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoItemsValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, amount, appliedAmount, createdById, createdDate, id, refundAmount, serviceEndDate, serviceStartDate, sku, skuName, sourceItemId, subscriptionId, updatedById, updatedDate, sort, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoItemsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoItemsAsync(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal appliedAmount, String createdById, OffsetDateTime createdDate, String id, BigDecimal refundAmount, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraOrgIds, ApiCallback<CreditMemoItemsResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoItemsValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, amount, appliedAmount, createdById, createdDate, id, refundAmount, serviceEndDate, serviceStartDate, sku, skuName, sourceItemId, subscriptionId, updatedById, updatedDate, sort, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoItemsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoItemsApi getCreditMemoItemsApi(String creditMemoKey) {
        return new GetCreditMemoItemsApi(creditMemoKey);
    }

    private Call getCreditMemoPartCall(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/parts/{partId}".replace("{partId}", this.localVarApiClient.escapeString(partId.toString())).replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoPartValidateBeforeCall(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (partId == null) {
            throw new ApiException("Missing the required parameter 'partId' when calling getCreditMemoPart(Async)");
        }
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling getCreditMemoPart(Async)");
        }
        return this.getCreditMemoPartCall(partId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetCreditMemoPartResponse getCreditMemoPart(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetCreditMemoPartResponse> localVarResp = this.getCreditMemoPartWithHttpInfo(partId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetCreditMemoPartResponse> getCreditMemoPartWithHttpInfo(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoPartValidateBeforeCall(partId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetCreditMemoPartResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoPartAsync(String partId, String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetCreditMemoPartResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoPartValidateBeforeCall(partId, creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetCreditMemoPartResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoPartApi getCreditMemoPartApi(String partId, String creditMemoKey) {
        return new GetCreditMemoPartApi(partId, creditMemoKey);
    }

    private Call getCreditMemoPartsCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/parts".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoPartsValidateBeforeCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling getCreditMemoParts(Async)");
        }
        return this.getCreditMemoPartsCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetCreditMemoPartsResponse getCreditMemoParts(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetCreditMemoPartsResponse> localVarResp = this.getCreditMemoPartsWithHttpInfo(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetCreditMemoPartsResponse> getCreditMemoPartsWithHttpInfo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoPartsValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetCreditMemoPartsResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoPartsAsync(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetCreditMemoPartsResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoPartsValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetCreditMemoPartsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoPartsApi getCreditMemoPartsApi(String creditMemoKey) {
        return new GetCreditMemoPartsApi(creditMemoKey);
    }

    private Call getCreditMemoPdfStatusCall(String creditMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/pdf-status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (creditMemoKeys != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("creditMemoKeys", creditMemoKeys));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemoPdfStatusValidateBeforeCall(String creditMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKeys == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKeys' when calling getCreditMemoPdfStatus(Async)");
        }
        return this.getCreditMemoPdfStatusCall(creditMemoKeys, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetCreditMemoPdfStatusBatchResponse getCreditMemoPdfStatus(String creditMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetCreditMemoPdfStatusBatchResponse> localVarResp = this.getCreditMemoPdfStatusWithHttpInfo(creditMemoKeys, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetCreditMemoPdfStatusBatchResponse> getCreditMemoPdfStatusWithHttpInfo(String creditMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemoPdfStatusValidateBeforeCall(creditMemoKeys, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetCreditMemoPdfStatusBatchResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemoPdfStatusAsync(String creditMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetCreditMemoPdfStatusBatchResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemoPdfStatusValidateBeforeCall(creditMemoKeys, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetCreditMemoPdfStatusBatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemoPdfStatusApi getCreditMemoPdfStatusApi(String creditMemoKeys) {
        return new GetCreditMemoPdfStatusApi(creditMemoKeys);
    }

    private Call getCreditMemosCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal appliedAmount, Boolean autoApplyUponPosting, String createdById, String createdDate, LocalDate creditMemoDate, String currency, Boolean excludeFromAutoApplyRules, String number, String referredInvoiceId, BigDecimal refundAmount, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String transferredToAccounting, BigDecimal unappliedAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (accountId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("accountId", accountId));
        }
        if (accountNumber != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("accountNumber", accountNumber));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (appliedAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("appliedAmount", appliedAmount));
        }
        if (autoApplyUponPosting != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("autoApplyUponPosting", autoApplyUponPosting));
        }
        if (createdById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdById", createdById));
        }
        if (createdDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdDate", createdDate));
        }
        if (creditMemoDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("creditMemoDate", creditMemoDate));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (excludeFromAutoApplyRules != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("excludeFromAutoApplyRules", excludeFromAutoApplyRules));
        }
        if (number != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("number", number));
        }
        if (referredInvoiceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("referredInvoiceId", referredInvoiceId));
        }
        if (refundAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("refundAmount", refundAmount));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", (Object)status));
        }
        if (targetDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("targetDate", targetDate));
        }
        if (taxAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taxAmount", taxAmount));
        }
        if (totalTaxExemptAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("totalTaxExemptAmount", totalTaxExemptAmount));
        }
        if (transferredToAccounting != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("transferredToAccounting", transferredToAccounting));
        }
        if (unappliedAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("unappliedAmount", unappliedAmount));
        }
        if (updatedById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedById", updatedById));
        }
        if (updatedDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedDate", updatedDate));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCreditMemosValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal appliedAmount, Boolean autoApplyUponPosting, String createdById, String createdDate, LocalDate creditMemoDate, String currency, Boolean excludeFromAutoApplyRules, String number, String referredInvoiceId, BigDecimal refundAmount, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String transferredToAccounting, BigDecimal unappliedAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getCreditMemosCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, accountId, accountNumber, amount, appliedAmount, autoApplyUponPosting, createdById, createdDate, creditMemoDate, currency, excludeFromAutoApplyRules, number, referredInvoiceId, refundAmount, status, targetDate, taxAmount, totalTaxExemptAmount, transferredToAccounting, unappliedAmount, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemosResponse getCreditMemos(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal appliedAmount, Boolean autoApplyUponPosting, String createdById, String createdDate, LocalDate creditMemoDate, String currency, Boolean excludeFromAutoApplyRules, String number, String referredInvoiceId, BigDecimal refundAmount, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String transferredToAccounting, BigDecimal unappliedAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemosResponse> localVarResp = this.getCreditMemosWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, accountId, accountNumber, amount, appliedAmount, autoApplyUponPosting, createdById, createdDate, creditMemoDate, currency, excludeFromAutoApplyRules, number, referredInvoiceId, refundAmount, status, targetDate, taxAmount, totalTaxExemptAmount, transferredToAccounting, unappliedAmount, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemosResponse> getCreditMemosWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal appliedAmount, Boolean autoApplyUponPosting, String createdById, String createdDate, LocalDate creditMemoDate, String currency, Boolean excludeFromAutoApplyRules, String number, String referredInvoiceId, BigDecimal refundAmount, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String transferredToAccounting, BigDecimal unappliedAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getCreditMemosValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, accountId, accountNumber, amount, appliedAmount, autoApplyUponPosting, createdById, createdDate, creditMemoDate, currency, excludeFromAutoApplyRules, number, referredInvoiceId, refundAmount, status, targetDate, taxAmount, totalTaxExemptAmount, transferredToAccounting, unappliedAmount, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemosResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getCreditMemosAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal appliedAmount, Boolean autoApplyUponPosting, String createdById, String createdDate, LocalDate creditMemoDate, String currency, Boolean excludeFromAutoApplyRules, String number, String referredInvoiceId, BigDecimal refundAmount, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String transferredToAccounting, BigDecimal unappliedAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemosResponse> _callback) throws ApiException {
        Call localVarCall = this.getCreditMemosValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, accountId, accountNumber, amount, appliedAmount, autoApplyUponPosting, createdById, createdDate, creditMemoDate, currency, excludeFromAutoApplyRules, number, referredInvoiceId, refundAmount, status, targetDate, taxAmount, totalTaxExemptAmount, transferredToAccounting, unappliedAmount, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemosResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCreditMemosApi getCreditMemosApi() {
        return new GetCreditMemosApi();
    }

    private Call getTaxationItemsOfCreditMemoItemCall(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/items/{creditMemoItemId}/taxation-items".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString())).replace("{creditMemoItemId}", this.localVarApiClient.escapeString(creditMemoItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTaxationItemsOfCreditMemoItemValidateBeforeCall(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling getTaxationItemsOfCreditMemoItem(Async)");
        }
        if (creditMemoItemId == null) {
            throw new ApiException("Missing the required parameter 'creditMemoItemId' when calling getTaxationItemsOfCreditMemoItem(Async)");
        }
        return this.getTaxationItemsOfCreditMemoItemCall(creditMemoKey, creditMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetTaxationItemsOfCreditMemoItemResponse getTaxationItemsOfCreditMemoItem(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetTaxationItemsOfCreditMemoItemResponse> localVarResp = this.getTaxationItemsOfCreditMemoItemWithHttpInfo(creditMemoKey, creditMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetTaxationItemsOfCreditMemoItemResponse> getTaxationItemsOfCreditMemoItemWithHttpInfo(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getTaxationItemsOfCreditMemoItemValidateBeforeCall(creditMemoKey, creditMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetTaxationItemsOfCreditMemoItemResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getTaxationItemsOfCreditMemoItemAsync(String creditMemoKey, String creditMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetTaxationItemsOfCreditMemoItemResponse> _callback) throws ApiException {
        Call localVarCall = this.getTaxationItemsOfCreditMemoItemValidateBeforeCall(creditMemoKey, creditMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetTaxationItemsOfCreditMemoItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetTaxationItemsOfCreditMemoItemApi getTaxationItemsOfCreditMemoItemApi(String creditMemoKey, String creditMemoItemId) {
        return new GetTaxationItemsOfCreditMemoItemApi(creditMemoKey, creditMemoItemId);
    }

    private Call getUnapplyCreditMemoAsyncJobCall(String unapplyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/unapply-async-jobs/{unapplyAsyncJobId}".replace("{unapplyAsyncJobId}", this.localVarApiClient.escapeString(unapplyAsyncJobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnapplyCreditMemoAsyncJobValidateBeforeCall(String unapplyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (unapplyAsyncJobId == null) {
            throw new ApiException("Missing the required parameter 'unapplyAsyncJobId' when calling getUnapplyCreditMemoAsyncJob(Async)");
        }
        return this.getUnapplyCreditMemoAsyncJobCall(unapplyAsyncJobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected InvoiceSettlementAsyncJobResponse getUnapplyCreditMemoAsyncJob(String unapplyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<InvoiceSettlementAsyncJobResponse> localVarResp = this.getUnapplyCreditMemoAsyncJobWithHttpInfo(unapplyAsyncJobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<InvoiceSettlementAsyncJobResponse> getUnapplyCreditMemoAsyncJobWithHttpInfo(String unapplyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getUnapplyCreditMemoAsyncJobValidateBeforeCall(unapplyAsyncJobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<InvoiceSettlementAsyncJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getUnapplyCreditMemoAsyncJobAsync(String unapplyAsyncJobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<InvoiceSettlementAsyncJobResponse> _callback) throws ApiException {
        Call localVarCall = this.getUnapplyCreditMemoAsyncJobValidateBeforeCall(unapplyAsyncJobId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<InvoiceSettlementAsyncJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetUnapplyCreditMemoAsyncJobApi getUnapplyCreditMemoAsyncJobApi(String unapplyAsyncJobId) {
        return new GetUnapplyCreditMemoAsyncJobApi(unapplyAsyncJobId);
    }

    private Call postAsyncCreditMemoCall(String creditMemoKey, PostCreditMemoRequest postCreditMemoRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostCreditMemoRequest localVarPostBody = postCreditMemoRequest;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/post-async".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postAsyncCreditMemoValidateBeforeCall(String creditMemoKey, PostCreditMemoRequest postCreditMemoRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling postAsyncCreditMemo(Async)");
        }
        if (postCreditMemoRequest == null) {
            throw new ApiException("Missing the required parameter 'postCreditMemoRequest' when calling postAsyncCreditMemo(Async)");
        }
        return this.postAsyncCreditMemoCall(creditMemoKey, postCreditMemoRequest, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected AsyncOperationResponse postAsyncCreditMemo(String creditMemoKey, PostCreditMemoRequest postCreditMemoRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<AsyncOperationResponse> localVarResp = this.postAsyncCreditMemoWithHttpInfo(creditMemoKey, postCreditMemoRequest, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<AsyncOperationResponse> postAsyncCreditMemoWithHttpInfo(String creditMemoKey, PostCreditMemoRequest postCreditMemoRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postAsyncCreditMemoValidateBeforeCall(creditMemoKey, postCreditMemoRequest, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<AsyncOperationResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call postAsyncCreditMemoAsync(String creditMemoKey, PostCreditMemoRequest postCreditMemoRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<AsyncOperationResponse> _callback) throws ApiException {
        Call localVarCall = this.postAsyncCreditMemoValidateBeforeCall(creditMemoKey, postCreditMemoRequest, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<AsyncOperationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostAsyncCreditMemoApi postAsyncCreditMemoApi(String creditMemoKey, PostCreditMemoRequest postCreditMemoRequest) {
        return new PostAsyncCreditMemoApi(creditMemoKey, postCreditMemoRequest);
    }

    private Call postCreditMemoCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/post".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postCreditMemoValidateBeforeCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling postCreditMemo(Async)");
        }
        return this.postCreditMemoCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoResponse postCreditMemo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoResponse> localVarResp = this.postCreditMemoWithHttpInfo(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoResponse> postCreditMemoWithHttpInfo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call postCreditMemoAsync(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.postCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostCreditMemoApi postCreditMemoApi(String creditMemoKey) {
        return new PostCreditMemoApi(creditMemoKey);
    }

    private Call refundCreditMemoCall(String creditMemoKey, RefundCreditMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RefundCreditMemoRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/refund".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call refundCreditMemoValidateBeforeCall(String creditMemoKey, RefundCreditMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling refundCreditMemo(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling refundCreditMemo(Async)");
        }
        return this.refundCreditMemoCall(creditMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected RefundCreditMemoResponse refundCreditMemo(String creditMemoKey, RefundCreditMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<RefundCreditMemoResponse> localVarResp = this.refundCreditMemoWithHttpInfo(creditMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<RefundCreditMemoResponse> refundCreditMemoWithHttpInfo(String creditMemoKey, RefundCreditMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.refundCreditMemoValidateBeforeCall(creditMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<RefundCreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call refundCreditMemoAsync(String creditMemoKey, RefundCreditMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<RefundCreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.refundCreditMemoValidateBeforeCall(creditMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<RefundCreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RefundCreditMemoApi refundCreditMemoApi(String creditMemoKey, RefundCreditMemoRequest body) {
        return new RefundCreditMemoApi(creditMemoKey, body);
    }

    private Call reverseCreditMemoCall(String creditMemoKey, ReverseCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ReverseCreditMemoRequest localVarPostBody = request;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/reverse".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call reverseCreditMemoValidateBeforeCall(String creditMemoKey, ReverseCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling reverseCreditMemo(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling reverseCreditMemo(Async)");
        }
        return this.reverseCreditMemoCall(creditMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected ReverseCreditMemoResponse reverseCreditMemo(String creditMemoKey, ReverseCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<ReverseCreditMemoResponse> localVarResp = this.reverseCreditMemoWithHttpInfo(creditMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<ReverseCreditMemoResponse> reverseCreditMemoWithHttpInfo(String creditMemoKey, ReverseCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.reverseCreditMemoValidateBeforeCall(creditMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<ReverseCreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call reverseCreditMemoAsync(String creditMemoKey, ReverseCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<ReverseCreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.reverseCreditMemoValidateBeforeCall(creditMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ReverseCreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ReverseCreditMemoApi reverseCreditMemoApi(String creditMemoKey, ReverseCreditMemoRequest request) {
        return new ReverseCreditMemoApi(creditMemoKey, request);
    }

    private Call unapplyCreditMemoCall(String creditMemoKey, UnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UnapplyCreditMemoRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/unapply".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unapplyCreditMemoValidateBeforeCall(String creditMemoKey, UnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling unapplyCreditMemo(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unapplyCreditMemo(Async)");
        }
        return this.unapplyCreditMemoCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoResponse unapplyCreditMemo(String creditMemoKey, UnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoResponse> localVarResp = this.unapplyCreditMemoWithHttpInfo(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoResponse> unapplyCreditMemoWithHttpInfo(String creditMemoKey, UnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unapplyCreditMemoValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call unapplyCreditMemoAsync(String creditMemoKey, UnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.unapplyCreditMemoValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnapplyCreditMemoApi unapplyCreditMemoApi(String creditMemoKey, UnapplyCreditMemoRequest body) {
        return new UnapplyCreditMemoApi(creditMemoKey, body);
    }

    private Call unapplyCreditMemoAsyncCall(String creditMemoKey, AsyncUnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AsyncUnapplyCreditMemoRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/unapply-async".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unapplyCreditMemoAsyncValidateBeforeCall(String creditMemoKey, AsyncUnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling unapplyCreditMemoAsync(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling unapplyCreditMemoAsync(Async)");
        }
        return this.unapplyCreditMemoAsyncCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected InvoiceSettlementAsyncJobResponse unapplyCreditMemoAsync(String creditMemoKey, AsyncUnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<InvoiceSettlementAsyncJobResponse> localVarResp = this.unapplyCreditMemoAsyncWithHttpInfo(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<InvoiceSettlementAsyncJobResponse> unapplyCreditMemoAsyncWithHttpInfo(String creditMemoKey, AsyncUnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unapplyCreditMemoAsyncValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<InvoiceSettlementAsyncJobResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call unapplyCreditMemoAsyncAsync(String creditMemoKey, AsyncUnapplyCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<InvoiceSettlementAsyncJobResponse> _callback) throws ApiException {
        Call localVarCall = this.unapplyCreditMemoAsyncValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<InvoiceSettlementAsyncJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnapplyCreditMemoAsyncApi unapplyCreditMemoAsyncApi(String creditMemoKey, AsyncUnapplyCreditMemoRequest body) {
        return new UnapplyCreditMemoAsyncApi(creditMemoKey, body);
    }

    private Call unpostCreditMemoCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/unpost".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unpostCreditMemoValidateBeforeCall(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling unpostCreditMemo(Async)");
        }
        return this.unpostCreditMemoCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoResponse unpostCreditMemo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoResponse> localVarResp = this.unpostCreditMemoWithHttpInfo(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoResponse> unpostCreditMemoWithHttpInfo(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unpostCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call unpostCreditMemoAsync(String creditMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.unpostCreditMemoValidateBeforeCall(creditMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnpostCreditMemoApi unpostCreditMemoApi(String creditMemoKey) {
        return new UnpostCreditMemoApi(creditMemoKey);
    }

    private Call updateCreditMemoCall(String creditMemoKey, UpdateCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateCreditMemoRequest localVarPostBody = body;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateCreditMemoValidateBeforeCall(String creditMemoKey, UpdateCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling updateCreditMemo(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateCreditMemo(Async)");
        }
        return this.updateCreditMemoCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreditMemoResponse updateCreditMemo(String creditMemoKey, UpdateCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreditMemoResponse> localVarResp = this.updateCreditMemoWithHttpInfo(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreditMemoResponse> updateCreditMemoWithHttpInfo(String creditMemoKey, UpdateCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateCreditMemoValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateCreditMemoAsync(String creditMemoKey, UpdateCreditMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.updateCreditMemoValidateBeforeCall(creditMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateCreditMemoApi updateCreditMemoApi(String creditMemoKey, UpdateCreditMemoRequest body) {
        return new UpdateCreditMemoApi(creditMemoKey, body);
    }

    private Call uploadFileForCreditMemoCall(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/files".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadFileForCreditMemoValidateBeforeCall(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling uploadFileForCreditMemo(Async)");
        }
        return this.uploadFileForCreditMemoCall(creditMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _file, _callback);
    }

    protected UploadFileResponse uploadFileForCreditMemo(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file) throws ApiException {
        ApiResponse<UploadFileResponse> localVarResp = this.uploadFileForCreditMemoWithHttpInfo(creditMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _file);
        return localVarResp.getData();
    }

    private ApiResponse<UploadFileResponse> uploadFileForCreditMemoWithHttpInfo(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file) throws ApiException {
        Call localVarCall = this.uploadFileForCreditMemoValidateBeforeCall(creditMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _file, null);
        try {
            Type localVarReturnType = new TypeToken<UploadFileResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call uploadFileForCreditMemoAsync(String creditMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file, ApiCallback<UploadFileResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadFileForCreditMemoValidateBeforeCall(creditMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _file, _callback);
        Type localVarReturnType = new TypeToken<UploadFileResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UploadFileForCreditMemoApi uploadFileForCreditMemoApi(String creditMemoKey) {
        return new UploadFileForCreditMemoApi(creditMemoKey);
    }

    private Call writeOffCreditMemoCall(String creditMemoKey, WriteOffCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WriteOffCreditMemoRequest localVarPostBody = request;
        String localVarPath = "/v1/credit-memos/{creditMemoKey}/write-off".replace("{creditMemoKey}", this.localVarApiClient.escapeString(creditMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call writeOffCreditMemoValidateBeforeCall(String creditMemoKey, WriteOffCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (creditMemoKey == null) {
            throw new ApiException("Missing the required parameter 'creditMemoKey' when calling writeOffCreditMemo(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling writeOffCreditMemo(Async)");
        }
        return this.writeOffCreditMemoCall(creditMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected WriteOffCreditMemoResponse writeOffCreditMemo(String creditMemoKey, WriteOffCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<WriteOffCreditMemoResponse> localVarResp = this.writeOffCreditMemoWithHttpInfo(creditMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<WriteOffCreditMemoResponse> writeOffCreditMemoWithHttpInfo(String creditMemoKey, WriteOffCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.writeOffCreditMemoValidateBeforeCall(creditMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<WriteOffCreditMemoResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call writeOffCreditMemoAsync(String creditMemoKey, WriteOffCreditMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<WriteOffCreditMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.writeOffCreditMemoValidateBeforeCall(creditMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<WriteOffCreditMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public WriteOffCreditMemoApi writeOffCreditMemoApi(String creditMemoKey, WriteOffCreditMemoRequest request) {
        return new WriteOffCreditMemoApi(creditMemoKey, request);
    }

    public class WriteOffCreditMemoApi {
        private final String creditMemoKey;
        private final WriteOffCreditMemoRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private WriteOffCreditMemoApi(String creditMemoKey, WriteOffCreditMemoRequest request) {
            this.creditMemoKey = creditMemoKey;
            this.request = request;
        }

        public WriteOffCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public WriteOffCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public WriteOffCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public WriteOffCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public WriteOffCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public WriteOffCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public WriteOffCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.writeOffCreditMemoCall(this.creditMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public WriteOffCreditMemoResponse execute() throws ApiException {
            ApiResponse<WriteOffCreditMemoResponse> localVarResp = CreditMemosApi.this.writeOffCreditMemoWithHttpInfo(this.creditMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<WriteOffCreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.writeOffCreditMemoWithHttpInfo(this.creditMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<WriteOffCreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.writeOffCreditMemoAsync(this.creditMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UploadFileForCreditMemoApi {
        private final String creditMemoKey;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private File _file;

        private UploadFileForCreditMemoApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public UploadFileForCreditMemoApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public UploadFileForCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UploadFileForCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UploadFileForCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UploadFileForCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UploadFileForCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UploadFileForCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UploadFileForCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public UploadFileForCreditMemoApi _file(File _file) {
            this._file = _file;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.uploadFileForCreditMemoCall(this.creditMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this._file, _callback);
        }

        public UploadFileResponse execute() throws ApiException {
            ApiResponse<UploadFileResponse> localVarResp = CreditMemosApi.this.uploadFileForCreditMemoWithHttpInfo(this.creditMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this._file);
            return localVarResp.getData();
        }

        public ApiResponse<UploadFileResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.uploadFileForCreditMemoWithHttpInfo(this.creditMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this._file);
        }

        public Call executeAsync(ApiCallback<UploadFileResponse> _callback) throws ApiException {
            return CreditMemosApi.this.uploadFileForCreditMemoAsync(this.creditMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this._file, _callback);
        }
    }

    public class UpdateCreditMemoApi {
        private final String creditMemoKey;
        private final UpdateCreditMemoRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateCreditMemoApi(String creditMemoKey, UpdateCreditMemoRequest body) {
            this.creditMemoKey = creditMemoKey;
            this.body = body;
        }

        public UpdateCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.updateCreditMemoCall(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoResponse execute() throws ApiException {
            ApiResponse<CreditMemoResponse> localVarResp = CreditMemosApi.this.updateCreditMemoWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.updateCreditMemoWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.updateCreditMemoAsync(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UnpostCreditMemoApi {
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UnpostCreditMemoApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public UnpostCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UnpostCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UnpostCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UnpostCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UnpostCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UnpostCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UnpostCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.unpostCreditMemoCall(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoResponse execute() throws ApiException {
            ApiResponse<CreditMemoResponse> localVarResp = CreditMemosApi.this.unpostCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.unpostCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.unpostCreditMemoAsync(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UnapplyCreditMemoAsyncApi {
        private final String creditMemoKey;
        private final AsyncUnapplyCreditMemoRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UnapplyCreditMemoAsyncApi(String creditMemoKey, AsyncUnapplyCreditMemoRequest body) {
            this.creditMemoKey = creditMemoKey;
            this.body = body;
        }

        public UnapplyCreditMemoAsyncApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UnapplyCreditMemoAsyncApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UnapplyCreditMemoAsyncApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UnapplyCreditMemoAsyncApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UnapplyCreditMemoAsyncApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UnapplyCreditMemoAsyncApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UnapplyCreditMemoAsyncApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.unapplyCreditMemoAsyncCall(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public InvoiceSettlementAsyncJobResponse execute() throws ApiException {
            ApiResponse<InvoiceSettlementAsyncJobResponse> localVarResp = CreditMemosApi.this.unapplyCreditMemoAsyncWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<InvoiceSettlementAsyncJobResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.unapplyCreditMemoAsyncWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<InvoiceSettlementAsyncJobResponse> _callback) throws ApiException {
            return CreditMemosApi.this.unapplyCreditMemoAsyncAsync(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UnapplyCreditMemoApi {
        private final String creditMemoKey;
        private final UnapplyCreditMemoRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UnapplyCreditMemoApi(String creditMemoKey, UnapplyCreditMemoRequest body) {
            this.creditMemoKey = creditMemoKey;
            this.body = body;
        }

        public UnapplyCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UnapplyCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UnapplyCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UnapplyCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UnapplyCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UnapplyCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UnapplyCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.unapplyCreditMemoCall(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoResponse execute() throws ApiException {
            ApiResponse<CreditMemoResponse> localVarResp = CreditMemosApi.this.unapplyCreditMemoWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.unapplyCreditMemoWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.unapplyCreditMemoAsync(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ReverseCreditMemoApi {
        private final String creditMemoKey;
        private final ReverseCreditMemoRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ReverseCreditMemoApi(String creditMemoKey, ReverseCreditMemoRequest request) {
            this.creditMemoKey = creditMemoKey;
            this.request = request;
        }

        public ReverseCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ReverseCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ReverseCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ReverseCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ReverseCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ReverseCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ReverseCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.reverseCreditMemoCall(this.creditMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public ReverseCreditMemoResponse execute() throws ApiException {
            ApiResponse<ReverseCreditMemoResponse> localVarResp = CreditMemosApi.this.reverseCreditMemoWithHttpInfo(this.creditMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<ReverseCreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.reverseCreditMemoWithHttpInfo(this.creditMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<ReverseCreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.reverseCreditMemoAsync(this.creditMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class RefundCreditMemoApi {
        private final String creditMemoKey;
        private final RefundCreditMemoRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private RefundCreditMemoApi(String creditMemoKey, RefundCreditMemoRequest body) {
            this.creditMemoKey = creditMemoKey;
            this.body = body;
        }

        public RefundCreditMemoApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public RefundCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public RefundCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public RefundCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public RefundCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public RefundCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public RefundCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public RefundCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.refundCreditMemoCall(this.creditMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public RefundCreditMemoResponse execute() throws ApiException {
            ApiResponse<RefundCreditMemoResponse> localVarResp = CreditMemosApi.this.refundCreditMemoWithHttpInfo(this.creditMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<RefundCreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.refundCreditMemoWithHttpInfo(this.creditMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<RefundCreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.refundCreditMemoAsync(this.creditMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class PostCreditMemoApi {
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PostCreditMemoApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public PostCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.postCreditMemoCall(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoResponse execute() throws ApiException {
            ApiResponse<CreditMemoResponse> localVarResp = CreditMemosApi.this.postCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.postCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.postCreditMemoAsync(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class PostAsyncCreditMemoApi {
        private final String creditMemoKey;
        private final PostCreditMemoRequest postCreditMemoRequest;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PostAsyncCreditMemoApi(String creditMemoKey, PostCreditMemoRequest postCreditMemoRequest) {
            this.creditMemoKey = creditMemoKey;
            this.postCreditMemoRequest = postCreditMemoRequest;
        }

        public PostAsyncCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostAsyncCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostAsyncCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostAsyncCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostAsyncCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostAsyncCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostAsyncCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.postAsyncCreditMemoCall(this.creditMemoKey, this.postCreditMemoRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public AsyncOperationResponse execute() throws ApiException {
            ApiResponse<AsyncOperationResponse> localVarResp = CreditMemosApi.this.postAsyncCreditMemoWithHttpInfo(this.creditMemoKey, this.postCreditMemoRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<AsyncOperationResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.postAsyncCreditMemoWithHttpInfo(this.creditMemoKey, this.postCreditMemoRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<AsyncOperationResponse> _callback) throws ApiException {
            return CreditMemosApi.this.postAsyncCreditMemoAsync(this.creditMemoKey, this.postCreditMemoRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetUnapplyCreditMemoAsyncJobApi {
        private final String unapplyAsyncJobId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetUnapplyCreditMemoAsyncJobApi(String unapplyAsyncJobId) {
            this.unapplyAsyncJobId = unapplyAsyncJobId;
        }

        public GetUnapplyCreditMemoAsyncJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetUnapplyCreditMemoAsyncJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetUnapplyCreditMemoAsyncJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetUnapplyCreditMemoAsyncJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetUnapplyCreditMemoAsyncJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetUnapplyCreditMemoAsyncJobApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetUnapplyCreditMemoAsyncJobApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getUnapplyCreditMemoAsyncJobCall(this.unapplyAsyncJobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public InvoiceSettlementAsyncJobResponse execute() throws ApiException {
            ApiResponse<InvoiceSettlementAsyncJobResponse> localVarResp = CreditMemosApi.this.getUnapplyCreditMemoAsyncJobWithHttpInfo(this.unapplyAsyncJobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<InvoiceSettlementAsyncJobResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getUnapplyCreditMemoAsyncJobWithHttpInfo(this.unapplyAsyncJobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<InvoiceSettlementAsyncJobResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getUnapplyCreditMemoAsyncJobAsync(this.unapplyAsyncJobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetTaxationItemsOfCreditMemoItemApi {
        private final String creditMemoKey;
        private final String creditMemoItemId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer pageSize;
        private Integer page;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetTaxationItemsOfCreditMemoItemApi(String creditMemoKey, String creditMemoItemId) {
            this.creditMemoKey = creditMemoKey;
            this.creditMemoItemId = creditMemoItemId;
        }

        public GetTaxationItemsOfCreditMemoItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetTaxationItemsOfCreditMemoItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetTaxationItemsOfCreditMemoItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetTaxationItemsOfCreditMemoItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetTaxationItemsOfCreditMemoItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetTaxationItemsOfCreditMemoItemApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetTaxationItemsOfCreditMemoItemApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetTaxationItemsOfCreditMemoItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetTaxationItemsOfCreditMemoItemApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getTaxationItemsOfCreditMemoItemCall(this.creditMemoKey, this.creditMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetTaxationItemsOfCreditMemoItemResponse execute() throws ApiException {
            ApiResponse<GetTaxationItemsOfCreditMemoItemResponse> localVarResp = CreditMemosApi.this.getTaxationItemsOfCreditMemoItemWithHttpInfo(this.creditMemoKey, this.creditMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetTaxationItemsOfCreditMemoItemResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getTaxationItemsOfCreditMemoItemWithHttpInfo(this.creditMemoKey, this.creditMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetTaxationItemsOfCreditMemoItemResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getTaxationItemsOfCreditMemoItemAsync(this.creditMemoKey, this.creditMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetCreditMemosApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String accountId;
        private String accountNumber;
        private BigDecimal amount;
        private BigDecimal appliedAmount;
        private Boolean autoApplyUponPosting;
        private String createdById;
        private String createdDate;
        private LocalDate creditMemoDate;
        private String currency;
        private Boolean excludeFromAutoApplyRules;
        private String number;
        private String referredInvoiceId;
        private BigDecimal refundAmount;
        private BillingDocumentStatus status;
        private LocalDate targetDate;
        private BigDecimal taxAmount;
        private BigDecimal totalTaxExemptAmount;
        private String transferredToAccounting;
        private BigDecimal unappliedAmount;
        private String updatedById;
        private String updatedDate;
        private String sort;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetCreditMemosApi() {
        }

        public GetCreditMemosApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCreditMemosApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCreditMemosApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCreditMemosApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCreditMemosApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCreditMemosApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCreditMemosApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetCreditMemosApi accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public GetCreditMemosApi accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public GetCreditMemosApi amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public GetCreditMemosApi appliedAmount(BigDecimal appliedAmount) {
            this.appliedAmount = appliedAmount;
            return this;
        }

        public GetCreditMemosApi autoApplyUponPosting(Boolean autoApplyUponPosting) {
            this.autoApplyUponPosting = autoApplyUponPosting;
            return this;
        }

        public GetCreditMemosApi createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public GetCreditMemosApi createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public GetCreditMemosApi creditMemoDate(LocalDate creditMemoDate) {
            this.creditMemoDate = creditMemoDate;
            return this;
        }

        public GetCreditMemosApi currency(String currency) {
            this.currency = currency;
            return this;
        }

        public GetCreditMemosApi excludeFromAutoApplyRules(Boolean excludeFromAutoApplyRules) {
            this.excludeFromAutoApplyRules = excludeFromAutoApplyRules;
            return this;
        }

        public GetCreditMemosApi number(String number) {
            this.number = number;
            return this;
        }

        public GetCreditMemosApi referredInvoiceId(String referredInvoiceId) {
            this.referredInvoiceId = referredInvoiceId;
            return this;
        }

        public GetCreditMemosApi refundAmount(BigDecimal refundAmount) {
            this.refundAmount = refundAmount;
            return this;
        }

        public GetCreditMemosApi status(BillingDocumentStatus status) {
            this.status = status;
            return this;
        }

        public GetCreditMemosApi targetDate(LocalDate targetDate) {
            this.targetDate = targetDate;
            return this;
        }

        public GetCreditMemosApi taxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
            return this;
        }

        public GetCreditMemosApi totalTaxExemptAmount(BigDecimal totalTaxExemptAmount) {
            this.totalTaxExemptAmount = totalTaxExemptAmount;
            return this;
        }

        public GetCreditMemosApi transferredToAccounting(String transferredToAccounting) {
            this.transferredToAccounting = transferredToAccounting;
            return this;
        }

        public GetCreditMemosApi unappliedAmount(BigDecimal unappliedAmount) {
            this.unappliedAmount = unappliedAmount;
            return this;
        }

        public GetCreditMemosApi updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public GetCreditMemosApi updatedDate(String updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public GetCreditMemosApi sort(String sort) {
            this.sort = sort;
            return this;
        }

        public GetCreditMemosApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCreditMemosApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemosCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.accountId, this.accountNumber, this.amount, this.appliedAmount, this.autoApplyUponPosting, this.createdById, this.createdDate, this.creditMemoDate, this.currency, this.excludeFromAutoApplyRules, this.number, this.referredInvoiceId, this.refundAmount, this.status, this.targetDate, this.taxAmount, this.totalTaxExemptAmount, this.transferredToAccounting, this.unappliedAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemosResponse execute() throws ApiException {
            ApiResponse<CreditMemosResponse> localVarResp = CreditMemosApi.this.getCreditMemosWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.accountId, this.accountNumber, this.amount, this.appliedAmount, this.autoApplyUponPosting, this.createdById, this.createdDate, this.creditMemoDate, this.currency, this.excludeFromAutoApplyRules, this.number, this.referredInvoiceId, this.refundAmount, this.status, this.targetDate, this.taxAmount, this.totalTaxExemptAmount, this.transferredToAccounting, this.unappliedAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemosResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getCreditMemosWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.accountId, this.accountNumber, this.amount, this.appliedAmount, this.autoApplyUponPosting, this.createdById, this.createdDate, this.creditMemoDate, this.currency, this.excludeFromAutoApplyRules, this.number, this.referredInvoiceId, this.refundAmount, this.status, this.targetDate, this.taxAmount, this.totalTaxExemptAmount, this.transferredToAccounting, this.unappliedAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemosResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemosAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.accountId, this.accountNumber, this.amount, this.appliedAmount, this.autoApplyUponPosting, this.createdById, this.createdDate, this.creditMemoDate, this.currency, this.excludeFromAutoApplyRules, this.number, this.referredInvoiceId, this.refundAmount, this.status, this.targetDate, this.taxAmount, this.totalTaxExemptAmount, this.transferredToAccounting, this.unappliedAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetCreditMemoPdfStatusApi {
        private final String creditMemoKeys;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetCreditMemoPdfStatusApi(String creditMemoKeys) {
            this.creditMemoKeys = creditMemoKeys;
        }

        public GetCreditMemoPdfStatusApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCreditMemoPdfStatusApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCreditMemoPdfStatusApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCreditMemoPdfStatusApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCreditMemoPdfStatusApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCreditMemoPdfStatusApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCreditMemoPdfStatusApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoPdfStatusCall(this.creditMemoKeys, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetCreditMemoPdfStatusBatchResponse execute() throws ApiException {
            ApiResponse<GetCreditMemoPdfStatusBatchResponse> localVarResp = CreditMemosApi.this.getCreditMemoPdfStatusWithHttpInfo(this.creditMemoKeys, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetCreditMemoPdfStatusBatchResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getCreditMemoPdfStatusWithHttpInfo(this.creditMemoKeys, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetCreditMemoPdfStatusBatchResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoPdfStatusAsync(this.creditMemoKeys, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetCreditMemoPartsApi {
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetCreditMemoPartsApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public GetCreditMemoPartsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCreditMemoPartsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCreditMemoPartsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCreditMemoPartsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCreditMemoPartsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCreditMemoPartsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCreditMemoPartsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetCreditMemoPartsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCreditMemoPartsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoPartsCall(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetCreditMemoPartsResponse execute() throws ApiException {
            ApiResponse<GetCreditMemoPartsResponse> localVarResp = CreditMemosApi.this.getCreditMemoPartsWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetCreditMemoPartsResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getCreditMemoPartsWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetCreditMemoPartsResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoPartsAsync(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetCreditMemoPartApi {
        private final String partId;
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetCreditMemoPartApi(String partId, String creditMemoKey) {
            this.partId = partId;
            this.creditMemoKey = creditMemoKey;
        }

        public GetCreditMemoPartApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCreditMemoPartApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCreditMemoPartApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCreditMemoPartApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCreditMemoPartApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCreditMemoPartApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCreditMemoPartApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoPartCall(this.partId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetCreditMemoPartResponse execute() throws ApiException {
            ApiResponse<GetCreditMemoPartResponse> localVarResp = CreditMemosApi.this.getCreditMemoPartWithHttpInfo(this.partId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetCreditMemoPartResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getCreditMemoPartWithHttpInfo(this.partId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetCreditMemoPartResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoPartAsync(this.partId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetCreditMemoItemsApi {
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;
        private BigDecimal amount;
        private BigDecimal appliedAmount;
        private String createdById;
        private OffsetDateTime createdDate;
        private String id;
        private BigDecimal refundAmount;
        private LocalDate serviceEndDate;
        private LocalDate serviceStartDate;
        private String sku;
        private String skuName;
        private String sourceItemId;
        private String subscriptionId;
        private String updatedById;
        private OffsetDateTime updatedDate;
        private String sort;
        private String zuoraOrgIds;

        private GetCreditMemoItemsApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public GetCreditMemoItemsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCreditMemoItemsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCreditMemoItemsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCreditMemoItemsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCreditMemoItemsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCreditMemoItemsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCreditMemoItemsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetCreditMemoItemsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCreditMemoItemsApi amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public GetCreditMemoItemsApi appliedAmount(BigDecimal appliedAmount) {
            this.appliedAmount = appliedAmount;
            return this;
        }

        public GetCreditMemoItemsApi createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public GetCreditMemoItemsApi createdDate(OffsetDateTime createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public GetCreditMemoItemsApi id(String id) {
            this.id = id;
            return this;
        }

        public GetCreditMemoItemsApi refundAmount(BigDecimal refundAmount) {
            this.refundAmount = refundAmount;
            return this;
        }

        public GetCreditMemoItemsApi serviceEndDate(LocalDate serviceEndDate) {
            this.serviceEndDate = serviceEndDate;
            return this;
        }

        public GetCreditMemoItemsApi serviceStartDate(LocalDate serviceStartDate) {
            this.serviceStartDate = serviceStartDate;
            return this;
        }

        public GetCreditMemoItemsApi sku(String sku) {
            this.sku = sku;
            return this;
        }

        public GetCreditMemoItemsApi skuName(String skuName) {
            this.skuName = skuName;
            return this;
        }

        public GetCreditMemoItemsApi sourceItemId(String sourceItemId) {
            this.sourceItemId = sourceItemId;
            return this;
        }

        public GetCreditMemoItemsApi subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public GetCreditMemoItemsApi updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public GetCreditMemoItemsApi updatedDate(OffsetDateTime updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public GetCreditMemoItemsApi sort(String sort) {
            this.sort = sort;
            return this;
        }

        public GetCreditMemoItemsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemsCall(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.amount, this.appliedAmount, this.createdById, this.createdDate, this.id, this.refundAmount, this.serviceEndDate, this.serviceStartDate, this.sku, this.skuName, this.sourceItemId, this.subscriptionId, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds, _callback);
        }

        public CreditMemoItemsResponse execute() throws ApiException {
            ApiResponse<CreditMemoItemsResponse> localVarResp = CreditMemosApi.this.getCreditMemoItemsWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.amount, this.appliedAmount, this.createdById, this.createdDate, this.id, this.refundAmount, this.serviceEndDate, this.serviceStartDate, this.sku, this.skuName, this.sourceItemId, this.subscriptionId, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoItemsResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemsWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.amount, this.appliedAmount, this.createdById, this.createdDate, this.id, this.refundAmount, this.serviceEndDate, this.serviceStartDate, this.sku, this.skuName, this.sourceItemId, this.subscriptionId, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoItemsResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemsAsync(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.amount, this.appliedAmount, this.createdById, this.createdDate, this.id, this.refundAmount, this.serviceEndDate, this.serviceStartDate, this.sku, this.skuName, this.sourceItemId, this.subscriptionId, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds, _callback);
        }
    }

    public class GetCreditMemoItemPartsApi {
        private final String partId;
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetCreditMemoItemPartsApi(String partId, String creditMemoKey) {
            this.partId = partId;
            this.creditMemoKey = creditMemoKey;
        }

        public GetCreditMemoItemPartsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCreditMemoItemPartsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCreditMemoItemPartsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCreditMemoItemPartsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCreditMemoItemPartsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCreditMemoItemPartsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetCreditMemoItemPartsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetCreditMemoItemPartsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCreditMemoItemPartsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemPartsCall(this.partId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetCreditMemoItemPartsResponse execute() throws ApiException {
            ApiResponse<GetCreditMemoItemPartsResponse> localVarResp = CreditMemosApi.this.getCreditMemoItemPartsWithHttpInfo(this.partId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetCreditMemoItemPartsResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemPartsWithHttpInfo(this.partId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetCreditMemoItemPartsResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemPartsAsync(this.partId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetCreditMemoItemPartApi {
        private final String partId;
        private final String itemPartId;
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetCreditMemoItemPartApi(String partId, String itemPartId, String creditMemoKey) {
            this.partId = partId;
            this.itemPartId = itemPartId;
            this.creditMemoKey = creditMemoKey;
        }

        public GetCreditMemoItemPartApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCreditMemoItemPartApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCreditMemoItemPartApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCreditMemoItemPartApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCreditMemoItemPartApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCreditMemoItemPartApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCreditMemoItemPartApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemPartCall(this.partId, this.itemPartId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetCreditMemoItemPartResponse execute() throws ApiException {
            ApiResponse<GetCreditMemoItemPartResponse> localVarResp = CreditMemosApi.this.getCreditMemoItemPartWithHttpInfo(this.partId, this.itemPartId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetCreditMemoItemPartResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemPartWithHttpInfo(this.partId, this.itemPartId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetCreditMemoItemPartResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemPartAsync(this.partId, this.itemPartId, this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetCreditMemoItemApi {
        private final String creditMemoKey;
        private final String creditMemoItemId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetCreditMemoItemApi(String creditMemoKey, String creditMemoItemId) {
            this.creditMemoKey = creditMemoKey;
            this.creditMemoItemId = creditMemoItemId;
        }

        public GetCreditMemoItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCreditMemoItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCreditMemoItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCreditMemoItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCreditMemoItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCreditMemoItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCreditMemoItemApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemCall(this.creditMemoKey, this.creditMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoItemResponse execute() throws ApiException {
            ApiResponse<CreditMemoItemResponse> localVarResp = CreditMemosApi.this.getCreditMemoItemWithHttpInfo(this.creditMemoKey, this.creditMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoItemResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemWithHttpInfo(this.creditMemoKey, this.creditMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoItemResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoItemAsync(this.creditMemoKey, this.creditMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetCreditMemoApi {
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetCreditMemoApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public GetCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoCall(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoResponse execute() throws ApiException {
            ApiResponse<CreditMemoResponse> localVarResp = CreditMemosApi.this.getCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getCreditMemoAsync(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetApplyCreditMemoAsyncJobApi {
        private final String applyAsyncJobId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetApplyCreditMemoAsyncJobApi(String applyAsyncJobId) {
            this.applyAsyncJobId = applyAsyncJobId;
        }

        public GetApplyCreditMemoAsyncJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetApplyCreditMemoAsyncJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetApplyCreditMemoAsyncJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetApplyCreditMemoAsyncJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetApplyCreditMemoAsyncJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetApplyCreditMemoAsyncJobApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetApplyCreditMemoAsyncJobApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.getApplyCreditMemoAsyncJobCall(this.applyAsyncJobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public InvoiceSettlementAsyncJobResponse execute() throws ApiException {
            ApiResponse<InvoiceSettlementAsyncJobResponse> localVarResp = CreditMemosApi.this.getApplyCreditMemoAsyncJobWithHttpInfo(this.applyAsyncJobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<InvoiceSettlementAsyncJobResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.getApplyCreditMemoAsyncJobWithHttpInfo(this.applyAsyncJobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<InvoiceSettlementAsyncJobResponse> _callback) throws ApiException {
            return CreditMemosApi.this.getApplyCreditMemoAsyncJobAsync(this.applyAsyncJobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GenerateCreditMemoPdfApi {
        private final String creditMemoKey;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GenerateCreditMemoPdfApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public GenerateCreditMemoPdfApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public GenerateCreditMemoPdfApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GenerateCreditMemoPdfApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GenerateCreditMemoPdfApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GenerateCreditMemoPdfApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GenerateCreditMemoPdfApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GenerateCreditMemoPdfApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GenerateCreditMemoPdfApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.generateCreditMemoPdfCall(this.creditMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = CreditMemosApi.this.generateCreditMemoPdfWithHttpInfo(this.creditMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.generateCreditMemoPdfWithHttpInfo(this.creditMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return CreditMemosApi.this.generateCreditMemoPdfAsync(this.creditMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class EmailCreditMemoApi {
        private final String creditMemoKey;
        private final EmailBillingDocumentRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private EmailCreditMemoApi(String creditMemoKey, EmailBillingDocumentRequest request) {
            this.creditMemoKey = creditMemoKey;
            this.request = request;
        }

        public EmailCreditMemoApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public EmailCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public EmailCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public EmailCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public EmailCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public EmailCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public EmailCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public EmailCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.emailCreditMemoCall(this.creditMemoKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = CreditMemosApi.this.emailCreditMemoWithHttpInfo(this.creditMemoKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.emailCreditMemoWithHttpInfo(this.creditMemoKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return CreditMemosApi.this.emailCreditMemoAsync(this.creditMemoKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class DeleteCreditMemoApi {
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DeleteCreditMemoApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public DeleteCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.deleteCreditMemoCall(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = CreditMemosApi.this.deleteCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.deleteCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return CreditMemosApi.this.deleteCreditMemoAsync(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateCreditMemoTaxationItemsApi {
        private final String creditMemoKey;
        private final CreateCreditMemoTaxationItemsRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateCreditMemoTaxationItemsApi(String creditMemoKey, CreateCreditMemoTaxationItemsRequest body) {
            this.creditMemoKey = creditMemoKey;
            this.body = body;
        }

        public CreateCreditMemoTaxationItemsApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateCreditMemoTaxationItemsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateCreditMemoTaxationItemsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateCreditMemoTaxationItemsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateCreditMemoTaxationItemsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateCreditMemoTaxationItemsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateCreditMemoTaxationItemsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateCreditMemoTaxationItemsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.createCreditMemoTaxationItemsCall(this.creditMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetTaxationItemsResponse execute() throws ApiException {
            ApiResponse<GetTaxationItemsResponse> localVarResp = CreditMemosApi.this.createCreditMemoTaxationItemsWithHttpInfo(this.creditMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetTaxationItemsResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.createCreditMemoTaxationItemsWithHttpInfo(this.creditMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetTaxationItemsResponse> _callback) throws ApiException {
            return CreditMemosApi.this.createCreditMemoTaxationItemsAsync(this.creditMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateCreditMemoFromInvoiceApi {
        private final String invoiceKey;
        private final CreateCreditMemoFromInvoiceRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateCreditMemoFromInvoiceApi(String invoiceKey, CreateCreditMemoFromInvoiceRequest body) {
            this.invoiceKey = invoiceKey;
            this.body = body;
        }

        public CreateCreditMemoFromInvoiceApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateCreditMemoFromInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateCreditMemoFromInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateCreditMemoFromInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateCreditMemoFromInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateCreditMemoFromInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateCreditMemoFromInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateCreditMemoFromInvoiceApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.createCreditMemoFromInvoiceCall(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoResponse execute() throws ApiException {
            ApiResponse<CreditMemoResponse> localVarResp = CreditMemosApi.this.createCreditMemoFromInvoiceWithHttpInfo(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.createCreditMemoFromInvoiceWithHttpInfo(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.createCreditMemoFromInvoiceAsync(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateCreditMemoFromChargeApi {
        private final CreateCreditMemoFromChargeRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateCreditMemoFromChargeApi(CreateCreditMemoFromChargeRequest body) {
            this.body = body;
        }

        public CreateCreditMemoFromChargeApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateCreditMemoFromChargeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateCreditMemoFromChargeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateCreditMemoFromChargeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateCreditMemoFromChargeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateCreditMemoFromChargeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateCreditMemoFromChargeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateCreditMemoFromChargeApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.createCreditMemoFromChargeCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoResponse execute() throws ApiException {
            ApiResponse<CreditMemoResponse> localVarResp = CreditMemosApi.this.createCreditMemoFromChargeWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.createCreditMemoFromChargeWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.createCreditMemoFromChargeAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CancelCreditMemoApi {
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CancelCreditMemoApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public CancelCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CancelCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.cancelCreditMemoCall(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoResponse execute() throws ApiException {
            ApiResponse<CreditMemoResponse> localVarResp = CreditMemosApi.this.cancelCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.cancelCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.cancelCreditMemoAsync(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CancelAsyncCreditMemoApi {
        private final String creditMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CancelAsyncCreditMemoApi(String creditMemoKey) {
            this.creditMemoKey = creditMemoKey;
        }

        public CancelAsyncCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelAsyncCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelAsyncCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelAsyncCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelAsyncCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelAsyncCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CancelAsyncCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.cancelAsyncCreditMemoCall(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public AsyncOperationResponse execute() throws ApiException {
            ApiResponse<AsyncOperationResponse> localVarResp = CreditMemosApi.this.cancelAsyncCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<AsyncOperationResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.cancelAsyncCreditMemoWithHttpInfo(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<AsyncOperationResponse> _callback) throws ApiException {
            return CreditMemosApi.this.cancelAsyncCreditMemoAsync(this.creditMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class BulkUpdateCreditMemosApi {
        private final BulkUpdateCreditMemosRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private BulkUpdateCreditMemosApi(BulkUpdateCreditMemosRequest body) {
            this.body = body;
        }

        public BulkUpdateCreditMemosApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public BulkUpdateCreditMemosApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public BulkUpdateCreditMemosApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public BulkUpdateCreditMemosApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public BulkUpdateCreditMemosApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public BulkUpdateCreditMemosApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public BulkUpdateCreditMemosApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.bulkUpdateCreditMemosCall(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public BulkCreditMemosResponse execute() throws ApiException {
            ApiResponse<BulkCreditMemosResponse> localVarResp = CreditMemosApi.this.bulkUpdateCreditMemosWithHttpInfo(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<BulkCreditMemosResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.bulkUpdateCreditMemosWithHttpInfo(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<BulkCreditMemosResponse> _callback) throws ApiException {
            return CreditMemosApi.this.bulkUpdateCreditMemosAsync(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class BulkCreateCreditMemosApi {
        private final BulkCreateCreditMemosRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private BulkCreateCreditMemosApi(BulkCreateCreditMemosRequest body) {
            this.body = body;
        }

        public BulkCreateCreditMemosApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public BulkCreateCreditMemosApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public BulkCreateCreditMemosApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public BulkCreateCreditMemosApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public BulkCreateCreditMemosApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public BulkCreateCreditMemosApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public BulkCreateCreditMemosApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public BulkCreateCreditMemosApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.bulkCreateCreditMemosCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public BulkCreditMemosResponse execute() throws ApiException {
            ApiResponse<BulkCreditMemosResponse> localVarResp = CreditMemosApi.this.bulkCreateCreditMemosWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<BulkCreditMemosResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.bulkCreateCreditMemosWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<BulkCreditMemosResponse> _callback) throws ApiException {
            return CreditMemosApi.this.bulkCreateCreditMemosAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ApplyCreditMemoAsyncApi {
        private final String creditMemoKey;
        private final AsyncApplyCreditMemoRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ApplyCreditMemoAsyncApi(String creditMemoKey, AsyncApplyCreditMemoRequest body) {
            this.creditMemoKey = creditMemoKey;
            this.body = body;
        }

        public ApplyCreditMemoAsyncApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ApplyCreditMemoAsyncApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ApplyCreditMemoAsyncApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ApplyCreditMemoAsyncApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ApplyCreditMemoAsyncApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ApplyCreditMemoAsyncApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ApplyCreditMemoAsyncApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.applyCreditMemoAsyncCall(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public InvoiceSettlementAsyncJobResponse execute() throws ApiException {
            ApiResponse<InvoiceSettlementAsyncJobResponse> localVarResp = CreditMemosApi.this.applyCreditMemoAsyncWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<InvoiceSettlementAsyncJobResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.applyCreditMemoAsyncWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<InvoiceSettlementAsyncJobResponse> _callback) throws ApiException {
            return CreditMemosApi.this.applyCreditMemoAsyncAsync(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ApplyCreditMemoApi {
        private final String creditMemoKey;
        private final ApplyCreditMemoRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ApplyCreditMemoApi(String creditMemoKey, ApplyCreditMemoRequest body) {
            this.creditMemoKey = creditMemoKey;
            this.body = body;
        }

        public ApplyCreditMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ApplyCreditMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ApplyCreditMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ApplyCreditMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ApplyCreditMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ApplyCreditMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ApplyCreditMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CreditMemosApi.this.applyCreditMemoCall(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreditMemoResponse execute() throws ApiException {
            ApiResponse<CreditMemoResponse> localVarResp = CreditMemosApi.this.applyCreditMemoWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreditMemoResponse> executeWithHttpInfo() throws ApiException {
            return CreditMemosApi.this.applyCreditMemoWithHttpInfo(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreditMemoResponse> _callback) throws ApiException {
            return CreditMemosApi.this.applyCreditMemoAsync(this.creditMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

