/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BillingDocumentItemPaymentApplicationRequest {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_TAXATION_ITEM_ID = "taxation_item_id";
    @SerializedName(value="taxation_item_id")
    private String taxationItemId;

    public BillingDocumentItemPaymentApplicationRequest id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifier of an invoice item or a debit memo item.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BillingDocumentItemPaymentApplicationRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The amount applied to this billing document item or taxation item.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BillingDocumentItemPaymentApplicationRequest taxationItemId(String taxationItemId) {
        this.taxationItemId = taxationItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of a taxation item.")
    public String getTaxationItemId() {
        return this.taxationItemId;
    }

    public void setTaxationItemId(String taxationItemId) {
        this.taxationItemId = taxationItemId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingDocumentItemPaymentApplicationRequest billingDocumentItemPaymentApplicationRequest = (BillingDocumentItemPaymentApplicationRequest)o;
        return Objects.equals(this.id, billingDocumentItemPaymentApplicationRequest.id) && Objects.equals(this.amount, billingDocumentItemPaymentApplicationRequest.amount) && Objects.equals(this.taxationItemId, billingDocumentItemPaymentApplicationRequest.taxationItemId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.amount, this.taxationItemId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingDocumentItemPaymentApplicationRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    taxationItemId: ").append(this.toIndentedString(this.taxationItemId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

