/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.GetCardList;
import org.openapitools.client.model.Mandate;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="If the `type` of the payment method is `apple_pay`, this hash contains details about the Apple Pay payment method. See [Supported payment methods](https://knowledgecenter.zuora.com/Billing/Billing_and_Payments/L_Payment_Methods/A_Supported_Payment_Methods) for payment gateways that support this type of payment method.")
public class ApplePay {
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private GetCardList card;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private Mandate mandate;
    public static final String SERIALIZED_NAME_PAYMENT_ID = "payment_id";
    @SerializedName(value="payment_id")
    private String paymentId;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;

    public ApplePay card(GetCardList card) {
        this.card = card;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Credit card information. When providing a card number, you must meet the requirements for PCI compliance. We strongly recommend using Zuora.js instead of interacting with this API directly.")
    public GetCardList getCard() {
        return this.card;
    }

    public void setCard(GetCardList card) {
        this.card = card;
    }

    public ApplePay mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public ApplePay paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of newly processed payment. Only available in the response of the Create Payment Method API request.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public ApplePay token(String token) {
        this.token = token;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A gateway unique identifier that replaces sensitive payment method data or represents a gateway's unique customer profile. When `token` is used to represent a customer profile, `second_token` is conditionally required for representing the underlying tokenized payment method.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplePay applePay = (ApplePay)o;
        return Objects.equals(this.card, applePay.card) && Objects.equals(this.mandate, applePay.mandate) && Objects.equals(this.paymentId, applePay.paymentId) && Objects.equals(this.token, applePay.token);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.card, this.mandate, this.paymentId, this.token);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplePay {\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

