/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

@ApiModel(description="Details about the customer\u2019s acceptance of the mandate.")
public class CustomerAcceptanceMandate {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;

    public CustomerAcceptanceMandate() {
    }

    public CustomerAcceptanceMandate(String id, LocalDate date) {
        this();
        this.id = id;
        this.date = date;
    }

    @Nullable
    @ApiModelProperty(value="A reference to the consent agreement you have with your customer.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="The date on which the customer accepted the mandate.")
    public LocalDate getDate() {
        return this.date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerAcceptanceMandate customerAcceptanceMandate = (CustomerAcceptanceMandate)o;
        return Objects.equals(this.id, customerAcceptanceMandate.id) && Objects.equals(this.date, customerAcceptanceMandate.date);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.date);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerAcceptanceMandate {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

