/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.AsyncOperationResponse;
import com.zuora.model.BillingDocumentStatus;
import com.zuora.model.BulkCreateDebitMemosRequest;
import com.zuora.model.BulkDebitMemosResponse;
import com.zuora.model.BulkUpdateDebitMemosRequest;
import com.zuora.model.CollectDebitMemoRequest;
import com.zuora.model.CollectDebitMemoResponse;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreateDebitMemoFromChargeRequest;
import com.zuora.model.CreateDebitMemoFromInvoiceRequest;
import com.zuora.model.CreateTaxationItemsForDebitMemoRequest;
import com.zuora.model.DebitMemoItemResponse;
import com.zuora.model.DebitMemoItemsResponse;
import com.zuora.model.DebitMemoResponse;
import com.zuora.model.DebitMemosResponse;
import com.zuora.model.EmailBillingDocumentRequest;
import com.zuora.model.GetDebitMemoApplicationPartsResponse;
import com.zuora.model.GetDebitMemoPdfStatusBatchResponse;
import com.zuora.model.GetTaxationItemsOfDebitMemoItemResponse;
import com.zuora.model.GetTaxationItemsResponse;
import com.zuora.model.UpdateDebitMemoRequest;
import com.zuora.model.UpdateDebitMemosDueDatesRequest;
import com.zuora.model.UploadFileResponse;
import com.zuora.model.WriteOffDebitMemoRequest;
import com.zuora.model.WriteOffDebitMemoResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DebitMemosApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DebitMemosApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DebitMemosApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call bulkCreateDebitMemosCall(BulkCreateDebitMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BulkCreateDebitMemosRequest localVarPostBody = body;
        String localVarPath = "/v1/debitmemos/bulk";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bulkCreateDebitMemosValidateBeforeCall(BulkCreateDebitMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling bulkCreateDebitMemos(Async)");
        }
        return this.bulkCreateDebitMemosCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected BulkDebitMemosResponse bulkCreateDebitMemos(BulkCreateDebitMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<BulkDebitMemosResponse> localVarResp = this.bulkCreateDebitMemosWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<BulkDebitMemosResponse> bulkCreateDebitMemosWithHttpInfo(BulkCreateDebitMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.bulkCreateDebitMemosValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<BulkDebitMemosResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call bulkCreateDebitMemosAsync(BulkCreateDebitMemosRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<BulkDebitMemosResponse> _callback) throws ApiException {
        Call localVarCall = this.bulkCreateDebitMemosValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BulkDebitMemosResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public BulkCreateDebitMemosApi bulkCreateDebitMemosApi(BulkCreateDebitMemosRequest body) {
        return new BulkCreateDebitMemosApi(body);
    }

    private Call bulkUpdateDebitMemosCall(BulkUpdateDebitMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BulkUpdateDebitMemosRequest localVarPostBody = body;
        String localVarPath = "/v1/debitmemos/bulk";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bulkUpdateDebitMemosValidateBeforeCall(BulkUpdateDebitMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling bulkUpdateDebitMemos(Async)");
        }
        return this.bulkUpdateDebitMemosCall(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected BulkDebitMemosResponse bulkUpdateDebitMemos(BulkUpdateDebitMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<BulkDebitMemosResponse> localVarResp = this.bulkUpdateDebitMemosWithHttpInfo(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<BulkDebitMemosResponse> bulkUpdateDebitMemosWithHttpInfo(BulkUpdateDebitMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.bulkUpdateDebitMemosValidateBeforeCall(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<BulkDebitMemosResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call bulkUpdateDebitMemosAsync(BulkUpdateDebitMemosRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<BulkDebitMemosResponse> _callback) throws ApiException {
        Call localVarCall = this.bulkUpdateDebitMemosValidateBeforeCall(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BulkDebitMemosResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public BulkUpdateDebitMemosApi bulkUpdateDebitMemosApi(BulkUpdateDebitMemosRequest body) {
        return new BulkUpdateDebitMemosApi(body);
    }

    private Call cancelAsyncDebitMemoCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/cancel-async".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelAsyncDebitMemoValidateBeforeCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling cancelAsyncDebitMemo(Async)");
        }
        return this.cancelAsyncDebitMemoCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected AsyncOperationResponse cancelAsyncDebitMemo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<AsyncOperationResponse> localVarResp = this.cancelAsyncDebitMemoWithHttpInfo(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<AsyncOperationResponse> cancelAsyncDebitMemoWithHttpInfo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelAsyncDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<AsyncOperationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call cancelAsyncDebitMemoAsync(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<AsyncOperationResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelAsyncDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<AsyncOperationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelAsyncDebitMemoApi cancelAsyncDebitMemoApi(String debitMemoKey) {
        return new CancelAsyncDebitMemoApi(debitMemoKey);
    }

    private Call cancelDebitMemoCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/cancel".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelDebitMemoValidateBeforeCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling cancelDebitMemo(Async)");
        }
        return this.cancelDebitMemoCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DebitMemoResponse cancelDebitMemo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemoResponse> localVarResp = this.cancelDebitMemoWithHttpInfo(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemoResponse> cancelDebitMemoWithHttpInfo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call cancelDebitMemoAsync(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<DebitMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelDebitMemoApi cancelDebitMemoApi(String debitMemoKey) {
        return new CancelDebitMemoApi(debitMemoKey);
    }

    private Call collectDebitMemoCall(String debitMemoKey, CollectDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CollectDebitMemoRequest localVarPostBody = body;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/collect".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call collectDebitMemoValidateBeforeCall(String debitMemoKey, CollectDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling collectDebitMemo(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling collectDebitMemo(Async)");
        }
        return this.collectDebitMemoCall(debitMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CollectDebitMemoResponse collectDebitMemo(String debitMemoKey, CollectDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CollectDebitMemoResponse> localVarResp = this.collectDebitMemoWithHttpInfo(debitMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CollectDebitMemoResponse> collectDebitMemoWithHttpInfo(String debitMemoKey, CollectDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.collectDebitMemoValidateBeforeCall(debitMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CollectDebitMemoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call collectDebitMemoAsync(String debitMemoKey, CollectDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CollectDebitMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.collectDebitMemoValidateBeforeCall(debitMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CollectDebitMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CollectDebitMemoApi collectDebitMemoApi(String debitMemoKey, CollectDebitMemoRequest body) {
        return new CollectDebitMemoApi(debitMemoKey, body);
    }

    private Call createDebitMemoFromChargeCall(CreateDebitMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateDebitMemoFromChargeRequest localVarPostBody = body;
        String localVarPath = "/v1/debitmemos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDebitMemoFromChargeValidateBeforeCall(CreateDebitMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDebitMemoFromCharge(Async)");
        }
        return this.createDebitMemoFromChargeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DebitMemoResponse createDebitMemoFromCharge(CreateDebitMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemoResponse> localVarResp = this.createDebitMemoFromChargeWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemoResponse> createDebitMemoFromChargeWithHttpInfo(CreateDebitMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createDebitMemoFromChargeValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createDebitMemoFromChargeAsync(CreateDebitMemoFromChargeRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<DebitMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.createDebitMemoFromChargeValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateDebitMemoFromChargeApi createDebitMemoFromChargeApi(CreateDebitMemoFromChargeRequest body) {
        return new CreateDebitMemoFromChargeApi(body);
    }

    private Call createDebitMemoFromInvoiceCall(String invoiceKey, CreateDebitMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateDebitMemoFromInvoiceRequest localVarPostBody = body;
        String localVarPath = "/v1/invoices/{invoiceKey}/debitmemos".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDebitMemoFromInvoiceValidateBeforeCall(String invoiceKey, CreateDebitMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling createDebitMemoFromInvoice(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createDebitMemoFromInvoice(Async)");
        }
        return this.createDebitMemoFromInvoiceCall(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DebitMemoResponse createDebitMemoFromInvoice(String invoiceKey, CreateDebitMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemoResponse> localVarResp = this.createDebitMemoFromInvoiceWithHttpInfo(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemoResponse> createDebitMemoFromInvoiceWithHttpInfo(String invoiceKey, CreateDebitMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createDebitMemoFromInvoiceValidateBeforeCall(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createDebitMemoFromInvoiceAsync(String invoiceKey, CreateDebitMemoFromInvoiceRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<DebitMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.createDebitMemoFromInvoiceValidateBeforeCall(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateDebitMemoFromInvoiceApi createDebitMemoFromInvoiceApi(String invoiceKey, CreateDebitMemoFromInvoiceRequest body) {
        return new CreateDebitMemoFromInvoiceApi(invoiceKey, body);
    }

    private Call createTaxationItemsForDebitMemoCall(String debitMemoKey, CreateTaxationItemsForDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateTaxationItemsForDebitMemoRequest localVarPostBody = body;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/taxationitems".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTaxationItemsForDebitMemoValidateBeforeCall(String debitMemoKey, CreateTaxationItemsForDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling createTaxationItemsForDebitMemo(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createTaxationItemsForDebitMemo(Async)");
        }
        return this.createTaxationItemsForDebitMemoCall(debitMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetTaxationItemsResponse createTaxationItemsForDebitMemo(String debitMemoKey, CreateTaxationItemsForDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetTaxationItemsResponse> localVarResp = this.createTaxationItemsForDebitMemoWithHttpInfo(debitMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetTaxationItemsResponse> createTaxationItemsForDebitMemoWithHttpInfo(String debitMemoKey, CreateTaxationItemsForDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createTaxationItemsForDebitMemoValidateBeforeCall(debitMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetTaxationItemsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createTaxationItemsForDebitMemoAsync(String debitMemoKey, CreateTaxationItemsForDebitMemoRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetTaxationItemsResponse> _callback) throws ApiException {
        Call localVarCall = this.createTaxationItemsForDebitMemoValidateBeforeCall(debitMemoKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetTaxationItemsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateTaxationItemsForDebitMemoApi createTaxationItemsForDebitMemoApi(String debitMemoKey, CreateTaxationItemsForDebitMemoRequest body) {
        return new CreateTaxationItemsForDebitMemoApi(debitMemoKey, body);
    }

    private Call deleteDebitMemoCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDebitMemoValidateBeforeCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling deleteDebitMemo(Async)");
        }
        return this.deleteDebitMemoCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse deleteDebitMemo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.deleteDebitMemoWithHttpInfo(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> deleteDebitMemoWithHttpInfo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteDebitMemoAsync(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteDebitMemoApi deleteDebitMemoApi(String debitMemoKey) {
        return new DeleteDebitMemoApi(debitMemoKey);
    }

    private Call emailDebitMemoCall(String debitMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EmailBillingDocumentRequest localVarPostBody = request;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/emails".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call emailDebitMemoValidateBeforeCall(String debitMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling emailDebitMemo(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling emailDebitMemo(Async)");
        }
        return this.emailDebitMemoCall(debitMemoKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse emailDebitMemo(String debitMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.emailDebitMemoWithHttpInfo(debitMemoKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> emailDebitMemoWithHttpInfo(String debitMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.emailDebitMemoValidateBeforeCall(debitMemoKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call emailDebitMemoAsync(String debitMemoKey, EmailBillingDocumentRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.emailDebitMemoValidateBeforeCall(debitMemoKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public EmailDebitMemoApi emailDebitMemoApi(String debitMemoKey, EmailBillingDocumentRequest request) {
        return new EmailDebitMemoApi(debitMemoKey, request);
    }

    private Call generateDebitMemoPdfCall(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/pdfs".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call generateDebitMemoPdfValidateBeforeCall(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling generateDebitMemoPdf(Async)");
        }
        return this.generateDebitMemoPdfCall(debitMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse generateDebitMemoPdf(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.generateDebitMemoPdfWithHttpInfo(debitMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> generateDebitMemoPdfWithHttpInfo(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.generateDebitMemoPdfValidateBeforeCall(debitMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call generateDebitMemoPdfAsync(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.generateDebitMemoPdfValidateBeforeCall(debitMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GenerateDebitMemoPdfApi generateDebitMemoPdfApi(String debitMemoKey) {
        return new GenerateDebitMemoPdfApi(debitMemoKey);
    }

    private Call getDebitMemoCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitMemoValidateBeforeCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling getDebitMemo(Async)");
        }
        return this.getDebitMemoCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DebitMemoResponse getDebitMemo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemoResponse> localVarResp = this.getDebitMemoWithHttpInfo(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemoResponse> getDebitMemoWithHttpInfo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getDebitMemoAsync(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<DebitMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.getDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDebitMemoApi getDebitMemoApi(String debitMemoKey) {
        return new GetDebitMemoApi(debitMemoKey);
    }

    private Call getDebitMemoApplicationPartsCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/application-parts".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitMemoApplicationPartsValidateBeforeCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling getDebitMemoApplicationParts(Async)");
        }
        return this.getDebitMemoApplicationPartsCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetDebitMemoApplicationPartsResponse getDebitMemoApplicationParts(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetDebitMemoApplicationPartsResponse> localVarResp = this.getDebitMemoApplicationPartsWithHttpInfo(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetDebitMemoApplicationPartsResponse> getDebitMemoApplicationPartsWithHttpInfo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDebitMemoApplicationPartsValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetDebitMemoApplicationPartsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getDebitMemoApplicationPartsAsync(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetDebitMemoApplicationPartsResponse> _callback) throws ApiException {
        Call localVarCall = this.getDebitMemoApplicationPartsValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetDebitMemoApplicationPartsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDebitMemoApplicationPartsApi getDebitMemoApplicationPartsApi(String debitMemoKey) {
        return new GetDebitMemoApplicationPartsApi(debitMemoKey);
    }

    private Call getDebitMemoItemCall(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/items/{debitMemoItemId}".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString())).replace("{debitMemoItemId}", this.localVarApiClient.escapeString(debitMemoItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitMemoItemValidateBeforeCall(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling getDebitMemoItem(Async)");
        }
        if (debitMemoItemId == null) {
            throw new ApiException("Missing the required parameter 'debitMemoItemId' when calling getDebitMemoItem(Async)");
        }
        return this.getDebitMemoItemCall(debitMemoKey, debitMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DebitMemoItemResponse getDebitMemoItem(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemoItemResponse> localVarResp = this.getDebitMemoItemWithHttpInfo(debitMemoKey, debitMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemoItemResponse> getDebitMemoItemWithHttpInfo(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDebitMemoItemValidateBeforeCall(debitMemoKey, debitMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemoItemResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getDebitMemoItemAsync(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<DebitMemoItemResponse> _callback) throws ApiException {
        Call localVarCall = this.getDebitMemoItemValidateBeforeCall(debitMemoKey, debitMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDebitMemoItemApi getDebitMemoItemApi(String debitMemoKey, String debitMemoItemId) {
        return new GetDebitMemoItemApi(debitMemoKey, debitMemoItemId);
    }

    private Call getDebitMemoItemsCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal beAppliedAmount, String createdById, String createdDate, String id, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, String updatedDate, String sort, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/items".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (beAppliedAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("beAppliedAmount", beAppliedAmount));
        }
        if (createdById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdById", createdById));
        }
        if (createdDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdDate", createdDate));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (serviceEndDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("serviceEndDate", serviceEndDate));
        }
        if (serviceStartDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("serviceStartDate", serviceStartDate));
        }
        if (sku != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sku", sku));
        }
        if (skuName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skuName", skuName));
        }
        if (sourceItemId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sourceItemId", sourceItemId));
        }
        if (subscriptionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subscriptionId", subscriptionId));
        }
        if (updatedById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedById", updatedById));
        }
        if (updatedDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedDate", updatedDate));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitMemoItemsValidateBeforeCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal beAppliedAmount, String createdById, String createdDate, String id, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, String updatedDate, String sort, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling getDebitMemoItems(Async)");
        }
        return this.getDebitMemoItemsCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, amount, beAppliedAmount, createdById, createdDate, id, serviceEndDate, serviceStartDate, sku, skuName, sourceItemId, subscriptionId, updatedById, updatedDate, sort, zuoraOrgIds, _callback);
    }

    protected DebitMemoItemsResponse getDebitMemoItems(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal beAppliedAmount, String createdById, String createdDate, String id, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, String updatedDate, String sort, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemoItemsResponse> localVarResp = this.getDebitMemoItemsWithHttpInfo(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, amount, beAppliedAmount, createdById, createdDate, id, serviceEndDate, serviceStartDate, sku, skuName, sourceItemId, subscriptionId, updatedById, updatedDate, sort, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemoItemsResponse> getDebitMemoItemsWithHttpInfo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal beAppliedAmount, String createdById, String createdDate, String id, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, String updatedDate, String sort, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDebitMemoItemsValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, amount, beAppliedAmount, createdById, createdDate, id, serviceEndDate, serviceStartDate, sku, skuName, sourceItemId, subscriptionId, updatedById, updatedDate, sort, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemoItemsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getDebitMemoItemsAsync(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, BigDecimal amount, BigDecimal beAppliedAmount, String createdById, String createdDate, String id, LocalDate serviceEndDate, LocalDate serviceStartDate, String sku, String skuName, String sourceItemId, String subscriptionId, String updatedById, String updatedDate, String sort, String zuoraOrgIds, ApiCallback<DebitMemoItemsResponse> _callback) throws ApiException {
        Call localVarCall = this.getDebitMemoItemsValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, amount, beAppliedAmount, createdById, createdDate, id, serviceEndDate, serviceStartDate, sku, skuName, sourceItemId, subscriptionId, updatedById, updatedDate, sort, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoItemsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDebitMemoItemsApi getDebitMemoItemsApi(String debitMemoKey) {
        return new GetDebitMemoItemsApi(debitMemoKey);
    }

    private Call getDebitMemoPdfStatusCall(String debitMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/pdf-status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (debitMemoKeys != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("debitMemoKeys", debitMemoKeys));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitMemoPdfStatusValidateBeforeCall(String debitMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKeys == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKeys' when calling getDebitMemoPdfStatus(Async)");
        }
        return this.getDebitMemoPdfStatusCall(debitMemoKeys, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetDebitMemoPdfStatusBatchResponse getDebitMemoPdfStatus(String debitMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetDebitMemoPdfStatusBatchResponse> localVarResp = this.getDebitMemoPdfStatusWithHttpInfo(debitMemoKeys, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetDebitMemoPdfStatusBatchResponse> getDebitMemoPdfStatusWithHttpInfo(String debitMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDebitMemoPdfStatusValidateBeforeCall(debitMemoKeys, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetDebitMemoPdfStatusBatchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getDebitMemoPdfStatusAsync(String debitMemoKeys, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetDebitMemoPdfStatusBatchResponse> _callback) throws ApiException {
        Call localVarCall = this.getDebitMemoPdfStatusValidateBeforeCall(debitMemoKeys, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetDebitMemoPdfStatusBatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDebitMemoPdfStatusApi getDebitMemoPdfStatusApi(String debitMemoKeys) {
        return new GetDebitMemoPdfStatusApi(debitMemoKeys);
    }

    private Call getDebitMemosCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal balance, BigDecimal beAppliedAmount, String createdById, String createdDate, String currency, LocalDate debitMemoDate, LocalDate dueDate, String number, String referredInvoiceId, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (accountId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("accountId", accountId));
        }
        if (accountNumber != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("accountNumber", accountNumber));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (balance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("balance", balance));
        }
        if (beAppliedAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("beAppliedAmount", beAppliedAmount));
        }
        if (createdById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdById", createdById));
        }
        if (createdDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdDate", createdDate));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (debitMemoDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("debitMemoDate", debitMemoDate));
        }
        if (dueDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueDate", dueDate));
        }
        if (number != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("number", number));
        }
        if (referredInvoiceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("referredInvoiceId", referredInvoiceId));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", (Object)status));
        }
        if (targetDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("targetDate", targetDate));
        }
        if (taxAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("taxAmount", taxAmount));
        }
        if (totalTaxExemptAmount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("totalTaxExemptAmount", totalTaxExemptAmount));
        }
        if (updatedById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedById", updatedById));
        }
        if (updatedDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedDate", updatedDate));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitMemosValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal balance, BigDecimal beAppliedAmount, String createdById, String createdDate, String currency, LocalDate debitMemoDate, LocalDate dueDate, String number, String referredInvoiceId, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getDebitMemosCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, accountId, accountNumber, amount, balance, beAppliedAmount, createdById, createdDate, currency, debitMemoDate, dueDate, number, referredInvoiceId, status, targetDate, taxAmount, totalTaxExemptAmount, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DebitMemosResponse getDebitMemos(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal balance, BigDecimal beAppliedAmount, String createdById, String createdDate, String currency, LocalDate debitMemoDate, LocalDate dueDate, String number, String referredInvoiceId, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemosResponse> localVarResp = this.getDebitMemosWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, accountId, accountNumber, amount, balance, beAppliedAmount, createdById, createdDate, currency, debitMemoDate, dueDate, number, referredInvoiceId, status, targetDate, taxAmount, totalTaxExemptAmount, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemosResponse> getDebitMemosWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal balance, BigDecimal beAppliedAmount, String createdById, String createdDate, String currency, LocalDate debitMemoDate, LocalDate dueDate, String number, String referredInvoiceId, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDebitMemosValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, accountId, accountNumber, amount, balance, beAppliedAmount, createdById, createdDate, currency, debitMemoDate, dueDate, number, referredInvoiceId, status, targetDate, taxAmount, totalTaxExemptAmount, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemosResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getDebitMemosAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String accountId, String accountNumber, BigDecimal amount, BigDecimal balance, BigDecimal beAppliedAmount, String createdById, String createdDate, String currency, LocalDate debitMemoDate, LocalDate dueDate, String number, String referredInvoiceId, BillingDocumentStatus status, LocalDate targetDate, BigDecimal taxAmount, BigDecimal totalTaxExemptAmount, String updatedById, String updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, ApiCallback<DebitMemosResponse> _callback) throws ApiException {
        Call localVarCall = this.getDebitMemosValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, accountId, accountNumber, amount, balance, beAppliedAmount, createdById, createdDate, currency, debitMemoDate, dueDate, number, referredInvoiceId, status, targetDate, taxAmount, totalTaxExemptAmount, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemosResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDebitMemosApi getDebitMemosApi() {
        return new GetDebitMemosApi();
    }

    private Call getTaxationItemsOfDebitMemoItemCall(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/items/{debitMemoItemId}/taxation-items".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString())).replace("{debitMemoItemId}", this.localVarApiClient.escapeString(debitMemoItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTaxationItemsOfDebitMemoItemValidateBeforeCall(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling getTaxationItemsOfDebitMemoItem(Async)");
        }
        if (debitMemoItemId == null) {
            throw new ApiException("Missing the required parameter 'debitMemoItemId' when calling getTaxationItemsOfDebitMemoItem(Async)");
        }
        return this.getTaxationItemsOfDebitMemoItemCall(debitMemoKey, debitMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetTaxationItemsOfDebitMemoItemResponse getTaxationItemsOfDebitMemoItem(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetTaxationItemsOfDebitMemoItemResponse> localVarResp = this.getTaxationItemsOfDebitMemoItemWithHttpInfo(debitMemoKey, debitMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetTaxationItemsOfDebitMemoItemResponse> getTaxationItemsOfDebitMemoItemWithHttpInfo(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getTaxationItemsOfDebitMemoItemValidateBeforeCall(debitMemoKey, debitMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetTaxationItemsOfDebitMemoItemResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getTaxationItemsOfDebitMemoItemAsync(String debitMemoKey, String debitMemoItemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetTaxationItemsOfDebitMemoItemResponse> _callback) throws ApiException {
        Call localVarCall = this.getTaxationItemsOfDebitMemoItemValidateBeforeCall(debitMemoKey, debitMemoItemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetTaxationItemsOfDebitMemoItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetTaxationItemsOfDebitMemoItemApi getTaxationItemsOfDebitMemoItemApi(String debitMemoKey, String debitMemoItemId) {
        return new GetTaxationItemsOfDebitMemoItemApi(debitMemoKey, debitMemoItemId);
    }

    private Call postAsyncDebitMemoCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/post-async".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postAsyncDebitMemoValidateBeforeCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling postAsyncDebitMemo(Async)");
        }
        return this.postAsyncDebitMemoCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected AsyncOperationResponse postAsyncDebitMemo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<AsyncOperationResponse> localVarResp = this.postAsyncDebitMemoWithHttpInfo(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<AsyncOperationResponse> postAsyncDebitMemoWithHttpInfo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postAsyncDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<AsyncOperationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postAsyncDebitMemoAsync(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<AsyncOperationResponse> _callback) throws ApiException {
        Call localVarCall = this.postAsyncDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<AsyncOperationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostAsyncDebitMemoApi postAsyncDebitMemoApi(String debitMemoKey) {
        return new PostAsyncDebitMemoApi(debitMemoKey);
    }

    private Call postDebitMemoCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/post".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postDebitMemoValidateBeforeCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling postDebitMemo(Async)");
        }
        return this.postDebitMemoCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DebitMemoResponse postDebitMemo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemoResponse> localVarResp = this.postDebitMemoWithHttpInfo(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemoResponse> postDebitMemoWithHttpInfo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postDebitMemoAsync(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<DebitMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.postDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostDebitMemoApi postDebitMemoApi(String debitMemoKey) {
        return new PostDebitMemoApi(debitMemoKey);
    }

    private Call unpostDebitMemoCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/unpost".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unpostDebitMemoValidateBeforeCall(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling unpostDebitMemo(Async)");
        }
        return this.unpostDebitMemoCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DebitMemoResponse unpostDebitMemo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemoResponse> localVarResp = this.unpostDebitMemoWithHttpInfo(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemoResponse> unpostDebitMemoWithHttpInfo(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unpostDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call unpostDebitMemoAsync(String debitMemoKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<DebitMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.unpostDebitMemoValidateBeforeCall(debitMemoKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnpostDebitMemoApi unpostDebitMemoApi(String debitMemoKey) {
        return new UnpostDebitMemoApi(debitMemoKey);
    }

    private Call updateDebitMemoCall(String debitMemoKey, UpdateDebitMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateDebitMemoRequest localVarPostBody = body;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDebitMemoValidateBeforeCall(String debitMemoKey, UpdateDebitMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling updateDebitMemo(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateDebitMemo(Async)");
        }
        return this.updateDebitMemoCall(debitMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected DebitMemoResponse updateDebitMemo(String debitMemoKey, UpdateDebitMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<DebitMemoResponse> localVarResp = this.updateDebitMemoWithHttpInfo(debitMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<DebitMemoResponse> updateDebitMemoWithHttpInfo(String debitMemoKey, UpdateDebitMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateDebitMemoValidateBeforeCall(debitMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateDebitMemoAsync(String debitMemoKey, UpdateDebitMemoRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<DebitMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.updateDebitMemoValidateBeforeCall(debitMemoKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateDebitMemoApi updateDebitMemoApi(String debitMemoKey, UpdateDebitMemoRequest body) {
        return new UpdateDebitMemoApi(debitMemoKey, body);
    }

    private Call updateDebitMemosDueDatesCall(UpdateDebitMemosDueDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateDebitMemosDueDatesRequest localVarPostBody = body;
        String localVarPath = "/v1/debitmemos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDebitMemosDueDatesValidateBeforeCall(UpdateDebitMemosDueDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateDebitMemosDueDates(Async)");
        }
        return this.updateDebitMemosDueDatesCall(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse updateDebitMemosDueDates(UpdateDebitMemosDueDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.updateDebitMemosDueDatesWithHttpInfo(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> updateDebitMemosDueDatesWithHttpInfo(UpdateDebitMemosDueDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateDebitMemosDueDatesValidateBeforeCall(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateDebitMemosDueDatesAsync(UpdateDebitMemosDueDatesRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.updateDebitMemosDueDatesValidateBeforeCall(body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateDebitMemosDueDatesApi updateDebitMemosDueDatesApi(UpdateDebitMemosDueDatesRequest body) {
        return new UpdateDebitMemosDueDatesApi(body);
    }

    private Call uploadFileForDebitMemoCall(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/files".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadFileForDebitMemoValidateBeforeCall(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling uploadFileForDebitMemo(Async)");
        }
        return this.uploadFileForDebitMemoCall(debitMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _file, _callback);
    }

    protected UploadFileResponse uploadFileForDebitMemo(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file) throws ApiException {
        ApiResponse<UploadFileResponse> localVarResp = this.uploadFileForDebitMemoWithHttpInfo(debitMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _file);
        return localVarResp.getData();
    }

    private ApiResponse<UploadFileResponse> uploadFileForDebitMemoWithHttpInfo(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file) throws ApiException {
        Call localVarCall = this.uploadFileForDebitMemoValidateBeforeCall(debitMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _file, null);
        Type localVarReturnType = new TypeToken<UploadFileResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadFileForDebitMemoAsync(String debitMemoKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, File _file, ApiCallback<UploadFileResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadFileForDebitMemoValidateBeforeCall(debitMemoKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, _file, _callback);
        Type localVarReturnType = new TypeToken<UploadFileResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UploadFileForDebitMemoApi uploadFileForDebitMemoApi(String debitMemoKey) {
        return new UploadFileForDebitMemoApi(debitMemoKey);
    }

    private Call writeOffDebitMemoCall(String debitMemoKey, WriteOffDebitMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WriteOffDebitMemoRequest localVarPostBody = request;
        String localVarPath = "/v1/debitmemos/{debitMemoKey}/write-off".replace("{debitMemoKey}", this.localVarApiClient.escapeString(debitMemoKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call writeOffDebitMemoValidateBeforeCall(String debitMemoKey, WriteOffDebitMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoKey == null) {
            throw new ApiException("Missing the required parameter 'debitMemoKey' when calling writeOffDebitMemo(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling writeOffDebitMemo(Async)");
        }
        return this.writeOffDebitMemoCall(debitMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected WriteOffDebitMemoResponse writeOffDebitMemo(String debitMemoKey, WriteOffDebitMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<WriteOffDebitMemoResponse> localVarResp = this.writeOffDebitMemoWithHttpInfo(debitMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<WriteOffDebitMemoResponse> writeOffDebitMemoWithHttpInfo(String debitMemoKey, WriteOffDebitMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.writeOffDebitMemoValidateBeforeCall(debitMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<WriteOffDebitMemoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call writeOffDebitMemoAsync(String debitMemoKey, WriteOffDebitMemoRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<WriteOffDebitMemoResponse> _callback) throws ApiException {
        Call localVarCall = this.writeOffDebitMemoValidateBeforeCall(debitMemoKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<WriteOffDebitMemoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public WriteOffDebitMemoApi writeOffDebitMemoApi(String debitMemoKey, WriteOffDebitMemoRequest request) {
        return new WriteOffDebitMemoApi(debitMemoKey, request);
    }

    public class WriteOffDebitMemoApi {
        private final String debitMemoKey;
        private final WriteOffDebitMemoRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private WriteOffDebitMemoApi(String debitMemoKey, WriteOffDebitMemoRequest request) {
            this.debitMemoKey = debitMemoKey;
            this.request = request;
        }

        public WriteOffDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public WriteOffDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public WriteOffDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public WriteOffDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public WriteOffDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public WriteOffDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public WriteOffDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.writeOffDebitMemoCall(this.debitMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public WriteOffDebitMemoResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.writeOffDebitMemoWithHttpInfo(this.debitMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (WriteOffDebitMemoResponse)localVarResp.getData();
        }

        private ApiResponse<WriteOffDebitMemoResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.writeOffDebitMemoWithHttpInfo(this.debitMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<WriteOffDebitMemoResponse> _callback) throws ApiException {
            return DebitMemosApi.this.writeOffDebitMemoAsync(this.debitMemoKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UploadFileForDebitMemoApi {
        private final String debitMemoKey;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private File _file;

        private UploadFileForDebitMemoApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public UploadFileForDebitMemoApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public UploadFileForDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UploadFileForDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UploadFileForDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UploadFileForDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UploadFileForDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UploadFileForDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UploadFileForDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public UploadFileForDebitMemoApi _file(File _file) {
            this._file = _file;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.uploadFileForDebitMemoCall(this.debitMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this._file, _callback);
        }

        public UploadFileResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.uploadFileForDebitMemoWithHttpInfo(this.debitMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this._file);
            return (UploadFileResponse)localVarResp.getData();
        }

        private ApiResponse<UploadFileResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.uploadFileForDebitMemoWithHttpInfo(this.debitMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this._file);
        }

        public Call executeAsync(ApiCallback<UploadFileResponse> _callback) throws ApiException {
            return DebitMemosApi.this.uploadFileForDebitMemoAsync(this.debitMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this._file, _callback);
        }
    }

    public class UpdateDebitMemosDueDatesApi {
        private final UpdateDebitMemosDueDatesRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateDebitMemosDueDatesApi(UpdateDebitMemosDueDatesRequest body) {
            this.body = body;
        }

        public UpdateDebitMemosDueDatesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateDebitMemosDueDatesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateDebitMemosDueDatesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateDebitMemosDueDatesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateDebitMemosDueDatesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateDebitMemosDueDatesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateDebitMemosDueDatesApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.updateDebitMemosDueDatesCall(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.updateDebitMemosDueDatesWithHttpInfo(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.updateDebitMemosDueDatesWithHttpInfo(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return DebitMemosApi.this.updateDebitMemosDueDatesAsync(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UpdateDebitMemoApi {
        private final String debitMemoKey;
        private final UpdateDebitMemoRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateDebitMemoApi(String debitMemoKey, UpdateDebitMemoRequest body) {
            this.debitMemoKey = debitMemoKey;
            this.body = body;
        }

        public UpdateDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.updateDebitMemoCall(this.debitMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DebitMemoResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.updateDebitMemoWithHttpInfo(this.debitMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (DebitMemoResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemoResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.updateDebitMemoWithHttpInfo(this.debitMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemoResponse> _callback) throws ApiException {
            return DebitMemosApi.this.updateDebitMemoAsync(this.debitMemoKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UnpostDebitMemoApi {
        private final String debitMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UnpostDebitMemoApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public UnpostDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UnpostDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UnpostDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UnpostDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UnpostDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UnpostDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UnpostDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.unpostDebitMemoCall(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DebitMemoResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.unpostDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (DebitMemoResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemoResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.unpostDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemoResponse> _callback) throws ApiException {
            return DebitMemosApi.this.unpostDebitMemoAsync(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class PostDebitMemoApi {
        private final String debitMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PostDebitMemoApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public PostDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.postDebitMemoCall(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DebitMemoResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.postDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (DebitMemoResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemoResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.postDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemoResponse> _callback) throws ApiException {
            return DebitMemosApi.this.postDebitMemoAsync(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class PostAsyncDebitMemoApi {
        private final String debitMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PostAsyncDebitMemoApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public PostAsyncDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostAsyncDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostAsyncDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostAsyncDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostAsyncDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostAsyncDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostAsyncDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.postAsyncDebitMemoCall(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public AsyncOperationResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.postAsyncDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (AsyncOperationResponse)localVarResp.getData();
        }

        private ApiResponse<AsyncOperationResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.postAsyncDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<AsyncOperationResponse> _callback) throws ApiException {
            return DebitMemosApi.this.postAsyncDebitMemoAsync(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetTaxationItemsOfDebitMemoItemApi {
        private final String debitMemoKey;
        private final String debitMemoItemId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer pageSize;
        private Integer page;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetTaxationItemsOfDebitMemoItemApi(String debitMemoKey, String debitMemoItemId) {
            this.debitMemoKey = debitMemoKey;
            this.debitMemoItemId = debitMemoItemId;
        }

        public GetTaxationItemsOfDebitMemoItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetTaxationItemsOfDebitMemoItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetTaxationItemsOfDebitMemoItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetTaxationItemsOfDebitMemoItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetTaxationItemsOfDebitMemoItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetTaxationItemsOfDebitMemoItemApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetTaxationItemsOfDebitMemoItemApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetTaxationItemsOfDebitMemoItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetTaxationItemsOfDebitMemoItemApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.getTaxationItemsOfDebitMemoItemCall(this.debitMemoKey, this.debitMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetTaxationItemsOfDebitMemoItemResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.getTaxationItemsOfDebitMemoItemWithHttpInfo(this.debitMemoKey, this.debitMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, this.zuoraOrgIds);
            return (GetTaxationItemsOfDebitMemoItemResponse)localVarResp.getData();
        }

        private ApiResponse<GetTaxationItemsOfDebitMemoItemResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.getTaxationItemsOfDebitMemoItemWithHttpInfo(this.debitMemoKey, this.debitMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetTaxationItemsOfDebitMemoItemResponse> _callback) throws ApiException {
            return DebitMemosApi.this.getTaxationItemsOfDebitMemoItemAsync(this.debitMemoKey, this.debitMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetDebitMemosApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String accountId;
        private String accountNumber;
        private BigDecimal amount;
        private BigDecimal balance;
        private BigDecimal beAppliedAmount;
        private String createdById;
        private String createdDate;
        private String currency;
        private LocalDate debitMemoDate;
        private LocalDate dueDate;
        private String number;
        private String referredInvoiceId;
        private BillingDocumentStatus status;
        private LocalDate targetDate;
        private BigDecimal taxAmount;
        private BigDecimal totalTaxExemptAmount;
        private String updatedById;
        private String updatedDate;
        private String sort;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetDebitMemosApi() {
        }

        public GetDebitMemosApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDebitMemosApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDebitMemosApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetDebitMemosApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetDebitMemosApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDebitMemosApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetDebitMemosApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetDebitMemosApi accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public GetDebitMemosApi accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public GetDebitMemosApi amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public GetDebitMemosApi balance(BigDecimal balance) {
            this.balance = balance;
            return this;
        }

        public GetDebitMemosApi beAppliedAmount(BigDecimal beAppliedAmount) {
            this.beAppliedAmount = beAppliedAmount;
            return this;
        }

        public GetDebitMemosApi createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public GetDebitMemosApi createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public GetDebitMemosApi currency(String currency) {
            this.currency = currency;
            return this;
        }

        public GetDebitMemosApi debitMemoDate(LocalDate debitMemoDate) {
            this.debitMemoDate = debitMemoDate;
            return this;
        }

        public GetDebitMemosApi dueDate(LocalDate dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public GetDebitMemosApi number(String number) {
            this.number = number;
            return this;
        }

        public GetDebitMemosApi referredInvoiceId(String referredInvoiceId) {
            this.referredInvoiceId = referredInvoiceId;
            return this;
        }

        public GetDebitMemosApi status(BillingDocumentStatus status) {
            this.status = status;
            return this;
        }

        public GetDebitMemosApi targetDate(LocalDate targetDate) {
            this.targetDate = targetDate;
            return this;
        }

        public GetDebitMemosApi taxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
            return this;
        }

        public GetDebitMemosApi totalTaxExemptAmount(BigDecimal totalTaxExemptAmount) {
            this.totalTaxExemptAmount = totalTaxExemptAmount;
            return this;
        }

        public GetDebitMemosApi updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public GetDebitMemosApi updatedDate(String updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public GetDebitMemosApi sort(String sort) {
            this.sort = sort;
            return this;
        }

        public GetDebitMemosApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetDebitMemosApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemosCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.accountId, this.accountNumber, this.amount, this.balance, this.beAppliedAmount, this.createdById, this.createdDate, this.currency, this.debitMemoDate, this.dueDate, this.number, this.referredInvoiceId, this.status, this.targetDate, this.taxAmount, this.totalTaxExemptAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DebitMemosResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.getDebitMemosWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.accountId, this.accountNumber, this.amount, this.balance, this.beAppliedAmount, this.createdById, this.createdDate, this.currency, this.debitMemoDate, this.dueDate, this.number, this.referredInvoiceId, this.status, this.targetDate, this.taxAmount, this.totalTaxExemptAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds);
            return (DebitMemosResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemosResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.getDebitMemosWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.accountId, this.accountNumber, this.amount, this.balance, this.beAppliedAmount, this.createdById, this.createdDate, this.currency, this.debitMemoDate, this.dueDate, this.number, this.referredInvoiceId, this.status, this.targetDate, this.taxAmount, this.totalTaxExemptAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemosResponse> _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemosAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.accountId, this.accountNumber, this.amount, this.balance, this.beAppliedAmount, this.createdById, this.createdDate, this.currency, this.debitMemoDate, this.dueDate, this.number, this.referredInvoiceId, this.status, this.targetDate, this.taxAmount, this.totalTaxExemptAmount, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetDebitMemoPdfStatusApi {
        private final String debitMemoKeys;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetDebitMemoPdfStatusApi(String debitMemoKeys) {
            this.debitMemoKeys = debitMemoKeys;
        }

        public GetDebitMemoPdfStatusApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDebitMemoPdfStatusApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDebitMemoPdfStatusApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetDebitMemoPdfStatusApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetDebitMemoPdfStatusApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDebitMemoPdfStatusApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetDebitMemoPdfStatusApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoPdfStatusCall(this.debitMemoKeys, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetDebitMemoPdfStatusBatchResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.getDebitMemoPdfStatusWithHttpInfo(this.debitMemoKeys, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (GetDebitMemoPdfStatusBatchResponse)localVarResp.getData();
        }

        private ApiResponse<GetDebitMemoPdfStatusBatchResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.getDebitMemoPdfStatusWithHttpInfo(this.debitMemoKeys, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetDebitMemoPdfStatusBatchResponse> _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoPdfStatusAsync(this.debitMemoKeys, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetDebitMemoItemsApi {
        private final String debitMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;
        private BigDecimal amount;
        private BigDecimal beAppliedAmount;
        private String createdById;
        private String createdDate;
        private String id;
        private LocalDate serviceEndDate;
        private LocalDate serviceStartDate;
        private String sku;
        private String skuName;
        private String sourceItemId;
        private String subscriptionId;
        private String updatedById;
        private String updatedDate;
        private String sort;
        private String zuoraOrgIds;

        private GetDebitMemoItemsApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public GetDebitMemoItemsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDebitMemoItemsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDebitMemoItemsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetDebitMemoItemsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetDebitMemoItemsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDebitMemoItemsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetDebitMemoItemsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetDebitMemoItemsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetDebitMemoItemsApi amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public GetDebitMemoItemsApi beAppliedAmount(BigDecimal beAppliedAmount) {
            this.beAppliedAmount = beAppliedAmount;
            return this;
        }

        public GetDebitMemoItemsApi createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public GetDebitMemoItemsApi createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public GetDebitMemoItemsApi id(String id) {
            this.id = id;
            return this;
        }

        public GetDebitMemoItemsApi serviceEndDate(LocalDate serviceEndDate) {
            this.serviceEndDate = serviceEndDate;
            return this;
        }

        public GetDebitMemoItemsApi serviceStartDate(LocalDate serviceStartDate) {
            this.serviceStartDate = serviceStartDate;
            return this;
        }

        public GetDebitMemoItemsApi sku(String sku) {
            this.sku = sku;
            return this;
        }

        public GetDebitMemoItemsApi skuName(String skuName) {
            this.skuName = skuName;
            return this;
        }

        public GetDebitMemoItemsApi sourceItemId(String sourceItemId) {
            this.sourceItemId = sourceItemId;
            return this;
        }

        public GetDebitMemoItemsApi subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public GetDebitMemoItemsApi updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public GetDebitMemoItemsApi updatedDate(String updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public GetDebitMemoItemsApi sort(String sort) {
            this.sort = sort;
            return this;
        }

        public GetDebitMemoItemsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoItemsCall(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.amount, this.beAppliedAmount, this.createdById, this.createdDate, this.id, this.serviceEndDate, this.serviceStartDate, this.sku, this.skuName, this.sourceItemId, this.subscriptionId, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds, _callback);
        }

        public DebitMemoItemsResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.getDebitMemoItemsWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.amount, this.beAppliedAmount, this.createdById, this.createdDate, this.id, this.serviceEndDate, this.serviceStartDate, this.sku, this.skuName, this.sourceItemId, this.subscriptionId, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds);
            return (DebitMemoItemsResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemoItemsResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.getDebitMemoItemsWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.amount, this.beAppliedAmount, this.createdById, this.createdDate, this.id, this.serviceEndDate, this.serviceStartDate, this.sku, this.skuName, this.sourceItemId, this.subscriptionId, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemoItemsResponse> _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoItemsAsync(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.amount, this.beAppliedAmount, this.createdById, this.createdDate, this.id, this.serviceEndDate, this.serviceStartDate, this.sku, this.skuName, this.sourceItemId, this.subscriptionId, this.updatedById, this.updatedDate, this.sort, this.zuoraOrgIds, _callback);
        }
    }

    public class GetDebitMemoItemApi {
        private final String debitMemoKey;
        private final String debitMemoItemId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetDebitMemoItemApi(String debitMemoKey, String debitMemoItemId) {
            this.debitMemoKey = debitMemoKey;
            this.debitMemoItemId = debitMemoItemId;
        }

        public GetDebitMemoItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDebitMemoItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDebitMemoItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetDebitMemoItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetDebitMemoItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDebitMemoItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetDebitMemoItemApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoItemCall(this.debitMemoKey, this.debitMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DebitMemoItemResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.getDebitMemoItemWithHttpInfo(this.debitMemoKey, this.debitMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (DebitMemoItemResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemoItemResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.getDebitMemoItemWithHttpInfo(this.debitMemoKey, this.debitMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemoItemResponse> _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoItemAsync(this.debitMemoKey, this.debitMemoItemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetDebitMemoApplicationPartsApi {
        private final String debitMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetDebitMemoApplicationPartsApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public GetDebitMemoApplicationPartsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDebitMemoApplicationPartsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDebitMemoApplicationPartsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetDebitMemoApplicationPartsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetDebitMemoApplicationPartsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDebitMemoApplicationPartsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetDebitMemoApplicationPartsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoApplicationPartsCall(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetDebitMemoApplicationPartsResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.getDebitMemoApplicationPartsWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (GetDebitMemoApplicationPartsResponse)localVarResp.getData();
        }

        private ApiResponse<GetDebitMemoApplicationPartsResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.getDebitMemoApplicationPartsWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetDebitMemoApplicationPartsResponse> _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoApplicationPartsAsync(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetDebitMemoApi {
        private final String debitMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetDebitMemoApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public GetDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoCall(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DebitMemoResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.getDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (DebitMemoResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemoResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.getDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemoResponse> _callback) throws ApiException {
            return DebitMemosApi.this.getDebitMemoAsync(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GenerateDebitMemoPdfApi {
        private final String debitMemoKey;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GenerateDebitMemoPdfApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public GenerateDebitMemoPdfApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public GenerateDebitMemoPdfApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GenerateDebitMemoPdfApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GenerateDebitMemoPdfApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GenerateDebitMemoPdfApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GenerateDebitMemoPdfApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GenerateDebitMemoPdfApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GenerateDebitMemoPdfApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.generateDebitMemoPdfCall(this.debitMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.generateDebitMemoPdfWithHttpInfo(this.debitMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.generateDebitMemoPdfWithHttpInfo(this.debitMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return DebitMemosApi.this.generateDebitMemoPdfAsync(this.debitMemoKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class EmailDebitMemoApi {
        private final String debitMemoKey;
        private final EmailBillingDocumentRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private EmailDebitMemoApi(String debitMemoKey, EmailBillingDocumentRequest request) {
            this.debitMemoKey = debitMemoKey;
            this.request = request;
        }

        public EmailDebitMemoApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public EmailDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public EmailDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public EmailDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public EmailDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public EmailDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public EmailDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public EmailDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.emailDebitMemoCall(this.debitMemoKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.emailDebitMemoWithHttpInfo(this.debitMemoKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.emailDebitMemoWithHttpInfo(this.debitMemoKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return DebitMemosApi.this.emailDebitMemoAsync(this.debitMemoKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class DeleteDebitMemoApi {
        private final String debitMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DeleteDebitMemoApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public DeleteDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.deleteDebitMemoCall(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.deleteDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.deleteDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return DebitMemosApi.this.deleteDebitMemoAsync(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateTaxationItemsForDebitMemoApi {
        private final String debitMemoKey;
        private final CreateTaxationItemsForDebitMemoRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateTaxationItemsForDebitMemoApi(String debitMemoKey, CreateTaxationItemsForDebitMemoRequest body) {
            this.debitMemoKey = debitMemoKey;
            this.body = body;
        }

        public CreateTaxationItemsForDebitMemoApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateTaxationItemsForDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateTaxationItemsForDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateTaxationItemsForDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateTaxationItemsForDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateTaxationItemsForDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateTaxationItemsForDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateTaxationItemsForDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.createTaxationItemsForDebitMemoCall(this.debitMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetTaxationItemsResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.createTaxationItemsForDebitMemoWithHttpInfo(this.debitMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (GetTaxationItemsResponse)localVarResp.getData();
        }

        private ApiResponse<GetTaxationItemsResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.createTaxationItemsForDebitMemoWithHttpInfo(this.debitMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetTaxationItemsResponse> _callback) throws ApiException {
            return DebitMemosApi.this.createTaxationItemsForDebitMemoAsync(this.debitMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateDebitMemoFromInvoiceApi {
        private final String invoiceKey;
        private final CreateDebitMemoFromInvoiceRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateDebitMemoFromInvoiceApi(String invoiceKey, CreateDebitMemoFromInvoiceRequest body) {
            this.invoiceKey = invoiceKey;
            this.body = body;
        }

        public CreateDebitMemoFromInvoiceApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateDebitMemoFromInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateDebitMemoFromInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateDebitMemoFromInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateDebitMemoFromInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateDebitMemoFromInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateDebitMemoFromInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateDebitMemoFromInvoiceApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.createDebitMemoFromInvoiceCall(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DebitMemoResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.createDebitMemoFromInvoiceWithHttpInfo(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (DebitMemoResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemoResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.createDebitMemoFromInvoiceWithHttpInfo(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemoResponse> _callback) throws ApiException {
            return DebitMemosApi.this.createDebitMemoFromInvoiceAsync(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateDebitMemoFromChargeApi {
        private final CreateDebitMemoFromChargeRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateDebitMemoFromChargeApi(CreateDebitMemoFromChargeRequest body) {
            this.body = body;
        }

        public CreateDebitMemoFromChargeApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateDebitMemoFromChargeApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateDebitMemoFromChargeApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateDebitMemoFromChargeApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateDebitMemoFromChargeApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateDebitMemoFromChargeApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateDebitMemoFromChargeApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateDebitMemoFromChargeApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.createDebitMemoFromChargeCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DebitMemoResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.createDebitMemoFromChargeWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (DebitMemoResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemoResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.createDebitMemoFromChargeWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemoResponse> _callback) throws ApiException {
            return DebitMemosApi.this.createDebitMemoFromChargeAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CollectDebitMemoApi {
        private final String debitMemoKey;
        private final CollectDebitMemoRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CollectDebitMemoApi(String debitMemoKey, CollectDebitMemoRequest body) {
            this.debitMemoKey = debitMemoKey;
            this.body = body;
        }

        public CollectDebitMemoApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CollectDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CollectDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CollectDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CollectDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CollectDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CollectDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CollectDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.collectDebitMemoCall(this.debitMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CollectDebitMemoResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.collectDebitMemoWithHttpInfo(this.debitMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CollectDebitMemoResponse)localVarResp.getData();
        }

        private ApiResponse<CollectDebitMemoResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.collectDebitMemoWithHttpInfo(this.debitMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CollectDebitMemoResponse> _callback) throws ApiException {
            return DebitMemosApi.this.collectDebitMemoAsync(this.debitMemoKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CancelDebitMemoApi {
        private final String debitMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CancelDebitMemoApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public CancelDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CancelDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.cancelDebitMemoCall(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public DebitMemoResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.cancelDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (DebitMemoResponse)localVarResp.getData();
        }

        private ApiResponse<DebitMemoResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.cancelDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<DebitMemoResponse> _callback) throws ApiException {
            return DebitMemosApi.this.cancelDebitMemoAsync(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CancelAsyncDebitMemoApi {
        private final String debitMemoKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CancelAsyncDebitMemoApi(String debitMemoKey) {
            this.debitMemoKey = debitMemoKey;
        }

        public CancelAsyncDebitMemoApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelAsyncDebitMemoApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelAsyncDebitMemoApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelAsyncDebitMemoApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelAsyncDebitMemoApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelAsyncDebitMemoApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CancelAsyncDebitMemoApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.cancelAsyncDebitMemoCall(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public AsyncOperationResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.cancelAsyncDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (AsyncOperationResponse)localVarResp.getData();
        }

        private ApiResponse<AsyncOperationResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.cancelAsyncDebitMemoWithHttpInfo(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<AsyncOperationResponse> _callback) throws ApiException {
            return DebitMemosApi.this.cancelAsyncDebitMemoAsync(this.debitMemoKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class BulkUpdateDebitMemosApi {
        private final BulkUpdateDebitMemosRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private BulkUpdateDebitMemosApi(BulkUpdateDebitMemosRequest body) {
            this.body = body;
        }

        public BulkUpdateDebitMemosApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public BulkUpdateDebitMemosApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public BulkUpdateDebitMemosApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public BulkUpdateDebitMemosApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public BulkUpdateDebitMemosApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public BulkUpdateDebitMemosApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public BulkUpdateDebitMemosApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.bulkUpdateDebitMemosCall(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public BulkDebitMemosResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.bulkUpdateDebitMemosWithHttpInfo(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (BulkDebitMemosResponse)localVarResp.getData();
        }

        private ApiResponse<BulkDebitMemosResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.bulkUpdateDebitMemosWithHttpInfo(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<BulkDebitMemosResponse> _callback) throws ApiException {
            return DebitMemosApi.this.bulkUpdateDebitMemosAsync(this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class BulkCreateDebitMemosApi {
        private final BulkCreateDebitMemosRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private BulkCreateDebitMemosApi(BulkCreateDebitMemosRequest body) {
            this.body = body;
        }

        public BulkCreateDebitMemosApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public BulkCreateDebitMemosApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public BulkCreateDebitMemosApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public BulkCreateDebitMemosApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public BulkCreateDebitMemosApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public BulkCreateDebitMemosApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public BulkCreateDebitMemosApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public BulkCreateDebitMemosApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DebitMemosApi.this.bulkCreateDebitMemosCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public BulkDebitMemosResponse execute() throws ApiException {
            ApiResponse localVarResp = DebitMemosApi.this.bulkCreateDebitMemosWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (BulkDebitMemosResponse)localVarResp.getData();
        }

        private ApiResponse<BulkDebitMemosResponse> executeWithHttpInfo() throws ApiException {
            return DebitMemosApi.this.bulkCreateDebitMemosWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<BulkDebitMemosResponse> _callback) throws ApiException {
            return DebitMemosApi.this.bulkCreateDebitMemosAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

