/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.PriceListResponse;
import org.openapitools.client.model.Product;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Plan information.")
public class Plan {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PLAN_NUMBER = "plan_number";
    @SerializedName(value="plan_number")
    private String planNumber;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ACTIVE_CURRENCIES = "active_currencies";
    @SerializedName(value="active_currencies")
    private List<String> activeCurrencies = null;
    public static final String SERIALIZED_NAME_PRODUCT_ID = "product_id";
    @SerializedName(value="product_id")
    private String productId;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_PRODUCT = "product";
    @SerializedName(value="product")
    private Product product;
    public static final String SERIALIZED_NAME_SKU = "sku";
    @SerializedName(value="sku")
    private String sku;
    public static final String SERIALIZED_NAME_PRICES = "prices";
    @SerializedName(value="prices")
    private PriceListResponse prices;

    public Plan() {
    }

    public Plan(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, PriceListResponse prices) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.prices = prices;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public Plan customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Plan putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public Plan startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date from which the plan can be used for new purchases.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Plan endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which the plan can no longer be used for new purchases.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Plan name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the plan.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Plan planNumber(String planNumber) {
        this.planNumber = planNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the plan. It can be user-supplied.")
    public String getPlanNumber() {
        return this.planNumber;
    }

    public void setPlanNumber(String planNumber) {
        this.planNumber = planNumber;
    }

    public Plan description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Plan activeCurrencies(List<String> activeCurrencies) {
        this.activeCurrencies = activeCurrencies;
        return this;
    }

    public Plan addActiveCurrenciesItem(String activeCurrenciesItem) {
        if (this.activeCurrencies == null) {
            this.activeCurrencies = new ArrayList<String>();
        }
        this.activeCurrencies.add(activeCurrenciesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of 3-letter ISO-standard currency codes representing active currencies for the plan.")
    public List<String> getActiveCurrencies() {
        return this.activeCurrencies;
    }

    public void setActiveCurrencies(List<String> activeCurrencies) {
        this.activeCurrencies = activeCurrencies;
    }

    public Plan productId(String productId) {
        this.productId = productId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the product associated with this plan.")
    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Plan active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the plan can be used for new purchases.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Plan product(Product product) {
        this.product = product;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The product associated with this plan.")
    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Plan sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The product sku. This field is only availble for customers using high speed cache.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    @Nullable
    @ApiModelProperty(value="A list of prices.")
    public PriceListResponse getPrices() {
        return this.prices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plan plan = (Plan)o;
        return Objects.equals(this.id, plan.id) && Objects.equals(this.updatedById, plan.updatedById) && Objects.equals(this.updatedTime, plan.updatedTime) && Objects.equals(this.createdById, plan.createdById) && Objects.equals(this.createdTime, plan.createdTime) && Objects.equals(this.customFields, plan.customFields) && Objects.equals(this.customObjects, plan.customObjects) && Objects.equals(this.startDate, plan.startDate) && Objects.equals(this.endDate, plan.endDate) && Objects.equals(this.name, plan.name) && Objects.equals(this.planNumber, plan.planNumber) && Objects.equals(this.description, plan.description) && Objects.equals(this.activeCurrencies, plan.activeCurrencies) && Objects.equals(this.productId, plan.productId) && Objects.equals(this.active, plan.active) && Objects.equals(this.product, plan.product) && Objects.equals(this.sku, plan.sku) && Objects.equals(this.prices, plan.prices);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.startDate, this.endDate, this.name, this.planNumber, this.description, this.activeCurrencies, this.productId, this.active, this.product, this.sku, this.prices);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Plan {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    planNumber: ").append(this.toIndentedString(this.planNumber)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    activeCurrencies: ").append(this.toIndentedString(this.activeCurrencies)).append("\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    prices: ").append(this.toIndentedString(this.prices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

