/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

public class CcRefCard {
    public static final String SERIALIZED_NAME_BRAND = "brand";
    @SerializedName(value="brand")
    private BrandEnum brand;
    public static final String SERIALIZED_NAME_EXPIRY_MONTH = "expiry_month";
    @SerializedName(value="expiry_month")
    private BigDecimal expiryMonth;
    public static final String SERIALIZED_NAME_EXPIRY_YEAR = "expiry_year";
    @SerializedName(value="expiry_year")
    private BigDecimal expiryYear;
    public static final String SERIALIZED_NAME_LAST4 = "last_4";
    @SerializedName(value="last_4")
    private String last4;

    public CcRefCard() {
    }

    public CcRefCard(String last4) {
        this();
        this.last4 = last4;
    }

    public CcRefCard brand(BrandEnum brand) {
        this.brand = brand;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Card brand.")
    public BrandEnum getBrand() {
        return this.brand;
    }

    public void setBrand(BrandEnum brand) {
        this.brand = brand;
    }

    public CcRefCard expiryMonth(BigDecimal expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="One or two digit expiration month (1-12) of the credit card.")
    public BigDecimal getExpiryMonth() {
        return this.expiryMonth;
    }

    public void setExpiryMonth(BigDecimal expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public CcRefCard expiryYear(BigDecimal expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2024", value="Two- or four-digit number representing the card's expiration year.")
    public BigDecimal getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(BigDecimal expiryYear) {
        this.expiryYear = expiryYear;
    }

    @Nullable
    @ApiModelProperty(example="2042", value="The last four digits of the card number.")
    public String getLast4() {
        return this.last4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CcRefCard ccRefCard = (CcRefCard)o;
        return Objects.equals((Object)this.brand, (Object)ccRefCard.brand) && Objects.equals(this.expiryMonth, ccRefCard.expiryMonth) && Objects.equals(this.expiryYear, ccRefCard.expiryYear) && Objects.equals(this.last4, ccRefCard.last4);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brand, this.expiryMonth, this.expiryYear, this.last4});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CcRefCard {\n");
        sb.append("    brand: ").append(this.toIndentedString((Object)this.brand)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    last4: ").append(this.toIndentedString(this.last4)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BrandEnum {
        VISA("visa"),
        MASTERCARD("mastercard"),
        AMERICAN_EXPRESS("american_express"),
        DISCOVER("discover"),
        JCB("jcb"),
        DINERS("diners"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BrandEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BrandEnum fromValue(String value) {
            for (BrandEnum b : BrandEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BrandEnum> {
            public void write(JsonWriter jsonWriter, BrandEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BrandEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BrandEnum.fromValue(value);
            }
        }
    }
}

