/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.BillingDocumentItemCreateRequest;
import org.threeten.bp.LocalDate;

public class BillingDocumentCreateRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DUE_DATE = "due_date";
    @SerializedName(value="due_date")
    private LocalDate dueDate;
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_REASON_CODE = "reason_code";
    @SerializedName(value="reason_code")
    private String reasonCode;
    public static final String SERIALIZED_NAME_INVOICE_ID = "invoice_id";
    @SerializedName(value="invoice_id")
    private String invoiceId;
    public static final String SERIALIZED_NAME_TRANSFER_TO_ACCOUNTING = "transfer_to_accounting";
    @SerializedName(value="transfer_to_accounting")
    private Boolean transferToAccounting;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_EXCLUDE_FROM_AUTO_APPLY_RULES = "exclude_from_auto_apply_rules";
    @SerializedName(value="exclude_from_auto_apply_rules")
    private Boolean excludeFromAutoApplyRules;
    public static final String SERIALIZED_NAME_PAY = "pay";
    @SerializedName(value="pay")
    private Boolean pay;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<BillingDocumentItemCreateRequest> items = null;
    public static final String SERIALIZED_NAME_APPLY = "apply";
    @SerializedName(value="apply")
    private Boolean apply;
    public static final String SERIALIZED_NAME_POST = "post";
    @SerializedName(value="post")
    private Boolean post;

    public BillingDocumentCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the billing document.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BillingDocumentCreateRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the account that owns the billing document.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public BillingDocumentCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string associated with the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BillingDocumentCreateRequest dueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date on which payment for the billing document is due.")
    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public BillingDocumentCreateRequest documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the billing document takes effect.")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public BillingDocumentCreateRequest reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for issuing this billing document. This field is applicable only if the `type` field is set to `credit_memo` or `debit_memo`.")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public BillingDocumentCreateRequest invoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the invoice billing document from which this credit memo or debit memo billing document is created. This field is applicable only if the `type` field is set to `credit_memo` or `debit_memo`.")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public BillingDocumentCreateRequest transferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to transfer to an external accounting system.")
    public Boolean getTransferToAccounting() {
        return this.transferToAccounting;
    }

    public void setTransferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
    }

    public BillingDocumentCreateRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public BillingDocumentCreateRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public BillingDocumentCreateRequest excludeFromAutoApplyRules(Boolean excludeFromAutoApplyRules) {
        this.excludeFromAutoApplyRules = excludeFromAutoApplyRules;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to exclude this credit memo billing document from the rule of automatically applying it to invoices. This field is applicable only if the `type` field is set to `credit_memo`.")
    public Boolean getExcludeFromAutoApplyRules() {
        return this.excludeFromAutoApplyRules;
    }

    public void setExcludeFromAutoApplyRules(Boolean excludeFromAutoApplyRules) {
        this.excludeFromAutoApplyRules = excludeFromAutoApplyRules;
    }

    public BillingDocumentCreateRequest pay(Boolean pay) {
        this.pay = pay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the billing document is automatically picked up for processing in the corresponding payment run.")
    public Boolean getPay() {
        return this.pay;
    }

    public void setPay(Boolean pay) {
        this.pay = pay;
    }

    public BillingDocumentCreateRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of billing document. Can be one of the credit memo, debit memo, or invoice.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BillingDocumentCreateRequest items(List<BillingDocumentItemCreateRequest> items) {
        this.items = items;
        return this;
    }

    public BillingDocumentCreateRequest addItemsItem(BillingDocumentItemCreateRequest itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<BillingDocumentItemCreateRequest>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information of all billing document items.")
    public List<BillingDocumentItemCreateRequest> getItems() {
        return this.items;
    }

    public void setItems(List<BillingDocumentItemCreateRequest> items) {
        this.items = items;
    }

    public BillingDocumentCreateRequest apply(Boolean apply) {
        this.apply = apply;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to automatically apply the billing document upon posting.")
    public Boolean getApply() {
        return this.apply;
    }

    public void setApply(Boolean apply) {
        this.apply = apply;
    }

    public BillingDocumentCreateRequest post(Boolean post) {
        this.post = post;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to automatically post a billing document after it is created.")
    public Boolean getPost() {
        return this.post;
    }

    public void setPost(Boolean post) {
        this.post = post;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingDocumentCreateRequest billingDocumentCreateRequest = (BillingDocumentCreateRequest)o;
        return Objects.equals(this.accountId, billingDocumentCreateRequest.accountId) && Objects.equals(this.accountNumber, billingDocumentCreateRequest.accountNumber) && Objects.equals(this.description, billingDocumentCreateRequest.description) && Objects.equals(this.dueDate, billingDocumentCreateRequest.dueDate) && Objects.equals(this.documentDate, billingDocumentCreateRequest.documentDate) && Objects.equals(this.reasonCode, billingDocumentCreateRequest.reasonCode) && Objects.equals(this.invoiceId, billingDocumentCreateRequest.invoiceId) && Objects.equals(this.transferToAccounting, billingDocumentCreateRequest.transferToAccounting) && Objects.equals(this.customFields, billingDocumentCreateRequest.customFields) && Objects.equals(this.excludeFromAutoApplyRules, billingDocumentCreateRequest.excludeFromAutoApplyRules) && Objects.equals(this.pay, billingDocumentCreateRequest.pay) && Objects.equals((Object)this.type, (Object)billingDocumentCreateRequest.type) && Objects.equals(this.items, billingDocumentCreateRequest.items) && Objects.equals(this.apply, billingDocumentCreateRequest.apply) && Objects.equals(this.post, billingDocumentCreateRequest.post);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.accountNumber, this.description, this.dueDate, this.documentDate, this.reasonCode, this.invoiceId, this.transferToAccounting, this.customFields, this.excludeFromAutoApplyRules, this.pay, this.type, this.items, this.apply, this.post});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingDocumentCreateRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    invoiceId: ").append(this.toIndentedString(this.invoiceId)).append("\n");
        sb.append("    transferToAccounting: ").append(this.toIndentedString(this.transferToAccounting)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    excludeFromAutoApplyRules: ").append(this.toIndentedString(this.excludeFromAutoApplyRules)).append("\n");
        sb.append("    pay: ").append(this.toIndentedString(this.pay)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    apply: ").append(this.toIndentedString(this.apply)).append("\n");
        sb.append("    post: ").append(this.toIndentedString(this.post)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CREDIT_MEMO("credit_memo"),
        DEBIT_MEMO("debit_memo"),
        INVOICE("invoice"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

