/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Tier information for tiered prices.")
public class Tier {
    public static final String SERIALIZED_NAME_UP_TO = "up_to";
    @SerializedName(value="up_to")
    private BigDecimal upTo;
    public static final String SERIALIZED_NAME_AMOUNTS = "amounts";
    @SerializedName(value="amounts")
    private Map amounts;
    public static final String SERIALIZED_NAME_UNIT_AMOUNTS = "unit_amounts";
    @SerializedName(value="unit_amounts")
    private Map unitAmounts;

    public Tier upTo(BigDecimal upTo) {
        this.upTo = upTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The upper bound of a tier. The lower bound of a tier is the upper bound of the previous tier plus one or some fraction of one, depending on the precision of the unit of measure.")
    public BigDecimal getUpTo() {
        return this.upTo;
    }

    public void setUpTo(BigDecimal upTo) {
        this.upTo = upTo;
    }

    public Tier amounts(Map amounts) {
        this.amounts = amounts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Prices for the tier. Only set if `charge_model` is `tiered`, `tiered_overage`, or `highwatermark_tiered`.")
    public Map getAmounts() {
        return this.amounts;
    }

    public void setAmounts(Map amounts) {
        this.amounts = amounts;
    }

    public Tier unitAmounts(Map unitAmounts) {
        this.unitAmounts = unitAmounts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Per unit prices for units in the tier. Only set if `charge_model` is `tiered`, `tiered_overage`, or `highwatermark_tiered`.")
    public Map getUnitAmounts() {
        return this.unitAmounts;
    }

    public void setUnitAmounts(Map unitAmounts) {
        this.unitAmounts = unitAmounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tier tier = (Tier)o;
        return Objects.equals(this.upTo, tier.upTo) && Objects.equals(this.amounts, tier.amounts) && Objects.equals(this.unitAmounts, tier.unitAmounts);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.upTo, this.amounts, this.unitAmounts);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tier {\n");
        sb.append("    upTo: ").append(this.toIndentedString(this.upTo)).append("\n");
        sb.append("    amounts: ").append(this.toIndentedString(this.amounts)).append("\n");
        sb.append("    unitAmounts: ").append(this.toIndentedString(this.unitAmounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

