/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The recurring components of a price such as interval and usage.")
public class Recurring {
    public static final String SERIALIZED_NAME_RECURRING_ON = "recurring_on";
    @SerializedName(value="recurring_on")
    private RecurringOnEnum recurringOn;
    public static final String SERIALIZED_NAME_ON = "on";
    @SerializedName(value="on")
    private OnEnum on;
    public static final String SERIALIZED_NAME_USAGE = "usage";
    @SerializedName(value="usage")
    private Boolean usage;
    public static final String SERIALIZED_NAME_INTERVAL = "interval";
    @SerializedName(value="interval")
    private IntervalEnum interval;
    public static final String SERIALIZED_NAME_INTERVAL_COUNT = "interval_count";
    @SerializedName(value="interval_count")
    private Integer intervalCount;
    public static final String SERIALIZED_NAME_ALIGNMENT_BEHAVIOR = "alignment_behavior";
    @SerializedName(value="alignment_behavior")
    private AlignmentBehaviorEnum alignmentBehavior;
    public static final String SERIALIZED_NAME_TIMING = "timing";
    @SerializedName(value="timing")
    private TimingEnum timing;
    public static final String SERIALIZED_NAME_FORMULA = "formula";
    @SerializedName(value="formula")
    private String formula;
    public static final String SERIALIZED_NAME_DURATION_INTERVAL = "duration_interval";
    @SerializedName(value="duration_interval")
    private DurationIntervalEnum durationInterval;
    public static final String SERIALIZED_NAME_DURATION_INTERVAL_COUNT = "duration_interval_count";
    @SerializedName(value="duration_interval_count")
    private Integer durationIntervalCount;
    public static final String SERIALIZED_NAME_RATING_GROUP = "rating_group";
    @SerializedName(value="rating_group")
    private RatingGroupEnum ratingGroup;

    public Recurring() {
    }

    public Recurring(String formula) {
        this();
        this.formula = formula;
    }

    public Recurring recurringOn(RecurringOnEnum recurringOn) {
        this.recurringOn = recurringOn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies on which day or the month or day of the week a customer shall be billed.")
    public RecurringOnEnum getRecurringOn() {
        return this.recurringOn;
    }

    public void setRecurringOn(RecurringOnEnum recurringOn) {
        this.recurringOn = recurringOn;
    }

    public Recurring on(OnEnum on) {
        this.on = on;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="Specifies on which day or the month or day of the week a customer shall be billed.")
    public OnEnum getOn() {
        return this.on;
    }

    public void setOn(OnEnum on) {
        this.on = on;
    }

    public Recurring usage(Boolean usage) {
        this.usage = usage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that this is a usage price.")
    public Boolean getUsage() {
        return this.usage;
    }

    public void setUsage(Boolean usage) {
        this.usage = usage;
    }

    public Recurring interval(IntervalEnum interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the billing frequency. One of `week`, `month` or `year`.")
    public IntervalEnum getInterval() {
        return this.interval;
    }

    public void setInterval(IntervalEnum interval) {
        this.interval = interval;
    }

    public Recurring intervalCount(Integer intervalCount) {
        this.intervalCount = intervalCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of intervals (specified in the interval attribute) between subscription billings. For example, interval=month and intervalCount=3 bills every 3 months.")
    public Integer getIntervalCount() {
        return this.intervalCount;
    }

    public void setIntervalCount(Integer intervalCount) {
        this.intervalCount = intervalCount;
    }

    public Recurring alignmentBehavior(AlignmentBehaviorEnum alignmentBehavior) {
        this.alignmentBehavior = alignmentBehavior;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies how to align billing for recurring (subscription) products that start on different days.")
    public AlignmentBehaviorEnum getAlignmentBehavior() {
        return this.alignmentBehavior;
    }

    public void setAlignmentBehavior(AlignmentBehaviorEnum alignmentBehavior) {
        this.alignmentBehavior = alignmentBehavior;
    }

    public Recurring timing(TimingEnum timing) {
        this.timing = timing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="You can choose to bill in_advance or in_arrears for recurring prices. The field is not used with one-time or usage-based prices.")
    public TimingEnum getTiming() {
        return this.timing;
    }

    public void setTiming(TimingEnum timing) {
        this.timing = timing;
    }

    @Nullable
    @ApiModelProperty(value="You can choose to bill in_advance or in_arrears for recurring prices. The field is not used with one-time or usage-based prices.")
    public String getFormula() {
        return this.formula;
    }

    public Recurring durationInterval(DurationIntervalEnum durationInterval) {
        this.durationInterval = durationInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the duration frequency. One of day, week, month or year.")
    public DurationIntervalEnum getDurationInterval() {
        return this.durationInterval;
    }

    public void setDurationInterval(DurationIntervalEnum durationInterval) {
        this.durationInterval = durationInterval;
    }

    public Recurring durationIntervalCount(Integer durationIntervalCount) {
        this.durationIntervalCount = durationIntervalCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies how long a customer shall be charged if this is less than the duration of the subscription")
    public Integer getDurationIntervalCount() {
        return this.durationIntervalCount;
    }

    public void setDurationIntervalCount(Integer durationIntervalCount) {
        this.durationIntervalCount = durationIntervalCount;
    }

    public Recurring ratingGroup(RatingGroupEnum ratingGroup) {
        this.ratingGroup = ratingGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A rating group based on which usage records are rated. Only applicable to usage prices.")
    public RatingGroupEnum getRatingGroup() {
        return this.ratingGroup;
    }

    public void setRatingGroup(RatingGroupEnum ratingGroup) {
        this.ratingGroup = ratingGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recurring recurring = (Recurring)o;
        return Objects.equals((Object)this.recurringOn, (Object)recurring.recurringOn) && Objects.equals((Object)this.on, (Object)recurring.on) && Objects.equals(this.usage, recurring.usage) && Objects.equals((Object)this.interval, (Object)recurring.interval) && Objects.equals(this.intervalCount, recurring.intervalCount) && Objects.equals((Object)this.alignmentBehavior, (Object)recurring.alignmentBehavior) && Objects.equals((Object)this.timing, (Object)recurring.timing) && Objects.equals(this.formula, recurring.formula) && Objects.equals((Object)this.durationInterval, (Object)recurring.durationInterval) && Objects.equals(this.durationIntervalCount, recurring.durationIntervalCount) && Objects.equals((Object)this.ratingGroup, (Object)recurring.ratingGroup);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recurringOn, this.on, this.usage, this.interval, this.intervalCount, this.alignmentBehavior, this.timing, this.formula, this.durationInterval, this.durationIntervalCount, this.ratingGroup});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recurring {\n");
        sb.append("    recurringOn: ").append(this.toIndentedString((Object)this.recurringOn)).append("\n");
        sb.append("    on: ").append(this.toIndentedString((Object)this.on)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("    intervalCount: ").append(this.toIndentedString(this.intervalCount)).append("\n");
        sb.append("    alignmentBehavior: ").append(this.toIndentedString((Object)this.alignmentBehavior)).append("\n");
        sb.append("    timing: ").append(this.toIndentedString((Object)this.timing)).append("\n");
        sb.append("    formula: ").append(this.toIndentedString(this.formula)).append("\n");
        sb.append("    durationInterval: ").append(this.toIndentedString((Object)this.durationInterval)).append("\n");
        sb.append("    durationIntervalCount: ").append(this.toIndentedString(this.durationIntervalCount)).append("\n");
        sb.append("    ratingGroup: ").append(this.toIndentedString((Object)this.ratingGroup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RatingGroupEnum {
        BILLING_PERIOD("billing_period"),
        USAGE_START_DATE("usage_start_date"),
        USAGE_RECORD("usage_record"),
        USAGE_UPLOAD("usage_upload"),
        CUSTOM_GROUP("custom_group"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private RatingGroupEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RatingGroupEnum fromValue(String value) {
            for (RatingGroupEnum b : RatingGroupEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RatingGroupEnum> {
            public void write(JsonWriter jsonWriter, RatingGroupEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RatingGroupEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RatingGroupEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DurationIntervalEnum {
        DAY("day"),
        WEEK("week"),
        MONTH("month"),
        YEAR("year"),
        SUBSCRIPTION_TERM("subscription_term"),
        BILLING_PERIOD("billing_period"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private DurationIntervalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DurationIntervalEnum fromValue(String value) {
            for (DurationIntervalEnum b : DurationIntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DurationIntervalEnum> {
            public void write(JsonWriter jsonWriter, DurationIntervalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DurationIntervalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DurationIntervalEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TimingEnum {
        ADVANCE("in_advance"),
        ARREARS("in_arrears"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TimingEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TimingEnum fromValue(String value) {
            for (TimingEnum b : TimingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TimingEnum> {
            public void write(JsonWriter jsonWriter, TimingEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TimingEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TimingEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AlignmentBehaviorEnum {
        SUBSCRIPTION_START("subscription_start"),
        TERM_START("term_start"),
        TERM_END("term_end"),
        NONE("none"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private AlignmentBehaviorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AlignmentBehaviorEnum fromValue(String value) {
            for (AlignmentBehaviorEnum b : AlignmentBehaviorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AlignmentBehaviorEnum> {
            public void write(JsonWriter jsonWriter, AlignmentBehaviorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AlignmentBehaviorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AlignmentBehaviorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IntervalEnum {
        MONTH("month"),
        YEAR("year"),
        WEEK("week"),
        TERM("term"),
        DAY("day"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private IntervalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IntervalEnum fromValue(String value) {
            for (IntervalEnum b : IntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<IntervalEnum> {
            public void write(JsonWriter jsonWriter, IntervalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IntervalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IntervalEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OnEnum {
        _1("_1"),
        _2("_2"),
        _3("_3"),
        _4("_4"),
        _5("_5"),
        _6("_6"),
        _7("_7"),
        _8("_8"),
        _9("_9"),
        _10("_10"),
        _11("_11"),
        _12("_12"),
        _13("_13"),
        _14("_14"),
        _15("_15"),
        _16("_16"),
        _17("_17"),
        _18("_18"),
        _19("_19"),
        _20("_20"),
        _21("_21"),
        _22("_22"),
        _23("_23"),
        _24("_24"),
        _25("_25"),
        _26("_26"),
        _27("_27"),
        _28("_28"),
        _29("_29"),
        _30("_30"),
        _31("_31"),
        SUBSCRIPTION_ITEM_START_DAY("subscription_item_start_day"),
        ACCOUNT_CYCLE_DATE("account_cycle_date"),
        SUBSCRIPTION_START_DAY("subscription_start_day"),
        TERM_END_DAY("term_end_day"),
        TERM_START_DAY("term_start_day"),
        MONDAY("monday"),
        TUESDAY("tuesday"),
        WEDNESDAY("wednesday"),
        THURSDAY("thursday"),
        FRIDAY("friday"),
        SATURDAY("saturday"),
        SUNDAY("sunday"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private OnEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OnEnum fromValue(String value) {
            for (OnEnum b : OnEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OnEnum> {
            public void write(JsonWriter jsonWriter, OnEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OnEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OnEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecurringOnEnum {
        _1("_1"),
        _2("_2"),
        _3("_3"),
        _4("_4"),
        _5("_5"),
        _6("_6"),
        _7("_7"),
        _8("_8"),
        _9("_9"),
        _10("_10"),
        _11("_11"),
        _12("_12"),
        _13("_13"),
        _14("_14"),
        _15("_15"),
        _16("_16"),
        _17("_17"),
        _18("_18"),
        _19("_19"),
        _20("_20"),
        _21("_21"),
        _22("_22"),
        _23("_23"),
        _24("_24"),
        _25("_25"),
        _26("_26"),
        _27("_27"),
        _28("_28"),
        _29("_29"),
        _30("_30"),
        _31("_31"),
        SUBSCRIPTION_ITEM_START_DAY("subscription_item_start_day"),
        ACCOUNT_CYCLE_DATE("account_cycle_date"),
        SUBSCRIPTION_START_DAY("subscription_start_day"),
        TERM_END_DAY("term_end_day"),
        TERM_START_DAY("term_start_day"),
        MONDAY("monday"),
        TUESDAY("tuesday"),
        WEDNESDAY("wednesday"),
        THURSDAY("thursday"),
        FRIDAY("friday"),
        SATURDAY("saturday"),
        SUNDAY("sunday"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private RecurringOnEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecurringOnEnum fromValue(String value) {
            for (RecurringOnEnum b : RecurringOnEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RecurringOnEnum> {
            public void write(JsonWriter jsonWriter, RecurringOnEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecurringOnEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecurringOnEnum.fromValue(value);
            }
        }
    }
}

