/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.PaymentSchedulePaymentOptionRequest;
import org.threeten.bp.LocalDate;

public class PaymentSchedulePatchRequest {
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_NUMBER_OF_PAYMENTS = "number_of_payments";
    @SerializedName(value="number_of_payments")
    private Integer numberOfPayments;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY_ID = "payment_gateway_id";
    @SerializedName(value="payment_gateway_id")
    private String paymentGatewayId;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_NUMBER = "payment_method_number";
    @SerializedName(value="payment_method_number")
    private String paymentMethodNumber;
    public static final String SERIALIZED_NAME_RUN_HOUR = "run_hour";
    @SerializedName(value="run_hour")
    private Integer runHour;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_PAYMENT_OPTIONS = "payment_options";
    @SerializedName(value="payment_options")
    private List<PaymentSchedulePaymentOptionRequest> paymentOptions = null;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_PERIOD = "period";
    @SerializedName(value="period")
    private PeriodEnum period;

    public PaymentSchedulePatchRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Currency of the payment schedule. Note: This field is optional. The default value is the account's default currency. This field will be ignored when items is specified.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentSchedulePatchRequest numberOfPayments(Integer numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of payment schedule items to be created for this payment schedule.")
    public Integer getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public void setNumberOfPayments(Integer numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
    }

    public PaymentSchedulePatchRequest paymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="ID of the payment gateway used to collect payments. Note: This field is optional. The default value is the account's default payment gateway ID. If no payment gateway ID is found on the customer account level, the default value will be the tenant's default payment gateway ID. This field will be ignored when items is specified.")
    public String getPaymentGatewayId() {
        return this.paymentGatewayId;
    }

    public void setPaymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
    }

    public PaymentSchedulePatchRequest paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8a95b1946b6aeac8718c32aab8c395f", value="ID of the payment method. Note: This field is optional. The default value is the account's default payment method ID. This field will be ignored when items is specified.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public PaymentSchedulePatchRequest paymentMethodNumber(String paymentMethodNumber) {
        this.paymentMethodNumber = paymentMethodNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment method number of the payment method to be used to collect payments.")
    public String getPaymentMethodNumber() {
        return this.paymentMethodNumber;
    }

    public void setPaymentMethodNumber(String paymentMethodNumber) {
        this.paymentMethodNumber = paymentMethodNumber;
    }

    public PaymentSchedulePatchRequest runHour(Integer runHour) {
        this.runHour = runHour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="At which hour in the day in the tenant's timezone this payment will be collected. Available values:[0,1,2,~,22,23]. If the time difference between your tenant\u2019s timezone and the timezone where Zuora servers are located is not in full hours, for example, 2.5 hours, the payment schedule items will be triggered half an hour later than your scheduled time.       The default value is `0`. If the payment `run_hour` and `scheduled_date` are backdated, the system will collect the payment when the next `run_hour` occurs.")
    public Integer getRunHour() {
        return this.runHour;
    }

    public void setRunHour(Integer runHour) {
        this.runHour = runHour;
    }

    public PaymentSchedulePatchRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PaymentSchedulePatchRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public PaymentSchedulePatchRequest paymentOptions(List<PaymentSchedulePaymentOptionRequest> paymentOptions) {
        this.paymentOptions = paymentOptions;
        return this;
    }

    public PaymentSchedulePatchRequest addPaymentOptionsItem(PaymentSchedulePaymentOptionRequest paymentOptionsItem) {
        if (this.paymentOptions == null) {
            this.paymentOptions = new ArrayList<PaymentSchedulePaymentOptionRequest>();
        }
        this.paymentOptions.add(paymentOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container for the payment options, which describe the transactional level rules for processing payments. Currently, only the gateway_options type is supported. Payment schedule payment_options take precedence over payment schedule item payment_options.")
    public List<PaymentSchedulePaymentOptionRequest> getPaymentOptions() {
        return this.paymentOptions;
    }

    public void setPaymentOptions(List<PaymentSchedulePaymentOptionRequest> paymentOptions) {
        this.paymentOptions = paymentOptions;
    }

    public PaymentSchedulePatchRequest startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date of the first scheduled payment collection. Note: This parameter is required when `items` is not specified. This parameter will be ignored when `items` is specified.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public PaymentSchedulePatchRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of each payment schedule item in the payment schedule.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public PaymentSchedulePatchRequest period(PeriodEnum period) {
        this.period = period;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unit in which term duration is defined. One of week or month.")
    public PeriodEnum getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodEnum period) {
        this.period = period;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentSchedulePatchRequest paymentSchedulePatchRequest = (PaymentSchedulePatchRequest)o;
        return Objects.equals(this.currency, paymentSchedulePatchRequest.currency) && Objects.equals(this.numberOfPayments, paymentSchedulePatchRequest.numberOfPayments) && Objects.equals(this.paymentGatewayId, paymentSchedulePatchRequest.paymentGatewayId) && Objects.equals(this.paymentMethodId, paymentSchedulePatchRequest.paymentMethodId) && Objects.equals(this.paymentMethodNumber, paymentSchedulePatchRequest.paymentMethodNumber) && Objects.equals(this.runHour, paymentSchedulePatchRequest.runHour) && Objects.equals(this.customFields, paymentSchedulePatchRequest.customFields) && Objects.equals(this.paymentOptions, paymentSchedulePatchRequest.paymentOptions) && Objects.equals(this.startDate, paymentSchedulePatchRequest.startDate) && Objects.equals(this.amount, paymentSchedulePatchRequest.amount) && Objects.equals((Object)this.period, (Object)paymentSchedulePatchRequest.period);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currency, this.numberOfPayments, this.paymentGatewayId, this.paymentMethodId, this.paymentMethodNumber, this.runHour, this.customFields, this.paymentOptions, this.startDate, this.amount, this.period});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentSchedulePatchRequest {\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    numberOfPayments: ").append(this.toIndentedString(this.numberOfPayments)).append("\n");
        sb.append("    paymentGatewayId: ").append(this.toIndentedString(this.paymentGatewayId)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    paymentMethodNumber: ").append(this.toIndentedString(this.paymentMethodNumber)).append("\n");
        sb.append("    runHour: ").append(this.toIndentedString(this.runHour)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    paymentOptions: ").append(this.toIndentedString(this.paymentOptions)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    period: ").append(this.toIndentedString((Object)this.period)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PeriodEnum {
        WEEK("week"),
        MONTH("month"),
        BIWEEKLY("biweekly"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PeriodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PeriodEnum fromValue(String value) {
            for (PeriodEnum b : PeriodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PeriodEnum> {
            public void write(JsonWriter jsonWriter, PeriodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PeriodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PeriodEnum.fromValue(value);
            }
        }
    }
}

