/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.InvoiceItemListResponse;
import org.openapitools.client.model.OrderLineItemRevenue;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Data of order line items.")
public class OrderLineItem {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_REVENUE = "revenue";
    @SerializedName(value="revenue")
    private OrderLineItemRevenue revenue;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_ACCOUNTING_CODE = "accounting_code";
    @SerializedName(value="accounting_code")
    private String accountingCode;
    public static final String SERIALIZED_NAME_ADJUSTMENT_LIABILITY_ACCOUNT = "adjustment_liability_account";
    @SerializedName(value="adjustment_liability_account")
    private String adjustmentLiabilityAccount;
    public static final String SERIALIZED_NAME_UNIT_AMOUNT = "unit_amount";
    @SerializedName(value="unit_amount")
    private BigDecimal unitAmount;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_BILLING_RULE = "billing_rule";
    @SerializedName(value="billing_rule")
    private BillingRuleEnum billingRule;
    public static final String SERIALIZED_NAME_CONTRACT_ASSET_ACCOUNT = "contract_asset_account";
    @SerializedName(value="contract_asset_account")
    private String contractAssetAccount;
    public static final String SERIALIZED_NAME_CONTRACT_LIABILITY_ACCOUNT = "contract_liability_account";
    @SerializedName(value="contract_liability_account")
    private String contractLiabilityAccount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DISCOUNT_UNIT_AMOUNT = "discount_unit_amount";
    @SerializedName(value="discount_unit_amount")
    private BigDecimal discountUnitAmount;
    public static final String SERIALIZED_NAME_DISCOUNT_PERCENT = "discount_percent";
    @SerializedName(value="discount_percent")
    private BigDecimal discountPercent;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_LIST_UNIT_PRICE = "list_unit_price";
    @SerializedName(value="list_unit_price")
    private BigDecimal listUnitPrice;
    public static final String SERIALIZED_NAME_PRODUCT_CODE = "product_code";
    @SerializedName(value="product_code")
    private String productCode;
    public static final String SERIALIZED_NAME_PURCHASE_ORDER_NUMBER = "purchase_order_number";
    @SerializedName(value="purchase_order_number")
    private String purchaseOrderNumber;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_RELATED_SUBSCRIPTION_NUMBER = "related_subscription_number";
    @SerializedName(value="related_subscription_number")
    private String relatedSubscriptionNumber;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    private String soldToId;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_UNBILLED_RECEIVABLES_ACCOUNT = "unbilled_receivables_account";
    @SerializedName(value="unbilled_receivables_account")
    private String unbilledReceivablesAccount;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_ITEM_NUMBER = "item_number";
    @SerializedName(value="item_number")
    private String itemNumber;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_PRICE_ID = "price_id";
    @SerializedName(value="price_id")
    private String priceId;
    public static final String SERIALIZED_NAME_QUANTITY_AVAILABLE_FOR_RETURN = "quantity_available_for_return";
    @SerializedName(value="quantity_available_for_return")
    private BigDecimal quantityAvailableForReturn;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;
    public static final String SERIALIZED_NAME_INVOICE_ITEMS = "invoice_items";
    @SerializedName(value="invoice_items")
    private InvoiceItemListResponse invoiceItems;
    public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
    @SerializedName(value="order_id")
    private String orderId;
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(value="total")
    private BigDecimal total;
    public static final String SERIALIZED_NAME_SUBTOTAL = "subtotal";
    @SerializedName(value="subtotal")
    private BigDecimal subtotal;
    public static final String SERIALIZED_NAME_QUANTITY_FULFILLED = "quantity_fulfilled";
    @SerializedName(value="quantity_fulfilled")
    private BigDecimal quantityFulfilled;
    public static final String SERIALIZED_NAME_QUANTITY_PENDING_FULFILLMENT = "quantity_pending_fulfillment";
    @SerializedName(value="quantity_pending_fulfillment")
    private BigDecimal quantityPendingFulfillment;
    public static final String SERIALIZED_NAME_REQUIRES_FULFILLMENT = "requires_fulfillment";
    @SerializedName(value="requires_fulfillment")
    private Boolean requiresFulfillment;
    public static final String SERIALIZED_NAME_ORIGINAL_ORDER_DATE = "original_order_date";
    @SerializedName(value="original_order_date")
    private LocalDate originalOrderDate;
    public static final String SERIALIZED_NAME_ORIGINAL_ORDER_ID = "original_order_id";
    @SerializedName(value="original_order_id")
    private String originalOrderId;
    public static final String SERIALIZED_NAME_ORIGINAL_ORDER_LINE_ITEM_ID = "original_order_line_item_id";
    @SerializedName(value="original_order_line_item_id")
    private String originalOrderLineItemId;
    public static final String SERIALIZED_NAME_ORIGINAL_ORDER_LINE_ITEM_NUMBER = "original_order_line_item_number";
    @SerializedName(value="original_order_line_item_number")
    private String originalOrderLineItemNumber;
    public static final String SERIALIZED_NAME_ORIGINAL_ORDER_NUMBER = "original_order_number";
    @SerializedName(value="original_order_number")
    private String originalOrderNumber;
    public static final String SERIALIZED_NAME_DISCOUNT_TOTAL = "discount_total";
    @SerializedName(value="discount_total")
    private BigDecimal discountTotal;
    public static final String SERIALIZED_NAME_LIST_PRICE = "list_price";
    @SerializedName(value="list_price")
    private BigDecimal listPrice;
    public static final String SERIALIZED_NAME_ORIGINAL_SOLD_TO_ID = "original_sold_to_id";
    @SerializedName(value="original_sold_to_id")
    private String originalSoldToId;

    public OrderLineItem() {
    }

    public OrderLineItem(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, InvoiceItemListResponse invoiceItems) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.invoiceItems = invoiceItems;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OrderLineItem customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public OrderLineItem putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public OrderLineItem revenue(OrderLineItemRevenue revenue) {
        this.revenue = revenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OrderLineItemRevenue getRevenue() {
        return this.revenue;
    }

    public void setRevenue(OrderLineItemRevenue revenue) {
        this.revenue = revenue;
    }

    public OrderLineItem unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A configured unit of measure.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public OrderLineItem accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public OrderLineItem adjustmentLiabilityAccount(String adjustmentLiabilityAccount) {
        this.adjustmentLiabilityAccount = adjustmentLiabilityAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getAdjustmentLiabilityAccount() {
        return this.adjustmentLiabilityAccount;
    }

    public void setAdjustmentLiabilityAccount(String adjustmentLiabilityAccount) {
        this.adjustmentLiabilityAccount = adjustmentLiabilityAccount;
    }

    public OrderLineItem unitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit amount to be charged.")
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public OrderLineItem targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="All order line items that were unbilled on or before this date are included in future bill runs.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public OrderLineItem billingRule(BillingRuleEnum billingRule) {
        this.billingRule = billingRule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing rule for the order line item.")
    public BillingRuleEnum getBillingRule() {
        return this.billingRule;
    }

    public void setBillingRule(BillingRuleEnum billingRule) {
        this.billingRule = billingRule;
    }

    public OrderLineItem contractAssetAccount(String contractAssetAccount) {
        this.contractAssetAccount = contractAssetAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getContractAssetAccount() {
        return this.contractAssetAccount;
    }

    public void setContractAssetAccount(String contractAssetAccount) {
        this.contractAssetAccount = contractAssetAccount;
    }

    public OrderLineItem contractLiabilityAccount(String contractLiabilityAccount) {
        this.contractLiabilityAccount = contractLiabilityAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getContractLiabilityAccount() {
        return this.contractLiabilityAccount;
    }

    public void setContractLiabilityAccount(String contractLiabilityAccount) {
        this.contractLiabilityAccount = contractLiabilityAccount;
    }

    public OrderLineItem description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OrderLineItem discountUnitAmount(BigDecimal discountUnitAmount) {
        this.discountUnitAmount = discountUnitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount amount per unit.")
    public BigDecimal getDiscountUnitAmount() {
        return this.discountUnitAmount;
    }

    public void setDiscountUnitAmount(BigDecimal discountUnitAmount) {
        this.discountUnitAmount = discountUnitAmount;
    }

    public OrderLineItem discountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount percent.")
    public BigDecimal getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
    }

    public OrderLineItem category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The category for the order line item, to indicate a product sale or return.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public OrderLineItem name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the order line item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrderLineItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the order line item.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OrderLineItem listUnitPrice(BigDecimal listUnitPrice) {
        this.listUnitPrice = listUnitPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list price per unit for the order line item.")
    public BigDecimal getListUnitPrice() {
        return this.listUnitPrice;
    }

    public void setListUnitPrice(BigDecimal listUnitPrice) {
        this.listUnitPrice = listUnitPrice;
    }

    public OrderLineItem productCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The product code for the order line item.")
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public OrderLineItem purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used by customers to specify the Purchase Order Number provided by the buyer.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public OrderLineItem quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The quantity of the product ordered.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public OrderLineItem relatedSubscriptionNumber(String relatedSubscriptionNumber) {
        this.relatedSubscriptionNumber = relatedSubscriptionNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use this field to relate an order line item to an subscription.")
    public String getRelatedSubscriptionNumber() {
        return this.relatedSubscriptionNumber;
    }

    public void setRelatedSubscriptionNumber(String relatedSubscriptionNumber) {
        this.relatedSubscriptionNumber = relatedSubscriptionNumber;
    }

    public OrderLineItem soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad0823f8040e52d0180433026b156fe", value="The unique identifier of a contact belonging to the billing account of the order line item. Use this field to assign and existing contact as the sold to contact of an order line item.")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    public OrderLineItem taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tax code for the order line item.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public OrderLineItem unbilledReceivablesAccount(String unbilledReceivablesAccount) {
        this.unbilledReceivablesAccount = unbilledReceivablesAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts..")
    public String getUnbilledReceivablesAccount() {
        return this.unbilledReceivablesAccount;
    }

    public void setUnbilledReceivablesAccount(String unbilledReceivablesAccount) {
        this.unbilledReceivablesAccount = unbilledReceivablesAccount;
    }

    public OrderLineItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of an order line item. If you want to generate billing documents for order line items, you must set this field to `sent_to_billing`. For invoice preview, you do not need to set this field.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public OrderLineItem itemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the order item. It can be user-supplied.")
    public String getItemNumber() {
        return this.itemNumber;
    }

    public void setItemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
    }

    public OrderLineItem startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date a transaction starts. The default value of this field is the order date.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public OrderLineItem endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date the order line item transitions to complete.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public OrderLineItem priceId(String priceId) {
        this.priceId = priceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the price.")
    public String getPriceId() {
        return this.priceId;
    }

    public void setPriceId(String priceId) {
        this.priceId = priceId;
    }

    public OrderLineItem quantityAvailableForReturn(BigDecimal quantityAvailableForReturn) {
        this.quantityAvailableForReturn = quantityAvailableForReturn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The quantity of the product ordered available for return.")
    public BigDecimal getQuantityAvailableForReturn() {
        return this.quantityAvailableForReturn;
    }

    public void setQuantityAvailableForReturn(BigDecimal quantityAvailableForReturn) {
        this.quantityAvailableForReturn = quantityAvailableForReturn;
    }

    public OrderLineItem taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this field is set to `true`, it indicates that amounts are inclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    @Nullable
    @ApiModelProperty(value="List of invoice items. EXPANDABLE")
    public InvoiceItemListResponse getInvoiceItems() {
        return this.invoiceItems;
    }

    public OrderLineItem orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the order associated with this order line item.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public OrderLineItem total(BigDecimal total) {
        this.total = total;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total after discounts and taxes.")
    public BigDecimal getTotal() {
        return this.total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public OrderLineItem subtotal(BigDecimal subtotal) {
        this.subtotal = subtotal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total before discounts and taxes are applied.")
    public BigDecimal getSubtotal() {
        return this.subtotal;
    }

    public void setSubtotal(BigDecimal subtotal) {
        this.subtotal = subtotal;
    }

    public OrderLineItem quantityFulfilled(BigDecimal quantityFulfilled) {
        this.quantityFulfilled = quantityFulfilled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The quantity fulfilled.")
    public BigDecimal getQuantityFulfilled() {
        return this.quantityFulfilled;
    }

    public void setQuantityFulfilled(BigDecimal quantityFulfilled) {
        this.quantityFulfilled = quantityFulfilled;
    }

    public OrderLineItem quantityPendingFulfillment(BigDecimal quantityPendingFulfillment) {
        this.quantityPendingFulfillment = quantityPendingFulfillment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The quantity pending fulfillment.")
    public BigDecimal getQuantityPendingFulfillment() {
        return this.quantityPendingFulfillment;
    }

    public void setQuantityPendingFulfillment(BigDecimal quantityPendingFulfillment) {
        this.quantityPendingFulfillment = quantityPendingFulfillment;
    }

    public OrderLineItem requiresFulfillment(Boolean requiresFulfillment) {
        this.requiresFulfillment = requiresFulfillment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, a fulfillment is required to trigger billing.")
    public Boolean getRequiresFulfillment() {
        return this.requiresFulfillment;
    }

    public void setRequiresFulfillment(Boolean requiresFulfillment) {
        this.requiresFulfillment = requiresFulfillment;
    }

    public OrderLineItem originalOrderDate(LocalDate originalOrderDate) {
        this.originalOrderDate = originalOrderDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date when the subscription item is created through an order. This field is to standardize the booking date information to increase audit ability and traceability of data between Zuora Billing and Zuora Revenue. It is mapped as the booking date for a sales order line in Zuora Revenue.")
    public LocalDate getOriginalOrderDate() {
        return this.originalOrderDate;
    }

    public void setOriginalOrderDate(LocalDate originalOrderDate) {
        this.originalOrderDate = originalOrderDate;
    }

    public OrderLineItem originalOrderId(String originalOrderId) {
        this.originalOrderId = originalOrderId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of the original sales order for a return order line item.")
    public String getOriginalOrderId() {
        return this.originalOrderId;
    }

    public void setOriginalOrderId(String originalOrderId) {
        this.originalOrderId = originalOrderId;
    }

    public OrderLineItem originalOrderLineItemId(String originalOrderLineItemId) {
        this.originalOrderLineItemId = originalOrderLineItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of the original sales order line item for a return order line item.")
    public String getOriginalOrderLineItemId() {
        return this.originalOrderLineItemId;
    }

    public void setOriginalOrderLineItemId(String originalOrderLineItemId) {
        this.originalOrderLineItemId = originalOrderLineItemId;
    }

    public OrderLineItem originalOrderLineItemNumber(String originalOrderLineItemNumber) {
        this.originalOrderLineItemNumber = originalOrderLineItemNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of the original sales order line item for a return order line item.")
    public String getOriginalOrderLineItemNumber() {
        return this.originalOrderLineItemNumber;
    }

    public void setOriginalOrderLineItemNumber(String originalOrderLineItemNumber) {
        this.originalOrderLineItemNumber = originalOrderLineItemNumber;
    }

    public OrderLineItem originalOrderNumber(String originalOrderNumber) {
        this.originalOrderNumber = originalOrderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of the original sales order for a return order line item.")
    public String getOriginalOrderNumber() {
        return this.originalOrderNumber;
    }

    public void setOriginalOrderNumber(String originalOrderNumber) {
        this.originalOrderNumber = originalOrderNumber;
    }

    public OrderLineItem discountTotal(BigDecimal discountTotal) {
        this.discountTotal = discountTotal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total discount amount.")
    public BigDecimal getDiscountTotal() {
        return this.discountTotal;
    }

    public void setDiscountTotal(BigDecimal discountTotal) {
        this.discountTotal = discountTotal;
    }

    public OrderLineItem listPrice(BigDecimal listPrice) {
        this.listPrice = listPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The extended list price for an order line item, calculated by the formula: listPrice = listPricePerUnit * quantity")
    public BigDecimal getListPrice() {
        return this.listPrice;
    }

    public void setListPrice(BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public OrderLineItem originalSoldToId(String originalSoldToId) {
        this.originalSoldToId = originalSoldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of a contact belonging to the billing account of the order line item that was the original sold to contact when the order line item was created. ")
    public String getOriginalSoldToId() {
        return this.originalSoldToId;
    }

    public void setOriginalSoldToId(String originalSoldToId) {
        this.originalSoldToId = originalSoldToId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderLineItem orderLineItem = (OrderLineItem)o;
        return Objects.equals(this.id, orderLineItem.id) && Objects.equals(this.updatedById, orderLineItem.updatedById) && Objects.equals(this.updatedTime, orderLineItem.updatedTime) && Objects.equals(this.createdById, orderLineItem.createdById) && Objects.equals(this.createdTime, orderLineItem.createdTime) && Objects.equals(this.customFields, orderLineItem.customFields) && Objects.equals(this.customObjects, orderLineItem.customObjects) && Objects.equals(this.revenue, orderLineItem.revenue) && Objects.equals(this.unitOfMeasure, orderLineItem.unitOfMeasure) && Objects.equals(this.accountingCode, orderLineItem.accountingCode) && Objects.equals(this.adjustmentLiabilityAccount, orderLineItem.adjustmentLiabilityAccount) && Objects.equals(this.unitAmount, orderLineItem.unitAmount) && Objects.equals(this.targetDate, orderLineItem.targetDate) && Objects.equals((Object)this.billingRule, (Object)orderLineItem.billingRule) && Objects.equals(this.contractAssetAccount, orderLineItem.contractAssetAccount) && Objects.equals(this.contractLiabilityAccount, orderLineItem.contractLiabilityAccount) && Objects.equals(this.description, orderLineItem.description) && Objects.equals(this.discountUnitAmount, orderLineItem.discountUnitAmount) && Objects.equals(this.discountPercent, orderLineItem.discountPercent) && Objects.equals((Object)this.category, (Object)orderLineItem.category) && Objects.equals(this.name, orderLineItem.name) && Objects.equals((Object)this.type, (Object)orderLineItem.type) && Objects.equals(this.listUnitPrice, orderLineItem.listUnitPrice) && Objects.equals(this.productCode, orderLineItem.productCode) && Objects.equals(this.purchaseOrderNumber, orderLineItem.purchaseOrderNumber) && Objects.equals(this.quantity, orderLineItem.quantity) && Objects.equals(this.relatedSubscriptionNumber, orderLineItem.relatedSubscriptionNumber) && Objects.equals(this.soldToId, orderLineItem.soldToId) && Objects.equals(this.taxCode, orderLineItem.taxCode) && Objects.equals(this.unbilledReceivablesAccount, orderLineItem.unbilledReceivablesAccount) && Objects.equals((Object)this.state, (Object)orderLineItem.state) && Objects.equals(this.itemNumber, orderLineItem.itemNumber) && Objects.equals(this.startDate, orderLineItem.startDate) && Objects.equals(this.endDate, orderLineItem.endDate) && Objects.equals(this.priceId, orderLineItem.priceId) && Objects.equals(this.quantityAvailableForReturn, orderLineItem.quantityAvailableForReturn) && Objects.equals(this.taxInclusive, orderLineItem.taxInclusive) && Objects.equals(this.invoiceItems, orderLineItem.invoiceItems) && Objects.equals(this.orderId, orderLineItem.orderId) && Objects.equals(this.total, orderLineItem.total) && Objects.equals(this.subtotal, orderLineItem.subtotal) && Objects.equals(this.quantityFulfilled, orderLineItem.quantityFulfilled) && Objects.equals(this.quantityPendingFulfillment, orderLineItem.quantityPendingFulfillment) && Objects.equals(this.requiresFulfillment, orderLineItem.requiresFulfillment) && Objects.equals(this.originalOrderDate, orderLineItem.originalOrderDate) && Objects.equals(this.originalOrderId, orderLineItem.originalOrderId) && Objects.equals(this.originalOrderLineItemId, orderLineItem.originalOrderLineItemId) && Objects.equals(this.originalOrderLineItemNumber, orderLineItem.originalOrderLineItemNumber) && Objects.equals(this.originalOrderNumber, orderLineItem.originalOrderNumber) && Objects.equals(this.discountTotal, orderLineItem.discountTotal) && Objects.equals(this.listPrice, orderLineItem.listPrice) && Objects.equals(this.originalSoldToId, orderLineItem.originalSoldToId);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.revenue, this.unitOfMeasure, this.accountingCode, this.adjustmentLiabilityAccount, this.unitAmount, this.targetDate, this.billingRule, this.contractAssetAccount, this.contractLiabilityAccount, this.description, this.discountUnitAmount, this.discountPercent, this.category, this.name, this.type, this.listUnitPrice, this.productCode, this.purchaseOrderNumber, this.quantity, this.relatedSubscriptionNumber, this.soldToId, this.taxCode, this.unbilledReceivablesAccount, this.state, this.itemNumber, this.startDate, this.endDate, this.priceId, this.quantityAvailableForReturn, this.taxInclusive, this.invoiceItems, this.orderId, this.total, this.subtotal, this.quantityFulfilled, this.quantityPendingFulfillment, this.requiresFulfillment, this.originalOrderDate, this.originalOrderId, this.originalOrderLineItemId, this.originalOrderLineItemNumber, this.originalOrderNumber, this.discountTotal, this.listPrice, this.originalSoldToId});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderLineItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    revenue: ").append(this.toIndentedString(this.revenue)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    adjustmentLiabilityAccount: ").append(this.toIndentedString(this.adjustmentLiabilityAccount)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    billingRule: ").append(this.toIndentedString((Object)this.billingRule)).append("\n");
        sb.append("    contractAssetAccount: ").append(this.toIndentedString(this.contractAssetAccount)).append("\n");
        sb.append("    contractLiabilityAccount: ").append(this.toIndentedString(this.contractLiabilityAccount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    discountUnitAmount: ").append(this.toIndentedString(this.discountUnitAmount)).append("\n");
        sb.append("    discountPercent: ").append(this.toIndentedString(this.discountPercent)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    listUnitPrice: ").append(this.toIndentedString(this.listUnitPrice)).append("\n");
        sb.append("    productCode: ").append(this.toIndentedString(this.productCode)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    relatedSubscriptionNumber: ").append(this.toIndentedString(this.relatedSubscriptionNumber)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    unbilledReceivablesAccount: ").append(this.toIndentedString(this.unbilledReceivablesAccount)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    itemNumber: ").append(this.toIndentedString(this.itemNumber)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    priceId: ").append(this.toIndentedString(this.priceId)).append("\n");
        sb.append("    quantityAvailableForReturn: ").append(this.toIndentedString(this.quantityAvailableForReturn)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("    invoiceItems: ").append(this.toIndentedString(this.invoiceItems)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    subtotal: ").append(this.toIndentedString(this.subtotal)).append("\n");
        sb.append("    quantityFulfilled: ").append(this.toIndentedString(this.quantityFulfilled)).append("\n");
        sb.append("    quantityPendingFulfillment: ").append(this.toIndentedString(this.quantityPendingFulfillment)).append("\n");
        sb.append("    requiresFulfillment: ").append(this.toIndentedString(this.requiresFulfillment)).append("\n");
        sb.append("    originalOrderDate: ").append(this.toIndentedString(this.originalOrderDate)).append("\n");
        sb.append("    originalOrderId: ").append(this.toIndentedString(this.originalOrderId)).append("\n");
        sb.append("    originalOrderLineItemId: ").append(this.toIndentedString(this.originalOrderLineItemId)).append("\n");
        sb.append("    originalOrderLineItemNumber: ").append(this.toIndentedString(this.originalOrderLineItemNumber)).append("\n");
        sb.append("    originalOrderNumber: ").append(this.toIndentedString(this.originalOrderNumber)).append("\n");
        sb.append("    discountTotal: ").append(this.toIndentedString(this.discountTotal)).append("\n");
        sb.append("    listPrice: ").append(this.toIndentedString(this.listPrice)).append("\n");
        sb.append("    originalSoldToId: ").append(this.toIndentedString(this.originalSoldToId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        BOOKED("booked"),
        SENT_TO_BILLING("sent_to_billing"),
        COMPLETE("complete"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PRODUCT("product"),
        FEE("fee"),
        SERVICES("services"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        SALE("sale"),
        RETURN("return"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BillingRuleEnum {
        WITHOUT_FULFILLMENT("trigger_without_fulfillment"),
        ON_FULFILLMENT("trigger_on_fulfillment"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BillingRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BillingRuleEnum fromValue(String value) {
            for (BillingRuleEnum b : BillingRuleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BillingRuleEnum> {
            public void write(JsonWriter jsonWriter, BillingRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BillingRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BillingRuleEnum.fromValue(value);
            }
        }
    }
}

