/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.InvoiceItemListResponse;
import org.openapitools.client.model.Revenue;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Data of order line items.")
public class LineItem {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_UNIT_AMOUNT = "unit_amount";
    @SerializedName(value="unit_amount")
    private BigDecimal unitAmount;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNT = "deferred_revenue_account";
    @SerializedName(value="deferred_revenue_account")
    private String deferredRevenueAccount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_REVENUE = "revenue";
    @SerializedName(value="revenue")
    private Revenue revenue;
    public static final String SERIALIZED_NAME_DISCOUNT_UNIT_AMOUNT = "discount_unit_amount";
    @SerializedName(value="discount_unit_amount")
    private BigDecimal discountUnitAmount;
    public static final String SERIALIZED_NAME_DISCOUNT_PERCENT = "discount_percent";
    @SerializedName(value="discount_percent")
    private BigDecimal discountPercent;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ITEM_NUMBER = "item_number";
    @SerializedName(value="item_number")
    private String itemNumber;
    public static final String SERIALIZED_NAME_LIST_UNIT_PRICE = "list_unit_price";
    @SerializedName(value="list_unit_price")
    private BigDecimal listUnitPrice;
    public static final String SERIALIZED_NAME_PRODUCT_CODE = "product_code";
    @SerializedName(value="product_code")
    private String productCode;
    public static final String SERIALIZED_NAME_PRICE_ID = "price_id";
    @SerializedName(value="price_id")
    private String priceId;
    public static final String SERIALIZED_NAME_PURCHASE_ORDER_NUMBER = "purchase_order_number";
    @SerializedName(value="purchase_order_number")
    private String purchaseOrderNumber;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNT = "recognized_revenue_account";
    @SerializedName(value="recognized_revenue_account")
    private String recognizedRevenueAccount;
    public static final String SERIALIZED_NAME_REVENUE_RECOGNITION_RULE_NAME = "revenue_recognition_rule_name";
    @SerializedName(value="revenue_recognition_rule_name")
    private String revenueRecognitionRuleName;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    private String soldToId;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_INVOICE_ITEMS = "invoice_items";
    @SerializedName(value="invoice_items")
    private InvoiceItemListResponse invoiceItems;
    public static final String SERIALIZED_NAME_RELATED_SUBSCRIPTION_NUMBER = "related_subscription_number";
    @SerializedName(value="related_subscription_number")
    private String relatedSubscriptionNumber;
    public static final String SERIALIZED_NAME_BILLING_RULE = "billing_rule";
    @SerializedName(value="billing_rule")
    private BillingRuleEnum billingRule;
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(value="total")
    private String total;
    public static final String SERIALIZED_NAME_SUBTOTAL = "subtotal";
    @SerializedName(value="subtotal")
    private String subtotal;
    public static final String SERIALIZED_NAME_ORIGINAL_ORDER_DATE = "original_order_date";
    @SerializedName(value="original_order_date")
    private LocalDate originalOrderDate;
    public static final String SERIALIZED_NAME_ACCOUNTING_CODE = "accounting_code";
    @SerializedName(value="accounting_code")
    private String accountingCode;
    public static final String SERIALIZED_NAME_ADJUSTMENT_LIABILITY_ACCOUNT = "adjustment_liability_account";
    @SerializedName(value="adjustment_liability_account")
    private String adjustmentLiabilityAccount;
    public static final String SERIALIZED_NAME_ADJUSTMENT_REVENUE_ACCOUNT = "adjustment_revenue_account";
    @SerializedName(value="adjustment_revenue_account")
    private String adjustmentRevenueAccount;
    public static final String SERIALIZED_NAME_DISCOUNT_TOTAL = "discount_total";
    @SerializedName(value="discount_total")
    private String discountTotal;
    public static final String SERIALIZED_NAME_LIST_PRICE = "list_price";
    @SerializedName(value="list_price")
    private String listPrice;
    public static final String SERIALIZED_NAME_ORIGINAL_SOLD_TO_ID = "original_sold_to_id";
    @SerializedName(value="original_sold_to_id")
    private String originalSoldToId;
    public static final String SERIALIZED_NAME_UNBILLED_RECEIVABLES_ACCOUNT = "unbilled_receivables_account";
    @SerializedName(value="unbilled_receivables_account")
    private String unbilledReceivablesAccount;

    public LineItem() {
    }

    public LineItem(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, InvoiceItemListResponse invoiceItems) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.invoiceItems = invoiceItems;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public LineItem customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public LineItem putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public LineItem unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A configured unit of measure. This field is required for per-unit prices.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public LineItem unitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit amount of the price. Specify this field if you want to override the original price with a per-unit price.")
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public LineItem targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target date for the order line item to be picked up by bill run for billing.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public LineItem deferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getDeferredRevenueAccount() {
        return this.deferredRevenueAccount;
    }

    public void setDeferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
    }

    public LineItem description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LineItem revenue(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Revenue getRevenue() {
        return this.revenue;
    }

    public void setRevenue(Revenue revenue) {
        this.revenue = revenue;
    }

    public LineItem discountUnitAmount(BigDecimal discountUnitAmount) {
        this.discountUnitAmount = discountUnitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount amount. Specify this field if you offer an amount-based discount.")
    public BigDecimal getDiscountUnitAmount() {
        return this.discountUnitAmount;
    }

    public void setDiscountUnitAmount(BigDecimal discountUnitAmount) {
        this.discountUnitAmount = discountUnitAmount;
    }

    public LineItem discountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount percent. Specify this field if you offer a percentage-based discount.")
    public BigDecimal getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
    }

    public LineItem category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The category for the order line item, to indicate a product sale or return.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public LineItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of an order line item. If you want to generate billing documents for order line items, you must set this field to `sent_to_billing`. For invoice preview, you do not need to set this field.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public LineItem type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the order line item.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LineItem name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the order line item")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LineItem itemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the order item. It can be user-supplied.")
    public String getItemNumber() {
        return this.itemNumber;
    }

    public void setItemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
    }

    public LineItem listUnitPrice(BigDecimal listUnitPrice) {
        this.listUnitPrice = listUnitPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list price per unit for the order line item.")
    public BigDecimal getListUnitPrice() {
        return this.listUnitPrice;
    }

    public void setListUnitPrice(BigDecimal listUnitPrice) {
        this.listUnitPrice = listUnitPrice;
    }

    public LineItem productCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The product code for the order line item.")
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public LineItem priceId(String priceId) {
        this.priceId = priceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the price.")
    public String getPriceId() {
        return this.priceId;
    }

    public void setPriceId(String priceId) {
        this.priceId = priceId;
    }

    public LineItem purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used by customers to specify the Purchase Order Number provided by the buyer.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public LineItem quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The quantity of units, such as the number of authors in a hosted wiki service.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public LineItem recognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getRecognizedRevenueAccount() {
        return this.recognizedRevenueAccount;
    }

    public void setRecognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
    }

    public LineItem revenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The revenue recognition rule for the order line item.")
    public String getRevenueRecognitionRuleName() {
        return this.revenueRecognitionRuleName;
    }

    public void setRevenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
    }

    public LineItem soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad0823f8040e52d0180433026b156fe", value="Customer address used for calculating tax.")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    public LineItem taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A tax code identifier. If a `tax_code` of a price is not provided when you create or update a price, Zuora will treat the charged amount as non-taxable. If this code is provide, Zuora considers that this price is taxable and the charged amount will be handled accordingly.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public LineItem taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this field is set to `true`, it indicates that amounts are inclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    public LineItem startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date a transaction starts. The default value of this field is the order date.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LineItem endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date a transaction is completed. The default value of this field is the transaction start date. Also, the value of this field should always equal or be later than the value of the `start_date` field.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    @Nullable
    @ApiModelProperty(value="List of invoice items. EXPANDABLE")
    public InvoiceItemListResponse getInvoiceItems() {
        return this.invoiceItems;
    }

    public LineItem relatedSubscriptionNumber(String relatedSubscriptionNumber) {
        this.relatedSubscriptionNumber = relatedSubscriptionNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use this field to relate an order line item to an subscription. Specify this field to the subscription number of the subscription to relate.")
    public String getRelatedSubscriptionNumber() {
        return this.relatedSubscriptionNumber;
    }

    public void setRelatedSubscriptionNumber(String relatedSubscriptionNumber) {
        this.relatedSubscriptionNumber = relatedSubscriptionNumber;
    }

    public LineItem billingRule(BillingRuleEnum billingRule) {
        this.billingRule = billingRule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing rule for the Order Line Item.")
    public BillingRuleEnum getBillingRule() {
        return this.billingRule;
    }

    public void setBillingRule(BillingRuleEnum billingRule) {
        this.billingRule = billingRule;
    }

    public LineItem total(String total) {
        this.total = total;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount, including the total tax amount.")
    public String getTotal() {
        return this.total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public LineItem subtotal(String subtotal) {
        this.subtotal = subtotal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount exclusive of tax. ")
    public String getSubtotal() {
        return this.subtotal;
    }

    public void setSubtotal(String subtotal) {
        this.subtotal = subtotal;
    }

    public LineItem originalOrderDate(LocalDate originalOrderDate) {
        this.originalOrderDate = originalOrderDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date when the subscription item is created through an order. This field is to standardize the booking date information to increase audit ability and traceability of data between Zuora Billing and Zuora Revenue. It is mapped as the booking date for a sales order line in Zuora Revenue.")
    public LocalDate getOriginalOrderDate() {
        return this.originalOrderDate;
    }

    public void setOriginalOrderDate(LocalDate originalOrderDate) {
        this.originalOrderDate = originalOrderDate;
    }

    public LineItem accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The accounting code for the order line item.")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public LineItem adjustmentLiabilityAccount(String adjustmentLiabilityAccount) {
        this.adjustmentLiabilityAccount = adjustmentLiabilityAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The accounting code on the Order Line Item object for customers using Zuora Billing - Revenue Integration.")
    public String getAdjustmentLiabilityAccount() {
        return this.adjustmentLiabilityAccount;
    }

    public void setAdjustmentLiabilityAccount(String adjustmentLiabilityAccount) {
        this.adjustmentLiabilityAccount = adjustmentLiabilityAccount;
    }

    public LineItem adjustmentRevenueAccount(String adjustmentRevenueAccount) {
        this.adjustmentRevenueAccount = adjustmentRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The accounting code on the Order Line Item object for customers using Zuora Billing - Revenue Integration.")
    public String getAdjustmentRevenueAccount() {
        return this.adjustmentRevenueAccount;
    }

    public void setAdjustmentRevenueAccount(String adjustmentRevenueAccount) {
        this.adjustmentRevenueAccount = adjustmentRevenueAccount;
    }

    public LineItem discountTotal(String discountTotal) {
        this.discountTotal = discountTotal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total discount amount.")
    public String getDiscountTotal() {
        return this.discountTotal;
    }

    public void setDiscountTotal(String discountTotal) {
        this.discountTotal = discountTotal;
    }

    public LineItem listPrice(String listPrice) {
        this.listPrice = listPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The extended list price for an order line item, calculated by the formula: listPrice = listPricePerUnit * quantity")
    public String getListPrice() {
        return this.listPrice;
    }

    public void setListPrice(String listPrice) {
        this.listPrice = listPrice;
    }

    public LineItem originalSoldToId(String originalSoldToId) {
        this.originalSoldToId = originalSoldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of a contact that belongs to the billing account of the order line item. Use this field to assign an existing account as the sold-to contact of an order line item.")
    public String getOriginalSoldToId() {
        return this.originalSoldToId;
    }

    public void setOriginalSoldToId(String originalSoldToId) {
        this.originalSoldToId = originalSoldToId;
    }

    public LineItem unbilledReceivablesAccount(String unbilledReceivablesAccount) {
        this.unbilledReceivablesAccount = unbilledReceivablesAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The accounting code on the Order Line Item object for customers using Zuora Billing - Revenue Integration.")
    public String getUnbilledReceivablesAccount() {
        return this.unbilledReceivablesAccount;
    }

    public void setUnbilledReceivablesAccount(String unbilledReceivablesAccount) {
        this.unbilledReceivablesAccount = unbilledReceivablesAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineItem lineItem = (LineItem)o;
        return Objects.equals(this.id, lineItem.id) && Objects.equals(this.updatedById, lineItem.updatedById) && Objects.equals(this.updatedTime, lineItem.updatedTime) && Objects.equals(this.createdById, lineItem.createdById) && Objects.equals(this.createdTime, lineItem.createdTime) && Objects.equals(this.customFields, lineItem.customFields) && Objects.equals(this.customObjects, lineItem.customObjects) && Objects.equals(this.unitOfMeasure, lineItem.unitOfMeasure) && Objects.equals(this.unitAmount, lineItem.unitAmount) && Objects.equals(this.targetDate, lineItem.targetDate) && Objects.equals(this.deferredRevenueAccount, lineItem.deferredRevenueAccount) && Objects.equals(this.description, lineItem.description) && Objects.equals(this.revenue, lineItem.revenue) && Objects.equals(this.discountUnitAmount, lineItem.discountUnitAmount) && Objects.equals(this.discountPercent, lineItem.discountPercent) && Objects.equals((Object)this.category, (Object)lineItem.category) && Objects.equals((Object)this.state, (Object)lineItem.state) && Objects.equals(this.type, lineItem.type) && Objects.equals(this.name, lineItem.name) && Objects.equals(this.itemNumber, lineItem.itemNumber) && Objects.equals(this.listUnitPrice, lineItem.listUnitPrice) && Objects.equals(this.productCode, lineItem.productCode) && Objects.equals(this.priceId, lineItem.priceId) && Objects.equals(this.purchaseOrderNumber, lineItem.purchaseOrderNumber) && Objects.equals(this.quantity, lineItem.quantity) && Objects.equals(this.recognizedRevenueAccount, lineItem.recognizedRevenueAccount) && Objects.equals(this.revenueRecognitionRuleName, lineItem.revenueRecognitionRuleName) && Objects.equals(this.soldToId, lineItem.soldToId) && Objects.equals(this.taxCode, lineItem.taxCode) && Objects.equals(this.taxInclusive, lineItem.taxInclusive) && Objects.equals(this.startDate, lineItem.startDate) && Objects.equals(this.endDate, lineItem.endDate) && Objects.equals(this.invoiceItems, lineItem.invoiceItems) && Objects.equals(this.relatedSubscriptionNumber, lineItem.relatedSubscriptionNumber) && Objects.equals((Object)this.billingRule, (Object)lineItem.billingRule) && Objects.equals(this.total, lineItem.total) && Objects.equals(this.subtotal, lineItem.subtotal) && Objects.equals(this.originalOrderDate, lineItem.originalOrderDate) && Objects.equals(this.accountingCode, lineItem.accountingCode) && Objects.equals(this.adjustmentLiabilityAccount, lineItem.adjustmentLiabilityAccount) && Objects.equals(this.adjustmentRevenueAccount, lineItem.adjustmentRevenueAccount) && Objects.equals(this.discountTotal, lineItem.discountTotal) && Objects.equals(this.listPrice, lineItem.listPrice) && Objects.equals(this.originalSoldToId, lineItem.originalSoldToId) && Objects.equals(this.unbilledReceivablesAccount, lineItem.unbilledReceivablesAccount);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.unitOfMeasure, this.unitAmount, this.targetDate, this.deferredRevenueAccount, this.description, this.revenue, this.discountUnitAmount, this.discountPercent, this.category, this.state, this.type, this.name, this.itemNumber, this.listUnitPrice, this.productCode, this.priceId, this.purchaseOrderNumber, this.quantity, this.recognizedRevenueAccount, this.revenueRecognitionRuleName, this.soldToId, this.taxCode, this.taxInclusive, this.startDate, this.endDate, this.invoiceItems, this.relatedSubscriptionNumber, this.billingRule, this.total, this.subtotal, this.originalOrderDate, this.accountingCode, this.adjustmentLiabilityAccount, this.adjustmentRevenueAccount, this.discountTotal, this.listPrice, this.originalSoldToId, this.unbilledReceivablesAccount});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    deferredRevenueAccount: ").append(this.toIndentedString(this.deferredRevenueAccount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    revenue: ").append(this.toIndentedString(this.revenue)).append("\n");
        sb.append("    discountUnitAmount: ").append(this.toIndentedString(this.discountUnitAmount)).append("\n");
        sb.append("    discountPercent: ").append(this.toIndentedString(this.discountPercent)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    itemNumber: ").append(this.toIndentedString(this.itemNumber)).append("\n");
        sb.append("    listUnitPrice: ").append(this.toIndentedString(this.listUnitPrice)).append("\n");
        sb.append("    productCode: ").append(this.toIndentedString(this.productCode)).append("\n");
        sb.append("    priceId: ").append(this.toIndentedString(this.priceId)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    recognizedRevenueAccount: ").append(this.toIndentedString(this.recognizedRevenueAccount)).append("\n");
        sb.append("    revenueRecognitionRuleName: ").append(this.toIndentedString(this.revenueRecognitionRuleName)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    invoiceItems: ").append(this.toIndentedString(this.invoiceItems)).append("\n");
        sb.append("    relatedSubscriptionNumber: ").append(this.toIndentedString(this.relatedSubscriptionNumber)).append("\n");
        sb.append("    billingRule: ").append(this.toIndentedString((Object)this.billingRule)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    subtotal: ").append(this.toIndentedString(this.subtotal)).append("\n");
        sb.append("    originalOrderDate: ").append(this.toIndentedString(this.originalOrderDate)).append("\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    adjustmentLiabilityAccount: ").append(this.toIndentedString(this.adjustmentLiabilityAccount)).append("\n");
        sb.append("    adjustmentRevenueAccount: ").append(this.toIndentedString(this.adjustmentRevenueAccount)).append("\n");
        sb.append("    discountTotal: ").append(this.toIndentedString(this.discountTotal)).append("\n");
        sb.append("    listPrice: ").append(this.toIndentedString(this.listPrice)).append("\n");
        sb.append("    originalSoldToId: ").append(this.toIndentedString(this.originalSoldToId)).append("\n");
        sb.append("    unbilledReceivablesAccount: ").append(this.toIndentedString(this.unbilledReceivablesAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BillingRuleEnum {
        WITHOUT_FULFILLMENT("trigger_without_fulfillment"),
        ON_FULFILLMENT("trigger_on_fulfillment"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BillingRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BillingRuleEnum fromValue(String value) {
            for (BillingRuleEnum b : BillingRuleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BillingRuleEnum> {
            public void write(JsonWriter jsonWriter, BillingRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BillingRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BillingRuleEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        BOOKED("booked"),
        SENT_TO_BILLING("sent_to_billing"),
        COMPLETE("complete"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        SALE("sale"),
        RETURN("return"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

