/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Address;
import org.threeten.bp.OffsetDateTime;

public class Contact {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private Address address;
    public static final String SERIALIZED_NAME_FIRST_NAME = "first_name";
    @SerializedName(value="first_name")
    private String firstName;
    public static final String SERIALIZED_NAME_HOME_PHONE = "home_phone";
    @SerializedName(value="home_phone")
    private String homePhone;
    public static final String SERIALIZED_NAME_LAST_NAME = "last_name";
    @SerializedName(value="last_name")
    private String lastName;
    public static final String SERIALIZED_NAME_MOBILE_PHONE = "mobile_phone";
    @SerializedName(value="mobile_phone")
    private String mobilePhone;
    public static final String SERIALIZED_NAME_NICKNAME = "nickname";
    @SerializedName(value="nickname")
    private String nickname;
    public static final String SERIALIZED_NAME_OTHER_PHONE = "other_phone";
    @SerializedName(value="other_phone")
    private String otherPhone;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_TAX_REGION = "tax_region";
    @SerializedName(value="tax_region")
    private String taxRegion;
    public static final String SERIALIZED_NAME_WORK_EMAIL = "work_email";
    @SerializedName(value="work_email")
    private String workEmail;
    public static final String SERIALIZED_NAME_WORK_PHONE = "work_phone";
    @SerializedName(value="work_phone")
    private String workPhone;
    public static final String SERIALIZED_NAME_OTHER_PHONE_TYPE = "other_phone_type";
    @SerializedName(value="other_phone_type")
    private OtherPhoneTypeEnum otherPhoneType;
    public static final String SERIALIZED_NAME_FAX = "fax";
    @SerializedName(value="fax")
    private String fax;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;

    public Contact() {
    }

    public Contact(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public Contact customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Contact putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public Contact address(Address address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Contact firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Amy", value="Customer first name.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Contact homePhone(String homePhone) {
        this.homePhone = homePhone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="(888)976-9056", value="Customer home phone (including extension).")
    public String getHomePhone() {
        return this.homePhone;
    }

    public void setHomePhone(String homePhone) {
        this.homePhone = homePhone;
    }

    public Contact lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Lawrence", value="Customer last name.")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Contact mobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="(888)101-0011", value="Customer phone (including extension).")
    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public Contact nickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Ami", value="Nickname for this contact.")
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Contact otherPhone(String otherPhone) {
        this.otherPhone = otherPhone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="(888)100-0001", value="Other customer phone (including extension).")
    public String getOtherPhone() {
        return this.otherPhone;
    }

    public void setOtherPhone(String otherPhone) {
        this.otherPhone = otherPhone;
    }

    public Contact email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="alawrence@gmail.com", value="Customer email address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Contact taxRegion(String taxRegion) {
        this.taxRegion = taxRegion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Georgia", value="A region defined in your Zuora Tax rules.")
    public String getTaxRegion() {
        return this.taxRegion;
    }

    public void setTaxRegion(String taxRegion) {
        this.taxRegion = taxRegion;
    }

    public Contact workEmail(String workEmail) {
        this.workEmail = workEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="alawrence@zuora.com", value="Customer work email.")
    public String getWorkEmail() {
        return this.workEmail;
    }

    public void setWorkEmail(String workEmail) {
        this.workEmail = workEmail;
    }

    public Contact workPhone(String workPhone) {
        this.workPhone = workPhone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="(888)976-9056", value="Customer work phone.")
    public String getWorkPhone() {
        return this.workPhone;
    }

    public void setWorkPhone(String workPhone) {
        this.workPhone = workPhone;
    }

    public Contact otherPhoneType(OtherPhoneTypeEnum otherPhoneType) {
        this.otherPhoneType = otherPhoneType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the additional phone number.")
    public OtherPhoneTypeEnum getOtherPhoneType() {
        return this.otherPhoneType;
    }

    public void setOtherPhoneType(OtherPhoneTypeEnum otherPhoneType) {
        this.otherPhoneType = otherPhoneType;
    }

    public Contact fax(String fax) {
        this.fax = fax;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The contact's fax number.")
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public Contact accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="Identifier of a customer account with which this contact is associated.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        return Objects.equals(this.id, contact.id) && Objects.equals(this.updatedById, contact.updatedById) && Objects.equals(this.updatedTime, contact.updatedTime) && Objects.equals(this.createdById, contact.createdById) && Objects.equals(this.createdTime, contact.createdTime) && Objects.equals(this.customFields, contact.customFields) && Objects.equals(this.customObjects, contact.customObjects) && Objects.equals(this.address, contact.address) && Objects.equals(this.firstName, contact.firstName) && Objects.equals(this.homePhone, contact.homePhone) && Objects.equals(this.lastName, contact.lastName) && Objects.equals(this.mobilePhone, contact.mobilePhone) && Objects.equals(this.nickname, contact.nickname) && Objects.equals(this.otherPhone, contact.otherPhone) && Objects.equals(this.email, contact.email) && Objects.equals(this.taxRegion, contact.taxRegion) && Objects.equals(this.workEmail, contact.workEmail) && Objects.equals(this.workPhone, contact.workPhone) && Objects.equals((Object)this.otherPhoneType, (Object)contact.otherPhoneType) && Objects.equals(this.fax, contact.fax) && Objects.equals(this.accountId, contact.accountId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.address, this.firstName, this.homePhone, this.lastName, this.mobilePhone, this.nickname, this.otherPhone, this.email, this.taxRegion, this.workEmail, this.workPhone, this.otherPhoneType, this.fax, this.accountId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Contact {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    homePhone: ").append(this.toIndentedString(this.homePhone)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    mobilePhone: ").append(this.toIndentedString(this.mobilePhone)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    otherPhone: ").append(this.toIndentedString(this.otherPhone)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    taxRegion: ").append(this.toIndentedString(this.taxRegion)).append("\n");
        sb.append("    workEmail: ").append(this.toIndentedString(this.workEmail)).append("\n");
        sb.append("    workPhone: ").append(this.toIndentedString(this.workPhone)).append("\n");
        sb.append("    otherPhoneType: ").append(this.toIndentedString((Object)this.otherPhoneType)).append("\n");
        sb.append("    fax: ").append(this.toIndentedString(this.fax)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OtherPhoneTypeEnum {
        WORK("work"),
        MOBILE("mobile"),
        HOME("home"),
        OTHER("other"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private OtherPhoneTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OtherPhoneTypeEnum fromValue(String value) {
            for (OtherPhoneTypeEnum b : OtherPhoneTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OtherPhoneTypeEnum> {
            public void write(JsonWriter jsonWriter, OtherPhoneTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OtherPhoneTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OtherPhoneTypeEnum.fromValue(value);
            }
        }
    }
}

