/*
 * Decompiled with CFR 0.152.
 */
package com.zuora;

import java.util.List;
import java.util.Map;

public class ApiResponse<T> {
    private final Map<String, List<String>> headers;
    private final T data;
    private int statusCode = 0;
    private String contentEncoding = "";
    private String rateLimitLimit = "";
    private long rateLimitRemaining = 0L;
    private long rateLimitReset = 0L;
    private String zuoraTrackId = "";
    private String zuoraRequestId = "";
    private String concurrencyLimitType = "";
    private int concurrencyLimitLimit = 0;
    private int concurrencyLimitRemaining = 0;

    public ApiResponse(int statusCode, Map<String, List<String>> headers) {
        this(statusCode, headers, null);
    }

    public ApiResponse(int statusCode, Map<String, List<String>> headers, T data) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.parseAndSetResponseHeaders();
        this.data = data;
    }

    private void parseAndSetResponseHeaders() {
        try {
            if (this.headers != null) {
                for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                    String key = entry.getKey().toLowerCase();
                    String value = entry.getValue().iterator().next();
                    switch (key) {
                        case "content-encoding": {
                            this.contentEncoding = value;
                            break;
                        }
                        case "ratelimit-limit": {
                            this.rateLimitLimit = value;
                            break;
                        }
                        case "ratelimit-remaining": {
                            this.rateLimitRemaining = Long.parseLong(value);
                            break;
                        }
                        case "ratelimit-reset": {
                            this.rateLimitReset = Long.parseLong(value);
                            break;
                        }
                        case "zuora-request-id": {
                            this.zuoraRequestId = value;
                            break;
                        }
                        case "zuora-track-id": {
                            this.zuoraTrackId = value;
                            break;
                        }
                        case "concurrency-limit-type": {
                            this.concurrencyLimitType = value;
                            break;
                        }
                        case "concurrency-limit-limit": {
                            this.concurrencyLimitLimit = Integer.parseInt(value);
                            break;
                        }
                        case "concurrency-limit-remaining": {
                            this.concurrencyLimitRemaining = Integer.parseInt(value);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getZuoraRequestId() {
        return this.zuoraRequestId;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getRateLimitLimit() {
        return this.rateLimitLimit;
    }

    public long getRateLimitRemaining() {
        return this.rateLimitRemaining;
    }

    public long getRateLimitReset() {
        return this.rateLimitReset;
    }

    public String getZuoraTrackId() {
        return this.zuoraTrackId;
    }

    public String getConcurrencyLimitType() {
        return this.concurrencyLimitType;
    }

    public int getConcurrencyLimitLimit() {
        return this.concurrencyLimitLimit;
    }

    public int getConcurrencyLimitRemaining() {
        return this.concurrencyLimitRemaining;
    }

    public T getData() {
        return this.data;
    }
}

