/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.SubscriptionItemPatchRequest;

@ApiModel(description="Subscription Plan information.")
public class SubscriptionPlanPatchRequest {
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_PLAN_ID = "subscription_plan_id";
    @SerializedName(value="subscription_plan_id")
    private String subscriptionPlanId;
    public static final String SERIALIZED_NAME_UNIQUE_TOKEN = "unique_token";
    @SerializedName(value="unique_token")
    private String uniqueToken;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEMS = "subscription_items";
    @SerializedName(value="subscription_items")
    private List<SubscriptionItemPatchRequest> subscriptionItems = null;

    public SubscriptionPlanPatchRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionPlanPatchRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public SubscriptionPlanPatchRequest subscriptionPlanId(String subscriptionPlanId) {
        this.subscriptionPlanId = subscriptionPlanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the subscription plan.")
    public String getSubscriptionPlanId() {
        return this.subscriptionPlanId;
    }

    public void setSubscriptionPlanId(String subscriptionPlanId) {
        this.subscriptionPlanId = subscriptionPlanId;
    }

    public SubscriptionPlanPatchRequest uniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the subscription plan. This identifier enables you to refer to the subscription plan before the subscription plan has an internal identifier in Zuora.")
    public String getUniqueToken() {
        return this.uniqueToken;
    }

    public void setUniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
    }

    public SubscriptionPlanPatchRequest subscriptionItems(List<SubscriptionItemPatchRequest> subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
        return this;
    }

    public SubscriptionPlanPatchRequest addSubscriptionItemsItem(SubscriptionItemPatchRequest subscriptionItemsItem) {
        if (this.subscriptionItems == null) {
            this.subscriptionItems = new ArrayList<SubscriptionItemPatchRequest>();
        }
        this.subscriptionItems.add(subscriptionItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subscription item information.")
    public List<SubscriptionItemPatchRequest> getSubscriptionItems() {
        return this.subscriptionItems;
    }

    public void setSubscriptionItems(List<SubscriptionItemPatchRequest> subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionPlanPatchRequest subscriptionPlanPatchRequest = (SubscriptionPlanPatchRequest)o;
        return Objects.equals(this.customFields, subscriptionPlanPatchRequest.customFields) && Objects.equals(this.subscriptionPlanId, subscriptionPlanPatchRequest.subscriptionPlanId) && Objects.equals(this.uniqueToken, subscriptionPlanPatchRequest.uniqueToken) && Objects.equals(this.subscriptionItems, subscriptionPlanPatchRequest.subscriptionItems);
    }

    public int hashCode() {
        return Objects.hash(this.customFields, this.subscriptionPlanId, this.uniqueToken, this.subscriptionItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionPlanPatchRequest {\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    subscriptionPlanId: ").append(this.toIndentedString(this.subscriptionPlanId)).append("\n");
        sb.append("    uniqueToken: ").append(this.toIndentedString(this.uniqueToken)).append("\n");
        sb.append("    subscriptionItems: ").append(this.toIndentedString(this.subscriptionItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

