/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.SubscriptionItemListResponse;
import org.openapitools.jackson.nullable.JsonNullable;

public class SubscriptionAddPlanPatchResponse {
    public static final String SERIALIZED_NAME_UNIQUE_TOKEN = "unique_token";
    @SerializedName(value="unique_token")
    private String uniqueToken;
    public static final String SERIALIZED_NAME_PLAN_ID = "plan_id";
    @SerializedName(value="plan_id")
    private String planId;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEMS = "subscription_items";
    @SerializedName(value="subscription_items")
    private SubscriptionItemListResponse subscriptionItems;

    public SubscriptionAddPlanPatchResponse uniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique string to represent the subscription plan in the order. The unique token is used to perform multiple actions against a newly added subscription plan. For example, if you want to add and update a product in the same order, assign a unique token to the newly added subscription plan and use that token in future order actions.")
    public String getUniqueToken() {
        return this.uniqueToken;
    }

    public void setUniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
    }

    public SubscriptionAddPlanPatchResponse planId(String planId) {
        this.planId = planId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the subscription plan to be updated. It can be the latest version or any history version id.")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public SubscriptionAddPlanPatchResponse customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionAddPlanPatchResponse putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public SubscriptionAddPlanPatchResponse subscriptionItems(SubscriptionItemListResponse subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubscriptionItemListResponse getSubscriptionItems() {
        return this.subscriptionItems;
    }

    public void setSubscriptionItems(SubscriptionItemListResponse subscriptionItems) {
        this.subscriptionItems = subscriptionItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionAddPlanPatchResponse subscriptionAddPlanPatchResponse = (SubscriptionAddPlanPatchResponse)o;
        return Objects.equals(this.uniqueToken, subscriptionAddPlanPatchResponse.uniqueToken) && Objects.equals(this.planId, subscriptionAddPlanPatchResponse.planId) && Objects.equals(this.customFields, subscriptionAddPlanPatchResponse.customFields) && Objects.equals(this.subscriptionItems, subscriptionAddPlanPatchResponse.subscriptionItems);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.uniqueToken, this.planId, this.customFields, this.subscriptionItems);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionAddPlanPatchResponse {\n");
        sb.append("    uniqueToken: ").append(this.toIndentedString(this.uniqueToken)).append("\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    subscriptionItems: ").append(this.toIndentedString(this.subscriptionItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

