/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

public class SubscriptionActivateRequest {
    public static final String SERIALIZED_NAME_CONTRACT_EFFECTIVE = "contract_effective";
    @SerializedName(value="contract_effective")
    private LocalDate contractEffective;
    public static final String SERIALIZED_NAME_SERVICE_ACTIVATION = "service_activation";
    @SerializedName(value="service_activation")
    private LocalDate serviceActivation;
    public static final String SERIALIZED_NAME_CUSTOMER_ACCEPTANCE = "customer_acceptance";
    @SerializedName(value="customer_acceptance")
    private LocalDate customerAcceptance;

    public SubscriptionActivateRequest contractEffective(LocalDate contractEffective) {
        this.contractEffective = contractEffective;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Thu Jun 01 00:00:00 GMT 2023", value="Effective contract date for this subscription, in the `yyyy-mm-dd` format.")
    public LocalDate getContractEffective() {
        return this.contractEffective;
    }

    public void setContractEffective(LocalDate contractEffective) {
        this.contractEffective = contractEffective;
    }

    public SubscriptionActivateRequest serviceActivation(LocalDate serviceActivation) {
        this.serviceActivation = serviceActivation;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Thu Jun 01 00:00:00 GMT 2023", value="The date on which the services or products within a subscription have been activated and access has been provided to the customer, as the `yyyy-mm-dd` format.       <ul>        <li> If [Zuora is configured to require service activation](https://knowledgecenter.zuora.com/CB_Billing/Billing_Settings/Define_Default_Subscription_Settings#Require_Service_Activation_of_Orders.3F) and the `service_activation` field is not set for a `subscription_plans` order action or the \"Create a subscription\" operation, a `pending` order and/or a `pending_activation` subscription are created.</li>         <li> If [Zuora is configured to require service activation](https://knowledgecenter.zuora.com/CB_Billing/Billing_Settings/Define_Default_Subscription_Settings#Require_Service_Activation_of_Orders.3F) and the `service_activation` field is not set for any of the following order actions or the \"Update a subscription\" operation, a `pending` order is created. The subscription status is not impacted. **Note**: This feature is in Limited Availability. If you want to have access to the feature, submit a request at [Zuora Global Support](https://support.zuora.com/).         <ul>           <li>`add_subscription_plans`</li>           <li>`update_subscription_plans`</li>           <li>`remove_subscription_plans`</li>           <li>`renew`</li>           <li>`terms`</li>           </ul>           </li>         </ul>")
    public LocalDate getServiceActivation() {
        return this.serviceActivation;
    }

    public void setServiceActivation(LocalDate serviceActivation) {
        this.serviceActivation = serviceActivation;
    }

    public SubscriptionActivateRequest customerAcceptance(LocalDate customerAcceptance) {
        this.customerAcceptance = customerAcceptance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Thu Jun 01 00:00:00 GMT 2023", value="The date on which the services or products within a subscription have been accepted by the customer, in the `yyyy-mm-dd` format.      <ul>       <li> If [Zuora is configured to require customer acceptance](https://knowledgecenter.zuora.com/CB_Billing/Billing_Settings/Define_Default_Subscription_Settings#Require_Customer_Acceptance_of_Orders.3F) and the `customer_acceptance` field is not set for a `subscription_plans` order action or the \"Create a subscription\" operation, a `pending` order and/or a `pending_acceptance` subscription are created. At the same time, if the service activation date field is also required and not set, a `pending` order and/or a `pending_activation` subscription are created instead.</li>       <li>       If [Zuora is configured to require customer acceptance](https://knowledgecenter.zuora.com/CB_Billing/Billing_Settings/Define_Default_Subscription_Settings#Require_Customer_Acceptance_of_Orders.3F) and the `customer_acceptance` field is not set for any of the following order actions or the \"Update a subscription\" operation, a `pending` order is created. The subscription status is not impacted. **Note**: This feature is in Limited Availability. If you want to have access to the feature, submit a request at [Zuora Global Support](https://support.zuora.com/).       <ul>       <li>`add_subscription_plans`</li>       <li>`update_subscription_plans`</li>       <li>`remove_subscription_plans`</li>       <li>`renew`</li>       <li>`terms`</li>       </ul></li>       </ul>       ")
    public LocalDate getCustomerAcceptance() {
        return this.customerAcceptance;
    }

    public void setCustomerAcceptance(LocalDate customerAcceptance) {
        this.customerAcceptance = customerAcceptance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionActivateRequest subscriptionActivateRequest = (SubscriptionActivateRequest)o;
        return Objects.equals(this.contractEffective, subscriptionActivateRequest.contractEffective) && Objects.equals(this.serviceActivation, subscriptionActivateRequest.serviceActivation) && Objects.equals(this.customerAcceptance, subscriptionActivateRequest.customerAcceptance);
    }

    public int hashCode() {
        return Objects.hash(this.contractEffective, this.serviceActivation, this.customerAcceptance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionActivateRequest {\n");
        sb.append("    contractEffective: ").append(this.toIndentedString(this.contractEffective)).append("\n");
        sb.append("    serviceActivation: ").append(this.toIndentedString(this.serviceActivation)).append("\n");
        sb.append("    customerAcceptance: ").append(this.toIndentedString(this.customerAcceptance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

