/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.BillingDocumentPaymentApplicationRequest;
import org.threeten.bp.LocalDate;

public class PaymentApplyUnapplyRequest {
    public static final String SERIALIZED_NAME_EFFECTIVE_DATE = "effective_date";
    @SerializedName(value="effective_date")
    private LocalDate effectiveDate;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENTS = "billing_documents";
    @SerializedName(value="billing_documents")
    private List<BillingDocumentPaymentApplicationRequest> billingDocuments = new ArrayList<BillingDocumentPaymentApplicationRequest>();

    public PaymentApplyUnapplyRequest effectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the payment takes effect.")
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public PaymentApplyUnapplyRequest billingDocuments(List<BillingDocumentPaymentApplicationRequest> billingDocuments) {
        this.billingDocuments = billingDocuments;
        return this;
    }

    public PaymentApplyUnapplyRequest addBillingDocumentsItem(BillingDocumentPaymentApplicationRequest billingDocumentsItem) {
        this.billingDocuments.add(billingDocumentsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Indicates to which billing documents (invoices or debit memos) are the payment applied.")
    public List<BillingDocumentPaymentApplicationRequest> getBillingDocuments() {
        return this.billingDocuments;
    }

    public void setBillingDocuments(List<BillingDocumentPaymentApplicationRequest> billingDocuments) {
        this.billingDocuments = billingDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentApplyUnapplyRequest paymentApplyUnapplyRequest = (PaymentApplyUnapplyRequest)o;
        return Objects.equals(this.effectiveDate, paymentApplyUnapplyRequest.effectiveDate) && Objects.equals(this.billingDocuments, paymentApplyUnapplyRequest.billingDocuments);
    }

    public int hashCode() {
        return Objects.hash(this.effectiveDate, this.billingDocuments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentApplyUnapplyRequest {\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    billingDocuments: ").append(this.toIndentedString(this.billingDocuments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

