/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class BillRunCreateRequest {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private Boolean email;
    public static final String SERIALIZED_NAME_POST = "post";
    @SerializedName(value="post")
    private Boolean post;
    public static final String SERIALIZED_NAME_RENEW = "renew";
    @SerializedName(value="renew")
    private Boolean renew;
    public static final String SERIALIZED_NAME_DAY_OF_MONTH = "day_of_month";
    @SerializedName(value="day_of_month")
    private DayOfMonthEnum dayOfMonth;
    public static final String SERIALIZED_NAME_BATCHES = "batches";
    @SerializedName(value="batches")
    private List<String> batches = null;
    public static final String SERIALIZED_NAME_INVOICE_DATE = "invoice_date";
    @SerializedName(value="invoice_date")
    private LocalDate invoiceDate;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_EMAIL_ZERO_AMOUNT_INVOICES = "email_zero_amount_invoices";
    @SerializedName(value="email_zero_amount_invoices")
    private Boolean emailZeroAmountInvoices = true;
    public static final String SERIALIZED_NAME_CHARGES_EXCLUDED = "charges_excluded";
    @SerializedName(value="charges_excluded")
    private List<String> chargesExcluded = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_IDS = "subscription_ids";
    @SerializedName(value="subscription_ids")
    private List<String> subscriptionIds = null;

    public BillRunCreateRequest() {
    }

    public BillRunCreateRequest(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public BillRunCreateRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public BillRunCreateRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public BillRunCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the customer account to bill. Specify this field or `account_number` if you want to create a bill run for a single customer.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BillRunCreateRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the account to bill. Specify this field or `account_id` if you want to create a bill run for a single customer.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public BillRunCreateRequest email(Boolean email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, invoices will be automatically emailed to customers.")
    public Boolean getEmail() {
        return this.email;
    }

    public void setEmail(Boolean email) {
        this.email = email;
    }

    public BillRunCreateRequest post(Boolean post) {
        this.post = post;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to automatically post a billing document after it is created.")
    public Boolean getPost() {
        return this.post;
    }

    public void setPost(Boolean post) {
        this.post = post;
    }

    public BillRunCreateRequest renew(Boolean renew) {
        this.renew = renew;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, subscriptions will be automatically renewed.")
    public Boolean getRenew() {
        return this.renew;
    }

    public void setRenew(Boolean renew) {
        this.renew = renew;
    }

    public BillRunCreateRequest dayOfMonth(DayOfMonthEnum dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The day of the month on which the multiple customer accounts are billed.")
    public DayOfMonthEnum getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(DayOfMonthEnum dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public BillRunCreateRequest batches(List<String> batches) {
        this.batches = batches;
        return this;
    }

    public BillRunCreateRequest addBatchesItem(String batchesItem) {
        if (this.batches == null) {
            this.batches = new ArrayList<String>();
        }
        this.batches.add(batchesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the customer account batch to be included in this bill run.")
    public List<String> getBatches() {
        return this.batches;
    }

    public void setBatches(List<String> batches) {
        this.batches = batches;
    }

    public BillRunCreateRequest invoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", required=true, value="The date displayed on the invoice.")
    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public BillRunCreateRequest targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", required=true, value="All unbilled items on or before this date are included in this bill run.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public BillRunCreateRequest emailZeroAmountInvoices(Boolean emailZeroAmountInvoices) {
        this.emailZeroAmountInvoices = emailZeroAmountInvoices;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If it is set to `false`, invoices for zero amounts will not be emailed to customers. ")
    public Boolean getEmailZeroAmountInvoices() {
        return this.emailZeroAmountInvoices;
    }

    public void setEmailZeroAmountInvoices(Boolean emailZeroAmountInvoices) {
        this.emailZeroAmountInvoices = emailZeroAmountInvoices;
    }

    public BillRunCreateRequest chargesExcluded(List<String> chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
        return this;
    }

    public BillRunCreateRequest addChargesExcludedItem(String chargesExcludedItem) {
        if (this.chargesExcluded == null) {
            this.chargesExcluded = new ArrayList<String>();
        }
        this.chargesExcluded.add(chargesExcludedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of the charge to be excluded from the bill run.")
    public List<String> getChargesExcluded() {
        return this.chargesExcluded;
    }

    public void setChargesExcluded(List<String> chargesExcluded) {
        this.chargesExcluded = chargesExcluded;
    }

    public BillRunCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the bill run.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BillRunCreateRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the bill run. This field is only available if you have the <a href=\u201dhttps://knowledgecenter.zuora.com/Zuora_Billing/Bill_your_customers/Automate_billing_document_generation/Bill_runs/Z_Catch-Up_Bill_Run\u201d target=\u201d_blank\u201d>Catch-Up Bill Run</a> feature enabled in your tenant.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BillRunCreateRequest subscriptionIds(List<String> subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
        return this;
    }

    public BillRunCreateRequest addSubscriptionIdsItem(String subscriptionIdsItem) {
        if (this.subscriptionIds == null) {
            this.subscriptionIds = new ArrayList<String>();
        }
        this.subscriptionIds.add(subscriptionIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target subscriptions for this bill run. Note that all these subscriptions must belong to the same account.")
    public List<String> getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public void setSubscriptionIds(List<String> subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillRunCreateRequest billRunCreateRequest = (BillRunCreateRequest)o;
        return Objects.equals(this.id, billRunCreateRequest.id) && Objects.equals(this.updatedById, billRunCreateRequest.updatedById) && Objects.equals(this.updatedTime, billRunCreateRequest.updatedTime) && Objects.equals(this.createdById, billRunCreateRequest.createdById) && Objects.equals(this.createdTime, billRunCreateRequest.createdTime) && Objects.equals(this.customFields, billRunCreateRequest.customFields) && Objects.equals(this.customObjects, billRunCreateRequest.customObjects) && Objects.equals(this.accountId, billRunCreateRequest.accountId) && Objects.equals(this.accountNumber, billRunCreateRequest.accountNumber) && Objects.equals(this.email, billRunCreateRequest.email) && Objects.equals(this.post, billRunCreateRequest.post) && Objects.equals(this.renew, billRunCreateRequest.renew) && Objects.equals((Object)this.dayOfMonth, (Object)billRunCreateRequest.dayOfMonth) && Objects.equals(this.batches, billRunCreateRequest.batches) && Objects.equals(this.invoiceDate, billRunCreateRequest.invoiceDate) && Objects.equals(this.targetDate, billRunCreateRequest.targetDate) && Objects.equals(this.emailZeroAmountInvoices, billRunCreateRequest.emailZeroAmountInvoices) && Objects.equals(this.chargesExcluded, billRunCreateRequest.chargesExcluded) && Objects.equals(this.name, billRunCreateRequest.name) && Objects.equals((Object)this.type, (Object)billRunCreateRequest.type) && Objects.equals(this.subscriptionIds, billRunCreateRequest.subscriptionIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.accountId, this.accountNumber, this.email, this.post, this.renew, this.dayOfMonth, this.batches, this.invoiceDate, this.targetDate, this.emailZeroAmountInvoices, this.chargesExcluded, this.name, this.type, this.subscriptionIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillRunCreateRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    post: ").append(this.toIndentedString(this.post)).append("\n");
        sb.append("    renew: ").append(this.toIndentedString(this.renew)).append("\n");
        sb.append("    dayOfMonth: ").append(this.toIndentedString((Object)this.dayOfMonth)).append("\n");
        sb.append("    batches: ").append(this.toIndentedString(this.batches)).append("\n");
        sb.append("    invoiceDate: ").append(this.toIndentedString(this.invoiceDate)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    emailZeroAmountInvoices: ").append(this.toIndentedString(this.emailZeroAmountInvoices)).append("\n");
        sb.append("    chargesExcluded: ").append(this.toIndentedString(this.chargesExcluded)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    subscriptionIds: ").append(this.toIndentedString(this.subscriptionIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        REGULAR("regular"),
        CATCH_UP("catch_up"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DayOfMonthEnum {
        _1("1"),
        _2("2"),
        _3("3"),
        _4("4"),
        _5("5"),
        _6("6"),
        _7("7"),
        _8("8"),
        _9("9"),
        _10("10"),
        _11("11"),
        _12("12"),
        _13("13"),
        _14("14"),
        _15("15"),
        _16("16"),
        _17("17"),
        _18("18"),
        _19("19"),
        _20("20"),
        _21("21"),
        _22("22"),
        _23("23"),
        _24("24"),
        _25("25"),
        _26("26"),
        _27("27"),
        _28("28"),
        _29("29"),
        _30("30"),
        _31("31"),
        ALLBILLCYCLEDAYS("AllBillCycleDays"),
        ASRUNDAY("AsRunDay"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private DayOfMonthEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DayOfMonthEnum fromValue(String value) {
            for (DayOfMonthEnum b : DayOfMonthEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DayOfMonthEnum> {
            public void write(JsonWriter jsonWriter, DayOfMonthEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DayOfMonthEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DayOfMonthEnum.fromValue(value);
            }
        }
    }
}

