/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.zuora.JSON;
import com.zuora.model.CreateOrderOrderLineItem;
import com.zuora.model.CreateOrderSubscription;
import com.zuora.model.OrderCategory;
import com.zuora.model.OrderCreateAccount;
import com.zuora.model.OrderSchedulingOptions;
import com.zuora.model.OrderStatus;
import com.zuora.model.ProcessingOptionsWithDelayedCapturePayment;
import com.zuora.model.UpsertCommitmentInput;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CreateOrderRequest {
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private OrderCategory category = OrderCategory.NEWSALES;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "customFields";
    @SerializedName(value="customFields")
    private Map<String, Object> customFields;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER = "existingAccountNumber";
    @SerializedName(value="existingAccountNumber")
    private String existingAccountNumber;
    public static final String SERIALIZED_NAME_NEW_ACCOUNT = "newAccount";
    @SerializedName(value="newAccount")
    private OrderCreateAccount newAccount;
    public static final String SERIALIZED_NAME_ORDER_DATE = "orderDate";
    @SerializedName(value="orderDate")
    private LocalDate orderDate;
    public static final String SERIALIZED_NAME_ORDER_LINE_ITEMS = "orderLineItems";
    @SerializedName(value="orderLineItems")
    private List<CreateOrderOrderLineItem> orderLineItems;
    public static final String SERIALIZED_NAME_ORDER_NUMBER = "orderNumber";
    @SerializedName(value="orderNumber")
    private String orderNumber;
    public static final String SERIALIZED_NAME_PROCESSING_OPTIONS = "processingOptions";
    @SerializedName(value="processingOptions")
    private ProcessingOptionsWithDelayedCapturePayment processingOptions;
    public static final String SERIALIZED_NAME_REASON_CODE = "reasonCode";
    @SerializedName(value="reasonCode")
    private String reasonCode;
    public static final String SERIALIZED_NAME_SCHEDULING_OPTIONS = "schedulingOptions";
    @SerializedName(value="schedulingOptions")
    private OrderSchedulingOptions schedulingOptions;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private OrderStatus status;
    public static final String SERIALIZED_NAME_SUBSCRIPTIONS = "subscriptions";
    @SerializedName(value="subscriptions")
    private List<CreateOrderSubscription> subscriptions;
    public static final String SERIALIZED_NAME_COMMITMENTS = "commitments";
    @SerializedName(value="commitments")
    private List<UpsertCommitmentInput> commitments;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateOrderRequest category(OrderCategory category) {
        this.category = category;
        return this;
    }

    @Nullable
    public OrderCategory getCategory() {
        return this.category;
    }

    public void setCategory(OrderCategory category) {
        this.category = category;
    }

    public CreateOrderRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public CreateOrderRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public CreateOrderRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateOrderRequest existingAccountNumber(String existingAccountNumber) {
        this.existingAccountNumber = existingAccountNumber;
        return this;
    }

    @Nullable
    public String getExistingAccountNumber() {
        return this.existingAccountNumber;
    }

    public void setExistingAccountNumber(String existingAccountNumber) {
        this.existingAccountNumber = existingAccountNumber;
    }

    public CreateOrderRequest newAccount(OrderCreateAccount newAccount) {
        this.newAccount = newAccount;
        return this;
    }

    @Nullable
    public OrderCreateAccount getNewAccount() {
        return this.newAccount;
    }

    public void setNewAccount(OrderCreateAccount newAccount) {
        this.newAccount = newAccount;
    }

    public CreateOrderRequest orderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Nonnull
    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public CreateOrderRequest orderLineItems(List<CreateOrderOrderLineItem> orderLineItems) {
        this.orderLineItems = orderLineItems;
        return this;
    }

    public CreateOrderRequest addOrderLineItemsItem(CreateOrderOrderLineItem orderLineItemsItem) {
        if (this.orderLineItems == null) {
            this.orderLineItems = new ArrayList<CreateOrderOrderLineItem>();
        }
        this.orderLineItems.add(orderLineItemsItem);
        return this;
    }

    @Nullable
    public List<CreateOrderOrderLineItem> getOrderLineItems() {
        return this.orderLineItems;
    }

    public void setOrderLineItems(List<CreateOrderOrderLineItem> orderLineItems) {
        this.orderLineItems = orderLineItems;
    }

    public CreateOrderRequest orderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
        return this;
    }

    @Nullable
    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public CreateOrderRequest processingOptions(ProcessingOptionsWithDelayedCapturePayment processingOptions) {
        this.processingOptions = processingOptions;
        return this;
    }

    @Nullable
    public ProcessingOptionsWithDelayedCapturePayment getProcessingOptions() {
        return this.processingOptions;
    }

    public void setProcessingOptions(ProcessingOptionsWithDelayedCapturePayment processingOptions) {
        this.processingOptions = processingOptions;
    }

    public CreateOrderRequest reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public CreateOrderRequest schedulingOptions(OrderSchedulingOptions schedulingOptions) {
        this.schedulingOptions = schedulingOptions;
        return this;
    }

    @Nullable
    public OrderSchedulingOptions getSchedulingOptions() {
        return this.schedulingOptions;
    }

    public void setSchedulingOptions(OrderSchedulingOptions schedulingOptions) {
        this.schedulingOptions = schedulingOptions;
    }

    public CreateOrderRequest status(OrderStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public OrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(OrderStatus status) {
        this.status = status;
    }

    public CreateOrderRequest subscriptions(List<CreateOrderSubscription> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public CreateOrderRequest addSubscriptionsItem(CreateOrderSubscription subscriptionsItem) {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<CreateOrderSubscription>();
        }
        this.subscriptions.add(subscriptionsItem);
        return this;
    }

    @Nullable
    public List<CreateOrderSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(List<CreateOrderSubscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public CreateOrderRequest commitments(List<UpsertCommitmentInput> commitments) {
        this.commitments = commitments;
        return this;
    }

    public CreateOrderRequest addCommitmentsItem(UpsertCommitmentInput commitmentsItem) {
        if (this.commitments == null) {
            this.commitments = new ArrayList<UpsertCommitmentInput>();
        }
        this.commitments.add(commitmentsItem);
        return this;
    }

    @Nullable
    public List<UpsertCommitmentInput> getCommitments() {
        return this.commitments;
    }

    public void setCommitments(List<UpsertCommitmentInput> commitments) {
        this.commitments = commitments;
    }

    public CreateOrderRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrderRequest createOrderRequest = (CreateOrderRequest)o;
        return Objects.equals((Object)this.category, (Object)createOrderRequest.category) && Objects.equals(this.customFields, createOrderRequest.customFields) && Objects.equals(this.description, createOrderRequest.description) && Objects.equals(this.existingAccountNumber, createOrderRequest.existingAccountNumber) && Objects.equals(this.newAccount, createOrderRequest.newAccount) && Objects.equals(this.orderDate, createOrderRequest.orderDate) && Objects.equals(this.orderLineItems, createOrderRequest.orderLineItems) && Objects.equals(this.orderNumber, createOrderRequest.orderNumber) && Objects.equals(this.processingOptions, createOrderRequest.processingOptions) && Objects.equals(this.reasonCode, createOrderRequest.reasonCode) && Objects.equals(this.schedulingOptions, createOrderRequest.schedulingOptions) && Objects.equals((Object)this.status, (Object)createOrderRequest.status) && Objects.equals(this.subscriptions, createOrderRequest.subscriptions) && Objects.equals(this.commitments, createOrderRequest.commitments) && Objects.equals(this.additionalProperties, createOrderRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.customFields, this.description, this.existingAccountNumber, this.newAccount, this.orderDate, this.orderLineItems, this.orderNumber, this.processingOptions, this.reasonCode, this.schedulingOptions, this.status, this.subscriptions, this.commitments, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrderRequest {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    existingAccountNumber: ").append(this.toIndentedString(this.existingAccountNumber)).append("\n");
        sb.append("    newAccount: ").append(this.toIndentedString(this.newAccount)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    orderLineItems: ").append(this.toIndentedString(this.orderLineItems)).append("\n");
        sb.append("    orderNumber: ").append(this.toIndentedString(this.orderNumber)).append("\n");
        sb.append("    processingOptions: ").append(this.toIndentedString(this.processingOptions)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    schedulingOptions: ").append(this.toIndentedString(this.schedulingOptions)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subscriptions: ").append(this.toIndentedString(this.subscriptions)).append("\n");
        sb.append("    commitments: ").append(this.toIndentedString(this.commitments)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraycommitments;
        JsonArray jsonArraysubscriptions;
        int i;
        JsonArray jsonArrayorderLineItems;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateOrderRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CATEGORY) != null && !jsonObj.get(SERIALIZED_NAME_CATEGORY).isJsonNull()) {
            OrderCategory.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CATEGORY));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `existingAccountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEW_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_NEW_ACCOUNT).isJsonNull()) {
            OrderCreateAccount.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NEW_ACCOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEMS) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEMS).isJsonNull() && (jsonArrayorderLineItems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ORDER_LINE_ITEMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `orderLineItems` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_LINE_ITEMS).toString()));
            }
            for (i = 0; i < jsonArrayorderLineItems.size(); ++i) {
                CreateOrderOrderLineItem.validateJsonElement(jsonArrayorderLineItems.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORDER_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `orderNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROCESSING_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_PROCESSING_OPTIONS).isJsonNull()) {
            ProcessingOptionsWithDelayedCapturePayment.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PROCESSING_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON_CODE) != null && !jsonObj.get(SERIALIZED_NAME_REASON_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REASON_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reasonCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEDULING_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_SCHEDULING_OPTIONS).isJsonNull()) {
            OrderSchedulingOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SCHEDULING_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull()) {
            OrderStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS).isJsonNull() && (jsonArraysubscriptions = jsonObj.getAsJsonArray(SERIALIZED_NAME_SUBSCRIPTIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `subscriptions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBSCRIPTIONS).toString()));
            }
            for (i = 0; i < jsonArraysubscriptions.size(); ++i) {
                CreateOrderSubscription.validateJsonElement(jsonArraysubscriptions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMITMENTS) != null && !jsonObj.get(SERIALIZED_NAME_COMMITMENTS).isJsonNull() && (jsonArraycommitments = jsonObj.getAsJsonArray(SERIALIZED_NAME_COMMITMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_COMMITMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `commitments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMITMENTS).toString()));
            }
            for (i = 0; i < jsonArraycommitments.size(); ++i) {
                UpsertCommitmentInput.validateJsonElement(jsonArraycommitments.get(i));
            }
        }
    }

    public static CreateOrderRequest fromJson(String jsonString) throws IOException {
        return (CreateOrderRequest)JSON.getGson().fromJson(jsonString, CreateOrderRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CATEGORY);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_FIELDS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_EXISTING_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_NEW_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_ORDER_DATE);
        openapiFields.add(SERIALIZED_NAME_ORDER_LINE_ITEMS);
        openapiFields.add(SERIALIZED_NAME_ORDER_NUMBER);
        openapiFields.add(SERIALIZED_NAME_PROCESSING_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_REASON_CODE);
        openapiFields.add(SERIALIZED_NAME_SCHEDULING_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_SUBSCRIPTIONS);
        openapiFields.add(SERIALIZED_NAME_COMMITMENTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ORDER_DATE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CreateOrderRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateOrderRequest.class));
            return new TypeAdapter<CreateOrderRequest>(){

                public void write(JsonWriter out, CreateOrderRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    out.beginObject();
                    for (Map.Entry e : obj.entrySet()) {
                        out.name((String)e.getKey());
                        elementAdapter.write(out, (Object)((JsonElement)e.getValue()));
                    }
                    if (value.getAdditionalProperties() != null) {
                        boolean oldSerializeNulls = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                            } else if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                            } else if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                            } else if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                            } else if (entry.getValue() == null) {
                                obj.add(entry.getKey(), null);
                            } else {
                                JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                                if (jsonElement.isJsonArray()) {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                } else {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                                }
                            }
                            out.name(entry.getKey());
                            elementAdapter.write(out, (Object)obj.get(entry.getKey()));
                        }
                        out.setSerializeNulls(oldSerializeNulls);
                    }
                    out.endObject();
                }

                public CreateOrderRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CreateOrderRequest.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    CreateOrderRequest instance = (CreateOrderRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

