/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.zuora.JSON;
import com.zuora.model.AssociationRule;
import com.zuora.model.CommitmentPeriodInput;
import com.zuora.model.CommitmentTypeEnum;
import com.zuora.model.Condition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitmentInput {
    public static final String SERIALIZED_NAME_COMMITMENT_NUMBER = "commitmentNumber";
    @SerializedName(value="commitmentNumber")
    private String commitmentNumber;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private CommitmentTypeEnum type;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Integer priority;
    public static final String SERIALIZED_NAME_ASSOCIATION_RULES = "associationRules";
    @SerializedName(value="associationRules")
    private List<AssociationRule> associationRules;
    public static final String SERIALIZED_NAME_ELIGIBLE_ACCOUNT_CONDITIONS = "eligibleAccountConditions";
    @SerializedName(value="eligibleAccountConditions")
    private Condition eligibleAccountConditions;
    public static final String SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS = "eligibleChargeConditions";
    @SerializedName(value="eligibleChargeConditions")
    private Condition eligibleChargeConditions;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "customFields";
    @SerializedName(value="customFields")
    private Map<String, Object> customFields;
    public static final String SERIALIZED_NAME_ADJUSTMENT_LIABILITY_ACCOUNTING_CODE = "adjustmentLiabilityAccountingCode";
    @SerializedName(value="adjustmentLiabilityAccountingCode")
    private String adjustmentLiabilityAccountingCode;
    public static final String SERIALIZED_NAME_ADJUSTMENT_REVENUE_ACCOUNTING_CODE = "adjustmentRevenueAccountingCode";
    @SerializedName(value="adjustmentRevenueAccountingCode")
    private String adjustmentRevenueAccountingCode;
    public static final String SERIALIZED_NAME_CONTRACT_ASSET_ACCOUNTING_CODE = "contractAssetAccountingCode";
    @SerializedName(value="contractAssetAccountingCode")
    private String contractAssetAccountingCode;
    public static final String SERIALIZED_NAME_CONTRACT_LIABILITY_ACCOUNTING_CODE = "contractLiabilityAccountingCode";
    @SerializedName(value="contractLiabilityAccountingCode")
    private String contractLiabilityAccountingCode;
    public static final String SERIALIZED_NAME_CONTRACT_RECOGNIZED_REVENUE_ACCOUNTING_CODE = "contractRecognizedRevenueAccountingCode";
    @SerializedName(value="contractRecognizedRevenueAccountingCode")
    private String contractRecognizedRevenueAccountingCode;
    public static final String SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNTING_CODE = "deferredRevenueAccountingCode";
    @SerializedName(value="deferredRevenueAccountingCode")
    private String deferredRevenueAccountingCode;
    public static final String SERIALIZED_NAME_EXCLUDE_ITEM_BILLING_FROM_REVENUE_ACCOUNTING = "excludeItemBillingFromRevenueAccounting";
    @SerializedName(value="excludeItemBillingFromRevenueAccounting")
    private Boolean excludeItemBillingFromRevenueAccounting;
    public static final String SERIALIZED_NAME_EXCLUDE_ITEM_BOOKING_FROM_REVENUE_ACCOUNTING = "excludeItemBookingFromRevenueAccounting";
    @SerializedName(value="excludeItemBookingFromRevenueAccounting")
    private Boolean excludeItemBookingFromRevenueAccounting;
    public static final String SERIALIZED_NAME_IS_ALLOCATION_ELIGIBLE = "isAllocationEligible";
    @SerializedName(value="isAllocationEligible")
    private Boolean isAllocationEligible;
    public static final String SERIALIZED_NAME_IS_UNBILLED = "isUnbilled";
    @SerializedName(value="isUnbilled")
    private Boolean isUnbilled;
    public static final String SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNTING_CODE = "recognizedRevenueAccountingCode";
    @SerializedName(value="recognizedRevenueAccountingCode")
    private String recognizedRevenueAccountingCode;
    public static final String SERIALIZED_NAME_REVENUE_RECOGNITION_RULE = "revenueRecognitionRule";
    @SerializedName(value="revenueRecognitionRule")
    private String revenueRecognitionRule;
    public static final String SERIALIZED_NAME_ACCOUNT_RECEIVABLE_ACCOUNTING_CODE = "accountReceivableAccountingCode";
    @SerializedName(value="accountReceivableAccountingCode")
    private String accountReceivableAccountingCode;
    public static final String SERIALIZED_NAME_UNBILLED_RECEIVABLES_ACCOUNTING_CODE = "unbilledReceivablesAccountingCode";
    @SerializedName(value="unbilledReceivablesAccountingCode")
    private String unbilledReceivablesAccountingCode;
    public static final String SERIALIZED_NAME_REVENUE_RECOGNITION_TIMING = "revenueRecognitionTiming";
    @SerializedName(value="revenueRecognitionTiming")
    private String revenueRecognitionTiming;
    public static final String SERIALIZED_NAME_REVENUE_AMORTIZATION_METHOD = "revenueAmortizationMethod";
    @SerializedName(value="revenueAmortizationMethod")
    private String revenueAmortizationMethod;
    public static final String SERIALIZED_NAME_TAXABLE = "taxable";
    @SerializedName(value="taxable")
    private Boolean taxable;
    public static final String SERIALIZED_NAME_TAX_CODE = "taxCode";
    @SerializedName(value="taxCode")
    private String taxCode;
    public static final String SERIALIZED_NAME_TAX_MODE = "taxMode";
    @SerializedName(value="taxMode")
    private TaxModeEnum taxMode;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_PERIODS = "periods";
    @SerializedName(value="periods")
    private List<CommitmentPeriodInput> periods;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CommitmentInput() {
    }

    public CommitmentInput(Boolean excludeItemBookingFromRevenueAccounting) {
        this();
        this.excludeItemBookingFromRevenueAccounting = excludeItemBookingFromRevenueAccounting;
    }

    public CommitmentInput commitmentNumber(String commitmentNumber) {
        this.commitmentNumber = commitmentNumber;
        return this;
    }

    @Nullable
    public String getCommitmentNumber() {
        return this.commitmentNumber;
    }

    public void setCommitmentNumber(String commitmentNumber) {
        this.commitmentNumber = commitmentNumber;
    }

    public CommitmentInput name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CommitmentInput type(CommitmentTypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public CommitmentTypeEnum getType() {
        return this.type;
    }

    public void setType(CommitmentTypeEnum type) {
        this.type = type;
    }

    public CommitmentInput description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CommitmentInput priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public CommitmentInput associationRules(List<AssociationRule> associationRules) {
        this.associationRules = associationRules;
        return this;
    }

    public CommitmentInput addAssociationRulesItem(AssociationRule associationRulesItem) {
        if (this.associationRules == null) {
            this.associationRules = new ArrayList<AssociationRule>();
        }
        this.associationRules.add(associationRulesItem);
        return this;
    }

    @Nullable
    public List<AssociationRule> getAssociationRules() {
        return this.associationRules;
    }

    public void setAssociationRules(List<AssociationRule> associationRules) {
        this.associationRules = associationRules;
    }

    public CommitmentInput eligibleAccountConditions(Condition eligibleAccountConditions) {
        this.eligibleAccountConditions = eligibleAccountConditions;
        return this;
    }

    @Nullable
    public Condition getEligibleAccountConditions() {
        return this.eligibleAccountConditions;
    }

    public void setEligibleAccountConditions(Condition eligibleAccountConditions) {
        this.eligibleAccountConditions = eligibleAccountConditions;
    }

    public CommitmentInput eligibleChargeConditions(Condition eligibleChargeConditions) {
        this.eligibleChargeConditions = eligibleChargeConditions;
        return this;
    }

    @Nullable
    public Condition getEligibleChargeConditions() {
        return this.eligibleChargeConditions;
    }

    public void setEligibleChargeConditions(Condition eligibleChargeConditions) {
        this.eligibleChargeConditions = eligibleChargeConditions;
    }

    public CommitmentInput customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public CommitmentInput putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public CommitmentInput adjustmentLiabilityAccountingCode(String adjustmentLiabilityAccountingCode) {
        this.adjustmentLiabilityAccountingCode = adjustmentLiabilityAccountingCode;
        return this;
    }

    @Nullable
    public String getAdjustmentLiabilityAccountingCode() {
        return this.adjustmentLiabilityAccountingCode;
    }

    public void setAdjustmentLiabilityAccountingCode(String adjustmentLiabilityAccountingCode) {
        this.adjustmentLiabilityAccountingCode = adjustmentLiabilityAccountingCode;
    }

    public CommitmentInput adjustmentRevenueAccountingCode(String adjustmentRevenueAccountingCode) {
        this.adjustmentRevenueAccountingCode = adjustmentRevenueAccountingCode;
        return this;
    }

    @Nullable
    public String getAdjustmentRevenueAccountingCode() {
        return this.adjustmentRevenueAccountingCode;
    }

    public void setAdjustmentRevenueAccountingCode(String adjustmentRevenueAccountingCode) {
        this.adjustmentRevenueAccountingCode = adjustmentRevenueAccountingCode;
    }

    public CommitmentInput contractAssetAccountingCode(String contractAssetAccountingCode) {
        this.contractAssetAccountingCode = contractAssetAccountingCode;
        return this;
    }

    @Nullable
    public String getContractAssetAccountingCode() {
        return this.contractAssetAccountingCode;
    }

    public void setContractAssetAccountingCode(String contractAssetAccountingCode) {
        this.contractAssetAccountingCode = contractAssetAccountingCode;
    }

    public CommitmentInput contractLiabilityAccountingCode(String contractLiabilityAccountingCode) {
        this.contractLiabilityAccountingCode = contractLiabilityAccountingCode;
        return this;
    }

    @Nullable
    public String getContractLiabilityAccountingCode() {
        return this.contractLiabilityAccountingCode;
    }

    public void setContractLiabilityAccountingCode(String contractLiabilityAccountingCode) {
        this.contractLiabilityAccountingCode = contractLiabilityAccountingCode;
    }

    public CommitmentInput contractRecognizedRevenueAccountingCode(String contractRecognizedRevenueAccountingCode) {
        this.contractRecognizedRevenueAccountingCode = contractRecognizedRevenueAccountingCode;
        return this;
    }

    @Nullable
    public String getContractRecognizedRevenueAccountingCode() {
        return this.contractRecognizedRevenueAccountingCode;
    }

    public void setContractRecognizedRevenueAccountingCode(String contractRecognizedRevenueAccountingCode) {
        this.contractRecognizedRevenueAccountingCode = contractRecognizedRevenueAccountingCode;
    }

    public CommitmentInput deferredRevenueAccountingCode(String deferredRevenueAccountingCode) {
        this.deferredRevenueAccountingCode = deferredRevenueAccountingCode;
        return this;
    }

    @Nullable
    public String getDeferredRevenueAccountingCode() {
        return this.deferredRevenueAccountingCode;
    }

    public void setDeferredRevenueAccountingCode(String deferredRevenueAccountingCode) {
        this.deferredRevenueAccountingCode = deferredRevenueAccountingCode;
    }

    public CommitmentInput excludeItemBillingFromRevenueAccounting(Boolean excludeItemBillingFromRevenueAccounting) {
        this.excludeItemBillingFromRevenueAccounting = excludeItemBillingFromRevenueAccounting;
        return this;
    }

    @Nullable
    public Boolean getExcludeItemBillingFromRevenueAccounting() {
        return this.excludeItemBillingFromRevenueAccounting;
    }

    public void setExcludeItemBillingFromRevenueAccounting(Boolean excludeItemBillingFromRevenueAccounting) {
        this.excludeItemBillingFromRevenueAccounting = excludeItemBillingFromRevenueAccounting;
    }

    @Nullable
    public Boolean getExcludeItemBookingFromRevenueAccounting() {
        return this.excludeItemBookingFromRevenueAccounting;
    }

    public CommitmentInput isAllocationEligible(Boolean isAllocationEligible) {
        this.isAllocationEligible = isAllocationEligible;
        return this;
    }

    @Nullable
    public Boolean getIsAllocationEligible() {
        return this.isAllocationEligible;
    }

    public void setIsAllocationEligible(Boolean isAllocationEligible) {
        this.isAllocationEligible = isAllocationEligible;
    }

    public CommitmentInput isUnbilled(Boolean isUnbilled) {
        this.isUnbilled = isUnbilled;
        return this;
    }

    @Nullable
    public Boolean getIsUnbilled() {
        return this.isUnbilled;
    }

    public void setIsUnbilled(Boolean isUnbilled) {
        this.isUnbilled = isUnbilled;
    }

    public CommitmentInput recognizedRevenueAccountingCode(String recognizedRevenueAccountingCode) {
        this.recognizedRevenueAccountingCode = recognizedRevenueAccountingCode;
        return this;
    }

    @Nullable
    public String getRecognizedRevenueAccountingCode() {
        return this.recognizedRevenueAccountingCode;
    }

    public void setRecognizedRevenueAccountingCode(String recognizedRevenueAccountingCode) {
        this.recognizedRevenueAccountingCode = recognizedRevenueAccountingCode;
    }

    public CommitmentInput revenueRecognitionRule(String revenueRecognitionRule) {
        this.revenueRecognitionRule = revenueRecognitionRule;
        return this;
    }

    @Nullable
    public String getRevenueRecognitionRule() {
        return this.revenueRecognitionRule;
    }

    public void setRevenueRecognitionRule(String revenueRecognitionRule) {
        this.revenueRecognitionRule = revenueRecognitionRule;
    }

    public CommitmentInput accountReceivableAccountingCode(String accountReceivableAccountingCode) {
        this.accountReceivableAccountingCode = accountReceivableAccountingCode;
        return this;
    }

    @Nullable
    public String getAccountReceivableAccountingCode() {
        return this.accountReceivableAccountingCode;
    }

    public void setAccountReceivableAccountingCode(String accountReceivableAccountingCode) {
        this.accountReceivableAccountingCode = accountReceivableAccountingCode;
    }

    public CommitmentInput unbilledReceivablesAccountingCode(String unbilledReceivablesAccountingCode) {
        this.unbilledReceivablesAccountingCode = unbilledReceivablesAccountingCode;
        return this;
    }

    @Nullable
    public String getUnbilledReceivablesAccountingCode() {
        return this.unbilledReceivablesAccountingCode;
    }

    public void setUnbilledReceivablesAccountingCode(String unbilledReceivablesAccountingCode) {
        this.unbilledReceivablesAccountingCode = unbilledReceivablesAccountingCode;
    }

    public CommitmentInput revenueRecognitionTiming(String revenueRecognitionTiming) {
        this.revenueRecognitionTiming = revenueRecognitionTiming;
        return this;
    }

    @Nullable
    public String getRevenueRecognitionTiming() {
        return this.revenueRecognitionTiming;
    }

    public void setRevenueRecognitionTiming(String revenueRecognitionTiming) {
        this.revenueRecognitionTiming = revenueRecognitionTiming;
    }

    public CommitmentInput revenueAmortizationMethod(String revenueAmortizationMethod) {
        this.revenueAmortizationMethod = revenueAmortizationMethod;
        return this;
    }

    @Nullable
    public String getRevenueAmortizationMethod() {
        return this.revenueAmortizationMethod;
    }

    public void setRevenueAmortizationMethod(String revenueAmortizationMethod) {
        this.revenueAmortizationMethod = revenueAmortizationMethod;
    }

    public CommitmentInput taxable(Boolean taxable) {
        this.taxable = taxable;
        return this;
    }

    @Nullable
    public Boolean getTaxable() {
        return this.taxable;
    }

    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }

    public CommitmentInput taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public CommitmentInput taxMode(TaxModeEnum taxMode) {
        this.taxMode = taxMode;
        return this;
    }

    @Nullable
    public TaxModeEnum getTaxMode() {
        return this.taxMode;
    }

    public void setTaxMode(TaxModeEnum taxMode) {
        this.taxMode = taxMode;
    }

    public CommitmentInput currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public CommitmentInput periods(List<CommitmentPeriodInput> periods) {
        this.periods = periods;
        return this;
    }

    public CommitmentInput addPeriodsItem(CommitmentPeriodInput periodsItem) {
        if (this.periods == null) {
            this.periods = new ArrayList<CommitmentPeriodInput>();
        }
        this.periods.add(periodsItem);
        return this;
    }

    @Nonnull
    public List<CommitmentPeriodInput> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<CommitmentPeriodInput> periods) {
        this.periods = periods;
    }

    public CommitmentInput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitmentInput commitmentInput = (CommitmentInput)o;
        return Objects.equals(this.commitmentNumber, commitmentInput.commitmentNumber) && Objects.equals(this.name, commitmentInput.name) && Objects.equals((Object)this.type, (Object)commitmentInput.type) && Objects.equals(this.description, commitmentInput.description) && Objects.equals(this.priority, commitmentInput.priority) && Objects.equals(this.associationRules, commitmentInput.associationRules) && Objects.equals(this.eligibleAccountConditions, commitmentInput.eligibleAccountConditions) && Objects.equals(this.eligibleChargeConditions, commitmentInput.eligibleChargeConditions) && Objects.equals(this.customFields, commitmentInput.customFields) && Objects.equals(this.adjustmentLiabilityAccountingCode, commitmentInput.adjustmentLiabilityAccountingCode) && Objects.equals(this.adjustmentRevenueAccountingCode, commitmentInput.adjustmentRevenueAccountingCode) && Objects.equals(this.contractAssetAccountingCode, commitmentInput.contractAssetAccountingCode) && Objects.equals(this.contractLiabilityAccountingCode, commitmentInput.contractLiabilityAccountingCode) && Objects.equals(this.contractRecognizedRevenueAccountingCode, commitmentInput.contractRecognizedRevenueAccountingCode) && Objects.equals(this.deferredRevenueAccountingCode, commitmentInput.deferredRevenueAccountingCode) && Objects.equals(this.excludeItemBillingFromRevenueAccounting, commitmentInput.excludeItemBillingFromRevenueAccounting) && Objects.equals(this.excludeItemBookingFromRevenueAccounting, commitmentInput.excludeItemBookingFromRevenueAccounting) && Objects.equals(this.isAllocationEligible, commitmentInput.isAllocationEligible) && Objects.equals(this.isUnbilled, commitmentInput.isUnbilled) && Objects.equals(this.recognizedRevenueAccountingCode, commitmentInput.recognizedRevenueAccountingCode) && Objects.equals(this.revenueRecognitionRule, commitmentInput.revenueRecognitionRule) && Objects.equals(this.accountReceivableAccountingCode, commitmentInput.accountReceivableAccountingCode) && Objects.equals(this.unbilledReceivablesAccountingCode, commitmentInput.unbilledReceivablesAccountingCode) && Objects.equals(this.revenueRecognitionTiming, commitmentInput.revenueRecognitionTiming) && Objects.equals(this.revenueAmortizationMethod, commitmentInput.revenueAmortizationMethod) && Objects.equals(this.taxable, commitmentInput.taxable) && Objects.equals(this.taxCode, commitmentInput.taxCode) && Objects.equals((Object)this.taxMode, (Object)commitmentInput.taxMode) && Objects.equals(this.currency, commitmentInput.currency) && Objects.equals(this.periods, commitmentInput.periods) && Objects.equals(this.additionalProperties, commitmentInput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commitmentNumber, this.name, this.type, this.description, this.priority, this.associationRules, this.eligibleAccountConditions, this.eligibleChargeConditions, this.customFields, this.adjustmentLiabilityAccountingCode, this.adjustmentRevenueAccountingCode, this.contractAssetAccountingCode, this.contractLiabilityAccountingCode, this.contractRecognizedRevenueAccountingCode, this.deferredRevenueAccountingCode, this.excludeItemBillingFromRevenueAccounting, this.excludeItemBookingFromRevenueAccounting, this.isAllocationEligible, this.isUnbilled, this.recognizedRevenueAccountingCode, this.revenueRecognitionRule, this.accountReceivableAccountingCode, this.unbilledReceivablesAccountingCode, this.revenueRecognitionTiming, this.revenueAmortizationMethod, this.taxable, this.taxCode, this.taxMode, this.currency, this.periods, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommitmentInput {\n");
        sb.append("    commitmentNumber: ").append(this.toIndentedString(this.commitmentNumber)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    associationRules: ").append(this.toIndentedString(this.associationRules)).append("\n");
        sb.append("    eligibleAccountConditions: ").append(this.toIndentedString(this.eligibleAccountConditions)).append("\n");
        sb.append("    eligibleChargeConditions: ").append(this.toIndentedString(this.eligibleChargeConditions)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    adjustmentLiabilityAccountingCode: ").append(this.toIndentedString(this.adjustmentLiabilityAccountingCode)).append("\n");
        sb.append("    adjustmentRevenueAccountingCode: ").append(this.toIndentedString(this.adjustmentRevenueAccountingCode)).append("\n");
        sb.append("    contractAssetAccountingCode: ").append(this.toIndentedString(this.contractAssetAccountingCode)).append("\n");
        sb.append("    contractLiabilityAccountingCode: ").append(this.toIndentedString(this.contractLiabilityAccountingCode)).append("\n");
        sb.append("    contractRecognizedRevenueAccountingCode: ").append(this.toIndentedString(this.contractRecognizedRevenueAccountingCode)).append("\n");
        sb.append("    deferredRevenueAccountingCode: ").append(this.toIndentedString(this.deferredRevenueAccountingCode)).append("\n");
        sb.append("    excludeItemBillingFromRevenueAccounting: ").append(this.toIndentedString(this.excludeItemBillingFromRevenueAccounting)).append("\n");
        sb.append("    excludeItemBookingFromRevenueAccounting: ").append(this.toIndentedString(this.excludeItemBookingFromRevenueAccounting)).append("\n");
        sb.append("    isAllocationEligible: ").append(this.toIndentedString(this.isAllocationEligible)).append("\n");
        sb.append("    isUnbilled: ").append(this.toIndentedString(this.isUnbilled)).append("\n");
        sb.append("    recognizedRevenueAccountingCode: ").append(this.toIndentedString(this.recognizedRevenueAccountingCode)).append("\n");
        sb.append("    revenueRecognitionRule: ").append(this.toIndentedString(this.revenueRecognitionRule)).append("\n");
        sb.append("    accountReceivableAccountingCode: ").append(this.toIndentedString(this.accountReceivableAccountingCode)).append("\n");
        sb.append("    unbilledReceivablesAccountingCode: ").append(this.toIndentedString(this.unbilledReceivablesAccountingCode)).append("\n");
        sb.append("    revenueRecognitionTiming: ").append(this.toIndentedString(this.revenueRecognitionTiming)).append("\n");
        sb.append("    revenueAmortizationMethod: ").append(this.toIndentedString(this.revenueAmortizationMethod)).append("\n");
        sb.append("    taxable: ").append(this.toIndentedString(this.taxable)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    taxMode: ").append(this.toIndentedString((Object)this.taxMode)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    periods: ").append(this.toIndentedString(this.periods)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        int i;
        JsonArray jsonArrayassociationRules;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CommitmentInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_COMMITMENT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_COMMITMENT_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMITMENT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `commitmentNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMITMENT_NUMBER).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        CommitmentTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSOCIATION_RULES) != null && !jsonObj.get(SERIALIZED_NAME_ASSOCIATION_RULES).isJsonNull() && (jsonArrayassociationRules = jsonObj.getAsJsonArray(SERIALIZED_NAME_ASSOCIATION_RULES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ASSOCIATION_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `associationRules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSOCIATION_RULES).toString()));
            }
            for (i = 0; i < jsonArrayassociationRules.size(); ++i) {
                AssociationRule.validateJsonElement(jsonArrayassociationRules.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ELIGIBLE_ACCOUNT_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_ELIGIBLE_ACCOUNT_CONDITIONS).isJsonNull()) {
            Condition.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ELIGIBLE_ACCOUNT_CONDITIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS).isJsonNull()) {
            Condition.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADJUSTMENT_LIABILITY_ACCOUNTING_CODE) != null && !jsonObj.get(SERIALIZED_NAME_ADJUSTMENT_LIABILITY_ACCOUNTING_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ADJUSTMENT_LIABILITY_ACCOUNTING_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `adjustmentLiabilityAccountingCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADJUSTMENT_LIABILITY_ACCOUNTING_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADJUSTMENT_REVENUE_ACCOUNTING_CODE) != null && !jsonObj.get(SERIALIZED_NAME_ADJUSTMENT_REVENUE_ACCOUNTING_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ADJUSTMENT_REVENUE_ACCOUNTING_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `adjustmentRevenueAccountingCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADJUSTMENT_REVENUE_ACCOUNTING_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTRACT_ASSET_ACCOUNTING_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CONTRACT_ASSET_ACCOUNTING_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTRACT_ASSET_ACCOUNTING_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `contractAssetAccountingCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTRACT_ASSET_ACCOUNTING_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTRACT_LIABILITY_ACCOUNTING_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CONTRACT_LIABILITY_ACCOUNTING_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTRACT_LIABILITY_ACCOUNTING_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `contractLiabilityAccountingCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTRACT_LIABILITY_ACCOUNTING_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTRACT_RECOGNIZED_REVENUE_ACCOUNTING_CODE) != null && !jsonObj.get(SERIALIZED_NAME_CONTRACT_RECOGNIZED_REVENUE_ACCOUNTING_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTRACT_RECOGNIZED_REVENUE_ACCOUNTING_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `contractRecognizedRevenueAccountingCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTRACT_RECOGNIZED_REVENUE_ACCOUNTING_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNTING_CODE) != null && !jsonObj.get(SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNTING_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNTING_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deferredRevenueAccountingCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNTING_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNTING_CODE) != null && !jsonObj.get(SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNTING_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNTING_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recognizedRevenueAccountingCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNTING_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REVENUE_RECOGNITION_RULE) != null && !jsonObj.get(SERIALIZED_NAME_REVENUE_RECOGNITION_RULE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REVENUE_RECOGNITION_RULE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `revenueRecognitionRule` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REVENUE_RECOGNITION_RULE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_RECEIVABLE_ACCOUNTING_CODE) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_RECEIVABLE_ACCOUNTING_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_RECEIVABLE_ACCOUNTING_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountReceivableAccountingCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_RECEIVABLE_ACCOUNTING_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNBILLED_RECEIVABLES_ACCOUNTING_CODE) != null && !jsonObj.get(SERIALIZED_NAME_UNBILLED_RECEIVABLES_ACCOUNTING_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNBILLED_RECEIVABLES_ACCOUNTING_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unbilledReceivablesAccountingCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNBILLED_RECEIVABLES_ACCOUNTING_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REVENUE_RECOGNITION_TIMING) != null && !jsonObj.get(SERIALIZED_NAME_REVENUE_RECOGNITION_TIMING).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REVENUE_RECOGNITION_TIMING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `revenueRecognitionTiming` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REVENUE_RECOGNITION_TIMING).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REVENUE_AMORTIZATION_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_REVENUE_AMORTIZATION_METHOD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REVENUE_AMORTIZATION_METHOD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `revenueAmortizationMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REVENUE_AMORTIZATION_METHOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_CODE) != null && !jsonObj.get(SERIALIZED_NAME_TAX_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAX_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `taxCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_MODE) != null && !jsonObj.get(SERIALIZED_NAME_TAX_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAX_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `taxMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_MODE) != null && !jsonObj.get(SERIALIZED_NAME_TAX_MODE).isJsonNull()) {
            TaxModeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TAX_MODE));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PERIODS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `periods` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERIODS).toString()));
        }
        JsonArray jsonArrayperiods = jsonObj.getAsJsonArray(SERIALIZED_NAME_PERIODS);
        for (i = 0; i < jsonArrayperiods.size(); ++i) {
            CommitmentPeriodInput.validateJsonElement(jsonArrayperiods.get(i));
        }
    }

    public static CommitmentInput fromJson(String jsonString) throws IOException {
        return (CommitmentInput)JSON.getGson().fromJson(jsonString, CommitmentInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COMMITMENT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_PRIORITY);
        openapiFields.add(SERIALIZED_NAME_ASSOCIATION_RULES);
        openapiFields.add(SERIALIZED_NAME_ELIGIBLE_ACCOUNT_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_FIELDS);
        openapiFields.add(SERIALIZED_NAME_ADJUSTMENT_LIABILITY_ACCOUNTING_CODE);
        openapiFields.add(SERIALIZED_NAME_ADJUSTMENT_REVENUE_ACCOUNTING_CODE);
        openapiFields.add(SERIALIZED_NAME_CONTRACT_ASSET_ACCOUNTING_CODE);
        openapiFields.add(SERIALIZED_NAME_CONTRACT_LIABILITY_ACCOUNTING_CODE);
        openapiFields.add(SERIALIZED_NAME_CONTRACT_RECOGNIZED_REVENUE_ACCOUNTING_CODE);
        openapiFields.add(SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNTING_CODE);
        openapiFields.add(SERIALIZED_NAME_EXCLUDE_ITEM_BILLING_FROM_REVENUE_ACCOUNTING);
        openapiFields.add(SERIALIZED_NAME_EXCLUDE_ITEM_BOOKING_FROM_REVENUE_ACCOUNTING);
        openapiFields.add(SERIALIZED_NAME_IS_ALLOCATION_ELIGIBLE);
        openapiFields.add(SERIALIZED_NAME_IS_UNBILLED);
        openapiFields.add(SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNTING_CODE);
        openapiFields.add(SERIALIZED_NAME_REVENUE_RECOGNITION_RULE);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_RECEIVABLE_ACCOUNTING_CODE);
        openapiFields.add(SERIALIZED_NAME_UNBILLED_RECEIVABLES_ACCOUNTING_CODE);
        openapiFields.add(SERIALIZED_NAME_REVENUE_RECOGNITION_TIMING);
        openapiFields.add(SERIALIZED_NAME_REVENUE_AMORTIZATION_METHOD);
        openapiFields.add(SERIALIZED_NAME_TAXABLE);
        openapiFields.add(SERIALIZED_NAME_TAX_CODE);
        openapiFields.add(SERIALIZED_NAME_TAX_MODE);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_PERIODS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields.add(SERIALIZED_NAME_PERIODS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CommitmentInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CommitmentInput.class));
            return new TypeAdapter<CommitmentInput>(){

                public void write(JsonWriter out, CommitmentInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    out.beginObject();
                    for (Map.Entry e : obj.entrySet()) {
                        out.name((String)e.getKey());
                        elementAdapter.write(out, (Object)((JsonElement)e.getValue()));
                    }
                    if (value.getAdditionalProperties() != null) {
                        boolean oldSerializeNulls = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                            } else if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                            } else if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                            } else if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                            } else if (entry.getValue() == null) {
                                obj.add(entry.getKey(), null);
                            } else {
                                JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                                if (jsonElement.isJsonArray()) {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                } else {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                                }
                            }
                            out.name(entry.getKey());
                            elementAdapter.write(out, (Object)obj.get(entry.getKey()));
                        }
                        out.setSerializeNulls(oldSerializeNulls);
                    }
                    out.endObject();
                }

                public CommitmentInput read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CommitmentInput.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    CommitmentInput instance = (CommitmentInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TaxModeEnum {
        TAXINCLUSIVE("TaxInclusive"),
        TAXEXCLUSIVE("TaxExclusive");

        private String value;

        private TaxModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TaxModeEnum fromValue(String value) {
            for (TaxModeEnum b : TaxModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            TaxModeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<TaxModeEnum> {
            public void write(JsonWriter jsonWriter, TaxModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TaxModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TaxModeEnum.fromValue(value);
            }
        }
    }
}

