/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.ObjectPostImportRequestImportType;
import com.zuora.model.ProxyGetImport;
import com.zuora.model.ProxyPostImport;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ImportsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ImportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImportsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call objectGetImportCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/object/import/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call objectGetImportValidateBeforeCall(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling objectGetImport(Async)");
        }
        return this.objectGetImportCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, fields, zuoraVersion, _callback);
    }

    public ProxyGetImport objectGetImport(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion) throws ApiException {
        ApiResponse<ProxyGetImport> localVarResp = this.objectGetImportWithHttpInfo(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, fields, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyGetImport> objectGetImportWithHttpInfo(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion) throws ApiException {
        Call localVarCall = this.objectGetImportValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, fields, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<ProxyGetImport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call objectGetImportAsync(String id, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String fields, String zuoraVersion, ApiCallback<ProxyGetImport> _callback) throws ApiException {
        Call localVarCall = this.objectGetImportValidateBeforeCall(id, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, fields, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<ProxyGetImport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ObjectGetImportApi objectGetImportApi(String id) {
        return new ObjectGetImportApi(id);
    }

    private Call objectPostImportCall(File _file, ObjectPostImportRequestImportType importType, String name, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/object/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("File", _file);
        }
        if (importType != null) {
            localVarFormParams.put("ImportType", (Object)importType);
        }
        if (name != null) {
            localVarFormParams.put("Name", name);
        }
        if (rejectUnknownFields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rejectUnknownFields", rejectUnknownFields));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call objectPostImportValidateBeforeCall(File _file, ObjectPostImportRequestImportType importType, String name, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (_file == null) {
            throw new ApiException("Missing the required parameter '_file' when calling objectPostImport(Async)");
        }
        if (importType == null) {
            throw new ApiException("Missing the required parameter 'importType' when calling objectPostImport(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling objectPostImport(Async)");
        }
        return this.objectPostImportCall(_file, importType, name, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
    }

    public ProxyPostImport objectPostImport(File _file, ObjectPostImportRequestImportType importType, String name, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        ApiResponse<ProxyPostImport> localVarResp = this.objectPostImportWithHttpInfo(_file, importType, name, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<ProxyPostImport> objectPostImportWithHttpInfo(File _file, ObjectPostImportRequestImportType importType, String name, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        Call localVarCall = this.objectPostImportValidateBeforeCall(_file, importType, name, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<ProxyPostImport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call objectPostImportAsync(File _file, ObjectPostImportRequestImportType importType, String name, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, Boolean rejectUnknownFields, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback<ProxyPostImport> _callback) throws ApiException {
        Call localVarCall = this.objectPostImportValidateBeforeCall(_file, importType, name, idempotencyKey, acceptEncoding, contentEncoding, authorization, rejectUnknownFields, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<ProxyPostImport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ObjectPostImportApi objectPostImportApi(File _file, ObjectPostImportRequestImportType importType, String name) {
        return new ObjectPostImportApi(_file, importType, name);
    }

    public class ObjectPostImportApi {
        private final File _file;
        private final ObjectPostImportRequestImportType importType;
        private final String name;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private Boolean rejectUnknownFields;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;

        private ObjectPostImportApi(File _file, ObjectPostImportRequestImportType importType, String name) {
            this._file = _file;
            this.importType = importType;
            this.name = name;
        }

        public ObjectPostImportApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public ObjectPostImportApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ObjectPostImportApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ObjectPostImportApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ObjectPostImportApi rejectUnknownFields(Boolean rejectUnknownFields) {
            this.rejectUnknownFields = rejectUnknownFields;
            return this;
        }

        public ObjectPostImportApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ObjectPostImportApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ObjectPostImportApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImportsApi.this.objectPostImportCall(this._file, this.importType, this.name, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }

        public ProxyPostImport execute() throws ApiException {
            ApiResponse localVarResp = ImportsApi.this.objectPostImportWithHttpInfo(this._file, this.importType, this.name, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
            return (ProxyPostImport)localVarResp.getData();
        }

        private ApiResponse<ProxyPostImport> executeWithHttpInfo() throws ApiException {
            return ImportsApi.this.objectPostImportWithHttpInfo(this._file, this.importType, this.name, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<ProxyPostImport> _callback) throws ApiException {
            return ImportsApi.this.objectPostImportAsync(this._file, this.importType, this.name, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.rejectUnknownFields, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }
    }

    public class ObjectGetImportApi {
        private final String id;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String fields;
        private String zuoraVersion;

        private ObjectGetImportApi(String id) {
            this.id = id;
        }

        public ObjectGetImportApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ObjectGetImportApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ObjectGetImportApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ObjectGetImportApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ObjectGetImportApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ObjectGetImportApi fields(String fields) {
            this.fields = fields;
            return this;
        }

        public ObjectGetImportApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ImportsApi.this.objectGetImportCall(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.fields, this.zuoraVersion, _callback);
        }

        public ProxyGetImport execute() throws ApiException {
            ApiResponse localVarResp = ImportsApi.this.objectGetImportWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.fields, this.zuoraVersion);
            return (ProxyGetImport)localVarResp.getData();
        }

        private ApiResponse<ProxyGetImport> executeWithHttpInfo() throws ApiException {
            return ImportsApi.this.objectGetImportWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.fields, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<ProxyGetImport> _callback) throws ApiException {
            return ImportsApi.this.objectGetImportAsync(this.id, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.fields, this.zuoraVersion, _callback);
        }
    }
}

