/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.DeleteDataQueryJobResponse;
import com.zuora.model.GetDataQueryJobResponse;
import com.zuora.model.GetDataQueryJobsResponse;
import com.zuora.model.SubmitDataQueryRequest;
import com.zuora.model.SubmitDataQueryResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class DataQueriesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DataQueriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataQueriesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call deleteDataQueryJobCall(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/query/jobs/{job-id}".replace("{job-id}", this.localVarApiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDataQueryJobValidateBeforeCall(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling deleteDataQueryJob(Async)");
        }
        return this.deleteDataQueryJobCall(jobId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
    }

    public DeleteDataQueryJobResponse deleteDataQueryJob(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        ApiResponse<DeleteDataQueryJobResponse> localVarResp = this.deleteDataQueryJobWithHttpInfo(jobId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<DeleteDataQueryJobResponse> deleteDataQueryJobWithHttpInfo(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        Call localVarCall = this.deleteDataQueryJobValidateBeforeCall(jobId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<DeleteDataQueryJobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteDataQueryJobAsync(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback<DeleteDataQueryJobResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteDataQueryJobValidateBeforeCall(jobId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<DeleteDataQueryJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteDataQueryJobApi deleteDataQueryJobApi(UUID jobId) {
        return new DeleteDataQueryJobApi(jobId);
    }

    private Call getDataQueryJobCall(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/query/jobs/{job-id}".replace("{job-id}", this.localVarApiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDataQueryJobValidateBeforeCall(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getDataQueryJob(Async)");
        }
        return this.getDataQueryJobCall(jobId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
    }

    public GetDataQueryJobResponse getDataQueryJob(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        ApiResponse<GetDataQueryJobResponse> localVarResp = this.getDataQueryJobWithHttpInfo(jobId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetDataQueryJobResponse> getDataQueryJobWithHttpInfo(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getDataQueryJobValidateBeforeCall(jobId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetDataQueryJobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getDataQueryJobAsync(UUID jobId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback<GetDataQueryJobResponse> _callback) throws ApiException {
        Call localVarCall = this.getDataQueryJobValidateBeforeCall(jobId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetDataQueryJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDataQueryJobApi getDataQueryJobApi(UUID jobId) {
        return new GetDataQueryJobApi(jobId);
    }

    private Call getDataQueryJobsCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String queryStatus, Integer pageSize, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/query/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (queryStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("queryStatus", queryStatus));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDataQueryJobsValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String queryStatus, Integer pageSize, String zuoraVersion, ApiCallback _callback) throws ApiException {
        return this.getDataQueryJobsCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, queryStatus, pageSize, zuoraVersion, _callback);
    }

    public GetDataQueryJobsResponse getDataQueryJobs(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String queryStatus, Integer pageSize, String zuoraVersion) throws ApiException {
        ApiResponse<GetDataQueryJobsResponse> localVarResp = this.getDataQueryJobsWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, queryStatus, pageSize, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetDataQueryJobsResponse> getDataQueryJobsWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String queryStatus, Integer pageSize, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getDataQueryJobsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, queryStatus, pageSize, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetDataQueryJobsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getDataQueryJobsAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String queryStatus, Integer pageSize, String zuoraVersion, ApiCallback<GetDataQueryJobsResponse> _callback) throws ApiException {
        Call localVarCall = this.getDataQueryJobsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, queryStatus, pageSize, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetDataQueryJobsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDataQueryJobsApi getDataQueryJobsApi() {
        return new GetDataQueryJobsApi();
    }

    private Call postDataQueryJobCall(SubmitDataQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubmitDataQueryRequest localVarPostBody = body;
        String localVarPath = "/query/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postDataQueryJobValidateBeforeCall(SubmitDataQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postDataQueryJob(Async)");
        }
        return this.postDataQueryJobCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
    }

    public SubmitDataQueryResponse postDataQueryJob(SubmitDataQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        ApiResponse<SubmitDataQueryResponse> localVarResp = this.postDataQueryJobWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<SubmitDataQueryResponse> postDataQueryJobWithHttpInfo(SubmitDataQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        Call localVarCall = this.postDataQueryJobValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<SubmitDataQueryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postDataQueryJobAsync(SubmitDataQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback<SubmitDataQueryResponse> _callback) throws ApiException {
        Call localVarCall = this.postDataQueryJobValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<SubmitDataQueryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostDataQueryJobApi postDataQueryJobApi(SubmitDataQueryRequest body) {
        return new PostDataQueryJobApi(body);
    }

    public class PostDataQueryJobApi {
        private final SubmitDataQueryRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;

        private PostDataQueryJobApi(SubmitDataQueryRequest body) {
            this.body = body;
        }

        public PostDataQueryJobApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostDataQueryJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostDataQueryJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostDataQueryJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostDataQueryJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostDataQueryJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostDataQueryJobApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataQueriesApi.this.postDataQueryJobCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }

        public SubmitDataQueryResponse execute() throws ApiException {
            ApiResponse localVarResp = DataQueriesApi.this.postDataQueryJobWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
            return (SubmitDataQueryResponse)localVarResp.getData();
        }

        private ApiResponse<SubmitDataQueryResponse> executeWithHttpInfo() throws ApiException {
            return DataQueriesApi.this.postDataQueryJobWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<SubmitDataQueryResponse> _callback) throws ApiException {
            return DataQueriesApi.this.postDataQueryJobAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }
    }

    public class GetDataQueryJobsApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String queryStatus;
        private Integer pageSize;
        private String zuoraVersion;

        private GetDataQueryJobsApi() {
        }

        public GetDataQueryJobsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDataQueryJobsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDataQueryJobsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetDataQueryJobsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDataQueryJobsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetDataQueryJobsApi queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        public GetDataQueryJobsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetDataQueryJobsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataQueriesApi.this.getDataQueryJobsCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.queryStatus, this.pageSize, this.zuoraVersion, _callback);
        }

        public GetDataQueryJobsResponse execute() throws ApiException {
            ApiResponse localVarResp = DataQueriesApi.this.getDataQueryJobsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.queryStatus, this.pageSize, this.zuoraVersion);
            return (GetDataQueryJobsResponse)localVarResp.getData();
        }

        private ApiResponse<GetDataQueryJobsResponse> executeWithHttpInfo() throws ApiException {
            return DataQueriesApi.this.getDataQueryJobsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.queryStatus, this.pageSize, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetDataQueryJobsResponse> _callback) throws ApiException {
            return DataQueriesApi.this.getDataQueryJobsAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.queryStatus, this.pageSize, this.zuoraVersion, _callback);
        }
    }

    public class GetDataQueryJobApi {
        private final UUID jobId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;

        private GetDataQueryJobApi(UUID jobId) {
            this.jobId = jobId;
        }

        public GetDataQueryJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetDataQueryJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetDataQueryJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetDataQueryJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetDataQueryJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetDataQueryJobApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataQueriesApi.this.getDataQueryJobCall(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }

        public GetDataQueryJobResponse execute() throws ApiException {
            ApiResponse localVarResp = DataQueriesApi.this.getDataQueryJobWithHttpInfo(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
            return (GetDataQueryJobResponse)localVarResp.getData();
        }

        private ApiResponse<GetDataQueryJobResponse> executeWithHttpInfo() throws ApiException {
            return DataQueriesApi.this.getDataQueryJobWithHttpInfo(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetDataQueryJobResponse> _callback) throws ApiException {
            return DataQueriesApi.this.getDataQueryJobAsync(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }
    }

    public class DeleteDataQueryJobApi {
        private final UUID jobId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;

        private DeleteDataQueryJobApi(UUID jobId) {
            this.jobId = jobId;
        }

        public DeleteDataQueryJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteDataQueryJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteDataQueryJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteDataQueryJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteDataQueryJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteDataQueryJobApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DataQueriesApi.this.deleteDataQueryJobCall(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }

        public DeleteDataQueryJobResponse execute() throws ApiException {
            ApiResponse localVarResp = DataQueriesApi.this.deleteDataQueryJobWithHttpInfo(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
            return (DeleteDataQueryJobResponse)localVarResp.getData();
        }

        private ApiResponse<DeleteDataQueryJobResponse> executeWithHttpInfo() throws ApiException {
            return DataQueriesApi.this.deleteDataQueryJobWithHttpInfo(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<DeleteDataQueryJobResponse> _callback) throws ApiException {
            return DataQueriesApi.this.deleteDataQueryJobAsync(this.jobId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }
    }
}

