/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.GetContactSnapshotResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ContactSnapshotsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ContactSnapshotsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContactSnapshotsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getContactSnapshotCall(String contactSnapshotId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/contact-snapshots/{contact-snapshot-id}".replace("{contact-snapshot-id}", this.localVarApiClient.escapeString(contactSnapshotId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContactSnapshotValidateBeforeCall(String contactSnapshotId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (contactSnapshotId == null) {
            throw new ApiException("Missing the required parameter 'contactSnapshotId' when calling getContactSnapshot(Async)");
        }
        return this.getContactSnapshotCall(contactSnapshotId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, _callback);
    }

    public GetContactSnapshotResponse getContactSnapshot(String contactSnapshotId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion) throws ApiException {
        ApiResponse<GetContactSnapshotResponse> localVarResp = this.getContactSnapshotWithHttpInfo(contactSnapshotId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetContactSnapshotResponse> getContactSnapshotWithHttpInfo(String contactSnapshotId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getContactSnapshotValidateBeforeCall(contactSnapshotId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetContactSnapshotResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getContactSnapshotAsync(String contactSnapshotId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, ApiCallback<GetContactSnapshotResponse> _callback) throws ApiException {
        Call localVarCall = this.getContactSnapshotValidateBeforeCall(contactSnapshotId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetContactSnapshotResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetContactSnapshotApi getContactSnapshotApi(String contactSnapshotId) {
        return new GetContactSnapshotApi(contactSnapshotId);
    }

    public class GetContactSnapshotApi {
        private final String contactSnapshotId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;

        private GetContactSnapshotApi(String contactSnapshotId) {
            this.contactSnapshotId = contactSnapshotId;
        }

        public GetContactSnapshotApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetContactSnapshotApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetContactSnapshotApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetContactSnapshotApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetContactSnapshotApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetContactSnapshotApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetContactSnapshotApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetContactSnapshotApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContactSnapshotsApi.this.getContactSnapshotCall(this.contactSnapshotId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, _callback);
        }

        public GetContactSnapshotResponse execute() throws ApiException {
            ApiResponse localVarResp = ContactSnapshotsApi.this.getContactSnapshotWithHttpInfo(this.contactSnapshotId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion);
            return (GetContactSnapshotResponse)localVarResp.getData();
        }

        private ApiResponse<GetContactSnapshotResponse> executeWithHttpInfo() throws ApiException {
            return ContactSnapshotsApi.this.getContactSnapshotWithHttpInfo(this.contactSnapshotId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetContactSnapshotResponse> _callback) throws ApiException {
            return ContactSnapshotsApi.this.getContactSnapshotAsync(this.contactSnapshotId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, _callback);
        }
    }
}

