/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.BulkCreateInvoicesRequest;
import com.zuora.model.BulkCreateInvoicesResponse;
import com.zuora.model.BulkPostInvoicesRequest;
import com.zuora.model.BulkPostInvoicesResponse;
import com.zuora.model.BulkUpdateInvoicesRequest;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreateInvoiceRequest;
import com.zuora.model.CreateTaxationItemsRequest;
import com.zuora.model.DeleteInvoiceResponse;
import com.zuora.model.EmailInvoiceRequest;
import com.zuora.model.GetInvoiceApplicationPartsRequest;
import com.zuora.model.GetTaxationItemsResponse;
import com.zuora.model.InvoiceFilesResponse;
import com.zuora.model.InvoiceItemsResponse;
import com.zuora.model.InvoiceResponse;
import com.zuora.model.ReverseInvoiceRequest;
import com.zuora.model.ReverseInvoiceResponse;
import com.zuora.model.TaxationItemsDataResponse;
import com.zuora.model.UpdateInvoiceRequest;
import com.zuora.model.UpdateInvoiceResponse;
import com.zuora.model.UploadFileResponse;
import com.zuora.model.WriteOffInvoiceRequest;
import com.zuora.model.WriteOffInvoiceResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class InvoicesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InvoicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InvoicesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call bulkCreateStandaloneInvoicesCall(BulkCreateInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BulkCreateInvoicesRequest localVarPostBody = request;
        String localVarPath = "/v1/invoices/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bulkCreateStandaloneInvoicesValidateBeforeCall(BulkCreateInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling bulkCreateStandaloneInvoices(Async)");
        }
        return this.bulkCreateStandaloneInvoicesCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected BulkCreateInvoicesResponse bulkCreateStandaloneInvoices(BulkCreateInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<BulkCreateInvoicesResponse> localVarResp = this.bulkCreateStandaloneInvoicesWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<BulkCreateInvoicesResponse> bulkCreateStandaloneInvoicesWithHttpInfo(BulkCreateInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.bulkCreateStandaloneInvoicesValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<BulkCreateInvoicesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call bulkCreateStandaloneInvoicesAsync(BulkCreateInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<BulkCreateInvoicesResponse> _callback) throws ApiException {
        Call localVarCall = this.bulkCreateStandaloneInvoicesValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<BulkCreateInvoicesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public BulkCreateStandaloneInvoicesApi bulkCreateStandaloneInvoicesApi(BulkCreateInvoicesRequest request) {
        return new BulkCreateStandaloneInvoicesApi(request);
    }

    private Call bulkPostInvoicesCall(BulkPostInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BulkPostInvoicesRequest localVarPostBody = request;
        String localVarPath = "/v1/invoices/bulk-post";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bulkPostInvoicesValidateBeforeCall(BulkPostInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling bulkPostInvoices(Async)");
        }
        return this.bulkPostInvoicesCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected BulkPostInvoicesResponse bulkPostInvoices(BulkPostInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<BulkPostInvoicesResponse> localVarResp = this.bulkPostInvoicesWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<BulkPostInvoicesResponse> bulkPostInvoicesWithHttpInfo(BulkPostInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.bulkPostInvoicesValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<BulkPostInvoicesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call bulkPostInvoicesAsync(BulkPostInvoicesRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<BulkPostInvoicesResponse> _callback) throws ApiException {
        Call localVarCall = this.bulkPostInvoicesValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<BulkPostInvoicesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public BulkPostInvoicesApi bulkPostInvoicesApi(BulkPostInvoicesRequest request) {
        return new BulkPostInvoicesApi(request);
    }

    private Call bulkUpdateInvoicesCall(BulkUpdateInvoicesRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BulkUpdateInvoicesRequest localVarPostBody = request;
        String localVarPath = "/v1/invoices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bulkUpdateInvoicesValidateBeforeCall(BulkUpdateInvoicesRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling bulkUpdateInvoices(Async)");
        }
        return this.bulkUpdateInvoicesCall(request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected CommonResponse bulkUpdateInvoices(BulkUpdateInvoicesRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.bulkUpdateInvoicesWithHttpInfo(request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> bulkUpdateInvoicesWithHttpInfo(BulkUpdateInvoicesRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.bulkUpdateInvoicesValidateBeforeCall(request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call bulkUpdateInvoicesAsync(BulkUpdateInvoicesRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.bulkUpdateInvoicesValidateBeforeCall(request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public BulkUpdateInvoicesApi bulkUpdateInvoicesApi(BulkUpdateInvoicesRequest request) {
        return new BulkUpdateInvoicesApi(request);
    }

    private Call createInvoiceTaxationItemsCall(String invoiceKey, CreateTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateTaxationItemsRequest localVarPostBody = body;
        String localVarPath = "/v1/invoices/{invoiceKey}/taxationitems".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createInvoiceTaxationItemsValidateBeforeCall(String invoiceKey, CreateTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling createInvoiceTaxationItems(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createInvoiceTaxationItems(Async)");
        }
        return this.createInvoiceTaxationItemsCall(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected GetTaxationItemsResponse createInvoiceTaxationItems(String invoiceKey, CreateTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<GetTaxationItemsResponse> localVarResp = this.createInvoiceTaxationItemsWithHttpInfo(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetTaxationItemsResponse> createInvoiceTaxationItemsWithHttpInfo(String invoiceKey, CreateTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.createInvoiceTaxationItemsValidateBeforeCall(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetTaxationItemsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createInvoiceTaxationItemsAsync(String invoiceKey, CreateTaxationItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<GetTaxationItemsResponse> _callback) throws ApiException {
        Call localVarCall = this.createInvoiceTaxationItemsValidateBeforeCall(invoiceKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetTaxationItemsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateInvoiceTaxationItemsApi createInvoiceTaxationItemsApi(String invoiceKey, CreateTaxationItemsRequest body) {
        return new CreateInvoiceTaxationItemsApi(invoiceKey, body);
    }

    private Call createStandaloneInvoiceCall(CreateInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateInvoiceRequest localVarPostBody = request;
        String localVarPath = "/v1/invoices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createStandaloneInvoiceValidateBeforeCall(CreateInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createStandaloneInvoice(Async)");
        }
        return this.createStandaloneInvoiceCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected InvoiceResponse createStandaloneInvoice(CreateInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<InvoiceResponse> localVarResp = this.createStandaloneInvoiceWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<InvoiceResponse> createStandaloneInvoiceWithHttpInfo(CreateInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.createStandaloneInvoiceValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<InvoiceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createStandaloneInvoiceAsync(CreateInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<InvoiceResponse> _callback) throws ApiException {
        Call localVarCall = this.createStandaloneInvoiceValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<InvoiceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateStandaloneInvoiceApi createStandaloneInvoiceApi(CreateInvoiceRequest request) {
        return new CreateStandaloneInvoiceApi(request);
    }

    private Call deleteInvoiceCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/invoices/{invoiceKey}".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteInvoiceValidateBeforeCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling deleteInvoice(Async)");
        }
        return this.deleteInvoiceCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected DeleteInvoiceResponse deleteInvoice(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<DeleteInvoiceResponse> localVarResp = this.deleteInvoiceWithHttpInfo(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<DeleteInvoiceResponse> deleteInvoiceWithHttpInfo(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.deleteInvoiceValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<DeleteInvoiceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteInvoiceAsync(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<DeleteInvoiceResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteInvoiceValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<DeleteInvoiceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteInvoiceApi deleteInvoiceApi(String invoiceKey) {
        return new DeleteInvoiceApi(invoiceKey);
    }

    private Call emailInvoiceCall(String invoiceKey, EmailInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EmailInvoiceRequest localVarPostBody = request;
        String localVarPath = "/v1/invoices/{invoiceKey}/emails".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call emailInvoiceValidateBeforeCall(String invoiceKey, EmailInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling emailInvoice(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling emailInvoice(Async)");
        }
        return this.emailInvoiceCall(invoiceKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected CommonResponse emailInvoice(String invoiceKey, EmailInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.emailInvoiceWithHttpInfo(invoiceKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> emailInvoiceWithHttpInfo(String invoiceKey, EmailInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.emailInvoiceValidateBeforeCall(invoiceKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call emailInvoiceAsync(String invoiceKey, EmailInvoiceRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.emailInvoiceValidateBeforeCall(invoiceKey, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public EmailInvoiceApi emailInvoiceApi(String invoiceKey, EmailInvoiceRequest request) {
        return new EmailInvoiceApi(invoiceKey, request);
    }

    private Call getInvoiceCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/invoices/{invoiceKey}".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInvoiceValidateBeforeCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling getInvoice(Async)");
        }
        return this.getInvoiceCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected InvoiceResponse getInvoice(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<InvoiceResponse> localVarResp = this.getInvoiceWithHttpInfo(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<InvoiceResponse> getInvoiceWithHttpInfo(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getInvoiceValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<InvoiceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getInvoiceAsync(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<InvoiceResponse> _callback) throws ApiException {
        Call localVarCall = this.getInvoiceValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<InvoiceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetInvoiceApi getInvoiceApi(String invoiceKey) {
        return new GetInvoiceApi(invoiceKey);
    }

    private Call getInvoiceApplicationPartsCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/invoices/{invoiceKey}/application-parts".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInvoiceApplicationPartsValidateBeforeCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling getInvoiceApplicationParts(Async)");
        }
        return this.getInvoiceApplicationPartsCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected GetInvoiceApplicationPartsRequest getInvoiceApplicationParts(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<GetInvoiceApplicationPartsRequest> localVarResp = this.getInvoiceApplicationPartsWithHttpInfo(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetInvoiceApplicationPartsRequest> getInvoiceApplicationPartsWithHttpInfo(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getInvoiceApplicationPartsValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetInvoiceApplicationPartsRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getInvoiceApplicationPartsAsync(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<GetInvoiceApplicationPartsRequest> _callback) throws ApiException {
        Call localVarCall = this.getInvoiceApplicationPartsValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetInvoiceApplicationPartsRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetInvoiceApplicationPartsApi getInvoiceApplicationPartsApi(String invoiceKey) {
        return new GetInvoiceApplicationPartsApi(invoiceKey);
    }

    private Call getInvoiceFilesCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/invoices/{invoiceKey}/files".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInvoiceFilesValidateBeforeCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling getInvoiceFiles(Async)");
        }
        return this.getInvoiceFilesCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, _callback);
    }

    protected InvoiceFilesResponse getInvoiceFiles(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion) throws ApiException {
        ApiResponse<InvoiceFilesResponse> localVarResp = this.getInvoiceFilesWithHttpInfo(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<InvoiceFilesResponse> getInvoiceFilesWithHttpInfo(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getInvoiceFilesValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<InvoiceFilesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getInvoiceFilesAsync(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, ApiCallback<InvoiceFilesResponse> _callback) throws ApiException {
        Call localVarCall = this.getInvoiceFilesValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<InvoiceFilesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetInvoiceFilesApi getInvoiceFilesApi(String invoiceKey) {
        return new GetInvoiceFilesApi(invoiceKey);
    }

    private Call getInvoiceItemsCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/invoices/{invoiceKey}/items".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInvoiceItemsValidateBeforeCall(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling getInvoiceItems(Async)");
        }
        return this.getInvoiceItemsCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, _callback);
    }

    protected InvoiceItemsResponse getInvoiceItems(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion) throws ApiException {
        ApiResponse<InvoiceItemsResponse> localVarResp = this.getInvoiceItemsWithHttpInfo(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<InvoiceItemsResponse> getInvoiceItemsWithHttpInfo(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getInvoiceItemsValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<InvoiceItemsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getInvoiceItemsAsync(String invoiceKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, ApiCallback<InvoiceItemsResponse> _callback) throws ApiException {
        Call localVarCall = this.getInvoiceItemsValidateBeforeCall(invoiceKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<InvoiceItemsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetInvoiceItemsApi getInvoiceItemsApi(String invoiceKey) {
        return new GetInvoiceItemsApi(invoiceKey);
    }

    private Call getTaxationItemsOfInvoiceItemCall(String invoiceKey, String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/invoices/{invoiceKey}/items/{itemId}/taxation-items".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString())).replace("{itemId}", this.localVarApiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTaxationItemsOfInvoiceItemValidateBeforeCall(String invoiceKey, String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling getTaxationItemsOfInvoiceItem(Async)");
        }
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling getTaxationItemsOfInvoiceItem(Async)");
        }
        return this.getTaxationItemsOfInvoiceItemCall(invoiceKey, itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, _callback);
    }

    protected TaxationItemsDataResponse getTaxationItemsOfInvoiceItem(String invoiceKey, String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion) throws ApiException {
        ApiResponse<TaxationItemsDataResponse> localVarResp = this.getTaxationItemsOfInvoiceItemWithHttpInfo(invoiceKey, itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<TaxationItemsDataResponse> getTaxationItemsOfInvoiceItemWithHttpInfo(String invoiceKey, String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getTaxationItemsOfInvoiceItemValidateBeforeCall(invoiceKey, itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<TaxationItemsDataResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getTaxationItemsOfInvoiceItemAsync(String invoiceKey, String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer pageSize, Integer page, String zuoraVersion, ApiCallback<TaxationItemsDataResponse> _callback) throws ApiException {
        Call localVarCall = this.getTaxationItemsOfInvoiceItemValidateBeforeCall(invoiceKey, itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, pageSize, page, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<TaxationItemsDataResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetTaxationItemsOfInvoiceItemApi getTaxationItemsOfInvoiceItemApi(String invoiceKey, String itemId) {
        return new GetTaxationItemsOfInvoiceItemApi(invoiceKey, itemId);
    }

    private Call reverseInvoiceCall(String invoiceKey, ReverseInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ReverseInvoiceRequest localVarPostBody = request;
        String localVarPath = "/v1/invoices/{invoiceKey}/reverse".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call reverseInvoiceValidateBeforeCall(String invoiceKey, ReverseInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling reverseInvoice(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling reverseInvoice(Async)");
        }
        return this.reverseInvoiceCall(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected ReverseInvoiceResponse reverseInvoice(String invoiceKey, ReverseInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<ReverseInvoiceResponse> localVarResp = this.reverseInvoiceWithHttpInfo(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<ReverseInvoiceResponse> reverseInvoiceWithHttpInfo(String invoiceKey, ReverseInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.reverseInvoiceValidateBeforeCall(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<ReverseInvoiceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call reverseInvoiceAsync(String invoiceKey, ReverseInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<ReverseInvoiceResponse> _callback) throws ApiException {
        Call localVarCall = this.reverseInvoiceValidateBeforeCall(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<ReverseInvoiceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ReverseInvoiceApi reverseInvoiceApi(String invoiceKey, ReverseInvoiceRequest request) {
        return new ReverseInvoiceApi(invoiceKey, request);
    }

    private Call updateInvoiceCall(String invoiceKey, UpdateInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateInvoiceRequest localVarPostBody = request;
        String localVarPath = "/v1/invoices/{invoiceKey}".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateInvoiceValidateBeforeCall(String invoiceKey, UpdateInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling updateInvoice(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling updateInvoice(Async)");
        }
        return this.updateInvoiceCall(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected UpdateInvoiceResponse updateInvoice(String invoiceKey, UpdateInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<UpdateInvoiceResponse> localVarResp = this.updateInvoiceWithHttpInfo(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<UpdateInvoiceResponse> updateInvoiceWithHttpInfo(String invoiceKey, UpdateInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.updateInvoiceValidateBeforeCall(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<UpdateInvoiceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateInvoiceAsync(String invoiceKey, UpdateInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<UpdateInvoiceResponse> _callback) throws ApiException {
        Call localVarCall = this.updateInvoiceValidateBeforeCall(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<UpdateInvoiceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateInvoiceApi updateInvoiceApi(String invoiceKey, UpdateInvoiceRequest request) {
        return new UpdateInvoiceApi(invoiceKey, request);
    }

    private Call uploadFileForInvoiceCall(String invoiceKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/invoices/{invoiceKey}/files".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadFileForInvoiceValidateBeforeCall(String invoiceKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, File _file, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling uploadFileForInvoice(Async)");
        }
        return this.uploadFileForInvoiceCall(invoiceKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _file, _callback);
    }

    protected UploadFileResponse uploadFileForInvoice(String invoiceKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, File _file) throws ApiException {
        ApiResponse<UploadFileResponse> localVarResp = this.uploadFileForInvoiceWithHttpInfo(invoiceKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _file);
        return localVarResp.getData();
    }

    private ApiResponse<UploadFileResponse> uploadFileForInvoiceWithHttpInfo(String invoiceKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, File _file) throws ApiException {
        Call localVarCall = this.uploadFileForInvoiceValidateBeforeCall(invoiceKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _file, null);
        Type localVarReturnType = new TypeToken<UploadFileResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadFileForInvoiceAsync(String invoiceKey, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, File _file, ApiCallback<UploadFileResponse> _callback) throws ApiException {
        Call localVarCall = this.uploadFileForInvoiceValidateBeforeCall(invoiceKey, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _file, _callback);
        Type localVarReturnType = new TypeToken<UploadFileResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UploadFileForInvoiceApi uploadFileForInvoiceApi(String invoiceKey) {
        return new UploadFileForInvoiceApi(invoiceKey);
    }

    private Call writeOffInvoiceCall(String invoiceKey, WriteOffInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WriteOffInvoiceRequest localVarPostBody = request;
        String localVarPath = "/v1/invoices/{invoiceKey}/write-off".replace("{invoiceKey}", this.localVarApiClient.escapeString(invoiceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call writeOffInvoiceValidateBeforeCall(String invoiceKey, WriteOffInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (invoiceKey == null) {
            throw new ApiException("Missing the required parameter 'invoiceKey' when calling writeOffInvoice(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling writeOffInvoice(Async)");
        }
        return this.writeOffInvoiceCall(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected WriteOffInvoiceResponse writeOffInvoice(String invoiceKey, WriteOffInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<WriteOffInvoiceResponse> localVarResp = this.writeOffInvoiceWithHttpInfo(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<WriteOffInvoiceResponse> writeOffInvoiceWithHttpInfo(String invoiceKey, WriteOffInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.writeOffInvoiceValidateBeforeCall(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<WriteOffInvoiceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call writeOffInvoiceAsync(String invoiceKey, WriteOffInvoiceRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<WriteOffInvoiceResponse> _callback) throws ApiException {
        Call localVarCall = this.writeOffInvoiceValidateBeforeCall(invoiceKey, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<WriteOffInvoiceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public WriteOffInvoiceApi writeOffInvoiceApi(String invoiceKey, WriteOffInvoiceRequest request) {
        return new WriteOffInvoiceApi(invoiceKey, request);
    }

    public class WriteOffInvoiceApi {
        private final String invoiceKey;
        private final WriteOffInvoiceRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private WriteOffInvoiceApi(String invoiceKey, WriteOffInvoiceRequest request) {
            this.invoiceKey = invoiceKey;
            this.request = request;
        }

        public WriteOffInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public WriteOffInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public WriteOffInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public WriteOffInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public WriteOffInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public WriteOffInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.writeOffInvoiceCall(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public WriteOffInvoiceResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.writeOffInvoiceWithHttpInfo(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (WriteOffInvoiceResponse)localVarResp.getData();
        }

        private ApiResponse<WriteOffInvoiceResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.writeOffInvoiceWithHttpInfo(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<WriteOffInvoiceResponse> _callback) throws ApiException {
            return InvoicesApi.this.writeOffInvoiceAsync(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class UploadFileForInvoiceApi {
        private final String invoiceKey;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private File _file;

        private UploadFileForInvoiceApi(String invoiceKey) {
            this.invoiceKey = invoiceKey;
        }

        public UploadFileForInvoiceApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public UploadFileForInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UploadFileForInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UploadFileForInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UploadFileForInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UploadFileForInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UploadFileForInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UploadFileForInvoiceApi _file(File _file) {
            this._file = _file;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.uploadFileForInvoiceCall(this.invoiceKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this._file, _callback);
        }

        public UploadFileResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.uploadFileForInvoiceWithHttpInfo(this.invoiceKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this._file);
            return (UploadFileResponse)localVarResp.getData();
        }

        private ApiResponse<UploadFileResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.uploadFileForInvoiceWithHttpInfo(this.invoiceKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this._file);
        }

        public Call executeAsync(ApiCallback<UploadFileResponse> _callback) throws ApiException {
            return InvoicesApi.this.uploadFileForInvoiceAsync(this.invoiceKey, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this._file, _callback);
        }
    }

    public class UpdateInvoiceApi {
        private final String invoiceKey;
        private final UpdateInvoiceRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private UpdateInvoiceApi(String invoiceKey, UpdateInvoiceRequest request) {
            this.invoiceKey = invoiceKey;
            this.request = request;
        }

        public UpdateInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.updateInvoiceCall(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public UpdateInvoiceResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.updateInvoiceWithHttpInfo(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (UpdateInvoiceResponse)localVarResp.getData();
        }

        private ApiResponse<UpdateInvoiceResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.updateInvoiceWithHttpInfo(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<UpdateInvoiceResponse> _callback) throws ApiException {
            return InvoicesApi.this.updateInvoiceAsync(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class ReverseInvoiceApi {
        private final String invoiceKey;
        private final ReverseInvoiceRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private ReverseInvoiceApi(String invoiceKey, ReverseInvoiceRequest request) {
            this.invoiceKey = invoiceKey;
            this.request = request;
        }

        public ReverseInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ReverseInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ReverseInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ReverseInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ReverseInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ReverseInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.reverseInvoiceCall(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public ReverseInvoiceResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.reverseInvoiceWithHttpInfo(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (ReverseInvoiceResponse)localVarResp.getData();
        }

        private ApiResponse<ReverseInvoiceResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.reverseInvoiceWithHttpInfo(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<ReverseInvoiceResponse> _callback) throws ApiException {
            return InvoicesApi.this.reverseInvoiceAsync(this.invoiceKey, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class GetTaxationItemsOfInvoiceItemApi {
        private final String invoiceKey;
        private final String itemId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer pageSize;
        private Integer page;
        private String zuoraVersion;

        private GetTaxationItemsOfInvoiceItemApi(String invoiceKey, String itemId) {
            this.invoiceKey = invoiceKey;
            this.itemId = itemId;
        }

        public GetTaxationItemsOfInvoiceItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetTaxationItemsOfInvoiceItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetTaxationItemsOfInvoiceItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetTaxationItemsOfInvoiceItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetTaxationItemsOfInvoiceItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetTaxationItemsOfInvoiceItemApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetTaxationItemsOfInvoiceItemApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetTaxationItemsOfInvoiceItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.getTaxationItemsOfInvoiceItemCall(this.invoiceKey, this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, _callback);
        }

        public TaxationItemsDataResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.getTaxationItemsOfInvoiceItemWithHttpInfo(this.invoiceKey, this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion);
            return (TaxationItemsDataResponse)localVarResp.getData();
        }

        private ApiResponse<TaxationItemsDataResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.getTaxationItemsOfInvoiceItemWithHttpInfo(this.invoiceKey, this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<TaxationItemsDataResponse> _callback) throws ApiException {
            return InvoicesApi.this.getTaxationItemsOfInvoiceItemAsync(this.invoiceKey, this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, _callback);
        }
    }

    public class GetInvoiceItemsApi {
        private final String invoiceKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer pageSize;
        private Integer page;
        private String zuoraVersion;

        private GetInvoiceItemsApi(String invoiceKey) {
            this.invoiceKey = invoiceKey;
        }

        public GetInvoiceItemsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetInvoiceItemsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetInvoiceItemsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetInvoiceItemsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetInvoiceItemsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetInvoiceItemsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetInvoiceItemsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetInvoiceItemsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.getInvoiceItemsCall(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, _callback);
        }

        public InvoiceItemsResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.getInvoiceItemsWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion);
            return (InvoiceItemsResponse)localVarResp.getData();
        }

        private ApiResponse<InvoiceItemsResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.getInvoiceItemsWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<InvoiceItemsResponse> _callback) throws ApiException {
            return InvoicesApi.this.getInvoiceItemsAsync(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, _callback);
        }
    }

    public class GetInvoiceFilesApi {
        private final String invoiceKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer pageSize;
        private Integer page;
        private String zuoraVersion;

        private GetInvoiceFilesApi(String invoiceKey) {
            this.invoiceKey = invoiceKey;
        }

        public GetInvoiceFilesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetInvoiceFilesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetInvoiceFilesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetInvoiceFilesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetInvoiceFilesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetInvoiceFilesApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetInvoiceFilesApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetInvoiceFilesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.getInvoiceFilesCall(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, _callback);
        }

        public InvoiceFilesResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.getInvoiceFilesWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion);
            return (InvoiceFilesResponse)localVarResp.getData();
        }

        private ApiResponse<InvoiceFilesResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.getInvoiceFilesWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<InvoiceFilesResponse> _callback) throws ApiException {
            return InvoicesApi.this.getInvoiceFilesAsync(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.pageSize, this.page, this.zuoraVersion, _callback);
        }
    }

    public class GetInvoiceApplicationPartsApi {
        private final String invoiceKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private GetInvoiceApplicationPartsApi(String invoiceKey) {
            this.invoiceKey = invoiceKey;
        }

        public GetInvoiceApplicationPartsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetInvoiceApplicationPartsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetInvoiceApplicationPartsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetInvoiceApplicationPartsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetInvoiceApplicationPartsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetInvoiceApplicationPartsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.getInvoiceApplicationPartsCall(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public GetInvoiceApplicationPartsRequest execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.getInvoiceApplicationPartsWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (GetInvoiceApplicationPartsRequest)localVarResp.getData();
        }

        private ApiResponse<GetInvoiceApplicationPartsRequest> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.getInvoiceApplicationPartsWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetInvoiceApplicationPartsRequest> _callback) throws ApiException {
            return InvoicesApi.this.getInvoiceApplicationPartsAsync(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class GetInvoiceApi {
        private final String invoiceKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private GetInvoiceApi(String invoiceKey) {
            this.invoiceKey = invoiceKey;
        }

        public GetInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.getInvoiceCall(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public InvoiceResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.getInvoiceWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (InvoiceResponse)localVarResp.getData();
        }

        private ApiResponse<InvoiceResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.getInvoiceWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<InvoiceResponse> _callback) throws ApiException {
            return InvoicesApi.this.getInvoiceAsync(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class EmailInvoiceApi {
        private final String invoiceKey;
        private final EmailInvoiceRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private EmailInvoiceApi(String invoiceKey, EmailInvoiceRequest request) {
            this.invoiceKey = invoiceKey;
            this.request = request;
        }

        public EmailInvoiceApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public EmailInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public EmailInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public EmailInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public EmailInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public EmailInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public EmailInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.emailInvoiceCall(this.invoiceKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.emailInvoiceWithHttpInfo(this.invoiceKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.emailInvoiceWithHttpInfo(this.invoiceKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return InvoicesApi.this.emailInvoiceAsync(this.invoiceKey, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class DeleteInvoiceApi {
        private final String invoiceKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private DeleteInvoiceApi(String invoiceKey) {
            this.invoiceKey = invoiceKey;
        }

        public DeleteInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.deleteInvoiceCall(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public DeleteInvoiceResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.deleteInvoiceWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (DeleteInvoiceResponse)localVarResp.getData();
        }

        private ApiResponse<DeleteInvoiceResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.deleteInvoiceWithHttpInfo(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<DeleteInvoiceResponse> _callback) throws ApiException {
            return InvoicesApi.this.deleteInvoiceAsync(this.invoiceKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class CreateStandaloneInvoiceApi {
        private final CreateInvoiceRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private CreateStandaloneInvoiceApi(CreateInvoiceRequest request) {
            this.request = request;
        }

        public CreateStandaloneInvoiceApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateStandaloneInvoiceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateStandaloneInvoiceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateStandaloneInvoiceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateStandaloneInvoiceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateStandaloneInvoiceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateStandaloneInvoiceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.createStandaloneInvoiceCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public InvoiceResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.createStandaloneInvoiceWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (InvoiceResponse)localVarResp.getData();
        }

        private ApiResponse<InvoiceResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.createStandaloneInvoiceWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<InvoiceResponse> _callback) throws ApiException {
            return InvoicesApi.this.createStandaloneInvoiceAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class CreateInvoiceTaxationItemsApi {
        private final String invoiceKey;
        private final CreateTaxationItemsRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private CreateInvoiceTaxationItemsApi(String invoiceKey, CreateTaxationItemsRequest body) {
            this.invoiceKey = invoiceKey;
            this.body = body;
        }

        public CreateInvoiceTaxationItemsApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateInvoiceTaxationItemsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateInvoiceTaxationItemsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateInvoiceTaxationItemsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateInvoiceTaxationItemsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateInvoiceTaxationItemsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateInvoiceTaxationItemsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.createInvoiceTaxationItemsCall(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public GetTaxationItemsResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.createInvoiceTaxationItemsWithHttpInfo(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (GetTaxationItemsResponse)localVarResp.getData();
        }

        private ApiResponse<GetTaxationItemsResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.createInvoiceTaxationItemsWithHttpInfo(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetTaxationItemsResponse> _callback) throws ApiException {
            return InvoicesApi.this.createInvoiceTaxationItemsAsync(this.invoiceKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class BulkUpdateInvoicesApi {
        private final BulkUpdateInvoicesRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private BulkUpdateInvoicesApi(BulkUpdateInvoicesRequest request) {
            this.request = request;
        }

        public BulkUpdateInvoicesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public BulkUpdateInvoicesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public BulkUpdateInvoicesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public BulkUpdateInvoicesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public BulkUpdateInvoicesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public BulkUpdateInvoicesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.bulkUpdateInvoicesCall(this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.bulkUpdateInvoicesWithHttpInfo(this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.bulkUpdateInvoicesWithHttpInfo(this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return InvoicesApi.this.bulkUpdateInvoicesAsync(this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class BulkPostInvoicesApi {
        private final BulkPostInvoicesRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private BulkPostInvoicesApi(BulkPostInvoicesRequest request) {
            this.request = request;
        }

        public BulkPostInvoicesApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public BulkPostInvoicesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public BulkPostInvoicesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public BulkPostInvoicesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public BulkPostInvoicesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public BulkPostInvoicesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public BulkPostInvoicesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.bulkPostInvoicesCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public BulkPostInvoicesResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.bulkPostInvoicesWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (BulkPostInvoicesResponse)localVarResp.getData();
        }

        private ApiResponse<BulkPostInvoicesResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.bulkPostInvoicesWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<BulkPostInvoicesResponse> _callback) throws ApiException {
            return InvoicesApi.this.bulkPostInvoicesAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class BulkCreateStandaloneInvoicesApi {
        private final BulkCreateInvoicesRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private BulkCreateStandaloneInvoicesApi(BulkCreateInvoicesRequest request) {
            this.request = request;
        }

        public BulkCreateStandaloneInvoicesApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public BulkCreateStandaloneInvoicesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public BulkCreateStandaloneInvoicesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public BulkCreateStandaloneInvoicesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public BulkCreateStandaloneInvoicesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public BulkCreateStandaloneInvoicesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public BulkCreateStandaloneInvoicesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return InvoicesApi.this.bulkCreateStandaloneInvoicesCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public BulkCreateInvoicesResponse execute() throws ApiException {
            ApiResponse localVarResp = InvoicesApi.this.bulkCreateStandaloneInvoicesWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (BulkCreateInvoicesResponse)localVarResp.getData();
        }

        private ApiResponse<BulkCreateInvoicesResponse> executeWithHttpInfo() throws ApiException {
            return InvoicesApi.this.bulkCreateStandaloneInvoicesWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<BulkCreateInvoicesResponse> _callback) throws ApiException {
            return InvoicesApi.this.bulkCreateStandaloneInvoicesAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }
}

