/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Account;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.BillingDocumentItem;
import com.zuora.sdk.InvoiceWriteOffData;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.enums.BillingDocumentType;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class BillingDocument
extends BaseFacade {
    private final String id;
    private final String documentNumber;
    @NonNull
    private final BillingDocumentType type;
    @NonNull
    private final Account account;
    private final String key;
    private final String currency;
    private final Double amount;
    private final Double tax;
    private final Double subtotal;
    private final Double balance;
    private String state;
    private String documentDate;
    private String dueDate;
    private Boolean autoPay;
    private final String description;
    private final Map<String, Object> customFields;
    private final String createdBy;
    private final ZonedDateTime createTime;
    private final String updatedBy;
    private final ZonedDateTime updateTime;
    private final String postedBy;
    private final ZonedDateTime postedTime;
    @NonNull
    private final ZuoraClient client;

    void setCustomFields(Map map) {
        this.customFields.clear();
        this.customFields.putAll(map);
    }

    public List<BillingDocumentItem> getItems() throws ZuoraSdkException {
        return this.client.billingDocuments().getItems(this);
    }

    public void post() throws ZuoraSdkException {
        this.client.billingDocuments().post(this);
    }

    public String writeOff(InvoiceWriteOffData invoiceWriteOffData) throws ZuoraSdkException {
        return this.client.billingDocuments().writeOff(this, invoiceWriteOffData);
    }

    public BillingDocumentType type() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Map<String, Object> $default$customFields() {
        return new HashMap<String, Object>();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    BillingDocument(String id, String documentNumber, @NonNull BillingDocumentType type, @NonNull Account account2, String key, String currency, Double amount, Double tax, Double subtotal, Double balance, String state, String documentDate, String dueDate, Boolean autoPay, String description, Map<String, Object> customFields, String createdBy, ZonedDateTime createTime, String updatedBy, ZonedDateTime updateTime, String postedBy, ZonedDateTime postedTime, @NonNull ZuoraClient client) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (account2 == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.id = id;
        this.documentNumber = documentNumber;
        this.type = type;
        this.account = account2;
        this.key = key;
        this.currency = currency;
        this.amount = amount;
        this.tax = tax;
        this.subtotal = subtotal;
        this.balance = balance;
        this.state = state;
        this.documentDate = documentDate;
        this.dueDate = dueDate;
        this.autoPay = autoPay;
        this.description = description;
        this.customFields = customFields;
        this.createdBy = createdBy;
        this.createTime = createTime;
        this.updatedBy = updatedBy;
        this.updateTime = updateTime;
        this.postedBy = postedBy;
        this.postedTime = postedTime;
        this.client = client;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static BillingDocumentBuilder builder() {
        return new BillingDocumentBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BillingDocumentBuilder toBuilder() {
        return new BillingDocumentBuilder().id(this.id).documentNumber(this.documentNumber).type(this.type).account(this.account).key(this.key).currency(this.currency).amount(this.amount).tax(this.tax).subtotal(this.subtotal).balance(this.balance).state(this.state).documentDate(this.documentDate).dueDate(this.dueDate).autoPay(this.autoPay).description(this.description).customFields(this.customFields).createdBy(this.createdBy).createTime(this.createTime).updatedBy(this.updatedBy).updateTime(this.updateTime).postedBy(this.postedBy).postedTime(this.postedTime).client(this.client);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BillingDocumentType getType() {
        return this.type;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Account getAccount() {
        return this.account;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getAmount() {
        return this.amount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getTax() {
        return this.tax;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getSubtotal() {
        return this.subtotal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getBalance() {
        return this.balance;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getState() {
        return this.state;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDocumentDate() {
        return this.documentDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDueDate() {
        return this.dueDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getAutoPay() {
        return this.autoPay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPostedBy() {
        return this.postedBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getPostedTime() {
        return this.postedTime;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZuoraClient getClient() {
        return this.client;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "BillingDocument(id=" + this.getId() + ", documentNumber=" + this.getDocumentNumber() + ", type=" + (Object)((Object)this.getType()) + ", account=" + this.getAccount() + ", key=" + this.getKey() + ", currency=" + this.getCurrency() + ", amount=" + this.getAmount() + ", tax=" + this.getTax() + ", subtotal=" + this.getSubtotal() + ", balance=" + this.getBalance() + ", state=" + this.getState() + ", documentDate=" + this.getDocumentDate() + ", dueDate=" + this.getDueDate() + ", autoPay=" + this.getAutoPay() + ", description=" + this.getDescription() + ", customFields=" + this.getCustomFields() + ", createdBy=" + this.getCreatedBy() + ", createTime=" + this.getCreateTime() + ", updatedBy=" + this.getUpdatedBy() + ", updateTime=" + this.getUpdateTime() + ", postedBy=" + this.getPostedBy() + ", postedTime=" + this.getPostedTime() + ", client=" + this.getClient() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BillingDocument)) {
            return false;
        }
        BillingDocument other = (BillingDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$amount = this.getAmount();
        Double other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Double this$tax = this.getTax();
        Double other$tax = other.getTax();
        if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
            return false;
        }
        Double this$subtotal = this.getSubtotal();
        Double other$subtotal = other.getSubtotal();
        if (this$subtotal == null ? other$subtotal != null : !((Object)this$subtotal).equals(other$subtotal)) {
            return false;
        }
        Double this$balance = this.getBalance();
        Double other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        Boolean this$autoPay = this.getAutoPay();
        Boolean other$autoPay = other.getAutoPay();
        if (this$autoPay == null ? other$autoPay != null : !((Object)this$autoPay).equals(other$autoPay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$documentNumber = this.getDocumentNumber();
        String other$documentNumber = other.getDocumentNumber();
        if (this$documentNumber == null ? other$documentNumber != null : !this$documentNumber.equals(other$documentNumber)) {
            return false;
        }
        BillingDocumentType this$type = this.getType();
        BillingDocumentType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Account this$account = this.getAccount();
        Account other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$documentDate = this.getDocumentDate();
        String other$documentDate = other.getDocumentDate();
        if (this$documentDate == null ? other$documentDate != null : !this$documentDate.equals(other$documentDate)) {
            return false;
        }
        String this$dueDate = this.getDueDate();
        String other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !this$dueDate.equals(other$dueDate)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, Object> this$customFields = this.getCustomFields();
        Map<String, Object> other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        ZonedDateTime this$createTime = this.getCreateTime();
        ZonedDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$postedBy = this.getPostedBy();
        String other$postedBy = other.getPostedBy();
        if (this$postedBy == null ? other$postedBy != null : !this$postedBy.equals(other$postedBy)) {
            return false;
        }
        ZonedDateTime this$postedTime = this.getPostedTime();
        ZonedDateTime other$postedTime = other.getPostedTime();
        if (this$postedTime == null ? other$postedTime != null : !((Object)this$postedTime).equals(other$postedTime)) {
            return false;
        }
        ZuoraClient this$client = this.getClient();
        ZuoraClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BillingDocument;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Double $tax = this.getTax();
        result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
        Double $subtotal = this.getSubtotal();
        result = result * 59 + ($subtotal == null ? 43 : ((Object)$subtotal).hashCode());
        Double $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        Boolean $autoPay = this.getAutoPay();
        result = result * 59 + ($autoPay == null ? 43 : ((Object)$autoPay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $documentNumber = this.getDocumentNumber();
        result = result * 59 + ($documentNumber == null ? 43 : $documentNumber.hashCode());
        BillingDocumentType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Account $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $documentDate = this.getDocumentDate();
        result = result * 59 + ($documentDate == null ? 43 : $documentDate.hashCode());
        String $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : $dueDate.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, Object> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        ZonedDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $postedBy = this.getPostedBy();
        result = result * 59 + ($postedBy == null ? 43 : $postedBy.hashCode());
        ZonedDateTime $postedTime = this.getPostedTime();
        result = result * 59 + ($postedTime == null ? 43 : ((Object)$postedTime).hashCode());
        ZuoraClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDocumentDate(String documentDate) {
        this.documentDate = documentDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAutoPay(Boolean autoPay) {
        this.autoPay = autoPay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class BillingDocumentBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String documentNumber;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private BillingDocumentType type;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Account account;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String currency;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double amount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double tax;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double subtotal;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double balance;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String state;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String documentDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String dueDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean autoPay;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean customFields$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, Object> customFields$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String createdBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime createTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String updatedBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime updateTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String postedBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime postedTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZuoraClient client;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        BillingDocumentBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder documentNumber(String documentNumber) {
            this.documentNumber = documentNumber;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder type(@NonNull BillingDocumentType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder account(@NonNull Account account2) {
            if (account2 == null) {
                throw new NullPointerException("account is marked non-null but is null");
            }
            this.account = account2;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder key(String key) {
            this.key = key;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder tax(Double tax) {
            this.tax = tax;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder subtotal(Double subtotal) {
            this.subtotal = subtotal;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder balance(Double balance) {
            this.balance = balance;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder state(String state) {
            this.state = state;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder documentDate(String documentDate) {
            this.documentDate = documentDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder dueDate(String dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder autoPay(Boolean autoPay) {
            this.autoPay = autoPay;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder customFields(Map<String, Object> customFields) {
            this.customFields$value = customFields;
            this.customFields$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder createTime(ZonedDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder updateTime(ZonedDateTime updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder postedBy(String postedBy) {
            this.postedBy = postedBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder postedTime(ZonedDateTime postedTime) {
            this.postedTime = postedTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentBuilder client(@NonNull ZuoraClient client) {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.client = client;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocument build() {
            Map customFields$value = this.customFields$value;
            if (!this.customFields$set) {
                customFields$value = BillingDocument.$default$customFields();
            }
            return new BillingDocument(this.id, this.documentNumber, this.type, this.account, this.key, this.currency, this.amount, this.tax, this.subtotal, this.balance, this.state, this.documentDate, this.dueDate, this.autoPay, this.description, customFields$value, this.createdBy, this.createTime, this.updatedBy, this.updateTime, this.postedBy, this.postedTime, this.client);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "BillingDocument.BillingDocumentBuilder(id=" + this.id + ", documentNumber=" + this.documentNumber + ", type=" + (Object)((Object)this.type) + ", account=" + this.account + ", key=" + this.key + ", currency=" + this.currency + ", amount=" + this.amount + ", tax=" + this.tax + ", subtotal=" + this.subtotal + ", balance=" + this.balance + ", state=" + this.state + ", documentDate=" + this.documentDate + ", dueDate=" + this.dueDate + ", autoPay=" + this.autoPay + ", description=" + this.description + ", customFields$value=" + this.customFields$value + ", createdBy=" + this.createdBy + ", createTime=" + this.createTime + ", updatedBy=" + this.updatedBy + ", updateTime=" + this.updateTime + ", postedBy=" + this.postedBy + ", postedTime=" + this.postedTime + ", client=" + this.client + ")";
        }
    }
}

