/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.zuora.sdk.Payment;
import com.zuora.sdk.PaymentCreateRequest;
import com.zuora.sdk.PaymentRefundRequest;
import com.zuora.sdk.TransactionMapper;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.HawkClient;
import com.zuora.sdk.internal.apis.PaymentsAPI;
import com.zuora.sdk.internal.apis.data.GETRefundPaymentType;
import com.zuora.sdk.internal.apis.data.PaymentCreateRequestFinanceInformation;
import com.zuora.sdk.internal.apis.data.PaymentRefundRequestFinanceInformation;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import com.zuora.sdk.internal.models.ZPayment;
import com.zuora.sdk.internal.models.enums.PaymentType;
import okhttp3.OkHttpClient;
import org.mapstruct.factory.Mappers;

public class PaymentAPI {
    private final HawkClient hawkClient;
    private final ApolloClient gqlClient;
    private final ZuoraClient client;
    private final TransactionMapper transactionMapper = (TransactionMapper)Mappers.getMapper(TransactionMapper.class);
    private APIContext context;
    private OkHttpClient okHttpClient = new OkHttpClient();

    PaymentAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.hawkClient = client.getHawkClient();
        this.gqlClient = this.hawkClient.getGqlClient();
    }

    /*
     * WARNING - void declaration
     */
    public Payment create(PaymentCreateRequest paymentCreateRequest) {
        long l = System.currentTimeMillis();
        Object object = this;
        PaymentCreateRequest paymentCreateRequest2 = paymentCreateRequest;
        try {
            void builder;
            void paymentCreateRequest3;
            ZPayment.Builder builder2 = paymentCreateRequest3.transactionMapper.toApi(paymentCreateRequest2);
            if (builder.getFinanceInformation() != null) {
                builder2.financeInformation(new PaymentCreateRequestFinanceInformation().bankAccountAccountingCode(builder.getFinanceInformation().getBankAccountAccountingCode()).transferredToAccounting(builder.getFinanceInformation().getTransferredToAccounting().getApiValue()).unappliedPaymentAccountingCode(builder.getFinanceInformation().getUnappliedPaymentAccountingCode()));
            }
            builder2.type(builder.getExternal() != false ? PaymentType.EXTERNAL : PaymentType.ELECTRONIC);
            builder2.gatewayOptions(builder.getGatewayOptions());
            String string = builder2.build();
            String string2 = string.create(paymentCreateRequest3.context);
            object = paymentCreateRequest3.get(string2);
            return object;
        }
        finally {
            paymentCreateRequest2 = null;
        }
    }

    public Payment get(String paymentId) {
        try {
            ZPayment zPayment = ZPayment.get((APIContext)this.context, (String)paymentId);
            Payment payment = this.transactionMapper.fromApi(zPayment, this.client);
            if (zPayment.paymentMethodId() != null) {
                payment.setPaymentMethod(this.client.paymentMethods().get(zPayment.paymentMethodId()));
            }
            if (zPayment.paymentMethodSnapshotId() != null) {
                payment.setPaymentMethodSnapshot(this.client.paymentMethods().get(zPayment.paymentMethodSnapshotId()));
            }
            return payment;
        }
        catch (Throwable e) {
            throw ZuoraSdkException.builder().message(e.getMessage()).cause(e).build();
        }
    }

    Payment update(Payment paymentUpdate) throws ZuoraSdkException {
        this.transactionMapper.toApi(paymentUpdate).build().update(this.context);
        return this.get(paymentUpdate.getId());
    }

    /*
     * WARNING - void declaration
     */
    public String refund(String string, PaymentRefundRequest paymentRefundRequest) {
        long l = System.currentTimeMillis();
        Object object = this;
        String string2 = string;
        PaymentRefundRequest paymentRefundRequest2 = paymentRefundRequest;
        try {
            void corePaymentRefundRequest;
            void paymentRefundRequest3;
            void paymentId;
            Object object2 = PaymentsAPI.refund((APIContext)paymentId.context, (String)paymentRefundRequest3);
            object2.totalAmount(corePaymentRefundRequest.getAmount()).comment(corePaymentRefundRequest.getDescription()).reasonCode(corePaymentRefundRequest.getReason()).referenceId(corePaymentRefundRequest.getReference()).refundDate(corePaymentRefundRequest.getDate() == null ? null : corePaymentRefundRequest.getDate().toString()).type(corePaymentRefundRequest.getExternal() != false ? PaymentType.EXTERNAL.getApiValue() : PaymentType.ELECTRONIC.getApiValue()).refundObjectCustomFields(corePaymentRefundRequest.getCustomFields()).secondRefundReferenceId(corePaymentRefundRequest.getSecondRefundReference()).gatewayOptions(corePaymentRefundRequest.getGatewayOptions()).softDescriptor(corePaymentRefundRequest.getStatementDescriptor()).softDescriptorPhone(corePaymentRefundRequest.getSoftDescriptorPhone());
            if (corePaymentRefundRequest.getFinanceInformation() != null) {
                object2.financeInformation(new PaymentRefundRequestFinanceInformation().bankAccountAccountingCode(corePaymentRefundRequest.getFinanceInformation().getBankAccountAccountingCode()).transferredToAccounting(corePaymentRefundRequest.getFinanceInformation().getTransferredToAccounting().getApiValue()).unappliedPaymentAccountingCode(corePaymentRefundRequest.getFinanceInformation().getUnappliedPaymentAccountingCode()));
            }
            if (corePaymentRefundRequest.getType() != null) {
                object2.methodType(corePaymentRefundRequest.getType().getApiValue());
            }
            String string3 = (GETRefundPaymentType)object2.execute().head();
            object = string3.id();
            return object;
        }
        finally {
            string2 = null;
        }
    }
}

