/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Overage;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.Recurring;
import com.zuora.sdk.Tier;
import com.zuora.sdk.enums.ApplyDiscountTo;
import com.zuora.sdk.internal.models.enums.BillingTiming;
import com.zuora.sdk.internal.models.enums.ChargeType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class SubscriptionPlanItem {
    final String id;
    final String name;
    final LocalDate invoicedThroughDate;
    final String description;
    final Boolean done;
    final LocalDate endDate;
    final LocalDate startDate;
    final String number;
    final LocalDate processedThroughDate;
    final Integer segment;
    final Integer version;
    final String createdBy;
    final ZonedDateTime createTime;
    final String updatedBy;
    final ZonedDateTime updateTime;
    final String subscriptionPlan;
    final String price;
    final boolean taxInclusive;
    final PriceEnum.TiersMode tiersMode;
    final String unitOfMeasure;
    final double minQuantity;
    final double maxQuantity;
    final PriceEnum.PriceBaseInterval priceBaseInterval;
    final Overage overage;
    final EnumSet<ApplyDiscountTo> applyDiscountTo;
    final PriceEnum.DiscountLevel discountLevel;
    final PriceEnum.ChargeModel chargeModel;
    final ChargeType chargeType;
    private final PriceEnum.Event startEvent;
    Recurring recurring;
    private List<Tier> tiers;
    private double quantity;
    private Map<Currency, Double> unitAmounts;
    private Map<Currency, Double> amounts;
    private Double percentAmount;

    @SuppressFBWarnings(justification="generated code")
    @Generated
    SubscriptionPlanItem(String id, String name, LocalDate invoicedThroughDate, String description, Boolean done, LocalDate endDate, LocalDate startDate, String number, LocalDate processedThroughDate, Integer segment, Integer version, String createdBy, ZonedDateTime createTime, String updatedBy, ZonedDateTime updateTime, String subscriptionPlan, String price, boolean taxInclusive, PriceEnum.TiersMode tiersMode, String unitOfMeasure, double minQuantity, double maxQuantity, PriceEnum.PriceBaseInterval priceBaseInterval, Overage overage, EnumSet<ApplyDiscountTo> applyDiscountTo, PriceEnum.DiscountLevel discountLevel, PriceEnum.ChargeModel chargeModel, ChargeType chargeType, PriceEnum.Event startEvent, Recurring recurring, List<Tier> tiers, double quantity, Map<Currency, Double> unitAmounts, Map<Currency, Double> amounts, Double percentAmount) {
        this.id = id;
        this.name = name;
        this.invoicedThroughDate = invoicedThroughDate;
        this.description = description;
        this.done = done;
        this.endDate = endDate;
        this.startDate = startDate;
        this.number = number;
        this.processedThroughDate = processedThroughDate;
        this.segment = segment;
        this.version = version;
        this.createdBy = createdBy;
        this.createTime = createTime;
        this.updatedBy = updatedBy;
        this.updateTime = updateTime;
        this.subscriptionPlan = subscriptionPlan;
        this.price = price;
        this.taxInclusive = taxInclusive;
        this.tiersMode = tiersMode;
        this.unitOfMeasure = unitOfMeasure;
        this.minQuantity = minQuantity;
        this.maxQuantity = maxQuantity;
        this.priceBaseInterval = priceBaseInterval;
        this.overage = overage;
        this.applyDiscountTo = applyDiscountTo;
        this.discountLevel = discountLevel;
        this.chargeModel = chargeModel;
        this.chargeType = chargeType;
        this.startEvent = startEvent;
        this.recurring = recurring;
        this.tiers = tiers;
        this.quantity = quantity;
        this.unitAmounts = unitAmounts;
        this.amounts = amounts;
        this.percentAmount = percentAmount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SubscriptionPlanItemBuilder builder() {
        return new SubscriptionPlanItemBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SubscriptionPlanItemBuilder toBuilder() {
        SubscriptionPlanItemBuilder builder = new SubscriptionPlanItemBuilder().id(this.id).name(this.name).invoicedThroughDate(this.invoicedThroughDate).description(this.description).done(this.done).endDate(this.endDate).startDate(this.startDate).number(this.number).processedThroughDate(this.processedThroughDate).segment(this.segment).version(this.version).createdBy(this.createdBy).createTime(this.createTime).updatedBy(this.updatedBy).updateTime(this.updateTime).subscriptionPlan(this.subscriptionPlan).price(this.price).taxInclusive(this.taxInclusive).tiersMode(this.tiersMode).unitOfMeasure(this.unitOfMeasure).minQuantity(this.minQuantity).maxQuantity(this.maxQuantity).priceBaseInterval(this.priceBaseInterval).overage(this.overage).applyDiscountTo(this.applyDiscountTo).discountLevel(this.discountLevel).chargeModel(this.chargeModel).chargeType(this.chargeType).startEvent(this.startEvent).recurring(this.recurring).quantity(this.quantity).percentAmount(this.percentAmount);
        if (this.tiers != null) {
            builder.tiers(this.tiers);
        }
        if (this.unitAmounts != null) {
            builder.unitAmounts(this.unitAmounts);
        }
        if (this.amounts != null) {
            builder.amounts(this.amounts);
        }
        return builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getInvoicedThroughDate() {
        return this.invoicedThroughDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getDone() {
        return this.done;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNumber() {
        return this.number;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getProcessedThroughDate() {
        return this.processedThroughDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getSegment() {
        return this.segment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSubscriptionPlan() {
        return this.subscriptionPlan;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPrice() {
        return this.price;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isTaxInclusive() {
        return this.taxInclusive;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.TiersMode getTiersMode() {
        return this.tiersMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getMinQuantity() {
        return this.minQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getMaxQuantity() {
        return this.maxQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.PriceBaseInterval getPriceBaseInterval() {
        return this.priceBaseInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Overage getOverage() {
        return this.overage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EnumSet<ApplyDiscountTo> getApplyDiscountTo() {
        return this.applyDiscountTo;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.DiscountLevel getDiscountLevel() {
        return this.discountLevel;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.ChargeModel getChargeModel() {
        return this.chargeModel;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChargeType getChargeType() {
        return this.chargeType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PriceEnum.Event getStartEvent() {
        return this.startEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Recurring getRecurring() {
        return this.recurring;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Tier> getTiers() {
        return this.tiers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getQuantity() {
        return this.quantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Currency, Double> getUnitAmounts() {
        return this.unitAmounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Currency, Double> getAmounts() {
        return this.amounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getPercentAmount() {
        return this.percentAmount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTiers(List<Tier> tiers) {
        this.tiers = tiers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionPlanItem)) {
            return false;
        }
        SubscriptionPlanItem other = (SubscriptionPlanItem)o;
        if (this.isTaxInclusive() != other.isTaxInclusive()) {
            return false;
        }
        if (Double.compare(this.getMinQuantity(), other.getMinQuantity()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxQuantity(), other.getMaxQuantity()) != 0) {
            return false;
        }
        if (Double.compare(this.getQuantity(), other.getQuantity()) != 0) {
            return false;
        }
        Boolean this$done = this.getDone();
        Boolean other$done = other.getDone();
        if (this$done == null ? other$done != null : !((Object)this$done).equals(other$done)) {
            return false;
        }
        Integer this$segment = this.getSegment();
        Integer other$segment = other.getSegment();
        if (this$segment == null ? other$segment != null : !((Object)this$segment).equals(other$segment)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Double this$percentAmount = this.getPercentAmount();
        Double other$percentAmount = other.getPercentAmount();
        if (this$percentAmount == null ? other$percentAmount != null : !((Object)this$percentAmount).equals(other$percentAmount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        LocalDate this$invoicedThroughDate = this.getInvoicedThroughDate();
        LocalDate other$invoicedThroughDate = other.getInvoicedThroughDate();
        if (this$invoicedThroughDate == null ? other$invoicedThroughDate != null : !((Object)this$invoicedThroughDate).equals(other$invoicedThroughDate)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        LocalDate this$processedThroughDate = this.getProcessedThroughDate();
        LocalDate other$processedThroughDate = other.getProcessedThroughDate();
        if (this$processedThroughDate == null ? other$processedThroughDate != null : !((Object)this$processedThroughDate).equals(other$processedThroughDate)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        ZonedDateTime this$createTime = this.getCreateTime();
        ZonedDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$subscriptionPlan = this.getSubscriptionPlan();
        String other$subscriptionPlan = other.getSubscriptionPlan();
        if (this$subscriptionPlan == null ? other$subscriptionPlan != null : !this$subscriptionPlan.equals(other$subscriptionPlan)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        PriceEnum.TiersMode this$tiersMode = this.getTiersMode();
        PriceEnum.TiersMode other$tiersMode = other.getTiersMode();
        if (this$tiersMode == null ? other$tiersMode != null : !((Object)((Object)this$tiersMode)).equals((Object)other$tiersMode)) {
            return false;
        }
        String this$unitOfMeasure = this.getUnitOfMeasure();
        String other$unitOfMeasure = other.getUnitOfMeasure();
        if (this$unitOfMeasure == null ? other$unitOfMeasure != null : !this$unitOfMeasure.equals(other$unitOfMeasure)) {
            return false;
        }
        PriceEnum.PriceBaseInterval this$priceBaseInterval = this.getPriceBaseInterval();
        PriceEnum.PriceBaseInterval other$priceBaseInterval = other.getPriceBaseInterval();
        if (this$priceBaseInterval == null ? other$priceBaseInterval != null : !((Object)((Object)this$priceBaseInterval)).equals((Object)other$priceBaseInterval)) {
            return false;
        }
        Overage this$overage = this.getOverage();
        Overage other$overage = other.getOverage();
        if (this$overage == null ? other$overage != null : !((Object)this$overage).equals(other$overage)) {
            return false;
        }
        EnumSet<ApplyDiscountTo> this$applyDiscountTo = this.getApplyDiscountTo();
        EnumSet<ApplyDiscountTo> other$applyDiscountTo = other.getApplyDiscountTo();
        if (this$applyDiscountTo == null ? other$applyDiscountTo != null : !((Object)this$applyDiscountTo).equals(other$applyDiscountTo)) {
            return false;
        }
        PriceEnum.DiscountLevel this$discountLevel = this.getDiscountLevel();
        PriceEnum.DiscountLevel other$discountLevel = other.getDiscountLevel();
        if (this$discountLevel == null ? other$discountLevel != null : !((Object)((Object)this$discountLevel)).equals((Object)other$discountLevel)) {
            return false;
        }
        PriceEnum.ChargeModel this$chargeModel = this.getChargeModel();
        PriceEnum.ChargeModel other$chargeModel = other.getChargeModel();
        if (this$chargeModel == null ? other$chargeModel != null : !((Object)((Object)this$chargeModel)).equals((Object)other$chargeModel)) {
            return false;
        }
        ChargeType this$chargeType = this.getChargeType();
        ChargeType other$chargeType = other.getChargeType();
        if (this$chargeType == null ? other$chargeType != null : !this$chargeType.equals(other$chargeType)) {
            return false;
        }
        PriceEnum.Event this$startEvent = this.getStartEvent();
        PriceEnum.Event other$startEvent = other.getStartEvent();
        if (this$startEvent == null ? other$startEvent != null : !((Object)((Object)this$startEvent)).equals((Object)other$startEvent)) {
            return false;
        }
        Recurring this$recurring = this.getRecurring();
        Recurring other$recurring = other.getRecurring();
        if (this$recurring == null ? other$recurring != null : !((Object)this$recurring).equals(other$recurring)) {
            return false;
        }
        List<Tier> this$tiers = this.getTiers();
        List<Tier> other$tiers = other.getTiers();
        if (this$tiers == null ? other$tiers != null : !((Object)this$tiers).equals(other$tiers)) {
            return false;
        }
        Map<Currency, Double> this$unitAmounts = this.getUnitAmounts();
        Map<Currency, Double> other$unitAmounts = other.getUnitAmounts();
        if (this$unitAmounts == null ? other$unitAmounts != null : !((Object)this$unitAmounts).equals(other$unitAmounts)) {
            return false;
        }
        Map<Currency, Double> this$amounts = this.getAmounts();
        Map<Currency, Double> other$amounts = other.getAmounts();
        return !(this$amounts == null ? other$amounts != null : !((Object)this$amounts).equals(other$amounts));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTaxInclusive() ? 79 : 97);
        long $minQuantity = Double.doubleToLongBits(this.getMinQuantity());
        result = result * 59 + (int)($minQuantity >>> 32 ^ $minQuantity);
        long $maxQuantity = Double.doubleToLongBits(this.getMaxQuantity());
        result = result * 59 + (int)($maxQuantity >>> 32 ^ $maxQuantity);
        long $quantity = Double.doubleToLongBits(this.getQuantity());
        result = result * 59 + (int)($quantity >>> 32 ^ $quantity);
        Boolean $done = this.getDone();
        result = result * 59 + ($done == null ? 43 : ((Object)$done).hashCode());
        Integer $segment = this.getSegment();
        result = result * 59 + ($segment == null ? 43 : ((Object)$segment).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Double $percentAmount = this.getPercentAmount();
        result = result * 59 + ($percentAmount == null ? 43 : ((Object)$percentAmount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        LocalDate $invoicedThroughDate = this.getInvoicedThroughDate();
        result = result * 59 + ($invoicedThroughDate == null ? 43 : ((Object)$invoicedThroughDate).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        LocalDate $processedThroughDate = this.getProcessedThroughDate();
        result = result * 59 + ($processedThroughDate == null ? 43 : ((Object)$processedThroughDate).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        ZonedDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $subscriptionPlan = this.getSubscriptionPlan();
        result = result * 59 + ($subscriptionPlan == null ? 43 : $subscriptionPlan.hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        PriceEnum.TiersMode $tiersMode = this.getTiersMode();
        result = result * 59 + ($tiersMode == null ? 43 : ((Object)((Object)$tiersMode)).hashCode());
        String $unitOfMeasure = this.getUnitOfMeasure();
        result = result * 59 + ($unitOfMeasure == null ? 43 : $unitOfMeasure.hashCode());
        PriceEnum.PriceBaseInterval $priceBaseInterval = this.getPriceBaseInterval();
        result = result * 59 + ($priceBaseInterval == null ? 43 : ((Object)((Object)$priceBaseInterval)).hashCode());
        Overage $overage = this.getOverage();
        result = result * 59 + ($overage == null ? 43 : ((Object)$overage).hashCode());
        EnumSet<ApplyDiscountTo> $applyDiscountTo = this.getApplyDiscountTo();
        result = result * 59 + ($applyDiscountTo == null ? 43 : ((Object)$applyDiscountTo).hashCode());
        PriceEnum.DiscountLevel $discountLevel = this.getDiscountLevel();
        result = result * 59 + ($discountLevel == null ? 43 : ((Object)((Object)$discountLevel)).hashCode());
        PriceEnum.ChargeModel $chargeModel = this.getChargeModel();
        result = result * 59 + ($chargeModel == null ? 43 : ((Object)((Object)$chargeModel)).hashCode());
        ChargeType $chargeType = this.getChargeType();
        result = result * 59 + ($chargeType == null ? 43 : $chargeType.hashCode());
        PriceEnum.Event $startEvent = this.getStartEvent();
        result = result * 59 + ($startEvent == null ? 43 : ((Object)((Object)$startEvent)).hashCode());
        Recurring $recurring = this.getRecurring();
        result = result * 59 + ($recurring == null ? 43 : ((Object)$recurring).hashCode());
        List<Tier> $tiers = this.getTiers();
        result = result * 59 + ($tiers == null ? 43 : ((Object)$tiers).hashCode());
        Map<Currency, Double> $unitAmounts = this.getUnitAmounts();
        result = result * 59 + ($unitAmounts == null ? 43 : ((Object)$unitAmounts).hashCode());
        Map<Currency, Double> $amounts = this.getAmounts();
        result = result * 59 + ($amounts == null ? 43 : ((Object)$amounts).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SubscriptionPlanItem(id=" + this.getId() + ", name=" + this.getName() + ", invoicedThroughDate=" + this.getInvoicedThroughDate() + ", description=" + this.getDescription() + ", done=" + this.getDone() + ", endDate=" + this.getEndDate() + ", startDate=" + this.getStartDate() + ", number=" + this.getNumber() + ", processedThroughDate=" + this.getProcessedThroughDate() + ", segment=" + this.getSegment() + ", version=" + this.getVersion() + ", createdBy=" + this.getCreatedBy() + ", createTime=" + this.getCreateTime() + ", updatedBy=" + this.getUpdatedBy() + ", updateTime=" + this.getUpdateTime() + ", subscriptionPlan=" + this.getSubscriptionPlan() + ", price=" + this.getPrice() + ", taxInclusive=" + this.isTaxInclusive() + ", tiersMode=" + (Object)((Object)this.getTiersMode()) + ", unitOfMeasure=" + this.getUnitOfMeasure() + ", minQuantity=" + this.getMinQuantity() + ", maxQuantity=" + this.getMaxQuantity() + ", priceBaseInterval=" + (Object)((Object)this.getPriceBaseInterval()) + ", overage=" + this.getOverage() + ", applyDiscountTo=" + this.getApplyDiscountTo() + ", discountLevel=" + (Object)((Object)this.getDiscountLevel()) + ", chargeModel=" + (Object)((Object)this.getChargeModel()) + ", chargeType=" + this.getChargeType() + ", startEvent=" + (Object)((Object)this.getStartEvent()) + ", recurring=" + this.getRecurring() + ", tiers=" + this.getTiers() + ", quantity=" + this.getQuantity() + ", unitAmounts=" + this.getUnitAmounts() + ", amounts=" + this.getAmounts() + ", percentAmount=" + this.getPercentAmount() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUnitAmounts(Map<Currency, Double> unitAmounts) {
        this.unitAmounts = unitAmounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAmounts(Map<Currency, Double> amounts) {
        this.amounts = amounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPercentAmount(Double percentAmount) {
        this.percentAmount = percentAmount;
    }

    public static class SubscriptionPlanItemBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate invoicedThroughDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean done;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate endDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate startDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String number;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate processedThroughDate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer segment;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer version;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String createdBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime createTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String updatedBy;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ZonedDateTime updateTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String subscriptionPlan;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String price;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean taxInclusive;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.TiersMode tiersMode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String unitOfMeasure;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double minQuantity;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double maxQuantity;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.PriceBaseInterval priceBaseInterval;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Overage overage;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private EnumSet<ApplyDiscountTo> applyDiscountTo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.DiscountLevel discountLevel;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.ChargeModel chargeModel;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ChargeType chargeType;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PriceEnum.Event startEvent;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Recurring recurring;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Tier> tiers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double quantity;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Currency> unitAmounts$key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Double> unitAmounts$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Currency> amounts$key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Double> amounts$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double percentAmount;

        public SubscriptionPlanItem build() {
            if (!(this.chargeType.equals((Object)ChargeType.ONE_TIME) || this.chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT) || this.chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE))) {
                this.recurring(this.recurring.toBuilder().timing(this.recurring.isUsage() ? BillingTiming.IN_ARREARS : BillingTiming.IN_ADVANCE).build());
            }
            return this.internalBuild();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionPlanItemBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder invoicedThroughDate(LocalDate invoicedThroughDate) {
            this.invoicedThroughDate = invoicedThroughDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder done(Boolean done) {
            this.done = done;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder endDate(LocalDate endDate) {
            this.endDate = endDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder number(String number) {
            this.number = number;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder processedThroughDate(LocalDate processedThroughDate) {
            this.processedThroughDate = processedThroughDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder segment(Integer segment) {
            this.segment = segment;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder createTime(ZonedDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder updateTime(ZonedDateTime updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder subscriptionPlan(String subscriptionPlan) {
            this.subscriptionPlan = subscriptionPlan;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder price(String price) {
            this.price = price;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder taxInclusive(boolean taxInclusive) {
            this.taxInclusive = taxInclusive;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder tiersMode(PriceEnum.TiersMode tiersMode) {
            this.tiersMode = tiersMode;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder unitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder minQuantity(double minQuantity) {
            this.minQuantity = minQuantity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder maxQuantity(double maxQuantity) {
            this.maxQuantity = maxQuantity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder priceBaseInterval(PriceEnum.PriceBaseInterval priceBaseInterval) {
            this.priceBaseInterval = priceBaseInterval;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder overage(Overage overage) {
            this.overage = overage;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder applyDiscountTo(EnumSet<ApplyDiscountTo> applyDiscountTo) {
            this.applyDiscountTo = applyDiscountTo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder discountLevel(PriceEnum.DiscountLevel discountLevel) {
            this.discountLevel = discountLevel;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder chargeModel(PriceEnum.ChargeModel chargeModel) {
            this.chargeModel = chargeModel;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder chargeType(ChargeType chargeType) {
            this.chargeType = chargeType;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder startEvent(PriceEnum.Event startEvent) {
            this.startEvent = startEvent;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder recurring(Recurring recurring) {
            this.recurring = recurring;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder tier(Tier tier) {
            if (this.tiers == null) {
                this.tiers = new ArrayList();
            }
            this.tiers.add(tier);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder tiers(Collection<? extends Tier> tiers) {
            if (tiers == null) {
                throw new NullPointerException("tiers cannot be null");
            }
            if (this.tiers == null) {
                this.tiers = new ArrayList();
            }
            this.tiers.addAll(tiers);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder clearTiers() {
            if (this.tiers != null) {
                this.tiers.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder unitAmount(Currency unitAmountKey, Double unitAmountValue) {
            if (this.unitAmounts$key == null) {
                this.unitAmounts$key = new ArrayList();
                this.unitAmounts$value = new ArrayList();
            }
            this.unitAmounts$key.add(unitAmountKey);
            this.unitAmounts$value.add(unitAmountValue);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder unitAmounts(Map<? extends Currency, ? extends Double> unitAmounts) {
            if (unitAmounts == null) {
                throw new NullPointerException("unitAmounts cannot be null");
            }
            if (this.unitAmounts$key == null) {
                this.unitAmounts$key = new ArrayList();
                this.unitAmounts$value = new ArrayList();
            }
            for (Map.Entry<? extends Currency, ? extends Double> $lombokEntry : unitAmounts.entrySet()) {
                this.unitAmounts$key.add($lombokEntry.getKey());
                this.unitAmounts$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder clearUnitAmounts() {
            if (this.unitAmounts$key != null) {
                this.unitAmounts$key.clear();
                this.unitAmounts$value.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder amount(Currency amountKey, Double amountValue) {
            if (this.amounts$key == null) {
                this.amounts$key = new ArrayList();
                this.amounts$value = new ArrayList();
            }
            this.amounts$key.add(amountKey);
            this.amounts$value.add(amountValue);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder amounts(Map<? extends Currency, ? extends Double> amounts) {
            if (amounts == null) {
                throw new NullPointerException("amounts cannot be null");
            }
            if (this.amounts$key == null) {
                this.amounts$key = new ArrayList();
                this.amounts$value = new ArrayList();
            }
            for (Map.Entry<? extends Currency, ? extends Double> $lombokEntry : amounts.entrySet()) {
                this.amounts$key.add($lombokEntry.getKey());
                this.amounts$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder clearAmounts() {
            if (this.amounts$key != null) {
                this.amounts$key.clear();
                this.amounts$value.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItemBuilder percentAmount(Double percentAmount) {
            this.percentAmount = percentAmount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionPlanItem internalBuild() {
            Map<Object, Object> amounts;
            Map<Object, Object> unitAmounts;
            List<Tier> tiers;
            switch (this.tiers == null ? 0 : this.tiers.size()) {
                case 0: {
                    tiers = Collections.emptyList();
                    break;
                }
                case 1: {
                    tiers = Collections.singletonList(this.tiers.get(0));
                    break;
                }
                default: {
                    tiers = Collections.unmodifiableList(new ArrayList<Tier>(this.tiers));
                }
            }
            switch (this.unitAmounts$key == null ? 0 : this.unitAmounts$key.size()) {
                case 0: {
                    unitAmounts = Collections.emptyMap();
                    break;
                }
                case 1: {
                    unitAmounts = Collections.singletonMap(this.unitAmounts$key.get(0), this.unitAmounts$value.get(0));
                    break;
                }
                default: {
                    unitAmounts = new LinkedHashMap(this.unitAmounts$key.size() < 0x40000000 ? 1 + this.unitAmounts$key.size() + (this.unitAmounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.unitAmounts$key.size(); ++$i) {
                        unitAmounts.put(this.unitAmounts$key.get($i), this.unitAmounts$value.get($i));
                    }
                    unitAmounts = Collections.unmodifiableMap(unitAmounts);
                }
            }
            switch (this.amounts$key == null ? 0 : this.amounts$key.size()) {
                case 0: {
                    amounts = Collections.emptyMap();
                    break;
                }
                case 1: {
                    amounts = Collections.singletonMap(this.amounts$key.get(0), this.amounts$value.get(0));
                    break;
                }
                default: {
                    amounts = new LinkedHashMap(this.amounts$key.size() < 0x40000000 ? 1 + this.amounts$key.size() + (this.amounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.amounts$key.size(); ++$i) {
                        amounts.put(this.amounts$key.get($i), this.amounts$value.get($i));
                    }
                    amounts = Collections.unmodifiableMap(amounts);
                }
            }
            return new SubscriptionPlanItem(this.id, this.name, this.invoicedThroughDate, this.description, this.done, this.endDate, this.startDate, this.number, this.processedThroughDate, this.segment, this.version, this.createdBy, this.createTime, this.updatedBy, this.updateTime, this.subscriptionPlan, this.price, this.taxInclusive, this.tiersMode, this.unitOfMeasure, this.minQuantity, this.maxQuantity, this.priceBaseInterval, this.overage, this.applyDiscountTo, this.discountLevel, this.chargeModel, this.chargeType, this.startEvent, this.recurring, tiers, this.quantity, unitAmounts, amounts, this.percentAmount);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SubscriptionPlanItem.SubscriptionPlanItemBuilder(id=" + this.id + ", name=" + this.name + ", invoicedThroughDate=" + this.invoicedThroughDate + ", description=" + this.description + ", done=" + this.done + ", endDate=" + this.endDate + ", startDate=" + this.startDate + ", number=" + this.number + ", processedThroughDate=" + this.processedThroughDate + ", segment=" + this.segment + ", version=" + this.version + ", createdBy=" + this.createdBy + ", createTime=" + this.createTime + ", updatedBy=" + this.updatedBy + ", updateTime=" + this.updateTime + ", subscriptionPlan=" + this.subscriptionPlan + ", price=" + this.price + ", taxInclusive=" + this.taxInclusive + ", tiersMode=" + (Object)((Object)this.tiersMode) + ", unitOfMeasure=" + this.unitOfMeasure + ", minQuantity=" + this.minQuantity + ", maxQuantity=" + this.maxQuantity + ", priceBaseInterval=" + (Object)((Object)this.priceBaseInterval) + ", overage=" + this.overage + ", applyDiscountTo=" + this.applyDiscountTo + ", discountLevel=" + (Object)((Object)this.discountLevel) + ", chargeModel=" + (Object)((Object)this.chargeModel) + ", chargeType=" + this.chargeType + ", startEvent=" + (Object)((Object)this.startEvent) + ", recurring=" + this.recurring + ", tiers=" + this.tiers + ", quantity=" + this.quantity + ", unitAmounts$key=" + this.unitAmounts$key + ", unitAmounts$value=" + this.unitAmounts$value + ", amounts$key=" + this.amounts$key + ", amounts$value=" + this.amounts$value + ", percentAmount=" + this.percentAmount + ")";
        }
    }
}

