/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.AmountsMapper;
import com.zuora.sdk.EnumMapper;
import com.zuora.sdk.Price;
import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.Recurring;
import com.zuora.sdk.TierMapper;
import com.zuora.sdk.internal.ProductRatePlanChargesQuery;
import com.zuora.sdk.internal.apis.data.ProxyCreateOrModifyProductRatePlanChargeTierData;
import com.zuora.sdk.internal.models.ZProductRatePlanCharge;
import com.zuora.sdk.internal.models.enums.ChargeType;
import com.zuora.sdk.internal.models.enums.EndDateCondition;
import com.zuora.sdk.internal.models.enums.OverageCalculationOption;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import org.mapstruct.AfterMapping;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE, uses={TierMapper.class, EnumMapper.class})
abstract class PriceMapper {
    PriceMapper() {
    }

    @Mappings(value={@Mapping(source="price.taxInclusive", target="taxMode"), @Mapping(source="price.startEvent", target="triggerEvent"), @Mapping(source="price.recognizedRevenueAccountingCode", target="recognizedRevenueAccount"), @Mapping(source="price.deferredRevenueAccountingCode", target="deferredRevenueAccount"), @Mapping(source="price.unitOfMeasure", target="uOM"), @Mapping(source="price", target="productRatePlanChargeTierData.productRatePlanChargeTier"), @Mapping(source="price.quantity", target="defaultQuantity"), @Mapping(source="price.plan", target="productRatePlanId"), @Mapping(source="price.recurring", target="endDateCondition"), @Mapping(source="price.recurring.durationIntervalCount", target="upToPeriods"), @Mapping(source="price.recurring.durationInterval", target="upToPeriodsType"), @Mapping(source="price.recurring.ratingGroup", target="ratingGroup"), @Mapping(source="price.recurring.timing", target="billingTiming"), @Mapping(source="price.recurring.interval", target="billingPeriod"), @Mapping(source="price.recurring.intervalCount", target="specificBillingPeriod"), @Mapping(source="price.recurring.on", target="billCycleType"), @Mapping(source="price.recurring.on", target="billCycleDay", resultType=Integer.class), @Mapping(source="price.recurring.on", target="weeklyBillCycleDay"), @Mapping(source="price.recurring.alignment", target="billingPeriodAlignment"), @Mapping(source="price.priceBaseInterval", target="listPriceBase"), @Mapping(source="price.customFields", target="productRatePlanChargeObjectCustomFields"), @Mapping(source="price.overage.intervalCount", target="numberOfPeriod"), @Mapping(source="price.overage.applyAtEndOfSmoothingPeriod", target="overageCalculationOption"), @Mapping(source="price.overage.creditUnusedUnits", target="overageUnusedUnitsCreditOption"), @Mapping(source="price.overage.includedUnits", target="includedUnits"), @Mapping(source="price.overage.type", target="smoothingModel")})
    abstract ZProductRatePlanCharge.Builder toApi(PriceCreateRequest var1);

    @AfterMapping
    protected void afterMapping(@MappingTarget ZProductRatePlanCharge.Builder result, PriceCreateRequest price) {
        AmountsMapper amountsMapper = new AmountsMapper();
        result.productRatePlanChargeTierData(new ProxyCreateOrModifyProductRatePlanChargeTierData().productRatePlanChargeTier(amountsMapper.mapAmountsToZPRCTier(price)));
        if ((price.getChargeModel().equals((Object)PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT) || price.getChargeModel().equals((Object)PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE)) && (price.getDeferredRevenueAccountingCode() != null || price.getRecognizedRevenueAccountingCode() != null)) {
            result.useDiscountSpecificAccountingCode(Boolean.valueOf(true));
        }
    }

    @InheritConfiguration(name="toApi")
    abstract void toApi(@MappingTarget ZProductRatePlanCharge.Builder var1, Price var2);

    @Mappings(value={@Mapping(target="taxInclusive", source="taxMode"), @Mapping(target="startEvent", source="triggerEvent"), @Mapping(target="recognizedRevenueAccountingCode", source="recognizedRevenueAccountingCode.name"), @Mapping(target="deferredRevenueAccountingCode", source="deferredRevenueAccountingCode.name"), @Mapping(target="unitOfMeasure", source="UOM"), @Mapping(target="tiers", source="productRatePlanCharge"), @Mapping(target="quantity", source="defaultQuantity"), @Mapping(target="plan", source="productRatePlanId"), @Mapping(target="recurring.alignment", source="billingPeriodAlignment"), @Mapping(target="recurring.durationIntervalCount", source="upToPeriods", resultType=Integer.class), @Mapping(target="recurring.durationInterval", source="upToPeriodsType"), @Mapping(target="recurring.ratingGroup", source="ratingGroup"), @Mapping(target="recurring.interval", source="billingPeriod"), @Mapping(target="recurring.intervalCount", source="specificBillingPeriod"), @Mapping(target="recurring.on", source="productRatePlanCharge"), @Mapping(target="recurring.timing", source="billingTiming"), @Mapping(target="priceBaseInterval", source="listPriceBase"), @Mapping(target="overage.intervalCount", source="numberOfPeriod"), @Mapping(target="overage.applyAtEndOfSmoothingPeriod", source="overageCalculationOption"), @Mapping(target="overage.creditUnusedUnits", source="overageUnusedUnitsCreditOption"), @Mapping(target="overage.includedUnits", source="includedUnits"), @Mapping(target="overage.type", source="smoothingModel"), @Mapping(source="createdDate", target="createTime"), @Mapping(source="updatedDate", target="updateTime"), @Mapping(source="createdById", target="createdBy"), @Mapping(source="updatedById", target="updatedBy")})
    abstract Price fromApi(ProductRatePlanChargesQuery.Node var1);

    @AfterMapping
    protected void updateFields(@MappingTarget Price.PriceBuilder result, ProductRatePlanChargesQuery.Node productRatePlanCharge) {
        Price priceRef = result.build();
        ChargeType chargeType = priceRef.getChargeType();
        if (chargeType.equals((Object)ChargeType.ONE_TIME)) {
            result.recurring(null);
        }
        if (chargeType.equals((Object)ChargeType.USAGE)) {
            result.recurring(priceRef.getRecurring().toBuilder().usage(true).build());
        }
        PriceEnum.ChargeModel chargeModel = result.build().getChargeModel();
        if (productRatePlanCharge.getProductrateplanchargetiers() != null && chargeModel != null) {
            TierMapper tierMapper = new TierMapper();
            List<ProductRatePlanChargesQuery.Edge1> tiers = productRatePlanCharge.getProductrateplanchargetiers().getEdges();
            Map<Currency, Double> amounts = tierMapper.mapProductRatePlanChargeAmountsToPrice(tiers, chargeModel);
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.OVERAGE)) {
                boolean applyAtEndOfSmoothingPeriod = false;
                if (productRatePlanCharge.getOverageCalculationOption() != null) {
                    applyAtEndOfSmoothingPeriod = productRatePlanCharge.getOverageCalculationOption().equals(OverageCalculationOption.END_OF_SMOOTHING_PERIOD.getApiValue());
                }
                result.unitAmounts(amounts).overage(priceRef.getOverage().toBuilder().applyAtEndOfSmoothingPeriod(applyAtEndOfSmoothingPeriod).build());
                return;
            }
            result.overage(null);
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.PER_UNIT) || chargeModel.equals((Object)PriceEnum.ChargeModel.TIERED_WITH_OVERAGE)) {
                result.unitAmounts(amounts);
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.FLAT_FEE) || chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT)) {
                result.amounts(amounts);
                return;
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE)) {
                amounts.values().stream().filter(aDouble -> !aDouble.equals(0.0)).forEach(result::percentAmount);
                return;
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.PER_UNIT)) {
                result.unitAmounts(amounts);
            }
        }
    }

    Integer map(Object value) {
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value.toString());
    }

    PriceEnum.RecurringOn toRecurringOn(ProductRatePlanChargesQuery.Node productRatePlanCharge) {
        if (productRatePlanCharge.getChargeType().equals(ChargeType.ONE_TIME.getApiValue())) {
            return null;
        }
        return ((EnumMapper)Mappers.getMapper(EnumMapper.class)).map(productRatePlanCharge.getBillCycleType(), productRatePlanCharge.getWeeklyBillCycleDay(), productRatePlanCharge.getBillCycleDay());
    }

    EndDateCondition mapEndDate(Recurring recurring) {
        if (recurring == null) {
            return null;
        }
        return recurring.getDurationInterval() == null ? EndDateCondition.SUBSCRIPTION_END : EndDateCondition.FIXED_PERIOD;
    }
}

