/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.enums;

import com.google.common.base.Strings;
import com.zuora.sdk.internal.exceptions.InvalidRequestException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public enum PaymentMethodType {
    PAYPAL_EXPRESS("PayPalEC"),
    PAYPAL_EXPRESS_NATIVE("PayPalNativeEC"),
    PAYPAL_ADAPTIVE("PayPalAdaptive"),
    CARD("CreditCard"),
    ACH_DEBIT("ACH"),
    SEPA_DEBIT("SEPA"),
    BETALINGS_DEBIT("Betalingsservice"),
    AUTOGIRO_DEBIT("Autogiro"),
    BACS_DEBIT("Bacs"),
    AU_BECS_DEBIT("Bacs"),
    NZ_BECS_DEBIT("Becs"),
    PAD_DEBIT("Becsnz"),
    APPLE_PAY("ApplePay");

    private final String apiValue;

    public static PaymentMethodType fromApi(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        for (PaymentMethodType v : PaymentMethodType.values()) {
            if (!v.apiValue.equals(value)) continue;
            return v;
        }
        throw InvalidRequestException.builder().addViolation(InvalidRequestException.Reason.InvalidValue, "MitProfileType", "invalid value " + value).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private PaymentMethodType(String apiValue) {
        this.apiValue = apiValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getApiValue() {
        return this.apiValue;
    }
}

