/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.EnumMapper;
import com.zuora.sdk.OverageType;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.enums.RatingGroup;
import com.zuora.sdk.internal.models.enums.BillCycleType;
import com.zuora.sdk.internal.models.enums.BillingPeriodAlignment;
import com.zuora.sdk.internal.models.enums.BillingPeriodType;
import com.zuora.sdk.internal.models.enums.BillingTiming;
import com.zuora.sdk.internal.models.enums.ChargeModel;
import com.zuora.sdk.internal.models.enums.ChargeType;
import com.zuora.sdk.internal.models.enums.DiscountLevel;
import com.zuora.sdk.internal.models.enums.ListPriceBase;
import com.zuora.sdk.internal.models.enums.TriggerEvent;
import com.zuora.sdk.internal.models.enums.UpToPeriodsType;
import com.zuora.sdk.internal.models.enums.WeeklyBillCycleDay;

class EnumMapperImpl
extends EnumMapper {
    EnumMapperImpl() {
    }

    @Override
    ChargeModel map(PriceEnum.ChargeModel chargeModel) {
        ChargeModel chargeModel1;
        if (chargeModel == null) {
            return null;
        }
        switch (chargeModel) {
            case HIGH_WATERMARK_VOLUME: {
                chargeModel1 = ChargeModel.HIGH_WATERMARK_VOLUME_PRICING;
                break;
            }
            case HIGH_WATERMARK_TIERED: {
                chargeModel1 = ChargeModel.HIGHWATERMARKTIEREDPRICING;
                break;
            }
            case DISCOUNT_FIXED_AMOUNT: {
                chargeModel1 = ChargeModel.DISCOUNT_FIXED_AMOUNT;
                break;
            }
            case DISCOUNT_PERCENTAGE: {
                chargeModel1 = ChargeModel.DISCOUNT_PERCENTAGE;
                break;
            }
            case FLAT_FEE: {
                chargeModel1 = ChargeModel.FLAT_FEE;
                break;
            }
            case PER_UNIT: {
                chargeModel1 = ChargeModel.PER_UNIT;
                break;
            }
            case OVERAGE: {
                chargeModel1 = ChargeModel.OVERAGE;
                break;
            }
            case TIERED: {
                chargeModel1 = ChargeModel.TIERED;
                break;
            }
            case TIERED_WITH_OVERAGE: {
                chargeModel1 = ChargeModel.TIERED_WITH_OVERAGE;
                break;
            }
            case VOLUME: {
                chargeModel1 = ChargeModel.VOLUME;
                break;
            }
            case CUSTOM_CHARGE_MODEL: {
                chargeModel1 = ChargeModel.CUSTOM_CHARGE_MODEL;
                break;
            }
            case MULTI_ATTRIBUTE_PRICING: {
                chargeModel1 = ChargeModel.MULTI_ATTRIBUTE_PRICING;
                break;
            }
            case PRERATED_PER_UNIT: {
                chargeModel1 = ChargeModel.PRERATED_PER_UNIT;
                break;
            }
            case PRERATED_PRICING: {
                chargeModel1 = ChargeModel.PRERATED_PRICING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)chargeModel));
            }
        }
        return chargeModel1;
    }

    @Override
    UpToPeriodsType map(PriceEnum.DurationInterval durationInterval) {
        UpToPeriodsType upToPeriodsType;
        if (durationInterval == null) {
            return UpToPeriodsType.BILLING_PERIODS;
        }
        switch (durationInterval) {
            case DAY: {
                upToPeriodsType = UpToPeriodsType.DAYS;
                break;
            }
            case WEEK: {
                upToPeriodsType = UpToPeriodsType.WEEKS;
                break;
            }
            case MONTH: {
                upToPeriodsType = UpToPeriodsType.MONTHS;
                break;
            }
            case YEAR: {
                upToPeriodsType = UpToPeriodsType.YEARS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)durationInterval));
            }
        }
        return upToPeriodsType;
    }

    @Override
    PriceEnum.DurationInterval map(String upToPeriodsType) {
        PriceEnum.DurationInterval durationInterval;
        if (upToPeriodsType == null) {
            return null;
        }
        switch (upToPeriodsType) {
            case "Days": {
                durationInterval = PriceEnum.DurationInterval.DAY;
                break;
            }
            case "Weeks": {
                durationInterval = PriceEnum.DurationInterval.WEEK;
                break;
            }
            case "Months": {
                durationInterval = PriceEnum.DurationInterval.MONTH;
                break;
            }
            case "Years": {
                durationInterval = PriceEnum.DurationInterval.YEAR;
                break;
            }
            case "DAY": {
                durationInterval = PriceEnum.DurationInterval.DAY;
                break;
            }
            case "WEEK": {
                durationInterval = PriceEnum.DurationInterval.WEEK;
                break;
            }
            case "MONTH": {
                durationInterval = PriceEnum.DurationInterval.MONTH;
                break;
            }
            case "YEAR": {
                durationInterval = PriceEnum.DurationInterval.YEAR;
                break;
            }
            default: {
                durationInterval = null;
            }
        }
        return durationInterval;
    }

    @Override
    BillingPeriodAlignment map(PriceEnum.Alignment alignment) {
        BillingPeriodAlignment billingPeriodAlignment;
        if (alignment == null) {
            return null;
        }
        switch (alignment) {
            case SUBSCRIPTION_START: {
                billingPeriodAlignment = BillingPeriodAlignment.ALIGN_TO_SUBSCRIPTION_START;
                break;
            }
            case TERM_START: {
                billingPeriodAlignment = BillingPeriodAlignment.ALIGN_TO_TERM_START;
                break;
            }
            case SUBSCRIPTION_PLAN_ITEM: {
                billingPeriodAlignment = BillingPeriodAlignment.ALIGN_TO_CHARGE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)alignment));
            }
        }
        return billingPeriodAlignment;
    }

    @Override
    PriceEnum.Alignment mapAlignment(String billingPeriodAlignment) {
        PriceEnum.Alignment alignment;
        if (billingPeriodAlignment == null) {
            return null;
        }
        switch (billingPeriodAlignment) {
            case "AlignToSubscriptionStart": {
                alignment = PriceEnum.Alignment.SUBSCRIPTION_START;
                break;
            }
            case "AlignToTermStart": {
                alignment = PriceEnum.Alignment.TERM_START;
                break;
            }
            case "AlignToCharge": {
                alignment = PriceEnum.Alignment.SUBSCRIPTION_PLAN_ITEM;
                break;
            }
            case "SUBSCRIPTION_START": {
                alignment = PriceEnum.Alignment.SUBSCRIPTION_START;
                break;
            }
            case "TERM_START": {
                alignment = PriceEnum.Alignment.TERM_START;
                break;
            }
            case "SUBSCRIPTION_PLAN_ITEM": {
                alignment = PriceEnum.Alignment.SUBSCRIPTION_PLAN_ITEM;
                break;
            }
            default: {
                alignment = PriceEnum.Alignment.SUBSCRIPTION_PLAN_ITEM;
            }
        }
        return alignment;
    }

    @Override
    BillingPeriodType map(PriceEnum.Interval interval) {
        BillingPeriodType billingPeriodType;
        if (interval == null) {
            return null;
        }
        switch (interval) {
            case YEAR: {
                billingPeriodType = BillingPeriodType.ANNUAL;
                break;
            }
            case SPECIFIC_MONTH: {
                billingPeriodType = BillingPeriodType.SPECIFIC_MONTHS;
                break;
            }
            case SPECIFIC_WEEK: {
                billingPeriodType = BillingPeriodType.SPECIFIC_WEEKS;
                break;
            }
            case WEEK: {
                billingPeriodType = BillingPeriodType.WEEK;
                break;
            }
            case MONTH: {
                billingPeriodType = BillingPeriodType.MONTH;
                break;
            }
            case QUARTER: {
                billingPeriodType = BillingPeriodType.QUARTER;
                break;
            }
            case SUBSCRIPTION_TERM: {
                billingPeriodType = BillingPeriodType.SUBSCRIPTION_TERM;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)interval));
            }
        }
        return billingPeriodType;
    }

    @Override
    DiscountLevel map(PriceEnum.DiscountLevel discountLevel) {
        DiscountLevel discountLevel1;
        if (discountLevel == null) {
            return null;
        }
        switch (discountLevel) {
            case PLAN: {
                discountLevel1 = DiscountLevel.RATE_PLAN;
                break;
            }
            case ACCOUNT: {
                discountLevel1 = DiscountLevel.ACCOUNT;
                break;
            }
            case SUBSCRIPTION: {
                discountLevel1 = DiscountLevel.SUBSCRIPTION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)discountLevel));
            }
        }
        return discountLevel1;
    }

    @Override
    PriceEnum.DiscountLevel fromDiscountLevel(String discountLevel) {
        PriceEnum.DiscountLevel discountLevel1;
        if (discountLevel == null) {
            return null;
        }
        switch (discountLevel) {
            case "rateplan": {
                discountLevel1 = PriceEnum.DiscountLevel.PLAN;
                break;
            }
            case "subscription": {
                discountLevel1 = PriceEnum.DiscountLevel.SUBSCRIPTION;
                break;
            }
            case "account": {
                discountLevel1 = PriceEnum.DiscountLevel.ACCOUNT;
                break;
            }
            case "PLAN": {
                discountLevel1 = PriceEnum.DiscountLevel.PLAN;
                break;
            }
            case "SUBSCRIPTION": {
                discountLevel1 = PriceEnum.DiscountLevel.SUBSCRIPTION;
                break;
            }
            case "ACCOUNT": {
                discountLevel1 = PriceEnum.DiscountLevel.ACCOUNT;
                break;
            }
            default: {
                discountLevel1 = null;
            }
        }
        return discountLevel1;
    }

    @Override
    PriceEnum.DiscountLevel map(DiscountLevel discountLevel) {
        PriceEnum.DiscountLevel discountLevel1;
        if (discountLevel == null) {
            return null;
        }
        switch (discountLevel) {
            case RATE_PLAN: {
                discountLevel1 = PriceEnum.DiscountLevel.PLAN;
                break;
            }
            case ACCOUNT: {
                discountLevel1 = PriceEnum.DiscountLevel.ACCOUNT;
                break;
            }
            case SUBSCRIPTION: {
                discountLevel1 = PriceEnum.DiscountLevel.SUBSCRIPTION;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + discountLevel);
            }
        }
        return discountLevel1;
    }

    @Override
    PriceEnum.Interval mapBillingPeriodType(String billingPeriod) {
        PriceEnum.Interval interval;
        if (billingPeriod == null) {
            return null;
        }
        switch (billingPeriod) {
            case "Month": {
                interval = PriceEnum.Interval.MONTH;
                break;
            }
            case "Quarter": {
                interval = PriceEnum.Interval.QUARTER;
                break;
            }
            case "Annual": {
                interval = PriceEnum.Interval.YEAR;
                break;
            }
            case "Semi-Annual": {
                interval = PriceEnum.Interval.MONTH;
                break;
            }
            case "Specific Months": {
                interval = PriceEnum.Interval.SPECIFIC_MONTH;
                break;
            }
            case "Subscription Term": {
                interval = PriceEnum.Interval.SUBSCRIPTION_TERM;
                break;
            }
            case "Week": {
                interval = PriceEnum.Interval.WEEK;
                break;
            }
            case "Specific Weeks": {
                interval = PriceEnum.Interval.SPECIFIC_WEEK;
                break;
            }
            case "WEEK": {
                interval = PriceEnum.Interval.WEEK;
                break;
            }
            case "MONTH": {
                interval = PriceEnum.Interval.MONTH;
                break;
            }
            case "QUARTER": {
                interval = PriceEnum.Interval.QUARTER;
                break;
            }
            case "YEAR": {
                interval = PriceEnum.Interval.YEAR;
                break;
            }
            case "SUBSCRIPTION_TERM": {
                interval = PriceEnum.Interval.SUBSCRIPTION_TERM;
                break;
            }
            case "SPECIFIC_MONTH": {
                interval = PriceEnum.Interval.SPECIFIC_MONTH;
                break;
            }
            case "SPECIFIC_WEEK": {
                interval = PriceEnum.Interval.SPECIFIC_WEEK;
                break;
            }
            default: {
                interval = null;
            }
        }
        return interval;
    }

    @Override
    BillCycleType mapTo(PriceEnum.RecurringOn on) {
        BillCycleType billCycleType;
        if (on == null) {
            return null;
        }
        switch (on) {
            case ACCOUNT_CYCLE_DATE: {
                billCycleType = BillCycleType.DEFAULT_FROM_CUSTOMER;
                break;
            }
            case SUBSCRIPTION_START_DAY: {
                billCycleType = BillCycleType.SUBSCRIPTION_STAR_TDAY;
                break;
            }
            case SUBSCRIPTION_PLAN_ITEM_DAY: {
                billCycleType = BillCycleType.CHARGE_TRIGGER_DAY;
                break;
            }
            case MONDAY: {
                billCycleType = BillCycleType.SPECIFIC_DAY_OF_WEEK;
                break;
            }
            case TUESDAY: {
                billCycleType = BillCycleType.SPECIFIC_DAY_OF_WEEK;
                break;
            }
            case WEDNESDAY: {
                billCycleType = BillCycleType.SPECIFIC_DAY_OF_WEEK;
                break;
            }
            case THURSDAY: {
                billCycleType = BillCycleType.SPECIFIC_DAY_OF_WEEK;
                break;
            }
            case FRIDAY: {
                billCycleType = BillCycleType.SPECIFIC_DAY_OF_WEEK;
                break;
            }
            case SATURDAY: {
                billCycleType = BillCycleType.SPECIFIC_DAY_OF_WEEK;
                break;
            }
            case SUNDAY: {
                billCycleType = BillCycleType.SPECIFIC_DAY_OF_WEEK;
                break;
            }
            default: {
                billCycleType = BillCycleType.SPECIFIC_DAY_OF_MONTH;
            }
        }
        return billCycleType;
    }

    @Override
    PriceEnum.RecurringOn mapFrom(BillCycleType billCycleType) {
        PriceEnum.RecurringOn recurringOn;
        if (billCycleType == null) {
            return null;
        }
        switch (billCycleType) {
            case DEFAULT_FROM_CUSTOMER: {
                recurringOn = PriceEnum.RecurringOn.ACCOUNT_CYCLE_DATE;
                break;
            }
            case SUBSCRIPTION_STAR_TDAY: {
                recurringOn = PriceEnum.RecurringOn.SUBSCRIPTION_START_DAY;
                break;
            }
            case CHARGE_TRIGGER_DAY: {
                recurringOn = PriceEnum.RecurringOn.SUBSCRIPTION_PLAN_ITEM_DAY;
                break;
            }
            default: {
                recurringOn = null;
            }
        }
        return recurringOn;
    }

    @Override
    PriceEnum.RecurringOn mapSpecificWeek(String specificDayOfWeek) {
        PriceEnum.RecurringOn recurringOn;
        if (specificDayOfWeek == null) {
            return null;
        }
        switch (specificDayOfWeek) {
            case "Monday": {
                recurringOn = PriceEnum.RecurringOn.MONDAY;
                break;
            }
            case "Tuesday": {
                recurringOn = PriceEnum.RecurringOn.TUESDAY;
                break;
            }
            case "Wednesday": {
                recurringOn = PriceEnum.RecurringOn.WEDNESDAY;
                break;
            }
            case "Thursday": {
                recurringOn = PriceEnum.RecurringOn.THURSDAY;
                break;
            }
            case "Friday": {
                recurringOn = PriceEnum.RecurringOn.FRIDAY;
                break;
            }
            case "Saturday": {
                recurringOn = PriceEnum.RecurringOn.SATURDAY;
                break;
            }
            case "Sunday": {
                recurringOn = PriceEnum.RecurringOn.SUNDAY;
                break;
            }
            case "ACCOUNT_CYCLE_DATE": {
                recurringOn = PriceEnum.RecurringOn.ACCOUNT_CYCLE_DATE;
                break;
            }
            case "SUBSCRIPTION_START_DAY": {
                recurringOn = PriceEnum.RecurringOn.SUBSCRIPTION_START_DAY;
                break;
            }
            case "SUBSCRIPTION_PLAN_ITEM_DAY": {
                recurringOn = PriceEnum.RecurringOn.SUBSCRIPTION_PLAN_ITEM_DAY;
                break;
            }
            case "MONDAY": {
                recurringOn = PriceEnum.RecurringOn.MONDAY;
                break;
            }
            case "TUESDAY": {
                recurringOn = PriceEnum.RecurringOn.TUESDAY;
                break;
            }
            case "WEDNESDAY": {
                recurringOn = PriceEnum.RecurringOn.WEDNESDAY;
                break;
            }
            case "THURSDAY": {
                recurringOn = PriceEnum.RecurringOn.THURSDAY;
                break;
            }
            case "FRIDAY": {
                recurringOn = PriceEnum.RecurringOn.FRIDAY;
                break;
            }
            case "SATURDAY": {
                recurringOn = PriceEnum.RecurringOn.SATURDAY;
                break;
            }
            case "SUNDAY": {
                recurringOn = PriceEnum.RecurringOn.SUNDAY;
                break;
            }
            case "_1": {
                recurringOn = PriceEnum.RecurringOn._1;
                break;
            }
            case "_2": {
                recurringOn = PriceEnum.RecurringOn._2;
                break;
            }
            case "_3": {
                recurringOn = PriceEnum.RecurringOn._3;
                break;
            }
            case "_4": {
                recurringOn = PriceEnum.RecurringOn._4;
                break;
            }
            case "_5": {
                recurringOn = PriceEnum.RecurringOn._5;
                break;
            }
            case "_6": {
                recurringOn = PriceEnum.RecurringOn._6;
                break;
            }
            case "_7": {
                recurringOn = PriceEnum.RecurringOn._7;
                break;
            }
            case "_8": {
                recurringOn = PriceEnum.RecurringOn._8;
                break;
            }
            case "_9": {
                recurringOn = PriceEnum.RecurringOn._9;
                break;
            }
            case "_10": {
                recurringOn = PriceEnum.RecurringOn._10;
                break;
            }
            case "_11": {
                recurringOn = PriceEnum.RecurringOn._11;
                break;
            }
            case "_12": {
                recurringOn = PriceEnum.RecurringOn._12;
                break;
            }
            case "_13": {
                recurringOn = PriceEnum.RecurringOn._13;
                break;
            }
            case "_14": {
                recurringOn = PriceEnum.RecurringOn._14;
                break;
            }
            case "_15": {
                recurringOn = PriceEnum.RecurringOn._15;
                break;
            }
            case "_16": {
                recurringOn = PriceEnum.RecurringOn._16;
                break;
            }
            case "_17": {
                recurringOn = PriceEnum.RecurringOn._17;
                break;
            }
            case "_18": {
                recurringOn = PriceEnum.RecurringOn._18;
                break;
            }
            case "_19": {
                recurringOn = PriceEnum.RecurringOn._19;
                break;
            }
            case "_20": {
                recurringOn = PriceEnum.RecurringOn._20;
                break;
            }
            case "_21": {
                recurringOn = PriceEnum.RecurringOn._21;
                break;
            }
            case "_22": {
                recurringOn = PriceEnum.RecurringOn._22;
                break;
            }
            case "_23": {
                recurringOn = PriceEnum.RecurringOn._23;
                break;
            }
            case "_24": {
                recurringOn = PriceEnum.RecurringOn._24;
                break;
            }
            case "_25": {
                recurringOn = PriceEnum.RecurringOn._25;
                break;
            }
            case "_26": {
                recurringOn = PriceEnum.RecurringOn._26;
                break;
            }
            case "_27": {
                recurringOn = PriceEnum.RecurringOn._27;
                break;
            }
            case "_28": {
                recurringOn = PriceEnum.RecurringOn._28;
                break;
            }
            case "_29": {
                recurringOn = PriceEnum.RecurringOn._29;
                break;
            }
            case "_30": {
                recurringOn = PriceEnum.RecurringOn._30;
                break;
            }
            case "_31": {
                recurringOn = PriceEnum.RecurringOn._31;
                break;
            }
            default: {
                recurringOn = null;
            }
        }
        return recurringOn;
    }

    @Override
    PriceEnum.RecurringOn mapSpecificDayOfMonth(String specificDay) {
        PriceEnum.RecurringOn recurringOn;
        if (specificDay == null) {
            return null;
        }
        switch (specificDay) {
            case "1": {
                recurringOn = PriceEnum.RecurringOn._1;
                break;
            }
            case "2": {
                recurringOn = PriceEnum.RecurringOn._2;
                break;
            }
            case "3": {
                recurringOn = PriceEnum.RecurringOn._3;
                break;
            }
            case "4": {
                recurringOn = PriceEnum.RecurringOn._4;
                break;
            }
            case "5": {
                recurringOn = PriceEnum.RecurringOn._5;
                break;
            }
            case "6": {
                recurringOn = PriceEnum.RecurringOn._6;
                break;
            }
            case "7": {
                recurringOn = PriceEnum.RecurringOn._7;
                break;
            }
            case "8": {
                recurringOn = PriceEnum.RecurringOn._8;
                break;
            }
            case "9": {
                recurringOn = PriceEnum.RecurringOn._9;
                break;
            }
            case "10": {
                recurringOn = PriceEnum.RecurringOn._10;
                break;
            }
            case "11": {
                recurringOn = PriceEnum.RecurringOn._11;
                break;
            }
            case "12": {
                recurringOn = PriceEnum.RecurringOn._12;
                break;
            }
            case "13": {
                recurringOn = PriceEnum.RecurringOn._13;
                break;
            }
            case "14": {
                recurringOn = PriceEnum.RecurringOn._14;
                break;
            }
            case "15": {
                recurringOn = PriceEnum.RecurringOn._15;
                break;
            }
            case "16": {
                recurringOn = PriceEnum.RecurringOn._16;
                break;
            }
            case "17": {
                recurringOn = PriceEnum.RecurringOn._17;
                break;
            }
            case "18": {
                recurringOn = PriceEnum.RecurringOn._18;
                break;
            }
            case "19": {
                recurringOn = PriceEnum.RecurringOn._19;
                break;
            }
            case "20": {
                recurringOn = PriceEnum.RecurringOn._20;
                break;
            }
            case "21": {
                recurringOn = PriceEnum.RecurringOn._21;
                break;
            }
            case "22": {
                recurringOn = PriceEnum.RecurringOn._22;
                break;
            }
            case "23": {
                recurringOn = PriceEnum.RecurringOn._23;
                break;
            }
            case "24": {
                recurringOn = PriceEnum.RecurringOn._24;
                break;
            }
            case "25": {
                recurringOn = PriceEnum.RecurringOn._25;
                break;
            }
            case "26": {
                recurringOn = PriceEnum.RecurringOn._26;
                break;
            }
            case "27": {
                recurringOn = PriceEnum.RecurringOn._27;
                break;
            }
            case "28": {
                recurringOn = PriceEnum.RecurringOn._28;
                break;
            }
            case "29": {
                recurringOn = PriceEnum.RecurringOn._29;
                break;
            }
            case "30": {
                recurringOn = PriceEnum.RecurringOn._30;
                break;
            }
            case "31": {
                recurringOn = PriceEnum.RecurringOn._31;
                break;
            }
            default: {
                recurringOn = null;
            }
        }
        return recurringOn;
    }

    @Override
    String mapToSpecificDayOfMonth(PriceEnum.RecurringOn on) {
        String string;
        if (on == null) {
            return null;
        }
        switch (on) {
            case _1: {
                string = "1";
                break;
            }
            case _2: {
                string = "2";
                break;
            }
            case _3: {
                string = "3";
                break;
            }
            case _4: {
                string = "4";
                break;
            }
            case _5: {
                string = "5";
                break;
            }
            case _6: {
                string = "6";
                break;
            }
            case _7: {
                string = "7";
                break;
            }
            case _8: {
                string = "8";
                break;
            }
            case _9: {
                string = "9";
                break;
            }
            case _10: {
                string = "10";
                break;
            }
            case _11: {
                string = "11";
                break;
            }
            case _12: {
                string = "12";
                break;
            }
            case _13: {
                string = "13";
                break;
            }
            case _14: {
                string = "14";
                break;
            }
            case _15: {
                string = "15";
                break;
            }
            case _16: {
                string = "16";
                break;
            }
            case _17: {
                string = "17";
                break;
            }
            case _18: {
                string = "18";
                break;
            }
            case _19: {
                string = "19";
                break;
            }
            case _20: {
                string = "20";
                break;
            }
            case _21: {
                string = "21";
                break;
            }
            case _22: {
                string = "22";
                break;
            }
            case _23: {
                string = "23";
                break;
            }
            case _24: {
                string = "24";
                break;
            }
            case _25: {
                string = "25";
                break;
            }
            case _26: {
                string = "26";
                break;
            }
            case _27: {
                string = "27";
                break;
            }
            case _28: {
                string = "28";
                break;
            }
            case _29: {
                string = "29";
                break;
            }
            case _30: {
                string = "30";
                break;
            }
            case _31: {
                string = "31";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @Override
    WeeklyBillCycleDay mapToWeeklyBillCycleDay(PriceEnum.RecurringOn on) {
        WeeklyBillCycleDay weeklyBillCycleDay;
        if (on == null) {
            return null;
        }
        switch (on) {
            case MONDAY: {
                weeklyBillCycleDay = WeeklyBillCycleDay.MONDAY;
                break;
            }
            case TUESDAY: {
                weeklyBillCycleDay = WeeklyBillCycleDay.TUESDAY;
                break;
            }
            case WEDNESDAY: {
                weeklyBillCycleDay = WeeklyBillCycleDay.WEDNESDAY;
                break;
            }
            case THURSDAY: {
                weeklyBillCycleDay = WeeklyBillCycleDay.THURSDAY;
                break;
            }
            case FRIDAY: {
                weeklyBillCycleDay = WeeklyBillCycleDay.FRIDAY;
                break;
            }
            case SATURDAY: {
                weeklyBillCycleDay = WeeklyBillCycleDay.SATURDAY;
                break;
            }
            case SUNDAY: {
                weeklyBillCycleDay = WeeklyBillCycleDay.SUNDAY;
                break;
            }
            default: {
                weeklyBillCycleDay = null;
            }
        }
        return weeklyBillCycleDay;
    }

    @Override
    BillingTiming mapBillingTiming(String billingTiming) {
        BillingTiming billingTiming1;
        if (billingTiming == null) {
            return null;
        }
        switch (billingTiming) {
            case "In Advance": {
                billingTiming1 = BillingTiming.IN_ADVANCE;
                break;
            }
            case "In Arrears": {
                billingTiming1 = BillingTiming.IN_ARREARS;
                break;
            }
            case "IN_ADVANCE": {
                billingTiming1 = BillingTiming.IN_ADVANCE;
                break;
            }
            case "IN_ARREARS": {
                billingTiming1 = BillingTiming.IN_ARREARS;
                break;
            }
            default: {
                billingTiming1 = null;
            }
        }
        return billingTiming1;
    }

    @Override
    TriggerEvent mapTriggerEvent(PriceEnum.Event triggerEvent) {
        TriggerEvent triggerEvent1;
        if (triggerEvent == null) {
            return null;
        }
        switch (triggerEvent) {
            case CONTRACT_EFFECTIVE: {
                triggerEvent1 = TriggerEvent.CONTRACT_EFFECTIVE;
                break;
            }
            case SERVICE_ACTIVATION: {
                triggerEvent1 = TriggerEvent.SERVICE_ACTIVATION;
                break;
            }
            case CUSTOMER_ACCEPTANCE: {
                triggerEvent1 = TriggerEvent.CUSTOMER_ACCEPTANCE;
                break;
            }
            default: {
                triggerEvent1 = null;
            }
        }
        return triggerEvent1;
    }

    @Override
    String map(PriceEnum.Event event) {
        String string;
        if (event == null) {
            return null;
        }
        switch (event) {
            case CONTRACT_EFFECTIVE: {
                string = "ContractEffective";
                break;
            }
            case SERVICE_ACTIVATION: {
                string = "ServiceActivation";
                break;
            }
            case CUSTOMER_ACCEPTANCE: {
                string = "CustomerAcceptance";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)event));
            }
        }
        return string;
    }

    @Override
    PriceEnum.Event mapTriggerEvent(String triggerEvent) {
        PriceEnum.Event event;
        if (triggerEvent == null) {
            return null;
        }
        switch (triggerEvent) {
            case "ContractEffective": {
                event = PriceEnum.Event.CONTRACT_EFFECTIVE;
                break;
            }
            case "ServiceActivation": {
                event = PriceEnum.Event.SERVICE_ACTIVATION;
                break;
            }
            case "CustomerAcceptance": {
                event = PriceEnum.Event.CUSTOMER_ACCEPTANCE;
                break;
            }
            case "CONTRACT_EFFECTIVE": {
                event = PriceEnum.Event.CONTRACT_EFFECTIVE;
                break;
            }
            case "SERVICE_ACTIVATION": {
                event = PriceEnum.Event.SERVICE_ACTIVATION;
                break;
            }
            case "CUSTOMER_ACCEPTANCE": {
                event = PriceEnum.Event.CUSTOMER_ACCEPTANCE;
                break;
            }
            default: {
                event = null;
            }
        }
        return event;
    }

    @Override
    ListPriceBase mapListPriceBase(PriceEnum.PriceBaseInterval priceBaseInterval) {
        ListPriceBase listPriceBase;
        if (priceBaseInterval == null) {
            return null;
        }
        switch (priceBaseInterval) {
            case BILLING_PERIOD: {
                listPriceBase = ListPriceBase.PER_BILLING_PERIOD;
                break;
            }
            case MONTH: {
                listPriceBase = ListPriceBase.PER_MONTH;
                break;
            }
            case WEEK: {
                listPriceBase = ListPriceBase.PER_WEEK;
                break;
            }
            default: {
                listPriceBase = null;
            }
        }
        return listPriceBase;
    }

    @Override
    String mapSubscriptionListPriceBase(PriceEnum.PriceBaseInterval priceBaseInterval) {
        String string;
        if (priceBaseInterval == null) {
            return null;
        }
        switch (priceBaseInterval) {
            case BILLING_PERIOD: {
                string = "Per_Billing_Period";
                break;
            }
            case MONTH: {
                string = "Per_Month";
                break;
            }
            case WEEK: {
                string = "Per_Week";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)priceBaseInterval));
            }
        }
        return string;
    }

    @Override
    PriceEnum.PriceBaseInterval mapListPriceBase(String listPriceBase) {
        PriceEnum.PriceBaseInterval priceBaseInterval;
        if (listPriceBase == null) {
            return null;
        }
        switch (listPriceBase) {
            case "Per Billing Period": {
                priceBaseInterval = PriceEnum.PriceBaseInterval.BILLING_PERIOD;
                break;
            }
            case "Per Month": {
                priceBaseInterval = PriceEnum.PriceBaseInterval.MONTH;
                break;
            }
            case "Per Week": {
                priceBaseInterval = PriceEnum.PriceBaseInterval.WEEK;
                break;
            }
            case "Per_Billing_Period": {
                priceBaseInterval = PriceEnum.PriceBaseInterval.BILLING_PERIOD;
                break;
            }
            case "Per_Month": {
                priceBaseInterval = PriceEnum.PriceBaseInterval.MONTH;
                break;
            }
            case "Per_Week": {
                priceBaseInterval = PriceEnum.PriceBaseInterval.WEEK;
                break;
            }
            case "BILLING_PERIOD": {
                priceBaseInterval = PriceEnum.PriceBaseInterval.BILLING_PERIOD;
                break;
            }
            case "MONTH": {
                priceBaseInterval = PriceEnum.PriceBaseInterval.MONTH;
                break;
            }
            case "WEEK": {
                priceBaseInterval = PriceEnum.PriceBaseInterval.WEEK;
                break;
            }
            default: {
                priceBaseInterval = null;
            }
        }
        return priceBaseInterval;
    }

    @Override
    PriceEnum.ChargeModel fromChargeModel(String chargeModel) {
        PriceEnum.ChargeModel chargeModel1;
        if (chargeModel == null) {
            return null;
        }
        switch (chargeModel) {
            case "Discount-Fixed Amount": {
                chargeModel1 = PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT;
                break;
            }
            case "Discount-Percentage": {
                chargeModel1 = PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE;
                break;
            }
            case "Flat Fee Pricing": {
                chargeModel1 = PriceEnum.ChargeModel.FLAT_FEE;
                break;
            }
            case "Per Unit Pricing": {
                chargeModel1 = PriceEnum.ChargeModel.PER_UNIT;
                break;
            }
            case "Overage Pricing": {
                chargeModel1 = PriceEnum.ChargeModel.OVERAGE;
                break;
            }
            case "Tiered Pricing": {
                chargeModel1 = PriceEnum.ChargeModel.TIERED;
                break;
            }
            case "Tiered with Overage Pricing": {
                chargeModel1 = PriceEnum.ChargeModel.TIERED_WITH_OVERAGE;
                break;
            }
            case "Volume Pricing": {
                chargeModel1 = PriceEnum.ChargeModel.VOLUME;
                break;
            }
            case "Custom Charge Model Pricing": {
                chargeModel1 = PriceEnum.ChargeModel.CUSTOM_CHARGE_MODEL;
                break;
            }
            case "MultiAttributePricing": {
                chargeModel1 = PriceEnum.ChargeModel.MULTI_ATTRIBUTE_PRICING;
                break;
            }
            case "PreratedPerUnit": {
                chargeModel1 = PriceEnum.ChargeModel.PRERATED_PER_UNIT;
                break;
            }
            case "PreratedPricing": {
                chargeModel1 = PriceEnum.ChargeModel.PRERATED_PRICING;
                break;
            }
            case "HighWatermarkVolumePricing": {
                chargeModel1 = PriceEnum.ChargeModel.HIGH_WATERMARK_VOLUME;
                break;
            }
            case "HighWatermarkTieredPricing": {
                chargeModel1 = PriceEnum.ChargeModel.HIGH_WATERMARK_TIERED;
                break;
            }
            case "DISCOUNT_FIXED_AMOUNT": {
                chargeModel1 = PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT;
                break;
            }
            case "DISCOUNT_PERCENTAGE": {
                chargeModel1 = PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE;
                break;
            }
            case "FLAT_FEE": {
                chargeModel1 = PriceEnum.ChargeModel.FLAT_FEE;
                break;
            }
            case "PER_UNIT": {
                chargeModel1 = PriceEnum.ChargeModel.PER_UNIT;
                break;
            }
            case "OVERAGE": {
                chargeModel1 = PriceEnum.ChargeModel.OVERAGE;
                break;
            }
            case "TIERED": {
                chargeModel1 = PriceEnum.ChargeModel.TIERED;
                break;
            }
            case "TIERED_WITH_OVERAGE": {
                chargeModel1 = PriceEnum.ChargeModel.TIERED_WITH_OVERAGE;
                break;
            }
            case "VOLUME": {
                chargeModel1 = PriceEnum.ChargeModel.VOLUME;
                break;
            }
            case "CUSTOM_CHARGE_MODEL": {
                chargeModel1 = PriceEnum.ChargeModel.CUSTOM_CHARGE_MODEL;
                break;
            }
            case "MULTI_ATTRIBUTE_PRICING": {
                chargeModel1 = PriceEnum.ChargeModel.MULTI_ATTRIBUTE_PRICING;
                break;
            }
            case "PRERATED_PER_UNIT": {
                chargeModel1 = PriceEnum.ChargeModel.PRERATED_PER_UNIT;
                break;
            }
            case "PRERATED_PRICING": {
                chargeModel1 = PriceEnum.ChargeModel.PRERATED_PRICING;
                break;
            }
            case "HIGH_WATERMARK_VOLUME": {
                chargeModel1 = PriceEnum.ChargeModel.HIGH_WATERMARK_VOLUME;
                break;
            }
            case "HIGH_WATERMARK_TIERED": {
                chargeModel1 = PriceEnum.ChargeModel.HIGH_WATERMARK_TIERED;
                break;
            }
            default: {
                chargeModel1 = null;
            }
        }
        return chargeModel1;
    }

    @Override
    ChargeType fromChargeType(String chargeType) {
        ChargeType chargeType1;
        if (chargeType == null) {
            return null;
        }
        switch (chargeType) {
            case "Recurring": {
                chargeType1 = ChargeType.RECURRING;
                break;
            }
            case "OneTime": {
                chargeType1 = ChargeType.ONE_TIME;
                break;
            }
            case "Usage": {
                chargeType1 = ChargeType.USAGE;
                break;
            }
            case "ONE_TIME": {
                chargeType1 = ChargeType.ONE_TIME;
                break;
            }
            case "RECURRING": {
                chargeType1 = ChargeType.RECURRING;
                break;
            }
            case "USAGE": {
                chargeType1 = ChargeType.USAGE;
                break;
            }
            default: {
                chargeType1 = null;
            }
        }
        return chargeType1;
    }

    @Override
    RatingGroup fromRatingGroup(String ratingGroup) {
        RatingGroup ratingGroup1;
        if (ratingGroup == null) {
            return null;
        }
        switch (ratingGroup) {
            case "ByBillingPeriod": {
                ratingGroup1 = RatingGroup.BY_BILLING_PERIOD;
                break;
            }
            case "ByUsageStartDate": {
                ratingGroup1 = RatingGroup.BY_USAGE_START_DATE;
                break;
            }
            case "ByUsageRecord": {
                ratingGroup1 = RatingGroup.BY_USAGE_RECORD;
                break;
            }
            case "ByUsageUpload": {
                ratingGroup1 = RatingGroup.BY_USAGE_UPLOAD;
                break;
            }
            case "ByGroupId": {
                ratingGroup1 = RatingGroup.BY_GROUP_ID;
                break;
            }
            case "BY_BILLING_PERIOD": {
                ratingGroup1 = RatingGroup.BY_BILLING_PERIOD;
                break;
            }
            case "BY_USAGE_START_DATE": {
                ratingGroup1 = RatingGroup.BY_USAGE_START_DATE;
                break;
            }
            case "BY_USAGE_RECORD": {
                ratingGroup1 = RatingGroup.BY_USAGE_RECORD;
                break;
            }
            case "BY_USAGE_UPLOAD": {
                ratingGroup1 = RatingGroup.BY_USAGE_UPLOAD;
                break;
            }
            case "BY_GROUP_ID": {
                ratingGroup1 = RatingGroup.BY_GROUP_ID;
                break;
            }
            default: {
                ratingGroup1 = null;
            }
        }
        return ratingGroup1;
    }

    @Override
    String toSmoothingModel(OverageType smoothingModel) {
        String string;
        if (smoothingModel == null) {
            return null;
        }
        switch (smoothingModel) {
            case ROLLOVER: {
                string = "Rollover";
                break;
            }
            case ROLLING_WINDOW: {
                string = "Rolling Window";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + (Object)((Object)smoothingModel));
            }
        }
        return string;
    }

    @Override
    OverageType fromSmoothingModel(String smoothingModel) {
        OverageType overageType;
        if (smoothingModel == null) {
            return null;
        }
        switch (smoothingModel) {
            case "Rollover": {
                overageType = OverageType.ROLLOVER;
                break;
            }
            case "Rolling Window": {
                overageType = OverageType.ROLLING_WINDOW;
                break;
            }
            case "ROLLING_WINDOW": {
                overageType = OverageType.ROLLING_WINDOW;
                break;
            }
            case "ROLLOVER": {
                overageType = OverageType.ROLLOVER;
                break;
            }
            default: {
                overageType = null;
            }
        }
        return overageType;
    }
}

