/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.base.Preconditions;
import com.zuora.sdk.Account;
import com.zuora.sdk.AccountCreateRequest;
import com.zuora.sdk.ApiMapper;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.BillingDocument;
import com.zuora.sdk.Payment;
import com.zuora.sdk.PaymentMethod;
import com.zuora.sdk.Subscription;
import com.zuora.sdk.SubscriptionPlan;
import com.zuora.sdk.Term;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.enums.BillingDocumentType;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.APINodeList;
import com.zuora.sdk.internal.CustomFieldHelper;
import com.zuora.sdk.internal.HawkClient;
import com.zuora.sdk.internal.Tools;
import com.zuora.sdk.internal.apis.AccountsAPI;
import com.zuora.sdk.internal.apis.PaymentsAPI;
import com.zuora.sdk.internal.apis.SubscriptionsAPI;
import com.zuora.sdk.internal.apis.data.AccountCreateRequestTaxInfo;
import com.zuora.sdk.internal.apis.data.GETARPaymentTypewithSuccess;
import com.zuora.sdk.internal.apis.data.GETSubscriptionTypeWithSuccess;
import com.zuora.sdk.internal.apis.data.PaymentCollectionResponseType;
import com.zuora.sdk.internal.exceptions.InvalidRequestException;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import com.zuora.sdk.internal.models.ZAccount;
import com.zuora.sdk.internal.models.enums.AccountStatus;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AccountAPI {
    private final APIContext context;
    private final HawkClient hawkClient;
    private final ZuoraClient client;

    AccountAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.hawkClient = client.getHawkClient();
    }

    /*
     * WARNING - void declaration
     */
    public Account create(AccountCreateRequest accountCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        AccountCreateRequest accountCreateRequest2 = accountCreateRequest;
        try {
            void account2;
            void taxInfo;
            if (accountCreateRequest2.getBillTo() != null) {
                InvalidRequestException.throwInvalidRequestExceptionIfNull((Object)accountCreateRequest2.getBillTo().getAddress(), (String)"billToContact.address");
                InvalidRequestException.throwInvalidRequestExceptionIfNull((Object)accountCreateRequest2.getBillTo().getAddress().getCountry(), (String)"billToContact.address.country");
                InvalidRequestException.throwInvalidRequestExceptionIfNull((Object)accountCreateRequest2.getBillTo().getAddress().getState(), (String)"billToContact.address.state");
            }
            if (accountCreateRequest2.getSoldTo() != null) {
                InvalidRequestException.throwInvalidRequestExceptionIfNull((Object)accountCreateRequest2.getSoldTo().getAddress(), (String)"soldToContact.address");
                InvalidRequestException.throwInvalidRequestExceptionIfNull((Object)accountCreateRequest2.getSoldTo().getAddress().getCountry(), (String)"soldToContact.address.country");
                InvalidRequestException.throwInvalidRequestExceptionIfNull((Object)accountCreateRequest2.getSoldTo().getAddress().getState(), (String)"soldToContact.address.state");
            }
            MetricRegistry metricRegistry = new AccountCreateRequestTaxInfo();
            if (taxInfo.getTaxIdentifier() != null) {
                metricRegistry.vATId(taxInfo.getTaxIdentifier().getId());
            }
            if (taxInfo.getTaxCertificate() != null) {
                metricRegistry.companyCode(taxInfo.getTaxCertificate().getCompanyCode()).exemptCertificateId(taxInfo.getTaxCertificate().getId()).exemptEffectiveDate(taxInfo.getTaxCertificate().getStartDate()).exemptExpirationDate(taxInfo.getTaxCertificate().getEndDate()).exemptIssuingJurisdiction(taxInfo.getTaxCertificate().getIssuingJurisdiction()).exemptStatus(taxInfo.getTaxCertificate().getState() == null ? null : taxInfo.getTaxCertificate().getState().getApiValue());
            }
            String string = ((ZAccount.Builder)((ZAccount.Builder)((ZAccount.Builder)((ZAccount.Builder)((ZAccount.Builder)((ZAccount.Builder)((ZAccount.Builder)ApiMapper.Mapper.toApi((AccountCreateRequest)taxInfo).status(AccountStatus.ACTIVE)).taxInfo((AccountCreateRequestTaxInfo)metricRegistry)).creditMemoTemplateId(taxInfo.getBillingDocumentSettings() != null ? taxInfo.getBillingDocumentSettings().getCreditMemoTemplate() : null)).debitMemoTemplateId(taxInfo.getBillingDocumentSettings() != null ? taxInfo.getBillingDocumentSettings().getDebitMemoTemplate() : null)).invoiceTemplateId(taxInfo.getBillingDocumentSettings() != null ? taxInfo.getBillingDocumentSettings().getInvoiceTemplate() : null)).invoiceDeliveryPrefsEmail(taxInfo.getBillingDocumentSettings() != null ? Boolean.valueOf(taxInfo.getBillingDocumentSettings().isEmail()) : null)).invoiceDeliveryPrefsPrint(taxInfo.getBillingDocumentSettings() != null ? Boolean.valueOf(taxInfo.getBillingDocumentSettings().isPrint()) : null)).build();
            String string2 = string.create(account2.context);
            account2.client.customObjects().saveAssociations((BaseFacade)taxInfo, string2);
            object = account2.get(string2);
            return object;
        }
        finally {
            accountCreateRequest2 = null;
        }
    }

    public Account get(String accountKey) throws ZuoraSdkException {
        ZAccount accRes = ZAccount.get((APIContext)this.context, (String)accountKey);
        Account account2 = ApiMapper.Mapper.toAccount(accRes, this.client);
        return account2;
    }

    void update(Account accountUpdate) throws ZuoraSdkException {
        ApiMapper.Mapper.toApi(accountUpdate).build().update(this.context);
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string) throws ZuoraSdkException {
        Meter meter;
        String string2;
        long l = System.currentTimeMillis();
        AccountAPI accountAPI = this;
        String string3 = string;
        try {
            void accountId;
            if (StringUtils.isBlank((CharSequence)string3)) {
                throw ZuoraSdkException.builder().message("accountId must not be empty").build();
            }
            AccountsAPI.objectDelete((APIContext)accountId.context, (String)string3);
            accountAPI = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string3 = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string4 = "com.zuora.sdk.AccountAPI".substring("com.zuora.sdk.AccountAPI".lastIndexOf(".") + 1);
        if (null != accountAPI) {
            string2 = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{accountAPI.getClass().getSimpleName(), string4, "delete"});
            meter = string3.meter(string2);
            meter.mark();
        } else {
            string2 = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string4, "delete"});
            meter = string3.meter(string2);
            meter.mark();
        }
        string2 = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string4, "delete"});
        meter = string3.histogram(string2);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (accountAPI != null) {
            throw accountAPI;
        }
    }

    List<BillingDocument> getInvoices(Account account2) throws ZuoraSdkException {
        return this.client.billingDocuments().findByAccount(account2, BillingDocumentType.INVOICE);
    }

    List<PaymentMethod> getPaymentMethods(Account account2) throws ZuoraSdkException {
        ArrayList<PaymentMethod> result = new ArrayList<PaymentMethod>();
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("field", "AccountId");
        filter.put("operator", "EQ");
        filter.put("value", account2.getId());
        List idList = this.hawkClient.getRecords("paymentmethod", filter).stream().map(v -> (String)v.get("id")).collect(Collectors.toList());
        for (String id : idList) {
            result.add(this.client.paymentMethods().get(id));
        }
        return result;
    }

    List<Payment> getPayments(Account account2, int limit) {
        Preconditions.checkArgument((limit > 0 && limit <= 1000 ? 1 : 0) != 0, (Object)"limit should be in range of [1, 1000]");
        ArrayList<Payment> payments = new ArrayList<Payment>();
        APINodeList pageResult = new PaymentsAPI.PaymentsListRequest(this.context).accountId(account2.getId()).setPageSize(40).sort("+updatedDate").execute();
        while (true) {
            String nextPage;
            List paymentsInCurrentPage = ((PaymentCollectionResponseType)pageResult.get(0)).payments();
            for (GETARPaymentTypewithSuccess rawPayment : paymentsInCurrentPage) {
                payments.add(ApiMapper.Mapper.fromApi(rawPayment, this.context));
                if (payments.size() != limit) continue;
                break;
            }
            if ((nextPage = ((PaymentCollectionResponseType)pageResult.get(0)).nextPage()) == null || payments.size() == limit) break;
            pageResult.setNext(nextPage);
            pageResult = pageResult.nextPage();
        }
        return payments;
    }

    List<Subscription> getSubscriptions(Account account2) throws ZuoraSdkException {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("field", "AccountId");
        filter.put("operator", "EQ");
        filter.put("value", account2.getId());
        return this.hawkClient.getRecords("subscription", filter).stream().map(sub -> {
            Subscription.SubscriptionBuilder builder = Subscription.builder().id((String)sub.get("id")).account(account2).state(Subscription.State.getByLabel((String)sub.get("status"))).initialTerm(Term.builder().type(Term.TermType.valueOf((String)sub.get("termType"))).intervalCount(Tools.doubleToInt((Double)((Double)sub.get("initialTerm")))).interval((String)sub.get("initialTermPeriodType")).build()).renewalTerm(Term.builder().type(Term.getRenewalTermType((String)sub.get("renewalSetting"))).intervalCount(Tools.doubleToInt((Double)((Double)sub.get("renewalTerm")))).interval((String)sub.get("renewalTermPeriodType")).build()).currentTerm(Term.builder().type(Term.TermType.valueOf((String)sub.get("termType"))).intervalCount(Tools.doubleToInt((Double)((Double)sub.get("currentTerm")))).interval((String)sub.get("currentTermPeriodType")).startDate(Tools.toLocalDate((String)((String)sub.get("termStartDate")))).endDate(Tools.toLocalDate((String)((String)sub.get("termEndDate")))).build()).startDate(Tools.toLocalDate((String)((String)sub.get("subscriptionStartDate")))).endDate(Tools.toLocalDate((String)((String)sub.get("subscriptionEndDate")))).termEndDate(Tools.toLocalDate((String)((String)sub.get("termEndDate")))).termStartDate(LocalDate.parse((String)sub.get("termStartDate"))).description((String)sub.get("notes")).contractEffective(Tools.toLocalDate((String)((String)sub.get("contractEffectiveDate")))).serviceActivation(Tools.toLocalDate((String)((String)sub.get("serviceActivationDate")))).customerAcceptance(Tools.toLocalDate((String)((String)sub.get("customerAcceptanceDate")))).invoiceSeparately((Boolean)sub.get("invoiceSeparately")).invoiceAccount(account2.getId().equals(sub.get("invoiceOwnerId")) ? account2 : this.client.accounts().get((String)sub.get("invoiceOwnerId"))).version(Tools.doubleToInt((Double)((Double)sub.get("version")))).canceledDate(Tools.toLocalDate((String)((String)sub.get("cancelledDate")))).createdBy((String)sub.get("createdById")).createTime(ZonedDateTime.parse((String)sub.get("createdDate"))).updatedBy((String)sub.get("updatedById")).updateTime(ZonedDateTime.parse((String)sub.get("updatedDate"))).autoRenew((Boolean)sub.get("autoRenew")).key((String)sub.get("name")).customFields(CustomFieldHelper.getCustomFields(sub)).client(this.client);
            GETSubscriptionTypeWithSuccess getSubscriptionTypeWithSuccess = SubscriptionsAPI.retrieveByKey((APIContext)this.context, (String)((String)sub.get("id")));
            builder.mrr(getSubscriptionTypeWithSuccess.contractedMrr()).tcv(getSubscriptionTypeWithSuccess.totalContractedValue());
            return builder.build();
        }).collect(Collectors.toList());
    }

    List<SubscriptionPlan> getSubscriptionPlans(String subscriptionId) throws ZuoraSdkException {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("field", "SubscriptionId");
        filter.put("operator", "EQ");
        filter.put("value", subscriptionId);
        return this.hawkClient.getRecords("rateplan", filter).stream().map(plan -> SubscriptionPlan.builder().id((String)plan.get("id")).name((String)plan.get("name")).plan((String)plan.get("productRatePlanId")).subscription((String)plan.get("subscriptionId")).customFields(CustomFieldHelper.getCustomFields(plan)).build()).collect(Collectors.toList());
    }
}

