/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.internal;

import com.apollographql.apollo.ApolloClient;
import com.google.gson.Gson;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.exceptions.InvalidRequestException;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HawkClient {
    private final APIContext context;
    private final String baseUrl;
    private final OkHttpClient client = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).build();
    private final ApolloClient gqlClient;

    public HawkClient(final APIContext context) {
        this.context = context;
        this.baseUrl = context.getEndpointBase() + "/object-query/";
        this.gqlClient = ApolloClient.builder().serverUrl(this.baseUrl + "graphql").okHttpClient(new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                return chain.proceed(chain.request().newBuilder().addHeader("Authorization", "Bearer " + context.getBearer()).build());
            }
        }).build()).build();
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Request.Builder makeRequest() {
        return new Request.Builder().header("Authorization", "Bearer " + this.context.getBearer()).header("Accept", "application/json");
    }

    private Reader execute(Request request) throws IOException {
        return this.client.newCall(request).execute().body().charStream();
    }

    private Reader post(String path, RequestBody body) throws IOException {
        Request request = this.makeRequest().url(this.baseUrl + path).method("POST", body).build();
        return this.execute(request);
    }

    private Reader get(String path) throws IOException {
        Request request = this.makeRequest().url(this.baseUrl + path).build();
        return this.execute(request);
    }

    public List getMetadata() {
        Reader response = null;
        List rawRes = null;
        try {
            response = this.get("metadata");
            List list = rawRes = (List)new Gson().fromJson(response, List.class);
            return list;
        }
        catch (IOException e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).operationName("getMetadata").build();
        }
        finally {
            HawkClient.closeQuietly(response);
        }
    }

    Map getRecord(String type, String id) {
        Map map;
        Reader response = null;
        Map rawRes = null;
        try {
            response = this.get("records/" + type + "/" + id);
            map = rawRes = (Map)new Gson().fromJson(response, HashMap.class);
        }
        catch (IOException e) {
            try {
                throw ZuoraSdkException.builder().cause((Throwable)e).operationName("getRecord").build();
            }
            catch (Throwable throwable) {
                HawkClient.closeQuietly(response);
                throw throwable;
            }
        }
        HawkClient.closeQuietly(response);
        return map;
    }

    public List<Map> getRecords(String type, Map filter) throws ZuoraSdkException {
        Map rawRes;
        HashMap<String, Object> postBody = new HashMap<String, Object>();
        postBody.put("pageSize", 1000);
        postBody.put("filter", filter);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)new Gson().toJson(postBody));
        Reader response = null;
        try {
            response = this.post("records/" + type, requestBody);
            rawRes = (Map)new Gson().fromJson(response, HashMap.class);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unexpected failure querying for records.", e);
            }
            catch (Throwable throwable) {
                HawkClient.closeQuietly(response);
                throw throwable;
            }
        }
        HawkClient.closeQuietly(response);
        if (rawRes.containsKey("code")) {
            throw ((InvalidRequestException.Builder)InvalidRequestException.builder().message((String)rawRes.get("message")).addViolation(InvalidRequestException.Reason.GenericError, null, (String)rawRes.get("details")).operationName("getRecords")).build();
        }
        if (rawRes.containsKey("error")) {
            Map error = (Map)rawRes.get("error");
            throw ((InvalidRequestException.Builder)InvalidRequestException.builder().message((String)error.get("message")).addViolation(InvalidRequestException.Reason.GenericError, null, (String)error.get("message")).operationName("getRecords")).build();
        }
        List recordsList = (List)rawRes.get("records");
        List<Map> records = recordsList.stream().map(record -> {
            HashMap map = new HashMap();
            record.forEach((key, value) -> {
                key = Character.toLowerCase(key.toString().charAt(0)) + key.toString().substring(1);
                map.put(key, value);
            });
            return map;
        }).collect(Collectors.toList());
        return records;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ApolloClient getGqlClient() {
        return this.gqlClient;
    }

    static class Page {
        List<Map<String, String>> records = null;
        String cursor = null;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Page() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<Map<String, String>> getRecords() {
            return this.records;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getCursor() {
            return this.cursor;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setRecords(List<Map<String, String>> records) {
            this.records = records;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setCursor(String cursor) {
            this.cursor = cursor;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Page)) {
                return false;
            }
            Page other = (Page)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Map<String, String>> this$records = this.getRecords();
            List<Map<String, String>> other$records = other.getRecords();
            if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
                return false;
            }
            String this$cursor = this.getCursor();
            String other$cursor = other.getCursor();
            return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Page;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Map<String, String>> $records = this.getRecords();
            result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
            String $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "HawkClient.Page(records=" + this.getRecords() + ", cursor=" + this.getCursor() + ")";
        }
    }
}

