/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.HydratedZuoraObject;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.ZuoraMetadata;
import com.zuora.sdk.ZuoraObject;
import com.zuora.sdk.ZuoraObjectField;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.apis.CustomObjectDefinitionsAPI;
import com.zuora.sdk.internal.apis.data.CustomObjectCustomFieldDefinitionUpdate;
import com.zuora.sdk.internal.apis.data.CustomObjectDefinitionUpdateActionRequest;
import com.zuora.sdk.internal.apis.data.CustomObjectDefinitionUpdateActionRequestRelationship;
import com.zuora.sdk.internal.apis.data.UpdateCustomObjectCusotmField;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CustomObjectAPI {
    private final ZuoraClient client;

    CustomObjectAPI(ZuoraClient client) {
        this.client = client;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T create(T t, Class<T> metricRegistry) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        CustomObjectAPI customObjectAPI = this;
        T t2 = t;
        MetricRegistry metricRegistry2 = metricRegistry;
        try {
            void annotation;
            void clazz;
            void instance;
            ZuoraObject zuoraObject = super.getAnnotation((Class<T>)metricRegistry2);
            Map map = instance.client.getMuranoClient().createRecord(super.toAPI(clazz, (Class)annotation), zuoraObject.name());
            customObjectAPI = super.toInstance(map, (Class<T>)annotation);
            return (T)customObjectAPI;
        }
        finally {
            t2 = null;
        }
    }

    public <T> T get(String id, Class<T> clazz) throws ZuoraSdkException {
        ZuoraObject annotation = this.getAnnotation(clazz);
        Map record = this.client.getMuranoClient().getRecordById(id, annotation.name());
        return this.toInstance(record, clazz);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T update(T t, Class<T> metricRegistry) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        CustomObjectAPI customObjectAPI = this;
        T t2 = t;
        MetricRegistry metricRegistry2 = metricRegistry;
        try {
            void toAPI;
            void id;
            void annotation;
            void clazz;
            void instance;
            ZuoraObject zuoraObject = super.getAnnotation((Class<T>)metricRegistry2);
            Map map = super.toAPI(clazz, (Class)annotation);
            String string = (String)map.get("Id");
            if (string == null) {
                throw ZuoraSdkException.builder().message("Instance is missing ZuoraCustomObjectField `Id`.").build();
            }
            Map map2 = instance.client.getMuranoClient().updateRecord(string, (Map)id, toAPI.name());
            customObjectAPI = super.toInstance(map2, (Class<T>)annotation);
            return (T)customObjectAPI;
        }
        finally {
            t2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T> void delete(String string, Class<T> clazz) throws ZuoraSdkException {
        Meter meter;
        Object object;
        long l = System.currentTimeMillis();
        CustomObjectAPI customObjectAPI = this;
        String string2 = string;
        Object object2 = clazz;
        try {
            void clazz2;
            void id;
            object = super.getAnnotation((Class<T>)object2);
            id.client.getMuranoClient().deleteRecord((String)clazz2, object.name());
            customObjectAPI = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string2 = SharedMetricRegistries.getOrCreate((String)"zuora");
        object2 = "com.zuora.sdk.CustomObjectAPI".substring("com.zuora.sdk.CustomObjectAPI".lastIndexOf(".") + 1);
        if (null != customObjectAPI) {
            object = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{customObjectAPI.getClass().getSimpleName(), object2, "delete"});
            meter = string2.meter((String)object);
            meter.mark();
        } else {
            object = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{object2, "delete"});
            meter = string2.meter((String)object);
            meter.mark();
        }
        object = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{object2, "delete"});
        meter = string2.histogram((String)object);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (customObjectAPI != null) {
            throw customObjectAPI;
        }
    }

    private <T> ZuoraObject getAnnotation(Class<T> clazz) {
        ZuoraObject annotation = clazz.getAnnotation(ZuoraObject.class);
        if (annotation == null) {
            throw ZuoraSdkException.builder().message("Cannot find annotation @ZuoraObject on " + clazz.getName()).build();
        }
        return annotation;
    }

    private Map toAPI(Object object, Class clazz) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                ZuoraObjectField annotation = field.getAnnotation(ZuoraObjectField.class);
                if (annotation == null) continue;
                Object value = field.get(object);
                map.put(annotation.name(), value);
            }
            catch (Exception e) {
                throw ZuoraSdkException.builder().cause((Throwable)e).build();
            }
        }
        return map;
    }

    public <T> List<T> getAssociatedObjects(HydratedZuoraObject object, Class<T> childClass) {
        ZuoraMetadata.ZuoraMetadataDefinition coDefinition = this.client.getMetaData().getDefinition(childClass);
        ZuoraMetadata.ZuoraMetadataDefinition parentDef = this.client.getMetaData().getDefinition(object.getClass());
        if (coDefinition == null) {
            throw ZuoraSdkException.builder().message("Cannot find definition: " + childClass.getClass().getName()).build();
        }
        if (parentDef == null) {
            throw ZuoraSdkException.builder().message("Cannot find definition: " + parentDef.getClass().getName()).build();
        }
        Map relationship = parentDef.getRelationship(coDefinition);
        if (relationship == null) {
            throw ZuoraSdkException.builder().message("Cannot find relationship between custom object " + coDefinition.getObjectType() + " and " + parentDef.getObjectType()).build();
        }
        Map fields = (Map)relationship.get("fields");
        String key = (String)fields.get("Id");
        StringBuilder qsb = new StringBuilder();
        qsb.append(key + ":" + object.getId());
        String query = qsb.toString();
        List<Map> records = this.client.getMuranoClient().queryRecords(coDefinition.getObjectType().replace("default__", ""), query);
        return records.stream().map(r -> this.toInstance((Map)r, childClass)).collect(Collectors.toList());
    }

    private <T> T toInstance(Map record, Class<T> clazz) {
        try {
            Field[] fields;
            Constructor<T> co = clazz.getDeclaredConstructor(new Class[0]);
            T instance = co.newInstance(new Object[0]);
            for (Field field : fields = clazz.getDeclaredFields()) {
                ZuoraObjectField annotation;
                Boolean wasAccessed = false;
                if (!field.isAccessible()) {
                    wasAccessed = true;
                    field.setAccessible(true);
                }
                if ((annotation = field.getAnnotation(ZuoraObjectField.class)) == null) continue;
                if (record.containsKey(annotation.name())) {
                    field.set(instance, record.get(annotation.name()));
                }
                if (!wasAccessed.booleanValue()) continue;
                field.setAccessible(false);
            }
            return instance;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).build();
        }
    }

    private void createTable(Class<?> clazz) {
        ZuoraObject annotation = this.getAnnotation(clazz);
        String objectType = annotation.name();
        HashMap properties = new HashMap();
        for (Field field : clazz.getDeclaredFields()) {
            String fieldName;
            ZuoraObjectField fieldAnnotation = field.getAnnotation(ZuoraObjectField.class);
            if (fieldAnnotation == null || !(fieldName = fieldAnnotation.name()).contains("__c")) continue;
            HashMap<String, String> newField = new HashMap<String, String>();
            String label = fieldName.replace("__c", "");
            newField.put("label", label);
            newField.put("type", "string");
            properties.put(fieldName, newField);
        }
        ArrayList filters = new ArrayList(properties.keySet());
        CustomObjectDefinitionsAPI.CustomObjectDefinitionCreateRequest creator = CustomObjectDefinitionsAPI.create((APIContext)this.client.getContext()).object(objectType).label(objectType).properties(properties).filterable(filters);
        creator.execute();
    }

    private void createManyToOneRelationship(ZuoraMetadata.ZuoraMetadataDefinition parent, ZuoraMetadata.ZuoraMetadataDefinition child) {
        String fieldName = parent.getObjectType() + "__c";
        CustomObjectCustomFieldDefinitionUpdate definition = new CustomObjectCustomFieldDefinitionUpdate().format("uuid").label(fieldName).origin("custom").type("string");
        UpdateCustomObjectCusotmField field = new UpdateCustomObjectCusotmField().name(fieldName).filterable(Boolean.valueOf(true)).definition(definition);
        CustomObjectDefinitionUpdateActionRequest fieldAction = new CustomObjectDefinitionUpdateActionRequest().object(child.getObjectType().replace("default__", "")).namespace(child.getNamespace()).type("addField").field(field);
        ArrayList<CustomObjectDefinitionUpdateActionRequest> fieldActions = new ArrayList<CustomObjectDefinitionUpdateActionRequest>();
        fieldActions.add(fieldAction);
        CustomObjectDefinitionsAPI.CustomObjectDefinitionUpdateRequest fieldReq = CustomObjectDefinitionsAPI.update((APIContext)this.client.getContext()).actions(fieldActions);
        fieldReq.execute();
        HashMap<String, String> relationshipFields = new HashMap<String, String>();
        relationshipFields.put(fieldName, "Id");
        CustomObjectDefinitionUpdateActionRequestRelationship relationship = new CustomObjectDefinitionUpdateActionRequestRelationship().cardinality("manyToOne").object(parent.getObjectType()).namespace(parent.getNamespace()).fields(relationshipFields);
        CustomObjectDefinitionUpdateActionRequest relationshipAction = new CustomObjectDefinitionUpdateActionRequest().object(child.getObjectType().replace("default__", "")).namespace(child.getNamespace()).type("addRelationship").relationship(relationship);
        ArrayList<CustomObjectDefinitionUpdateActionRequest> relationshipActions = new ArrayList<CustomObjectDefinitionUpdateActionRequest>();
        relationshipActions.add(relationshipAction);
        CustomObjectDefinitionsAPI.CustomObjectDefinitionUpdateRequest relationshipReq = CustomObjectDefinitionsAPI.update((APIContext)this.client.getContext()).actions(relationshipActions);
        relationshipReq.execute();
    }

    <T> void saveAssociation(Object record, Class<T> clazz, BaseFacade parentObject, String parentId) {
        ZuoraMetadata.ZuoraMetadataDefinition coDefinition = this.client.getMetaData().getDefinition(clazz);
        ZuoraMetadata.ZuoraMetadataDefinition parentDef = this.client.getMetaData().getDefinition(parentObject.getClass());
        if (coDefinition == null) {
            throw ZuoraSdkException.builder().message("Cannot find metadata definition: " + clazz.getName()).build();
        }
        if (parentDef == null) {
            throw ZuoraSdkException.builder().message("Cannot find metadata definition: " + parentObject.getClass().getName()).build();
        }
        Map relationship = parentDef.getRelationship(coDefinition);
        if (relationship == null) {
            throw ZuoraSdkException.builder().message("Cannot find relationship between custom object " + coDefinition.getObjectType() + " and " + parentDef.getObjectType()).build();
        }
        Map fields = (Map)relationship.get("fields");
        Map toApi = this.toAPI(record, clazz);
        toApi.put(fields.get("Id"), parentId);
        String customObjectName = coDefinition.getObjectType().replace("default__", "");
        String recordId = (String)toApi.get("Id");
        if (recordId == null) {
            Map newRecord = this.client.getMuranoClient().createRecord(toApi, customObjectName);
            for (Field field : clazz.getDeclaredFields()) {
                ZuoraObjectField fieldAnnotation = field.getAnnotation(ZuoraObjectField.class);
                if (fieldAnnotation == null || !fieldAnnotation.name().equals("Id")) continue;
                try {
                    field.setAccessible(true);
                    field.set(record, newRecord.get("Id"));
                }
                catch (Exception e) {
                    throw ZuoraSdkException.builder().message("Failed to set `Id` on associated record after create.").build();
                }
            }
        }
    }

    void saveAssociations(BaseFacade object, String id) {
        object.getAssociations().forEach(record -> {
            Class<?> clazz = record.getClass();
            this.saveAssociation(record, clazz, object, id);
        });
    }
}

