/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Query;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.collect.Lists;
import com.zuora.sdk.Account;
import com.zuora.sdk.BillingDocument;
import com.zuora.sdk.BillingDocumentItem;
import com.zuora.sdk.BillingDocumentPayRequest;
import com.zuora.sdk.InvoiceWriteOffData;
import com.zuora.sdk.Payment;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.enums.BillingDocumentStatus;
import com.zuora.sdk.enums.BillingDocumentType;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.APIException;
import com.zuora.sdk.internal.ApolloClientUtil;
import com.zuora.sdk.internal.BillingDocumentByKeyQuery;
import com.zuora.sdk.internal.InvoiceItemsByInvoiceQuery;
import com.zuora.sdk.internal.apis.CreditMemosAPI;
import com.zuora.sdk.internal.apis.DebitMemosAPI;
import com.zuora.sdk.internal.apis.InvoicesAPI;
import com.zuora.sdk.internal.apis.TransactionsAPI;
import com.zuora.sdk.internal.apis.data.BillingDocumentPostResponse;
import com.zuora.sdk.internal.apis.data.GETARPaymentType;
import com.zuora.sdk.internal.apis.data.GETCreditMemoType;
import com.zuora.sdk.internal.apis.data.GETDebitMemoType;
import com.zuora.sdk.internal.apis.data.GETInvoiceType;
import com.zuora.sdk.internal.apis.data.PUTWriteOffInvoiceResponse;
import com.zuora.sdk.internal.apis.data.PaymentDebitMemoApplicationCreateRequestType;
import com.zuora.sdk.internal.apis.data.PaymentInvoiceApplicationCreateRequestType;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class BillingDocumentAPI {
    private final ZuoraClient client;
    private APIContext context;
    private ApolloClient gqlClient;

    BillingDocumentAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.gqlClient = client.getHawkClient().getGqlClient();
    }

    public BillingDocument get(String id) throws ZuoraSdkException {
        BillingDocument billingDocument = null;
        try {
            CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new BillingDocumentByKeyQuery(id)));
            if (response.get().getData() == null) {
                throw ZuoraSdkException.builder().message("Null Pointer").operationName("getBillingDocument").build();
            }
            if (((BillingDocumentByKeyQuery.Data)response.get().getData()).getInvoices().getEdges() != null && !((BillingDocumentByKeyQuery.Data)response.get().getData()).getInvoices().getEdges().isEmpty()) {
                BillingDocumentByKeyQuery.Invoice invoice2 = ((BillingDocumentByKeyQuery.Data)response.get().getData()).getInvoices().getEdges().get(0).getInvoice();
                billingDocument = BillingDocument.builder().id(invoice2.getId()).type(BillingDocumentType.INVOICE).account(this.client.accounts().get(invoice2.getAccount().getAccountNumber())).autoPay(invoice2.getAutoPay()).description(invoice2.getComments()).subtotal(invoice2.getAmountWithoutTax()).key(invoice2.getInvoiceNumber()).amount(invoice2.getAmount()).balance(invoice2.getBalance()).documentDate(invoice2.getInvoiceDate()).dueDate(invoice2.getDueDate()).state(invoice2.getStatus()).createdBy(invoice2.getCreatedById()).createTime(ZonedDateTime.parse(invoice2.getCreatedDate())).updatedBy(invoice2.getUpdatedById()).updateTime(ZonedDateTime.parse(invoice2.getUpdatedDate())).currency(invoice2.getAccount().getCurrency()).client(this.client).build();
            } else if (((BillingDocumentByKeyQuery.Data)response.get().getData()).getCreditmemoes().getEdges() != null && !((BillingDocumentByKeyQuery.Data)response.get().getData()).getCreditmemoes().getEdges().isEmpty()) {
                BillingDocumentByKeyQuery.Memo memo2 = ((BillingDocumentByKeyQuery.Data)response.get().getData()).getCreditmemoes().getEdges().get(0).getMemo();
                billingDocument = BillingDocument.builder().id(memo2.getId()).type(BillingDocumentType.CREDIT_MEMO).account(this.client.accounts().get(memo2.getAccount().getAccountNumber())).key(memo2.getMemoNumber()).amount((double)memo2.getTotalAmount()).balance((double)memo2.getBalance()).documentDate(memo2.getMemoDate()).state(memo2.getStatus()).createdBy(memo2.getCreatedById()).createTime(ZonedDateTime.parse(memo2.getCreatedDate())).updatedBy(memo2.getUpdatedById()).updateTime(ZonedDateTime.parse(memo2.getUpdatedDate())).currency(memo2.getAccount().getCurrency()).client(this.client).build();
            } else if (((BillingDocumentByKeyQuery.Data)response.get().getData()).getDebitmemoes().getEdges() != null && !((BillingDocumentByKeyQuery.Data)response.get().getData()).getDebitmemoes().getEdges().isEmpty()) {
                BillingDocumentByKeyQuery.Memo1 memo3 = ((BillingDocumentByKeyQuery.Data)response.get().getData()).getDebitmemoes().getEdges().get(0).getMemo();
                billingDocument = BillingDocument.builder().id(memo3.getId()).type(BillingDocumentType.DEBIT_MEMO).account(this.client.accounts().get(memo3.getAccount().getAccountNumber())).key(memo3.getMemoNumber()).amount((double)memo3.getTotalAmount()).balance((double)memo3.getBalance()).documentDate(memo3.getMemoDate()).dueDate(memo3.getDueDate()).state(memo3.getStatus()).createdBy(memo3.getCreatedById()).createTime(ZonedDateTime.parse(memo3.getCreatedDate())).updatedBy(memo3.getUpdatedById()).updateTime(ZonedDateTime.parse(memo3.getUpdatedDate())).currency(memo3.getAccount().getCurrency()).client(this.client).build();
            }
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().message(e.getMessage()).operationName("getBillingDocument").build();
        }
        if (billingDocument != null) {
            this.loadCustomFields(billingDocument);
        }
        return billingDocument;
    }

    /*
     * WARNING - void declaration
     */
    public List<BillingDocument> findByAccount(Account account2, BillingDocumentType billingDocumentType) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Account account3 = account2;
        BillingDocumentType billingDocumentType2 = billingDocumentType;
        try {
            void billingDocuments;
            ArrayList arrayList = new ArrayList();
            switch (1.$SwitchMap$com$zuora$sdk$enums$BillingDocumentType[billingDocuments.ordinal()]) {
                case 1: {
                    void type;
                    void account4;
                    List list = TransactionsAPI.invoicesForAccountListAll((APIContext)account4.context, (String)type.getAccountKey()).invoices();
                    Meter meter = list.iterator();
                    while (meter.hasNext()) {
                        void invoices2;
                        GETInvoiceType gETInvoiceType = (GETInvoiceType)meter.next();
                        invoices2.add(account4.get(gETInvoiceType.invoiceNumber()));
                    }
                    break;
                }
                default: {
                    throw ZuoraSdkException.builder().message("Unsupported " + billingDocuments.name()).build();
                }
            }
            object = arrayList;
            return object;
        }
        finally {
            account3 = null;
        }
    }

    public List<BillingDocumentItem> getItems(BillingDocument billingDocument) throws ZuoraSdkException {
        try {
            if (!BillingDocumentType.INVOICE.equals((Object)billingDocument.getType())) {
                throw ZuoraSdkException.builder().message("Unsupported " + billingDocument.getType().name()).build();
            }
            CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new InvoiceItemsByInvoiceQuery(billingDocument.getKey())));
            if (response.get().getData() == null) {
                throw new APIException();
            }
            return ((InvoiceItemsByInvoiceQuery.Data)response.get().getData()).getInvoices().getEdges().get(0).getNode().getInvoiceitems().getEdges().stream().map(item -> BillingDocumentItem.builder().id(item.getNode().getId()).owner(item.getNode().getSubscription().getInvoiceOwner().getAccountNumber()).quantity(item.getNode().getQuantity()).accountsReceivableAccountingCode(item.getNode().getAccountReceivableAccountingCodeId()).createTime(ZonedDateTime.parse(item.getNode().getCreatedDate())).amount(item.getNode().getChargeAmount()).price(item.getNode().getProductRatePlanId()).product(item.getNode().getProductId()).subscriptionPlan(item.getNode().getRatePlanId()).subscriptionPlanItem(item.getNode().getRatePlanChargeId()).deferredRevenueAccountingCode(item.getNode().getDeferredRevenueAccountingCodeId()).balance(item.getNode().getBalance()).unitOfMeasure(item.getNode().getUOM()).subscription(item.getNode().getSubscription().getName()).serviceStartTime(LocalDate.parse(item.getNode().getServiceStartDate())).serviceEndTime(LocalDate.parse(item.getNode().getServiceEndDate())).tax(item.getNode().getTaxAmount()).taxInclusive(item.getNode().getTaxMode() == null ? null : Boolean.valueOf(item.getNode().getTaxMode().equals("Inclusive"))).updateTime(ZonedDateTime.parse(item.getNode().getUpdatedDate())).unitAmount(item.getNode().getUnitPrice()).build()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).message(e.getMessage()).operationName("getBillingDocumentItems").build();
        }
    }

    private BillingDocument postDebitMemo(BillingDocument billingDocument) {
        DebitMemosAPI.DebitMemoPostRequest request = DebitMemosAPI.post((APIContext)this.context, (String)billingDocument.getId());
        GETDebitMemoType response = (GETDebitMemoType)request.execute().head();
        return BillingDocument.builder().client(this.client).type(BillingDocumentType.DEBIT_MEMO).account(billingDocument.getAccount()).amount(response.amount()).state(response.status()).customFields(response.debitMemoObjectCustomFields()).id(response.id()).build();
    }

    private BillingDocument postCreditMemo(BillingDocument billingDocument) {
        CreditMemosAPI.CreditMemoPostRequest request = CreditMemosAPI.post((APIContext)this.context, (String)billingDocument.getId());
        GETCreditMemoType response = (GETCreditMemoType)request.execute().head();
        return BillingDocument.builder().client(this.client).type(BillingDocumentType.CREDIT_MEMO).account(billingDocument.getAccount()).amount(response.amount()).state(response.status()).id(response.id()).build();
    }

    /*
     * WARNING - void declaration
     */
    public BillingDocument post(BillingDocument billingDocument) throws ZuoraSdkException {
        Meter meter;
        String string;
        BillingDocument billingDocument2;
        String string2;
        MetricRegistry metricRegistry;
        BillingDocument billingDocument3;
        Object object;
        long l;
        block8: {
            l = System.currentTimeMillis();
            object = this;
            billingDocument3 = billingDocument;
            try {
                void billingDocument4;
                if (BillingDocumentType.INVOICE.equals((Object)billingDocument3.getType())) {
                    void invoicePostRequest;
                    metricRegistry = InvoicesAPI.post((APIContext)billingDocument4.context, (String)billingDocument3.getId());
                    metricRegistry.status(BillingDocumentStatus.POSTED.getValue());
                    string2 = (BillingDocumentPostResponse)metricRegistry.execute().head();
                    billingDocument2 = BillingDocument.builder().client(billingDocument4.client).type(BillingDocumentType.INVOICE).account(invoicePostRequest.getAccount()).id(string2.id()).build();
                    break block8;
                }
                if (BillingDocumentType.CREDIT_MEMO.equals((Object)billingDocument3.getType())) {
                    billingDocument2 = super.postCreditMemo(billingDocument3);
                    break block8;
                }
                if (BillingDocumentType.DEBIT_MEMO.equals((Object)billingDocument3.getType())) {
                    billingDocument2 = super.postDebitMemo(billingDocument3);
                    break block8;
                }
                throw ZuoraSdkException.builder().message("Unsupport document type to post").build();
            }
            catch (Throwable throwable) {
                object = null;
            }
        }
        object = billingDocument2;
        billingDocument3 = null;
        metricRegistry = SharedMetricRegistries.getOrCreate((String)"zuora");
        string2 = "com.zuora.sdk.BillingDocumentAPI".substring("com.zuora.sdk.BillingDocumentAPI".lastIndexOf(".") + 1);
        if (null != billingDocument3) {
            string = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{billingDocument3.getClass().getSimpleName(), string2, "post"});
            meter = metricRegistry.meter(string);
            meter.mark();
        } else {
            string = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string2, "post"});
            meter = metricRegistry.meter(string);
            meter.mark();
        }
        string = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string2, "post"});
        meter = metricRegistry.histogram(string);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (billingDocument3 != null) {
            throw billingDocument3;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public String writeOff(BillingDocument billingDocument, InvoiceWriteOffData invoiceWriteOffData) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        BillingDocument billingDocument2 = billingDocument;
        InvoiceWriteOffData invoiceWriteOffData2 = invoiceWriteOffData;
        try {
            void invoiceWriteOffRequest;
            void billingDocument3;
            void writeOffData;
            if (!BillingDocumentType.INVOICE.equals((Object)writeOffData.getType())) {
                throw ZuoraSdkException.builder().message("Unsupport document type to write off").build();
            }
            Object object2 = InvoicesAPI.writeOff((APIContext)billingDocument3.context, (String)writeOffData.getId());
            object2.comment(invoiceWriteOffRequest.getComment());
            object2.memoDate(invoiceWriteOffRequest.getMemoDate());
            object2.reasonCode(invoiceWriteOffRequest.getReasonCode());
            Object object3 = (PUTWriteOffInvoiceResponse)object2.execute().head();
            object = object3.creditMemo().id();
            return object;
        }
        finally {
            billingDocument2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Payment pay(BillingDocument billingDocument, BillingDocumentPayRequest billingDocumentPayRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        BillingDocument billingDocument2 = billingDocument;
        BillingDocumentPayRequest billingDocumentPayRequest2 = billingDocumentPayRequest;
        try {
            void debitMemoApplicationCreateRequestType;
            String string;
            void paymentCreateRequest;
            void billingDocument3;
            void request;
            if (request.getId() == null) {
                throw ZuoraSdkException.builder().message("Missing required parameter 'id' in 'billingDocument'.").build();
            }
            if (BillingDocumentType.CREDIT_MEMO.equals((Object)request.getType())) {
                throw ZuoraSdkException.builder().message("Payment is not allowed to be created from credit memo.").build();
            }
            Object object2 = billingDocumentPayRequest2.createAPIRequest(billingDocument3.context);
            object2.accountId(request.getAccount().getId());
            if (BillingDocumentType.INVOICE.equals((Object)request.getType())) {
                void invoiceApplicationCreateRequestType;
                string = new PaymentInvoiceApplicationCreateRequestType().invoiceId(request.getId()).amount(paymentCreateRequest.getAmount());
                invoiceApplicationCreateRequestType.invoices((List)Lists.newArrayList((Object[])new PaymentInvoiceApplicationCreateRequestType[]{string}));
            }
            if (BillingDocumentType.DEBIT_MEMO.equals((Object)request.getType())) {
                string = new PaymentDebitMemoApplicationCreateRequestType().debitMemoId(request.getId()).amount(paymentCreateRequest.getAmount());
                debitMemoApplicationCreateRequestType.debitMemos((List)Lists.newArrayList((Object[])new PaymentDebitMemoApplicationCreateRequestType[]{string}));
            }
            string = (GETARPaymentType)debitMemoApplicationCreateRequestType.execute().head();
            object = billingDocument3.client.payments().get(string.id());
            return object;
        }
        finally {
            billingDocument2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Payment pay(String string, BillingDocumentPayRequest billingDocumentPayRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        String string2 = string;
        BillingDocumentPayRequest billingDocumentPayRequest2 = billingDocumentPayRequest;
        try {
            void billingDocument;
            void request;
            void docNumber;
            BillingDocument billingDocument2 = docNumber.get((String)request);
            object = docNumber.pay(billingDocument2, (BillingDocumentPayRequest)billingDocument);
            return object;
        }
        finally {
            string2 = null;
        }
    }

    private void loadCustomFields(BillingDocument billingDocument) {
        Map customFields = null;
        if (BillingDocumentType.INVOICE.equals((Object)billingDocument.getType())) {
            customFields = InvoicesAPI.objectRetrieve((APIContext)this.context, (String)billingDocument.getId()).invoiceObjectCustomFields();
        } else if (BillingDocumentType.CREDIT_MEMO.equals((Object)billingDocument.getType())) {
            customFields = CreditMemosAPI.retrieve((APIContext)this.context, (String)billingDocument.getId()).creditMemoObjectCustomFields();
        } else if (BillingDocumentType.DEBIT_MEMO.equals((Object)billingDocument.getType())) {
            customFields = DebitMemosAPI.retrieve((APIContext)this.context, (String)billingDocument.getId()).debitMemoObjectCustomFields();
        }
        billingDocument.setCustomFields(customFields);
    }
}

