/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.enums;

import com.google.common.base.Strings;
import com.zuora.sdk.core.models.enums.ApiEnum;

public enum TaxRateType implements ApiEnum
{
    PERCENTAGE("percentage"),
    FLATFEE("flatfee");

    private final String label;

    private TaxRateType(String label) {
        this.label = label;
    }

    public static TaxRateType getByLabel(String label) {
        if (Strings.isNullOrEmpty((String)label)) {
            return null;
        }
        for (TaxRateType value : TaxRateType.values()) {
            if (!value.getApiValue().equalsIgnoreCase(label)) continue;
            return value;
        }
        throw ApiEnum.invalidValue(TaxRateType.class, (String)label);
    }

    public String getApiValue() {
        return this.label;
    }
}

