/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.planitems;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public class PlanItemEnum {

    public static enum Event {
        CONTRACT_EFFECTIVE("ContractEffective"),
        SERVICE_ACTIVATION("ServiceActivation"),
        CUSTOMER_ACCEPTANCE("CustomerAcceptance");

        private final String value;

        private Event(String value) {
            this.value = value;
        }

        public static Event getEventByName(String value) {
            if (Strings.isNullOrEmpty((String)value)) {
                return null;
            }
            for (int i = 0; i < Event.values().length; ++i) {
                if (!value.equals(Event.values()[i].value)) continue;
                return Event.values()[i];
            }
            return null;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum ChargeModel {
        DISCOUNT_FIXED("Discount-Fixed Amount"),
        DISCOUNT_PERCENT("Discount-Percentage"),
        FLAT_FEE("Flat Fee Pricing"),
        PER_UNIT("Per Unit Pricing"),
        OVERAGE("Overage Pricing"),
        TIERED("Tiered Pricing"),
        TIERED_WITH_OVERAGE("Tiered with Overage Pricing"),
        VOLUME("Volume Pricing");

        private final String subscriptionValue;

        private ChargeModel(String value) {
            this.subscriptionValue = value;
        }

        public static ChargeModel getChargeModelByName(String chargeModelName) {
            if (Strings.isNullOrEmpty((String)chargeModelName)) {
                return null;
            }
            for (int i = 0; i < ChargeModel.values().length; ++i) {
                if (!chargeModelName.equals(ChargeModel.values()[i].subscriptionValue)) continue;
                return ChargeModel.values()[i];
            }
            return null;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSubscriptionValue() {
            return this.subscriptionValue;
        }
    }

    public static enum RecurringOn {
        ACCOUNT_CYCLE_DATE("DefaultFromCustomer"),
        SUBSCRIPTION_START_DAY("SubscriptionStartDay"),
        SUBSCRIPTION_PLAN_ITEM_DAY("ChargeTriggerDay"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday"),
        SUNDAY("Sunday"),
        _1("1"),
        _2("2"),
        _3("3"),
        _4("4"),
        _5("5"),
        _6("6"),
        _7("7"),
        _8("8"),
        _9("9"),
        _10("10"),
        _11("11"),
        _12("12"),
        _13("13"),
        _14("14"),
        _15("15"),
        _16("16"),
        _17("17"),
        _18("18"),
        _19("19"),
        _20("20"),
        _21("21"),
        _22("22"),
        _23("23"),
        _24("24"),
        _25("25"),
        _26("26"),
        _27("27"),
        _28("28"),
        _29("29"),
        _30("30"),
        _31("31");

        private final String value;

        private RecurringOn(String value) {
            this.value = value;
        }

        public static RecurringOn getBillCycleTypeByName(String value) {
            if (value == null) {
                return null;
            }
            for (int i = 0; i < RecurringOn.values().length; ++i) {
                if (!value.equals(RecurringOn.values()[i].value)) continue;
                return RecurringOn.values()[i];
            }
            return null;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Alignment {
        SUBSCRIPTION_START("AlignToSubscriptionStart"),
        TERM_START("AlignToTermStart"),
        SUBSCRIPTION_PLAN_ITEM("AlignToCharge");

        public final String label;

        private Alignment(String label) {
            this.label = label;
        }

        public static Alignment getByLabel(String label) {
            if (Strings.isNullOrEmpty((String)label)) {
                return null;
            }
            for (Alignment alignment : Alignment.values()) {
                if (!alignment.label.equals(label)) continue;
                return alignment;
            }
            return null;
        }
    }

    public static enum Interval {
        WEEK("Week"),
        MONTH("Month"),
        QUARTER("Quarter"),
        YEAR("Annual"),
        SUBSCRIPTION_TERM("Subscription Term"),
        SPECIFIC_MONTH("Specific Months"),
        SPECIFIC_WEEK("Specific Weeks");

        final String value;

        private Interval(String value) {
            this.value = value;
        }

        public static Interval getIntervalByName(String value) {
            if (value == null) {
                return null;
            }
            for (int i = 0; i < Interval.values().length; ++i) {
                if (!value.equals(Interval.values()[i].value)) continue;
                return Interval.values()[i];
            }
            return null;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getValue() {
            return this.value;
        }
    }
}

