/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.planitems;

import com.zuora.sdk.chargemodels.ChargeModelInterface;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.core.models.enums.BillingTiming;
import com.zuora.sdk.planitems.PlanItemCreateRequest;
import com.zuora.sdk.planitems.PlanItemEnum;
import com.zuora.sdk.planitems.PlanItemType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumSet;
import lombok.Generated;

public final class OneTimePlanItem
extends PlanItemCreateRequest
implements PlanItemType {
    public OneTimePlanItem(String accountingCode, PlanItemEnum.Event startEvent, ChargeModelInterface chargeModel, String name, PlanItemType.ItemType planItemType, String plan, String description, String taxCode, boolean taxInclusive, BillingTiming timing) {
        super(accountingCode, startEvent, chargeModel, name, PlanItemType.ItemType.ONE_TIME, timing, plan, description, taxCode, taxInclusive);
    }

    public static OneTimePlanItemBuilder oneTimeBuilder() {
        return new OneTimePlanItemBuilder();
    }

    @Override
    public PlanItemType.ItemType getType() {
        return PlanItemType.ItemType.ONE_TIME;
    }

    public OneTimePlanItemBuilder toBuilder() {
        return new OneTimePlanItemBuilder().accountingCode(this.accountingCode).startEvent(this.startEvent).chargeModel(this.chargeModel).name(this.name).planItemType(this.planItemType).plan(this.plan).description(this.description).taxCode(this.taxCode).taxInclusive(this.taxInclusive).timing(this.timing);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OneTimePlanItem(super=" + super.toString() + ")";
    }

    public static class OneTimePlanItemBuilder {
        private final EnumSet<ChargeModelInterface.Type> chargeModels = EnumSet.of(ChargeModelInterface.Type.FLAT_FEE, ChargeModelInterface.Type.PER_UNIT, ChargeModelInterface.Type.TIERED, ChargeModelInterface.Type.VOLUME);
        private String accountingCode;
        private PlanItemEnum.Event startEvent;
        private ChargeModelInterface chargeModel;
        private String name;
        private PlanItemType.ItemType planItemType;
        private String plan;
        private String description;
        private String taxCode;
        private boolean taxInclusive;
        private BillingTiming timing;

        public OneTimePlanItemBuilder chargeModel(ChargeModelInterface chargeModel) {
            if (chargeModel != null && !this.chargeModels.contains((Object)chargeModel.getType())) {
                throw ZuoraSdkException.builder().message("Invalid Charge Model").build();
            }
            this.chargeModel = chargeModel;
            return this;
        }

        public OneTimePlanItemBuilder accountingCode(String accountingCode) {
            this.accountingCode = accountingCode;
            return this;
        }

        public OneTimePlanItemBuilder startEvent(PlanItemEnum.Event startEvent) {
            this.startEvent = startEvent;
            return this;
        }

        public OneTimePlanItemBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OneTimePlanItemBuilder planItemType(PlanItemType.ItemType planItemType) {
            this.planItemType = planItemType;
            return this;
        }

        public OneTimePlanItemBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        public OneTimePlanItemBuilder description(String description) {
            this.description = description;
            return this;
        }

        public OneTimePlanItemBuilder taxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        public OneTimePlanItemBuilder taxInclusive(boolean taxInclusive) {
            this.taxInclusive = taxInclusive;
            return this;
        }

        public OneTimePlanItemBuilder timing(BillingTiming timing) {
            this.timing = timing;
            return this;
        }

        public OneTimePlanItem build() {
            return new OneTimePlanItem(this.accountingCode, this.startEvent, this.chargeModel, this.name, this.planItemType, this.plan, this.description, this.taxCode, this.taxInclusive, this.timing);
        }

        public String toString() {
            return "OneTimePlanItem.OneTimePlanItemBuilder(chargeModels=" + this.chargeModels + ", accountingCode=" + this.accountingCode + ", startEvent=" + (Object)((Object)this.startEvent) + ", chargeModel=" + this.chargeModel + ", name=" + this.name + ", planItemType=" + (Object)((Object)this.planItemType) + ", plan=" + this.plan + ", description=" + this.description + ", taxCode=" + this.taxCode + ", taxInclusive=" + this.taxInclusive + ", timing=" + this.timing + ")";
        }
    }
}

