/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.zuora.JSON;
import com.zuora.model.BillingOptions;
import com.zuora.model.ElectronicPaymentOptions;
import com.zuora.model.WriteOffBehavior;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ProcessingOptions {
    public static final String SERIALIZED_NAME_APPLICATION_ORDER = "applicationOrder";
    @SerializedName(value="applicationOrder")
    private List<String> applicationOrder;
    public static final String SERIALIZED_NAME_APPLY_CREDIT = "applyCredit";
    @SerializedName(value="applyCredit")
    private Boolean applyCredit;
    public static final String SERIALIZED_NAME_APPLY_CREDIT_BALANCE = "applyCreditBalance";
    @SerializedName(value="applyCreditBalance")
    private Boolean applyCreditBalance;
    public static final String SERIALIZED_NAME_BILLING_OPTIONS = "billingOptions";
    @SerializedName(value="billingOptions")
    private BillingOptions billingOptions;
    public static final String SERIALIZED_NAME_COLLECT_PAYMENT = "collectPayment";
    @SerializedName(value="collectPayment")
    private Boolean collectPayment;
    public static final String SERIALIZED_NAME_ELECTRONIC_PAYMENT_OPTIONS = "electronicPaymentOptions";
    @SerializedName(value="electronicPaymentOptions")
    private ElectronicPaymentOptions electronicPaymentOptions;
    public static final String SERIALIZED_NAME_REFUND = "refund";
    @SerializedName(value="refund")
    private Boolean refund;
    public static final String SERIALIZED_NAME_REFUND_AMOUNT = "refundAmount";
    @SerializedName(value="refundAmount")
    private BigDecimal refundAmount;
    public static final String SERIALIZED_NAME_REFUND_REASON_CODE = "refundReasonCode";
    @SerializedName(value="refundReasonCode")
    private String refundReasonCode;
    public static final String SERIALIZED_NAME_RUN_BILLING = "runBilling";
    @SerializedName(value="runBilling")
    private Boolean runBilling;
    public static final String SERIALIZED_NAME_WRITE_OFF = "writeOff";
    @SerializedName(value="writeOff")
    private Boolean writeOff;
    public static final String SERIALIZED_NAME_WRITE_OFF_BEHAVIOR = "writeOffBehavior";
    @SerializedName(value="writeOffBehavior")
    private WriteOffBehavior writeOffBehavior;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ProcessingOptions applicationOrder(List<String> applicationOrder) {
        this.applicationOrder = applicationOrder;
        return this;
    }

    public ProcessingOptions addApplicationOrderItem(String applicationOrderItem) {
        if (this.applicationOrder == null) {
            this.applicationOrder = new ArrayList<String>();
        }
        this.applicationOrder.add(applicationOrderItem);
        return this;
    }

    @Nullable
    public List<String> getApplicationOrder() {
        return this.applicationOrder;
    }

    public void setApplicationOrder(List<String> applicationOrder) {
        this.applicationOrder = applicationOrder;
    }

    public ProcessingOptions applyCredit(Boolean applyCredit) {
        this.applyCredit = applyCredit;
        return this;
    }

    @Nullable
    public Boolean getApplyCredit() {
        return this.applyCredit;
    }

    public void setApplyCredit(Boolean applyCredit) {
        this.applyCredit = applyCredit;
    }

    public ProcessingOptions applyCreditBalance(Boolean applyCreditBalance) {
        this.applyCreditBalance = applyCreditBalance;
        return this;
    }

    @Nullable
    public Boolean getApplyCreditBalance() {
        return this.applyCreditBalance;
    }

    public void setApplyCreditBalance(Boolean applyCreditBalance) {
        this.applyCreditBalance = applyCreditBalance;
    }

    public ProcessingOptions billingOptions(BillingOptions billingOptions) {
        this.billingOptions = billingOptions;
        return this;
    }

    @Nullable
    public BillingOptions getBillingOptions() {
        return this.billingOptions;
    }

    public void setBillingOptions(BillingOptions billingOptions) {
        this.billingOptions = billingOptions;
    }

    public ProcessingOptions collectPayment(Boolean collectPayment) {
        this.collectPayment = collectPayment;
        return this;
    }

    @Nullable
    public Boolean getCollectPayment() {
        return this.collectPayment;
    }

    public void setCollectPayment(Boolean collectPayment) {
        this.collectPayment = collectPayment;
    }

    public ProcessingOptions electronicPaymentOptions(ElectronicPaymentOptions electronicPaymentOptions) {
        this.electronicPaymentOptions = electronicPaymentOptions;
        return this;
    }

    @Nullable
    public ElectronicPaymentOptions getElectronicPaymentOptions() {
        return this.electronicPaymentOptions;
    }

    public void setElectronicPaymentOptions(ElectronicPaymentOptions electronicPaymentOptions) {
        this.electronicPaymentOptions = electronicPaymentOptions;
    }

    public ProcessingOptions refund(Boolean refund) {
        this.refund = refund;
        return this;
    }

    @Nullable
    public Boolean getRefund() {
        return this.refund;
    }

    public void setRefund(Boolean refund) {
        this.refund = refund;
    }

    public ProcessingOptions refundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
        return this;
    }

    @Nullable
    public BigDecimal getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public ProcessingOptions refundReasonCode(String refundReasonCode) {
        this.refundReasonCode = refundReasonCode;
        return this;
    }

    @Nullable
    public String getRefundReasonCode() {
        return this.refundReasonCode;
    }

    public void setRefundReasonCode(String refundReasonCode) {
        this.refundReasonCode = refundReasonCode;
    }

    public ProcessingOptions runBilling(Boolean runBilling) {
        this.runBilling = runBilling;
        return this;
    }

    @Nullable
    public Boolean getRunBilling() {
        return this.runBilling;
    }

    public void setRunBilling(Boolean runBilling) {
        this.runBilling = runBilling;
    }

    public ProcessingOptions writeOff(Boolean writeOff) {
        this.writeOff = writeOff;
        return this;
    }

    @Nullable
    public Boolean getWriteOff() {
        return this.writeOff;
    }

    public void setWriteOff(Boolean writeOff) {
        this.writeOff = writeOff;
    }

    public ProcessingOptions writeOffBehavior(WriteOffBehavior writeOffBehavior) {
        this.writeOffBehavior = writeOffBehavior;
        return this;
    }

    @Nullable
    public WriteOffBehavior getWriteOffBehavior() {
        return this.writeOffBehavior;
    }

    public void setWriteOffBehavior(WriteOffBehavior writeOffBehavior) {
        this.writeOffBehavior = writeOffBehavior;
    }

    public ProcessingOptions putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessingOptions processingOptions = (ProcessingOptions)o;
        return Objects.equals(this.applicationOrder, processingOptions.applicationOrder) && Objects.equals(this.applyCredit, processingOptions.applyCredit) && Objects.equals(this.applyCreditBalance, processingOptions.applyCreditBalance) && Objects.equals(this.billingOptions, processingOptions.billingOptions) && Objects.equals(this.collectPayment, processingOptions.collectPayment) && Objects.equals(this.electronicPaymentOptions, processingOptions.electronicPaymentOptions) && Objects.equals(this.refund, processingOptions.refund) && Objects.equals(this.refundAmount, processingOptions.refundAmount) && Objects.equals(this.refundReasonCode, processingOptions.refundReasonCode) && Objects.equals(this.runBilling, processingOptions.runBilling) && Objects.equals(this.writeOff, processingOptions.writeOff) && Objects.equals(this.writeOffBehavior, processingOptions.writeOffBehavior) && Objects.equals(this.additionalProperties, processingOptions.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.applicationOrder, this.applyCredit, this.applyCreditBalance, this.billingOptions, this.collectPayment, this.electronicPaymentOptions, this.refund, this.refundAmount, this.refundReasonCode, this.runBilling, this.writeOff, this.writeOffBehavior, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessingOptions {\n");
        sb.append("    applicationOrder: ").append(this.toIndentedString(this.applicationOrder)).append("\n");
        sb.append("    applyCredit: ").append(this.toIndentedString(this.applyCredit)).append("\n");
        sb.append("    applyCreditBalance: ").append(this.toIndentedString(this.applyCreditBalance)).append("\n");
        sb.append("    billingOptions: ").append(this.toIndentedString(this.billingOptions)).append("\n");
        sb.append("    collectPayment: ").append(this.toIndentedString(this.collectPayment)).append("\n");
        sb.append("    electronicPaymentOptions: ").append(this.toIndentedString(this.electronicPaymentOptions)).append("\n");
        sb.append("    refund: ").append(this.toIndentedString(this.refund)).append("\n");
        sb.append("    refundAmount: ").append(this.toIndentedString(this.refundAmount)).append("\n");
        sb.append("    refundReasonCode: ").append(this.toIndentedString(this.refundReasonCode)).append("\n");
        sb.append("    runBilling: ").append(this.toIndentedString(this.runBilling)).append("\n");
        sb.append("    writeOff: ").append(this.toIndentedString(this.writeOff)).append("\n");
        sb.append("    writeOffBehavior: ").append(this.toIndentedString(this.writeOffBehavior)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ProcessingOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_ORDER) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_ORDER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APPLICATION_ORDER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `applicationOrder` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_ORDER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BILLING_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_BILLING_OPTIONS).isJsonNull()) {
            BillingOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_BILLING_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ELECTRONIC_PAYMENT_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ELECTRONIC_PAYMENT_OPTIONS).isJsonNull()) {
            ElectronicPaymentOptions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ELECTRONIC_PAYMENT_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFUND_REASON_CODE) != null && !jsonObj.get(SERIALIZED_NAME_REFUND_REASON_CODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REFUND_REASON_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `refundReasonCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFUND_REASON_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WRITE_OFF_BEHAVIOR) != null && !jsonObj.get(SERIALIZED_NAME_WRITE_OFF_BEHAVIOR).isJsonNull()) {
            WriteOffBehavior.validateJsonElement(jsonObj.get(SERIALIZED_NAME_WRITE_OFF_BEHAVIOR));
        }
    }

    public static ProcessingOptions fromJson(String jsonString) throws IOException {
        return (ProcessingOptions)JSON.getGson().fromJson(jsonString, ProcessingOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_APPLICATION_ORDER);
        openapiFields.add(SERIALIZED_NAME_APPLY_CREDIT);
        openapiFields.add(SERIALIZED_NAME_APPLY_CREDIT_BALANCE);
        openapiFields.add(SERIALIZED_NAME_BILLING_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_COLLECT_PAYMENT);
        openapiFields.add(SERIALIZED_NAME_ELECTRONIC_PAYMENT_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_REFUND);
        openapiFields.add(SERIALIZED_NAME_REFUND_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_REFUND_REASON_CODE);
        openapiFields.add(SERIALIZED_NAME_RUN_BILLING);
        openapiFields.add(SERIALIZED_NAME_WRITE_OFF);
        openapiFields.add(SERIALIZED_NAME_WRITE_OFF_BEHAVIOR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ProcessingOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ProcessingOptions.class));
            return new TypeAdapter<ProcessingOptions>(){

                public void write(JsonWriter out, ProcessingOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    out.beginObject();
                    for (Map.Entry e : obj.entrySet()) {
                        out.name((String)e.getKey());
                        elementAdapter.write(out, (Object)((JsonElement)e.getValue()));
                    }
                    if (value.getAdditionalProperties() != null) {
                        boolean oldSerializeNulls = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                            } else if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                            } else if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                            } else if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                            } else if (entry.getValue() == null) {
                                obj.add(entry.getKey(), null);
                            } else {
                                obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                            }
                            out.name(entry.getKey());
                            elementAdapter.write(out, (Object)obj.get(entry.getKey()));
                        }
                        out.setSerializeNulls(oldSerializeNulls);
                    }
                    out.endObject();
                }

                public ProcessingOptions read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ProcessingOptions.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    ProcessingOptions instance = (ProcessingOptions)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

