/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.DeleteWorkflowSuccess;
import com.zuora.model.ExportWorkflowVersionResponse;
import com.zuora.model.GetVersionsResponse;
import com.zuora.model.GetWorkflowResponse;
import com.zuora.model.GetWorkflowsResponse;
import com.zuora.model.PATCHUpdateWorkflowRequest;
import com.zuora.model.PostWorkflowDefinitionImportRequest;
import com.zuora.model.PostWorkflowVersionsImportRequest;
import com.zuora.model.PutTasksRequest;
import com.zuora.model.Task;
import com.zuora.model.TasksResponse;
import com.zuora.model.UsagesResponse;
import com.zuora.model.Workflow;
import com.zuora.model.WorkflowDefinition;
import com.zuora.model.WorkflowInstance;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class WorkflowsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkflowsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call deleteWorkflowCall(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows/{workflow_id}".replace("{workflow_id}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWorkflowValidateBeforeCall(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling deleteWorkflow(Async)");
        }
        return this.deleteWorkflowCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected DeleteWorkflowSuccess deleteWorkflow(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<DeleteWorkflowSuccess> localVarResp = this.deleteWorkflowWithHttpInfo(workflowId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<DeleteWorkflowSuccess> deleteWorkflowWithHttpInfo(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.deleteWorkflowValidateBeforeCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<DeleteWorkflowSuccess>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteWorkflowAsync(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<DeleteWorkflowSuccess> _callback) throws ApiException {
        Call localVarCall = this.deleteWorkflowValidateBeforeCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<DeleteWorkflowSuccess>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteWorkflowApi deleteWorkflowApi(String workflowId) {
        return new DeleteWorkflowApi(workflowId);
    }

    private Call deleteWorkflowVersionCall(Integer versionId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/versions/{version_id}".replace("{version_id}", this.localVarApiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWorkflowVersionValidateBeforeCall(Integer versionId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (versionId == null) {
            throw new ApiException("Missing the required parameter 'versionId' when calling deleteWorkflowVersion(Async)");
        }
        return this.deleteWorkflowVersionCall(versionId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected DeleteWorkflowSuccess deleteWorkflowVersion(Integer versionId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<DeleteWorkflowSuccess> localVarResp = this.deleteWorkflowVersionWithHttpInfo(versionId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<DeleteWorkflowSuccess> deleteWorkflowVersionWithHttpInfo(Integer versionId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.deleteWorkflowVersionValidateBeforeCall(versionId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<DeleteWorkflowSuccess>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteWorkflowVersionAsync(Integer versionId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<DeleteWorkflowSuccess> _callback) throws ApiException {
        Call localVarCall = this.deleteWorkflowVersionValidateBeforeCall(versionId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<DeleteWorkflowSuccess>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteWorkflowVersionApi deleteWorkflowVersionApi(Integer versionId) {
        return new DeleteWorkflowVersionApi(versionId);
    }

    private Call getWorkflowCall(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows/{workflow_id}".replace("{workflow_id}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowValidateBeforeCall(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling getWorkflow(Async)");
        }
        return this.getWorkflowCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected WorkflowDefinition getWorkflow(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<WorkflowDefinition> localVarResp = this.getWorkflowWithHttpInfo(workflowId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<WorkflowDefinition> getWorkflowWithHttpInfo(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getWorkflowValidateBeforeCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<WorkflowDefinition>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getWorkflowAsync(String workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<WorkflowDefinition> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowValidateBeforeCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<WorkflowDefinition>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetWorkflowApi getWorkflowApi(String workflowId) {
        return new GetWorkflowApi(workflowId);
    }

    private Call getWorkflowExportCall(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String version, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows/{workflow_id}/export".replace("{workflow_id}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowExportValidateBeforeCall(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String version, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling getWorkflowExport(Async)");
        }
        return this.getWorkflowExportCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, version, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected ExportWorkflowVersionResponse getWorkflowExport(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String version, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<ExportWorkflowVersionResponse> localVarResp = this.getWorkflowExportWithHttpInfo(workflowId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, version, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<ExportWorkflowVersionResponse> getWorkflowExportWithHttpInfo(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String version, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getWorkflowExportValidateBeforeCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, version, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<ExportWorkflowVersionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getWorkflowExportAsync(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String version, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<ExportWorkflowVersionResponse> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowExportValidateBeforeCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, version, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<ExportWorkflowVersionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetWorkflowExportApi getWorkflowExportApi(Integer workflowId) {
        return new GetWorkflowExportApi(workflowId);
    }

    private Call getWorkflowRunCall(String workflowRunId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows/workflow_runs/{workflow_run_id}".replace("{workflow_run_id}", this.localVarApiClient.escapeString(workflowRunId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowRunValidateBeforeCall(String workflowRunId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (workflowRunId == null) {
            throw new ApiException("Missing the required parameter 'workflowRunId' when calling getWorkflowRun(Async)");
        }
        return this.getWorkflowRunCall(workflowRunId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected GetWorkflowResponse getWorkflowRun(String workflowRunId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<GetWorkflowResponse> localVarResp = this.getWorkflowRunWithHttpInfo(workflowRunId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<GetWorkflowResponse> getWorkflowRunWithHttpInfo(String workflowRunId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getWorkflowRunValidateBeforeCall(workflowRunId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<GetWorkflowResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getWorkflowRunAsync(String workflowRunId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<GetWorkflowResponse> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowRunValidateBeforeCall(workflowRunId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<GetWorkflowResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetWorkflowRunApi getWorkflowRunApi(String workflowRunId) {
        return new GetWorkflowRunApi(workflowRunId);
    }

    private Call getWorkflowVersionsCall(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows/{workflow_id}/versions".replace("{workflow_id}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowVersionsValidateBeforeCall(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling getWorkflowVersions(Async)");
        }
        return this.getWorkflowVersionsCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected GetVersionsResponse getWorkflowVersions(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<GetVersionsResponse> localVarResp = this.getWorkflowVersionsWithHttpInfo(workflowId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<GetVersionsResponse> getWorkflowVersionsWithHttpInfo(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getWorkflowVersionsValidateBeforeCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<GetVersionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getWorkflowVersionsAsync(Integer workflowId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<GetVersionsResponse> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowVersionsValidateBeforeCall(workflowId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<GetVersionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetWorkflowVersionsApi getWorkflowVersionsApi(Integer workflowId) {
        return new GetWorkflowVersionsApi(workflowId);
    }

    private Call getWorkflowsCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, Boolean calloutTrigger, String interval, String name, Boolean ondemandTrigger, Boolean scheduledTrigger, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (calloutTrigger != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("callout_trigger", calloutTrigger));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (ondemandTrigger != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ondemand_trigger", ondemandTrigger));
        }
        if (scheduledTrigger != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("scheduled_trigger", scheduledTrigger));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageLength != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_length", pageLength));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowsValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, Boolean calloutTrigger, String interval, String name, Boolean ondemandTrigger, Boolean scheduledTrigger, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        return this.getWorkflowsCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, calloutTrigger, interval, name, ondemandTrigger, scheduledTrigger, page, pageLength, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected GetWorkflowsResponse getWorkflows(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, Boolean calloutTrigger, String interval, String name, Boolean ondemandTrigger, Boolean scheduledTrigger, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<GetWorkflowsResponse> localVarResp = this.getWorkflowsWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, calloutTrigger, interval, name, ondemandTrigger, scheduledTrigger, page, pageLength, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<GetWorkflowsResponse> getWorkflowsWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, Boolean calloutTrigger, String interval, String name, Boolean ondemandTrigger, Boolean scheduledTrigger, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getWorkflowsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, calloutTrigger, interval, name, ondemandTrigger, scheduledTrigger, page, pageLength, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<GetWorkflowsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getWorkflowsAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, Boolean calloutTrigger, String interval, String name, Boolean ondemandTrigger, Boolean scheduledTrigger, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<GetWorkflowsResponse> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, calloutTrigger, interval, name, ondemandTrigger, scheduledTrigger, page, pageLength, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<GetWorkflowsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetWorkflowsApi getWorkflowsApi() {
        return new GetWorkflowsApi();
    }

    private Call getWorkflowsTaskCall(String taskId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows/tasks/{task_id}".replace("{task_id}", this.localVarApiClient.escapeString(taskId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowsTaskValidateBeforeCall(String taskId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (taskId == null) {
            throw new ApiException("Missing the required parameter 'taskId' when calling getWorkflowsTask(Async)");
        }
        return this.getWorkflowsTaskCall(taskId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected Task getWorkflowsTask(String taskId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<Task> localVarResp = this.getWorkflowsTaskWithHttpInfo(taskId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<Task> getWorkflowsTaskWithHttpInfo(String taskId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getWorkflowsTaskValidateBeforeCall(taskId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<Task>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getWorkflowsTaskAsync(String taskId, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<Task> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowsTaskValidateBeforeCall(taskId, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<Task>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetWorkflowsTaskApi getWorkflowsTaskApi(String taskId) {
        return new GetWorkflowsTaskApi(taskId);
    }

    private Call getWorkflowsTasksCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String id, String name, Boolean instance, String actionType, String _object, String objectId, String callType, String workflowId, List<String> tags, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows/tasks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (instance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("instance", instance));
        }
        if (actionType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("action_type", actionType));
        }
        if (_object != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("object", _object));
        }
        if (objectId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("object_id", objectId));
        }
        if (callType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("call_type", callType));
        }
        if (workflowId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("workflow_id", workflowId));
        }
        if (tags != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "tags", tags));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageLength != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_length", pageLength));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowsTasksValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String id, String name, Boolean instance, String actionType, String _object, String objectId, String callType, String workflowId, List<String> tags, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        return this.getWorkflowsTasksCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, id, name, instance, actionType, _object, objectId, callType, workflowId, tags, page, pageLength, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected TasksResponse getWorkflowsTasks(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String id, String name, Boolean instance, String actionType, String _object, String objectId, String callType, String workflowId, List<String> tags, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<TasksResponse> localVarResp = this.getWorkflowsTasksWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, id, name, instance, actionType, _object, objectId, callType, workflowId, tags, page, pageLength, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<TasksResponse> getWorkflowsTasksWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String id, String name, Boolean instance, String actionType, String _object, String objectId, String callType, String workflowId, List<String> tags, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getWorkflowsTasksValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, id, name, instance, actionType, _object, objectId, callType, workflowId, tags, page, pageLength, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<TasksResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getWorkflowsTasksAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String id, String name, Boolean instance, String actionType, String _object, String objectId, String callType, String workflowId, List<String> tags, Integer page, Integer pageLength, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<TasksResponse> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowsTasksValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, id, name, instance, actionType, _object, objectId, callType, workflowId, tags, page, pageLength, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<TasksResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetWorkflowsTasksApi getWorkflowsTasksApi() {
        return new GetWorkflowsTasksApi();
    }

    private Call getWorkflowsUsagesCall(LocalDate startDate, LocalDate endDate, String metrics, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows/metrics.json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (metrics != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("metrics", metrics));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowsUsagesValidateBeforeCall(LocalDate startDate, LocalDate endDate, String metrics, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getWorkflowsUsages(Async)");
        }
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getWorkflowsUsages(Async)");
        }
        if (metrics == null) {
            throw new ApiException("Missing the required parameter 'metrics' when calling getWorkflowsUsages(Async)");
        }
        return this.getWorkflowsUsagesCall(startDate, endDate, metrics, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected UsagesResponse getWorkflowsUsages(LocalDate startDate, LocalDate endDate, String metrics, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<UsagesResponse> localVarResp = this.getWorkflowsUsagesWithHttpInfo(startDate, endDate, metrics, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<UsagesResponse> getWorkflowsUsagesWithHttpInfo(LocalDate startDate, LocalDate endDate, String metrics, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getWorkflowsUsagesValidateBeforeCall(startDate, endDate, metrics, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<UsagesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getWorkflowsUsagesAsync(LocalDate startDate, LocalDate endDate, String metrics, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<UsagesResponse> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowsUsagesValidateBeforeCall(startDate, endDate, metrics, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<UsagesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetWorkflowsUsagesApi getWorkflowsUsagesApi(LocalDate startDate, LocalDate endDate, String metrics) {
        return new GetWorkflowsUsagesApi(startDate, endDate, metrics);
    }

    private Call pATCHUpdateWorkflowCall(String workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PATCHUpdateWorkflowRequest request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PATCHUpdateWorkflowRequest localVarPostBody = request;
        String localVarPath = "/workflows/{workflow_id}".replace("{workflow_id}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call pATCHUpdateWorkflowValidateBeforeCall(String workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PATCHUpdateWorkflowRequest request, ApiCallback _callback) throws ApiException {
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling pATCHUpdateWorkflow(Async)");
        }
        return this.pATCHUpdateWorkflowCall(workflowId, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request, _callback);
    }

    protected WorkflowDefinition pATCHUpdateWorkflow(String workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PATCHUpdateWorkflowRequest request) throws ApiException {
        ApiResponse<WorkflowDefinition> localVarResp = this.pATCHUpdateWorkflowWithHttpInfo(workflowId, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request);
        return localVarResp.getData();
    }

    private ApiResponse<WorkflowDefinition> pATCHUpdateWorkflowWithHttpInfo(String workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PATCHUpdateWorkflowRequest request) throws ApiException {
        Call localVarCall = this.pATCHUpdateWorkflowValidateBeforeCall(workflowId, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request, null);
        Type localVarReturnType = new TypeToken<WorkflowDefinition>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call pATCHUpdateWorkflowAsync(String workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PATCHUpdateWorkflowRequest request, ApiCallback<WorkflowDefinition> _callback) throws ApiException {
        Call localVarCall = this.pATCHUpdateWorkflowValidateBeforeCall(workflowId, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request, _callback);
        Type localVarReturnType = new TypeToken<WorkflowDefinition>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PATCHUpdateWorkflowApi pATCHUpdateWorkflowApi(String workflowId) {
        return new PATCHUpdateWorkflowApi(workflowId);
    }

    private Call postRunWorkflowCall(Integer workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, Object inputparameters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = inputparameters;
        String localVarPath = "/workflows/{workflow_id}/run".replace("{workflow_id}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postRunWorkflowValidateBeforeCall(Integer workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, Object inputparameters, ApiCallback _callback) throws ApiException {
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling postRunWorkflow(Async)");
        }
        return this.postRunWorkflowCall(workflowId, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, inputparameters, _callback);
    }

    protected WorkflowInstance postRunWorkflow(Integer workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, Object inputparameters) throws ApiException {
        ApiResponse<WorkflowInstance> localVarResp = this.postRunWorkflowWithHttpInfo(workflowId, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, inputparameters);
        return localVarResp.getData();
    }

    private ApiResponse<WorkflowInstance> postRunWorkflowWithHttpInfo(Integer workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, Object inputparameters) throws ApiException {
        Call localVarCall = this.postRunWorkflowValidateBeforeCall(workflowId, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, inputparameters, null);
        Type localVarReturnType = new TypeToken<WorkflowInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postRunWorkflowAsync(Integer workflowId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, Object inputparameters, ApiCallback<WorkflowInstance> _callback) throws ApiException {
        Call localVarCall = this.postRunWorkflowValidateBeforeCall(workflowId, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, inputparameters, _callback);
        Type localVarReturnType = new TypeToken<WorkflowInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostRunWorkflowApi postRunWorkflowApi(Integer workflowId) {
        return new PostRunWorkflowApi(workflowId);
    }

    private Call postWorkflowImportCall(String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Integer workflowDefinitionId, String version, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowDefinitionImportRequest request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostWorkflowDefinitionImportRequest localVarPostBody = request;
        String localVarPath = "/workflows/import";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (workflowDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("workflow_definition_id", workflowDefinitionId));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (activate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activate", activate));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postWorkflowImportValidateBeforeCall(String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Integer workflowDefinitionId, String version, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowDefinitionImportRequest request, ApiCallback _callback) throws ApiException {
        return this.postWorkflowImportCall(idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, workflowDefinitionId, version, activate, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request, _callback);
    }

    protected Workflow postWorkflowImport(String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Integer workflowDefinitionId, String version, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowDefinitionImportRequest request) throws ApiException {
        ApiResponse<Workflow> localVarResp = this.postWorkflowImportWithHttpInfo(idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, workflowDefinitionId, version, activate, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request);
        return localVarResp.getData();
    }

    private ApiResponse<Workflow> postWorkflowImportWithHttpInfo(String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Integer workflowDefinitionId, String version, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowDefinitionImportRequest request) throws ApiException {
        Call localVarCall = this.postWorkflowImportValidateBeforeCall(idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, workflowDefinitionId, version, activate, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request, null);
        Type localVarReturnType = new TypeToken<Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postWorkflowImportAsync(String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Integer workflowDefinitionId, String version, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowDefinitionImportRequest request, ApiCallback<Workflow> _callback) throws ApiException {
        Call localVarCall = this.postWorkflowImportValidateBeforeCall(idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, workflowDefinitionId, version, activate, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request, _callback);
        Type localVarReturnType = new TypeToken<Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostWorkflowImportApi postWorkflowImportApi() {
        return new PostWorkflowImportApi();
    }

    private Call postWorkflowVersionsImportCall(Integer workflowId, String version, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowVersionsImportRequest request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostWorkflowVersionsImportRequest localVarPostBody = request;
        String localVarPath = "/workflows/{workflow_id}/versions/import".replace("{workflow_id}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (activate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activate", activate));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postWorkflowVersionsImportValidateBeforeCall(Integer workflowId, String version, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowVersionsImportRequest request, ApiCallback _callback) throws ApiException {
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling postWorkflowVersionsImport(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling postWorkflowVersionsImport(Async)");
        }
        return this.postWorkflowVersionsImportCall(workflowId, version, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, activate, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request, _callback);
    }

    protected WorkflowDefinition postWorkflowVersionsImport(Integer workflowId, String version, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowVersionsImportRequest request) throws ApiException {
        ApiResponse<WorkflowDefinition> localVarResp = this.postWorkflowVersionsImportWithHttpInfo(workflowId, version, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, activate, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request);
        return localVarResp.getData();
    }

    private ApiResponse<WorkflowDefinition> postWorkflowVersionsImportWithHttpInfo(Integer workflowId, String version, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowVersionsImportRequest request) throws ApiException {
        Call localVarCall = this.postWorkflowVersionsImportValidateBeforeCall(workflowId, version, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, activate, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request, null);
        Type localVarReturnType = new TypeToken<WorkflowDefinition>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postWorkflowVersionsImportAsync(Integer workflowId, String version, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, Boolean activate, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PostWorkflowVersionsImportRequest request, ApiCallback<WorkflowDefinition> _callback) throws ApiException {
        Call localVarCall = this.postWorkflowVersionsImportValidateBeforeCall(workflowId, version, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, activate, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, request, _callback);
        Type localVarReturnType = new TypeToken<WorkflowDefinition>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostWorkflowVersionsImportApi postWorkflowVersionsImportApi(Integer workflowId, String version) {
        return new PostWorkflowVersionsImportApi(workflowId, version);
    }

    private Call postWorkflowsTaskRerunCall(String taskId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/workflows/tasks/{task_id}/rerun".replace("{task_id}", this.localVarApiClient.escapeString(taskId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postWorkflowsTaskRerunValidateBeforeCall(String taskId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (taskId == null) {
            throw new ApiException("Missing the required parameter 'taskId' when calling postWorkflowsTaskRerun(Async)");
        }
        return this.postWorkflowsTaskRerunCall(taskId, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected Task postWorkflowsTaskRerun(String taskId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<Task> localVarResp = this.postWorkflowsTaskRerunWithHttpInfo(taskId, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<Task> postWorkflowsTaskRerunWithHttpInfo(String taskId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.postWorkflowsTaskRerunValidateBeforeCall(taskId, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<Task>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postWorkflowsTaskRerunAsync(String taskId, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<Task> _callback) throws ApiException {
        Call localVarCall = this.postWorkflowsTaskRerunValidateBeforeCall(taskId, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<Task>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostWorkflowsTaskRerunApi postWorkflowsTaskRerunApi(String taskId) {
        return new PostWorkflowsTaskRerunApi(taskId);
    }

    private Call putWorkflowsTasksUpdateCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PutTasksRequest updateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PutTasksRequest localVarPostBody = updateRequest;
        String localVarPath = "/workflows/tasks/batch_update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putWorkflowsTasksUpdateValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PutTasksRequest updateRequest, ApiCallback _callback) throws ApiException {
        return this.putWorkflowsTasksUpdateCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, updateRequest, _callback);
    }

    protected TasksResponse putWorkflowsTasksUpdate(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PutTasksRequest updateRequest) throws ApiException {
        ApiResponse<TasksResponse> localVarResp = this.putWorkflowsTasksUpdateWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, updateRequest);
        return localVarResp.getData();
    }

    private ApiResponse<TasksResponse> putWorkflowsTasksUpdateWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PutTasksRequest updateRequest) throws ApiException {
        Call localVarCall = this.putWorkflowsTasksUpdateValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, updateRequest, null);
        Type localVarReturnType = new TypeToken<TasksResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call putWorkflowsTasksUpdateAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, PutTasksRequest updateRequest, ApiCallback<TasksResponse> _callback) throws ApiException {
        Call localVarCall = this.putWorkflowsTasksUpdateValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, updateRequest, _callback);
        Type localVarReturnType = new TypeToken<TasksResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PutWorkflowsTasksUpdateApi putWorkflowsTasksUpdateApi() {
        return new PutWorkflowsTasksUpdateApi();
    }

    public class PutWorkflowsTasksUpdateApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;
        private PutTasksRequest updateRequest;

        private PutWorkflowsTasksUpdateApi() {
        }

        public PutWorkflowsTasksUpdateApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PutWorkflowsTasksUpdateApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PutWorkflowsTasksUpdateApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PutWorkflowsTasksUpdateApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PutWorkflowsTasksUpdateApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PutWorkflowsTasksUpdateApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PutWorkflowsTasksUpdateApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public PutWorkflowsTasksUpdateApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public PutWorkflowsTasksUpdateApi updateRequest(PutTasksRequest updateRequest) {
            this.updateRequest = updateRequest;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.putWorkflowsTasksUpdateCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.updateRequest, _callback);
        }

        public TasksResponse execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.putWorkflowsTasksUpdateWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.updateRequest);
            return (TasksResponse)localVarResp.getData();
        }

        private ApiResponse<TasksResponse> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.putWorkflowsTasksUpdateWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.updateRequest);
        }

        public Call executeAsync(ApiCallback<TasksResponse> _callback) throws ApiException {
            return WorkflowsApi.this.putWorkflowsTasksUpdateAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.updateRequest, _callback);
        }
    }

    public class PostWorkflowsTaskRerunApi {
        private final String taskId;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private PostWorkflowsTaskRerunApi(String taskId) {
            this.taskId = taskId;
        }

        public PostWorkflowsTaskRerunApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostWorkflowsTaskRerunApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostWorkflowsTaskRerunApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostWorkflowsTaskRerunApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostWorkflowsTaskRerunApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostWorkflowsTaskRerunApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostWorkflowsTaskRerunApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostWorkflowsTaskRerunApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public PostWorkflowsTaskRerunApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.postWorkflowsTaskRerunCall(this.taskId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public Task execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.postWorkflowsTaskRerunWithHttpInfo(this.taskId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (Task)localVarResp.getData();
        }

        private ApiResponse<Task> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.postWorkflowsTaskRerunWithHttpInfo(this.taskId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<Task> _callback) throws ApiException {
            return WorkflowsApi.this.postWorkflowsTaskRerunAsync(this.taskId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class PostWorkflowVersionsImportApi {
        private final Integer workflowId;
        private final String version;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private Boolean activate;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;
        private PostWorkflowVersionsImportRequest request;

        private PostWorkflowVersionsImportApi(Integer workflowId, String version) {
            this.workflowId = workflowId;
            this.version = version;
        }

        public PostWorkflowVersionsImportApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostWorkflowVersionsImportApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostWorkflowVersionsImportApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostWorkflowVersionsImportApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostWorkflowVersionsImportApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostWorkflowVersionsImportApi activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        public PostWorkflowVersionsImportApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostWorkflowVersionsImportApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public PostWorkflowVersionsImportApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public PostWorkflowVersionsImportApi request(PostWorkflowVersionsImportRequest request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.postWorkflowVersionsImportCall(this.workflowId, this.version, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.activate, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request, _callback);
        }

        public WorkflowDefinition execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.postWorkflowVersionsImportWithHttpInfo(this.workflowId, this.version, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.activate, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request);
            return (WorkflowDefinition)localVarResp.getData();
        }

        private ApiResponse<WorkflowDefinition> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.postWorkflowVersionsImportWithHttpInfo(this.workflowId, this.version, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.activate, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request);
        }

        public Call executeAsync(ApiCallback<WorkflowDefinition> _callback) throws ApiException {
            return WorkflowsApi.this.postWorkflowVersionsImportAsync(this.workflowId, this.version, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.activate, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request, _callback);
        }
    }

    public class PostWorkflowImportApi {
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private Integer workflowDefinitionId;
        private String version;
        private Boolean activate;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;
        private PostWorkflowDefinitionImportRequest request;

        private PostWorkflowImportApi() {
        }

        public PostWorkflowImportApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostWorkflowImportApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostWorkflowImportApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostWorkflowImportApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostWorkflowImportApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostWorkflowImportApi workflowDefinitionId(Integer workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
            return this;
        }

        public PostWorkflowImportApi version(String version) {
            this.version = version;
            return this;
        }

        public PostWorkflowImportApi activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        public PostWorkflowImportApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostWorkflowImportApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public PostWorkflowImportApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public PostWorkflowImportApi request(PostWorkflowDefinitionImportRequest request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.postWorkflowImportCall(this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.workflowDefinitionId, this.version, this.activate, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request, _callback);
        }

        public Workflow execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.postWorkflowImportWithHttpInfo(this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.workflowDefinitionId, this.version, this.activate, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request);
            return (Workflow)localVarResp.getData();
        }

        private ApiResponse<Workflow> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.postWorkflowImportWithHttpInfo(this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.workflowDefinitionId, this.version, this.activate, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request);
        }

        public Call executeAsync(ApiCallback<Workflow> _callback) throws ApiException {
            return WorkflowsApi.this.postWorkflowImportAsync(this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.workflowDefinitionId, this.version, this.activate, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request, _callback);
        }
    }

    public class PostRunWorkflowApi {
        private final Integer workflowId;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;
        private Object inputparameters;

        private PostRunWorkflowApi(Integer workflowId) {
            this.workflowId = workflowId;
        }

        public PostRunWorkflowApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostRunWorkflowApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostRunWorkflowApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostRunWorkflowApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostRunWorkflowApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostRunWorkflowApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostRunWorkflowApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PostRunWorkflowApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public PostRunWorkflowApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public PostRunWorkflowApi inputparameters(Object inputparameters) {
            this.inputparameters = inputparameters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.postRunWorkflowCall(this.workflowId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.inputparameters, _callback);
        }

        public WorkflowInstance execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.postRunWorkflowWithHttpInfo(this.workflowId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.inputparameters);
            return (WorkflowInstance)localVarResp.getData();
        }

        private ApiResponse<WorkflowInstance> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.postRunWorkflowWithHttpInfo(this.workflowId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.inputparameters);
        }

        public Call executeAsync(ApiCallback<WorkflowInstance> _callback) throws ApiException {
            return WorkflowsApi.this.postRunWorkflowAsync(this.workflowId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.inputparameters, _callback);
        }
    }

    public class PATCHUpdateWorkflowApi {
        private final String workflowId;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;
        private PATCHUpdateWorkflowRequest request;

        private PATCHUpdateWorkflowApi(String workflowId) {
            this.workflowId = workflowId;
        }

        public PATCHUpdateWorkflowApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PATCHUpdateWorkflowApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PATCHUpdateWorkflowApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PATCHUpdateWorkflowApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PATCHUpdateWorkflowApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PATCHUpdateWorkflowApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PATCHUpdateWorkflowApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PATCHUpdateWorkflowApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public PATCHUpdateWorkflowApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public PATCHUpdateWorkflowApi request(PATCHUpdateWorkflowRequest request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.pATCHUpdateWorkflowCall(this.workflowId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request, _callback);
        }

        public WorkflowDefinition execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.pATCHUpdateWorkflowWithHttpInfo(this.workflowId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request);
            return (WorkflowDefinition)localVarResp.getData();
        }

        private ApiResponse<WorkflowDefinition> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.pATCHUpdateWorkflowWithHttpInfo(this.workflowId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request);
        }

        public Call executeAsync(ApiCallback<WorkflowDefinition> _callback) throws ApiException {
            return WorkflowsApi.this.pATCHUpdateWorkflowAsync(this.workflowId, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, this.request, _callback);
        }
    }

    public class GetWorkflowsUsagesApi {
        private final LocalDate startDate;
        private final LocalDate endDate;
        private final String metrics;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetWorkflowsUsagesApi(LocalDate startDate, LocalDate endDate, String metrics) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.metrics = metrics;
        }

        public GetWorkflowsUsagesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetWorkflowsUsagesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetWorkflowsUsagesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetWorkflowsUsagesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetWorkflowsUsagesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetWorkflowsUsagesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetWorkflowsUsagesApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetWorkflowsUsagesApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowsUsagesCall(this.startDate, this.endDate, this.metrics, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public UsagesResponse execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.getWorkflowsUsagesWithHttpInfo(this.startDate, this.endDate, this.metrics, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (UsagesResponse)localVarResp.getData();
        }

        private ApiResponse<UsagesResponse> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.getWorkflowsUsagesWithHttpInfo(this.startDate, this.endDate, this.metrics, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<UsagesResponse> _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowsUsagesAsync(this.startDate, this.endDate, this.metrics, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetWorkflowsTasksApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String id;
        private String name;
        private Boolean instance;
        private String actionType;
        private String _object;
        private String objectId;
        private String callType;
        private String workflowId;
        private List<String> tags;
        private Integer page;
        private Integer pageLength;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetWorkflowsTasksApi() {
        }

        public GetWorkflowsTasksApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetWorkflowsTasksApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetWorkflowsTasksApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetWorkflowsTasksApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetWorkflowsTasksApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetWorkflowsTasksApi id(String id) {
            this.id = id;
            return this;
        }

        public GetWorkflowsTasksApi name(String name) {
            this.name = name;
            return this;
        }

        public GetWorkflowsTasksApi instance(Boolean instance) {
            this.instance = instance;
            return this;
        }

        public GetWorkflowsTasksApi actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public GetWorkflowsTasksApi _object(String _object) {
            this._object = _object;
            return this;
        }

        public GetWorkflowsTasksApi objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public GetWorkflowsTasksApi callType(String callType) {
            this.callType = callType;
            return this;
        }

        public GetWorkflowsTasksApi workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public GetWorkflowsTasksApi tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public GetWorkflowsTasksApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetWorkflowsTasksApi pageLength(Integer pageLength) {
            this.pageLength = pageLength;
            return this;
        }

        public GetWorkflowsTasksApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetWorkflowsTasksApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetWorkflowsTasksApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowsTasksCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.id, this.name, this.instance, this.actionType, this._object, this.objectId, this.callType, this.workflowId, this.tags, this.page, this.pageLength, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public TasksResponse execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.getWorkflowsTasksWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.id, this.name, this.instance, this.actionType, this._object, this.objectId, this.callType, this.workflowId, this.tags, this.page, this.pageLength, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (TasksResponse)localVarResp.getData();
        }

        private ApiResponse<TasksResponse> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.getWorkflowsTasksWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.id, this.name, this.instance, this.actionType, this._object, this.objectId, this.callType, this.workflowId, this.tags, this.page, this.pageLength, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<TasksResponse> _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowsTasksAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.id, this.name, this.instance, this.actionType, this._object, this.objectId, this.callType, this.workflowId, this.tags, this.page, this.pageLength, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetWorkflowsTaskApi {
        private final String taskId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetWorkflowsTaskApi(String taskId) {
            this.taskId = taskId;
        }

        public GetWorkflowsTaskApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetWorkflowsTaskApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetWorkflowsTaskApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetWorkflowsTaskApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetWorkflowsTaskApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetWorkflowsTaskApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetWorkflowsTaskApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetWorkflowsTaskApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowsTaskCall(this.taskId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public Task execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.getWorkflowsTaskWithHttpInfo(this.taskId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (Task)localVarResp.getData();
        }

        private ApiResponse<Task> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.getWorkflowsTaskWithHttpInfo(this.taskId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<Task> _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowsTaskAsync(this.taskId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetWorkflowsApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private Boolean calloutTrigger;
        private String interval;
        private String name;
        private Boolean ondemandTrigger;
        private Boolean scheduledTrigger;
        private Integer page;
        private Integer pageLength;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetWorkflowsApi() {
        }

        public GetWorkflowsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetWorkflowsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetWorkflowsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetWorkflowsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetWorkflowsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetWorkflowsApi calloutTrigger(Boolean calloutTrigger) {
            this.calloutTrigger = calloutTrigger;
            return this;
        }

        public GetWorkflowsApi interval(String interval) {
            this.interval = interval;
            return this;
        }

        public GetWorkflowsApi name(String name) {
            this.name = name;
            return this;
        }

        public GetWorkflowsApi ondemandTrigger(Boolean ondemandTrigger) {
            this.ondemandTrigger = ondemandTrigger;
            return this;
        }

        public GetWorkflowsApi scheduledTrigger(Boolean scheduledTrigger) {
            this.scheduledTrigger = scheduledTrigger;
            return this;
        }

        public GetWorkflowsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetWorkflowsApi pageLength(Integer pageLength) {
            this.pageLength = pageLength;
            return this;
        }

        public GetWorkflowsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetWorkflowsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetWorkflowsApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowsCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.calloutTrigger, this.interval, this.name, this.ondemandTrigger, this.scheduledTrigger, this.page, this.pageLength, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public GetWorkflowsResponse execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.getWorkflowsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.calloutTrigger, this.interval, this.name, this.ondemandTrigger, this.scheduledTrigger, this.page, this.pageLength, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (GetWorkflowsResponse)localVarResp.getData();
        }

        private ApiResponse<GetWorkflowsResponse> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.getWorkflowsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.calloutTrigger, this.interval, this.name, this.ondemandTrigger, this.scheduledTrigger, this.page, this.pageLength, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<GetWorkflowsResponse> _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowsAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.calloutTrigger, this.interval, this.name, this.ondemandTrigger, this.scheduledTrigger, this.page, this.pageLength, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetWorkflowVersionsApi {
        private final Integer workflowId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetWorkflowVersionsApi(Integer workflowId) {
            this.workflowId = workflowId;
        }

        public GetWorkflowVersionsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetWorkflowVersionsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetWorkflowVersionsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetWorkflowVersionsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetWorkflowVersionsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetWorkflowVersionsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetWorkflowVersionsApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowVersionsCall(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public GetVersionsResponse execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.getWorkflowVersionsWithHttpInfo(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (GetVersionsResponse)localVarResp.getData();
        }

        private ApiResponse<GetVersionsResponse> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.getWorkflowVersionsWithHttpInfo(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<GetVersionsResponse> _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowVersionsAsync(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetWorkflowRunApi {
        private final String workflowRunId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetWorkflowRunApi(String workflowRunId) {
            this.workflowRunId = workflowRunId;
        }

        public GetWorkflowRunApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetWorkflowRunApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetWorkflowRunApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetWorkflowRunApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetWorkflowRunApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetWorkflowRunApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetWorkflowRunApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetWorkflowRunApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowRunCall(this.workflowRunId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public GetWorkflowResponse execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.getWorkflowRunWithHttpInfo(this.workflowRunId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (GetWorkflowResponse)localVarResp.getData();
        }

        private ApiResponse<GetWorkflowResponse> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.getWorkflowRunWithHttpInfo(this.workflowRunId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<GetWorkflowResponse> _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowRunAsync(this.workflowRunId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetWorkflowExportApi {
        private final Integer workflowId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String version;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetWorkflowExportApi(Integer workflowId) {
            this.workflowId = workflowId;
        }

        public GetWorkflowExportApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetWorkflowExportApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetWorkflowExportApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetWorkflowExportApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetWorkflowExportApi version(String version) {
            this.version = version;
            return this;
        }

        public GetWorkflowExportApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetWorkflowExportApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetWorkflowExportApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowExportCall(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.version, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public ExportWorkflowVersionResponse execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.getWorkflowExportWithHttpInfo(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.version, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (ExportWorkflowVersionResponse)localVarResp.getData();
        }

        private ApiResponse<ExportWorkflowVersionResponse> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.getWorkflowExportWithHttpInfo(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.version, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<ExportWorkflowVersionResponse> _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowExportAsync(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.version, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetWorkflowApi {
        private final String workflowId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetWorkflowApi(String workflowId) {
            this.workflowId = workflowId;
        }

        public GetWorkflowApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetWorkflowApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetWorkflowApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetWorkflowApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetWorkflowApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetWorkflowApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetWorkflowApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetWorkflowApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowCall(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public WorkflowDefinition execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.getWorkflowWithHttpInfo(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (WorkflowDefinition)localVarResp.getData();
        }

        private ApiResponse<WorkflowDefinition> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.getWorkflowWithHttpInfo(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<WorkflowDefinition> _callback) throws ApiException {
            return WorkflowsApi.this.getWorkflowAsync(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class DeleteWorkflowVersionApi {
        private final Integer versionId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private DeleteWorkflowVersionApi(Integer versionId) {
            this.versionId = versionId;
        }

        public DeleteWorkflowVersionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteWorkflowVersionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteWorkflowVersionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteWorkflowVersionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteWorkflowVersionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteWorkflowVersionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public DeleteWorkflowVersionApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.deleteWorkflowVersionCall(this.versionId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public DeleteWorkflowSuccess execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.deleteWorkflowVersionWithHttpInfo(this.versionId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (DeleteWorkflowSuccess)localVarResp.getData();
        }

        private ApiResponse<DeleteWorkflowSuccess> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.deleteWorkflowVersionWithHttpInfo(this.versionId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<DeleteWorkflowSuccess> _callback) throws ApiException {
            return WorkflowsApi.this.deleteWorkflowVersionAsync(this.versionId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class DeleteWorkflowApi {
        private final String workflowId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private DeleteWorkflowApi(String workflowId) {
            this.workflowId = workflowId;
        }

        public DeleteWorkflowApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteWorkflowApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteWorkflowApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteWorkflowApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteWorkflowApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteWorkflowApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteWorkflowApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public DeleteWorkflowApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WorkflowsApi.this.deleteWorkflowCall(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public DeleteWorkflowSuccess execute() throws ApiException {
            ApiResponse localVarResp = WorkflowsApi.this.deleteWorkflowWithHttpInfo(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (DeleteWorkflowSuccess)localVarResp.getData();
        }

        private ApiResponse<DeleteWorkflowSuccess> executeWithHttpInfo() throws ApiException {
            return WorkflowsApi.this.deleteWorkflowWithHttpInfo(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<DeleteWorkflowSuccess> _callback) throws ApiException {
            return WorkflowsApi.this.deleteWorkflowAsync(this.workflowId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }
}

