/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.PaymentRunSummary;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class PaymentRun {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_APPLY_CREDIT_MEMOS = "apply_credit_memos";
    @SerializedName(value="apply_credit_memos")
    private Boolean applyCreditMemos;
    public static final String SERIALIZED_NAME_APPLY_UNAPPLIED_PAYMENTS = "apply_unapplied_payments";
    @SerializedName(value="apply_unapplied_payments")
    private Boolean applyUnappliedPayments;
    public static final String SERIALIZED_NAME_BATCH = "batch";
    @SerializedName(value="batch")
    private String batch;
    public static final String SERIALIZED_NAME_CONSOLIDATE_PAYMENT = "consolidate_payment";
    @SerializedName(value="consolidate_payment")
    private Boolean consolidatePayment;
    public static final String SERIALIZED_NAME_BILL_CYCLE_DAY = "bill_cycle_day";
    @SerializedName(value="bill_cycle_day")
    private Integer billCycleDay;
    public static final String SERIALIZED_NAME_BILL_RUN_ID = "bill_run_id";
    @SerializedName(value="bill_run_id")
    private String billRunId;
    public static final String SERIALIZED_NAME_COLLECT_PAYMENT = "collect_payment";
    @SerializedName(value="collect_payment")
    private Boolean collectPayment;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_STATE_TRANSITIONS = "state_transitions";
    @SerializedName(value="state_transitions")
    private Object stateTransitions;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY_ID = "payment_gateway_id";
    @SerializedName(value="payment_gateway_id")
    private String paymentGatewayId;
    public static final String SERIALIZED_NAME_PAYMENT_COLLECTION_DATE = "payment_collection_date";
    @SerializedName(value="payment_collection_date")
    private OffsetDateTime paymentCollectionDate;
    public static final String SERIALIZED_NAME_PAYMENT_RUN_NUMBER = "payment_run_number";
    @SerializedName(value="payment_run_number")
    private String paymentRunNumber;
    public static final String SERIALIZED_NAME_PAYMENT_RUN_DATE = "payment_run_date";
    @SerializedName(value="payment_run_date")
    private OffsetDateTime paymentRunDate;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_SUMMARY = "summary";
    @SerializedName(value="summary")
    private PaymentRunSummary summary;

    public PaymentRun() {
    }

    public PaymentRun(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, OffsetDateTime paymentCollectionDate, PaymentRunSummary summary) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.paymentCollectionDate = paymentCollectionDate;
        this.summary = summary;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public PaymentRun customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PaymentRun putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public PaymentRun applyCreditMemos(Boolean applyCreditMemos) {
        this.applyCreditMemos = applyCreditMemos;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, any posted credit memos are applied first.")
    public Boolean getApplyCreditMemos() {
        return this.applyCreditMemos;
    }

    public void setApplyCreditMemos(Boolean applyCreditMemos) {
        this.applyCreditMemos = applyCreditMemos;
    }

    public PaymentRun applyUnappliedPayments(Boolean applyUnappliedPayments) {
        this.applyUnappliedPayments = applyUnappliedPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, any unapplied payments are applied first.")
    public Boolean getApplyUnappliedPayments() {
        return this.applyUnappliedPayments;
    }

    public void setApplyUnappliedPayments(Boolean applyUnappliedPayments) {
        this.applyUnappliedPayments = applyUnappliedPayments;
    }

    public PaymentRun batch(String batch) {
        this.batch = batch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the customer account batch to be included in this payment run.")
    public String getBatch() {
        return this.batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public PaymentRun consolidatePayment(Boolean consolidatePayment) {
        this.consolidatePayment = consolidatePayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, a single payment will be collected for all receivables due on an account.")
    public Boolean getConsolidatePayment() {
        return this.consolidatePayment;
    }

    public void setConsolidatePayment(Boolean consolidatePayment) {
        this.consolidatePayment = consolidatePayment;
    }

    public PaymentRun billCycleDay(Integer billCycleDay) {
        this.billCycleDay = billCycleDay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The day of the month to bill multiple customer accounts.")
    public Integer getBillCycleDay() {
        return this.billCycleDay;
    }

    public void setBillCycleDay(Integer billCycleDay) {
        this.billCycleDay = billCycleDay;
    }

    public PaymentRun billRunId(String billRunId) {
        this.billRunId = billRunId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of a bill run.")
    public String getBillRunId() {
        return this.billRunId;
    }

    public void setBillRunId(String billRunId) {
        this.billRunId = billRunId;
    }

    public PaymentRun collectPayment(Boolean collectPayment) {
        this.collectPayment = collectPayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to process electronic payments during the execution of payment runs.")
    public Boolean getCollectPayment() {
        return this.collectPayment;
    }

    public void setCollectPayment(Boolean collectPayment) {
        this.collectPayment = collectPayment;
    }

    public PaymentRun currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Three-letter ISO currency code.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentRun stateTransitions(Object stateTransitions) {
        this.stateTransitions = stateTransitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the payment run executed, in the `yyyy-mm-dd hh:mm:ss` format.")
    public Object getStateTransitions() {
        return this.stateTransitions;
    }

    public void setStateTransitions(Object stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    public PaymentRun paymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the payment gateway.")
    public String getPaymentGatewayId() {
        return this.paymentGatewayId;
    }

    public void setPaymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getPaymentCollectionDate() {
        return this.paymentCollectionDate;
    }

    public PaymentRun paymentRunNumber(String paymentRunNumber) {
        this.paymentRunNumber = paymentRunNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier for this object.")
    public String getPaymentRunNumber() {
        return this.paymentRunNumber;
    }

    public void setPaymentRunNumber(String paymentRunNumber) {
        this.paymentRunNumber = paymentRunNumber;
    }

    public PaymentRun paymentRunDate(OffsetDateTime paymentRunDate) {
        this.paymentRunDate = paymentRunDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the scheduled payment run is to be executed, in `yyyy-mm-dd hh:mm:ss` format.")
    public OffsetDateTime getPaymentRunDate() {
        return this.paymentRunDate;
    }

    public void setPaymentRunDate(OffsetDateTime paymentRunDate) {
        this.paymentRunDate = paymentRunDate;
    }

    public PaymentRun targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The target date used to determine which receivables to be paid in the payment run.       The payments are collected for all receivables with the due date no later than the target date.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public PaymentRun state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status of the payment run.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    @Nullable
    @ApiModelProperty(value="Summary of the payment run.")
    public PaymentRunSummary getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRun paymentRun = (PaymentRun)o;
        return Objects.equals(this.id, paymentRun.id) && Objects.equals(this.updatedById, paymentRun.updatedById) && Objects.equals(this.updatedTime, paymentRun.updatedTime) && Objects.equals(this.createdById, paymentRun.createdById) && Objects.equals(this.createdTime, paymentRun.createdTime) && Objects.equals(this.customFields, paymentRun.customFields) && Objects.equals(this.customObjects, paymentRun.customObjects) && Objects.equals(this.applyCreditMemos, paymentRun.applyCreditMemos) && Objects.equals(this.applyUnappliedPayments, paymentRun.applyUnappliedPayments) && Objects.equals(this.batch, paymentRun.batch) && Objects.equals(this.consolidatePayment, paymentRun.consolidatePayment) && Objects.equals(this.billCycleDay, paymentRun.billCycleDay) && Objects.equals(this.billRunId, paymentRun.billRunId) && Objects.equals(this.collectPayment, paymentRun.collectPayment) && Objects.equals(this.currency, paymentRun.currency) && Objects.equals(this.stateTransitions, paymentRun.stateTransitions) && Objects.equals(this.paymentGatewayId, paymentRun.paymentGatewayId) && Objects.equals(this.paymentCollectionDate, paymentRun.paymentCollectionDate) && Objects.equals(this.paymentRunNumber, paymentRun.paymentRunNumber) && Objects.equals(this.paymentRunDate, paymentRun.paymentRunDate) && Objects.equals(this.targetDate, paymentRun.targetDate) && Objects.equals((Object)this.state, (Object)paymentRun.state) && Objects.equals(this.summary, paymentRun.summary);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.applyCreditMemos, this.applyUnappliedPayments, this.batch, this.consolidatePayment, this.billCycleDay, this.billRunId, this.collectPayment, this.currency, this.stateTransitions, this.paymentGatewayId, this.paymentCollectionDate, this.paymentRunNumber, this.paymentRunDate, this.targetDate, this.state, this.summary});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRun {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    applyCreditMemos: ").append(this.toIndentedString(this.applyCreditMemos)).append("\n");
        sb.append("    applyUnappliedPayments: ").append(this.toIndentedString(this.applyUnappliedPayments)).append("\n");
        sb.append("    batch: ").append(this.toIndentedString(this.batch)).append("\n");
        sb.append("    consolidatePayment: ").append(this.toIndentedString(this.consolidatePayment)).append("\n");
        sb.append("    billCycleDay: ").append(this.toIndentedString(this.billCycleDay)).append("\n");
        sb.append("    billRunId: ").append(this.toIndentedString(this.billRunId)).append("\n");
        sb.append("    collectPayment: ").append(this.toIndentedString(this.collectPayment)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    stateTransitions: ").append(this.toIndentedString(this.stateTransitions)).append("\n");
        sb.append("    paymentGatewayId: ").append(this.toIndentedString(this.paymentGatewayId)).append("\n");
        sb.append("    paymentCollectionDate: ").append(this.toIndentedString(this.paymentCollectionDate)).append("\n");
        sb.append("    paymentRunNumber: ").append(this.toIndentedString(this.paymentRunNumber)).append("\n");
        sb.append("    paymentRunDate: ").append(this.toIndentedString(this.paymentRunDate)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PROCESSING("processing"),
        PENDING("pending"),
        COMPLETED("completed"),
        CANCELED("canceled"),
        FAILED("failed"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

