/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.BillingDocumentListResponse;
import org.openapitools.client.model.BillingDocumentSettings;
import org.openapitools.client.model.Contact;
import org.openapitools.client.model.CreditMemoListResponse;
import org.openapitools.client.model.DebitMemoListResponse;
import org.openapitools.client.model.InvoiceListResponse;
import org.openapitools.client.model.ListUsageResponse;
import org.openapitools.client.model.PaymentListResponse;
import org.openapitools.client.model.PaymentMethod;
import org.openapitools.client.model.PaymentMethodListResponse;
import org.openapitools.client.model.SubscriptionListResponse;
import org.openapitools.client.model.TaxCertificate;
import org.openapitools.client.model.TaxIdentifier;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="The account data.")
public class Account {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_SETTINGS = "billing_document_settings";
    @SerializedName(value="billing_document_settings")
    private BillingDocumentSettings billingDocumentSettings;
    public static final String SERIALIZED_NAME_BATCH = "batch";
    @SerializedName(value="batch")
    private String batch;
    public static final String SERIALIZED_NAME_BILL_CYCLE_DAY = "bill_cycle_day";
    @SerializedName(value="bill_cycle_day")
    private Integer billCycleDay;
    public static final String SERIALIZED_NAME_BILL_TO = "bill_to";
    @SerializedName(value="bill_to")
    private Contact billTo;
    public static final String SERIALIZED_NAME_SOLD_TO = "sold_to";
    @SerializedName(value="sold_to")
    private Contact soldTo;
    public static final String SERIALIZED_NAME_COMMUNICATION_PROFILE_ID = "communication_profile_id";
    @SerializedName(value="communication_profile_id")
    private String communicationProfileId;
    public static final String SERIALIZED_NAME_CRM_ID = "crm_id";
    @SerializedName(value="crm_id")
    private String crmId;
    public static final String SERIALIZED_NAME_DEFAULT_PAYMENT_METHOD_ID = "default_payment_method_id";
    @SerializedName(value="default_payment_method_id")
    private String defaultPaymentMethodId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PARENT_ACCOUNT_ID = "parent_account_id";
    @SerializedName(value="parent_account_id")
    private String parentAccountId;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY = "payment_gateway";
    @SerializedName(value="payment_gateway")
    private String paymentGateway;
    public static final String SERIALIZED_NAME_PAYMENT_TERMS = "payment_terms";
    @SerializedName(value="payment_terms")
    private String paymentTerms;
    public static final String SERIALIZED_NAME_SEQUENCE_SET_ID = "sequence_set_id";
    @SerializedName(value="sequence_set_id")
    private String sequenceSetId;
    public static final String SERIALIZED_NAME_AUTO_PAY = "auto_pay";
    @SerializedName(value="auto_pay")
    private Boolean autoPay;
    public static final String SERIALIZED_NAME_TAX_CERTIFICATE = "tax_certificate";
    @SerializedName(value="tax_certificate")
    private TaxCertificate taxCertificate;
    public static final String SERIALIZED_NAME_TAX_IDENTIFIER = "tax_identifier";
    @SerializedName(value="tax_identifier")
    private TaxIdentifier taxIdentifier;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_SALES_REP = "sales_rep";
    @SerializedName(value="sales_rep")
    private String salesRep;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_REMAINING_DEBIT_MEMO_BALANCE = "remaining_debit_memo_balance";
    @SerializedName(value="remaining_debit_memo_balance")
    private BigDecimal remainingDebitMemoBalance;
    public static final String SERIALIZED_NAME_REMAINING_INVOICE_BALANCE = "remaining_invoice_balance";
    @SerializedName(value="remaining_invoice_balance")
    private BigDecimal remainingInvoiceBalance;
    public static final String SERIALIZED_NAME_REMAINING_CREDIT_MEMO_BALANCE = "remaining_credit_memo_balance";
    @SerializedName(value="remaining_credit_memo_balance")
    private BigDecimal remainingCreditMemoBalance;
    public static final String SERIALIZED_NAME_REMAINING_PAYMENT_BALANCE = "remaining_payment_balance";
    @SerializedName(value="remaining_payment_balance")
    private BigDecimal remainingPaymentBalance;
    public static final String SERIALIZED_NAME_BILL_TO_ID = "bill_to_id";
    @SerializedName(value="bill_to_id")
    private String billToId;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    private String soldToId;
    public static final String SERIALIZED_NAME_DEFAULT_PAYMENT_METHOD = "default_payment_method";
    @SerializedName(value="default_payment_method")
    private PaymentMethod defaultPaymentMethod;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENTS = "billing_documents";
    @SerializedName(value="billing_documents")
    private BillingDocumentListResponse billingDocuments;
    public static final String SERIALIZED_NAME_PAYMENTS = "payments";
    @SerializedName(value="payments")
    private PaymentListResponse payments;
    public static final String SERIALIZED_NAME_PAYMENT_METHODS = "payment_methods";
    @SerializedName(value="payment_methods")
    private PaymentMethodListResponse paymentMethods;
    public static final String SERIALIZED_NAME_SUBSCRIPTIONS = "subscriptions";
    @SerializedName(value="subscriptions")
    private SubscriptionListResponse subscriptions;
    public static final String SERIALIZED_NAME_USAGE_RECORDS = "usage_records";
    @SerializedName(value="usage_records")
    private ListUsageResponse usageRecords;
    public static final String SERIALIZED_NAME_CREDIT_MEMOS = "credit_memos";
    @SerializedName(value="credit_memos")
    private CreditMemoListResponse creditMemos;
    public static final String SERIALIZED_NAME_DEBIT_MEMOS = "debit_memos";
    @SerializedName(value="debit_memos")
    private DebitMemoListResponse debitMemos;
    public static final String SERIALIZED_NAME_INVOICES = "invoices";
    @SerializedName(value="invoices")
    private InvoiceListResponse invoices;

    public Account() {
    }

    public Account(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, Contact billTo, Contact soldTo, Boolean enabled, BigDecimal remainingDebitMemoBalance, BigDecimal remainingInvoiceBalance, BigDecimal remainingCreditMemoBalance, BigDecimal remainingPaymentBalance, BillingDocumentListResponse billingDocuments, PaymentListResponse payments, PaymentMethodListResponse paymentMethods, SubscriptionListResponse subscriptions, ListUsageResponse usageRecords, CreditMemoListResponse creditMemos, DebitMemoListResponse debitMemos, InvoiceListResponse invoices) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.billTo = billTo;
        this.soldTo = soldTo;
        this.enabled = enabled;
        this.remainingDebitMemoBalance = remainingDebitMemoBalance;
        this.remainingInvoiceBalance = remainingInvoiceBalance;
        this.remainingCreditMemoBalance = remainingCreditMemoBalance;
        this.remainingPaymentBalance = remainingPaymentBalance;
        this.billingDocuments = billingDocuments;
        this.payments = payments;
        this.paymentMethods = paymentMethods;
        this.subscriptions = subscriptions;
        this.usageRecords = usageRecords;
        this.creditMemos = creditMemos;
        this.debitMemos = debitMemos;
        this.invoices = invoices;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public Account customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Account putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public Account accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A-100001", value="Human-readable identifier of the account. It can be user-supplied.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Account billingDocumentSettings(BillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BillingDocumentSettings getBillingDocumentSettings() {
        return this.billingDocumentSettings;
    }

    public void setBillingDocumentSettings(BillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
    }

    public Account batch(String batch) {
        this.batch = batch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of a bill run batch.")
    public String getBatch() {
        return this.batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Account billCycleDay(Integer billCycleDay) {
        this.billCycleDay = billCycleDay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The day of the month on which your customer will be invoiced. For month-end specify 31.")
    public Integer getBillCycleDay() {
        return this.billCycleDay;
    }

    public void setBillCycleDay(Integer billCycleDay) {
        this.billCycleDay = billCycleDay;
    }

    @Nullable
    @ApiModelProperty(value="Customer billing address.")
    public Contact getBillTo() {
        return this.billTo;
    }

    @Nullable
    @ApiModelProperty(value="Customer address used for calculating tax.")
    public Contact getSoldTo() {
        return this.soldTo;
    }

    public Account communicationProfileId(String communicationProfileId) {
        this.communicationProfileId = communicationProfileId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0946a6dffc0016a7faab604299b", value="Identifier of the communication profile associated with this customer.")
    public String getCommunicationProfileId() {
        return this.communicationProfileId;
    }

    public void setCommunicationProfileId(String communicationProfileId) {
        this.communicationProfileId = communicationProfileId;
    }

    public Account crmId(String crmId) {
        this.crmId = crmId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1a2b3c4d5e", value="CRM account identifier.")
    public String getCrmId() {
        return this.crmId;
    }

    public void setCrmId(String crmId) {
        this.crmId = crmId;
    }

    public Account defaultPaymentMethodId(String defaultPaymentMethodId) {
        this.defaultPaymentMethodId = defaultPaymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8a95b1946b6aeac8718c32aab8c395f", value="Identifier of the default payment method on the customer account.")
    public String getDefaultPaymentMethodId() {
        return this.defaultPaymentMethodId;
    }

    public void setDefaultPaymentMethodId(String defaultPaymentMethodId) {
        this.defaultPaymentMethodId = defaultPaymentMethodId;
    }

    public Account name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="test account", value="The name of the customer account.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Account description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of test account", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Account parentAccountId(String parentAccountId) {
        this.parentAccountId = parentAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="Identifier of this customer's parent account, if any.")
    public String getParentAccountId() {
        return this.parentAccountId;
    }

    public void setParentAccountId(String parentAccountId) {
        this.parentAccountId = parentAccountId;
    }

    public Account paymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="adyen gateway", value="Payment gateway name.")
    public String getPaymentGateway() {
        return this.paymentGateway;
    }

    public void setPaymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
    }

    public Account paymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Net 30", value="Payment terms configured in **Billing Settings > Payment Terms** of your Zuora tenant.")
    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    public Account sequenceSetId(String sequenceSetId) {
        this.sequenceSetId = sequenceSetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92a4204a6dffc0016a7faab723041c", value="The identifier or the billing document sequence set that is assigned to the customer account.")
    public String getSequenceSetId() {
        return this.sequenceSetId;
    }

    public void setSequenceSetId(String sequenceSetId) {
        this.sequenceSetId = sequenceSetId;
    }

    public Account autoPay(Boolean autoPay) {
        this.autoPay = autoPay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Controls whether future payments are automatically billed when they are due.")
    public Boolean getAutoPay() {
        return this.autoPay;
    }

    public void setAutoPay(Boolean autoPay) {
        this.autoPay = autoPay;
    }

    public Account taxCertificate(TaxCertificate taxCertificate) {
        this.taxCertificate = taxCertificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaxCertificate getTaxCertificate() {
        return this.taxCertificate;
    }

    public void setTaxCertificate(TaxCertificate taxCertificate) {
        this.taxCertificate = taxCertificate;
    }

    public Account taxIdentifier(TaxIdentifier taxIdentifier) {
        this.taxIdentifier = taxIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaxIdentifier getTaxIdentifier() {
        return this.taxIdentifier;
    }

    public void setTaxIdentifier(TaxIdentifier taxIdentifier) {
        this.taxIdentifier = taxIdentifier;
    }

    public Account currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Three-letter ISO currency code. Once the currency is set for an account, it cannot be updated.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Account salesRep(String salesRep) {
        this.salesRep = salesRep;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Max", value="The name of the sales representative associated with this account")
    public String getSalesRep() {
        return this.salesRep;
    }

    public void setSalesRep(String salesRep) {
        this.salesRep = salesRep;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Usually used to disable the customer account. The default is true. If false, attempts to create subscriptions for the customer account will fail.")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Total remaining balance of all posted debit memos.")
    public BigDecimal getRemainingDebitMemoBalance() {
        return this.remainingDebitMemoBalance;
    }

    @Nullable
    @ApiModelProperty(example="100", value="Total remaining balance of all posted invoices.")
    public BigDecimal getRemainingInvoiceBalance() {
        return this.remainingInvoiceBalance;
    }

    @Nullable
    @ApiModelProperty(example="50", value="Total remaining balance of all posted credit memos.")
    public BigDecimal getRemainingCreditMemoBalance() {
        return this.remainingCreditMemoBalance;
    }

    @Nullable
    @ApiModelProperty(example="20", value="Total remaining balance of all posted payments.")
    public BigDecimal getRemainingPaymentBalance() {
        return this.remainingPaymentBalance;
    }

    public Account billToId(String billToId) {
        this.billToId = billToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="Customer billing address.")
    public String getBillToId() {
        return this.billToId;
    }

    public void setBillToId(String billToId) {
        this.billToId = billToId;
    }

    public Account soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad0823f8040e52d0180433026b156fe", value="Customer address used for calculating tax.")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    public Account defaultPaymentMethod(PaymentMethod defaultPaymentMethod) {
        this.defaultPaymentMethod = defaultPaymentMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default payment method for the customer.")
    public PaymentMethod getDefaultPaymentMethod() {
        return this.defaultPaymentMethod;
    }

    public void setDefaultPaymentMethod(PaymentMethod defaultPaymentMethod) {
        this.defaultPaymentMethod = defaultPaymentMethod;
    }

    @Nullable
    @ApiModelProperty(value="List of customer billing documents.")
    public BillingDocumentListResponse getBillingDocuments() {
        return this.billingDocuments;
    }

    @Nullable
    @ApiModelProperty(value="List of customer payments.")
    public PaymentListResponse getPayments() {
        return this.payments;
    }

    @Nullable
    @ApiModelProperty(value="List of customer payment methods.")
    public PaymentMethodListResponse getPaymentMethods() {
        return this.paymentMethods;
    }

    @Nullable
    @ApiModelProperty(value="List of customer subscriptions.")
    public SubscriptionListResponse getSubscriptions() {
        return this.subscriptions;
    }

    @Nullable
    @ApiModelProperty(value="List of customer usages.")
    public ListUsageResponse getUsageRecords() {
        return this.usageRecords;
    }

    @Nullable
    @ApiModelProperty(value="List of credit memo")
    public CreditMemoListResponse getCreditMemos() {
        return this.creditMemos;
    }

    @Nullable
    @ApiModelProperty(value="List of debit memo")
    public DebitMemoListResponse getDebitMemos() {
        return this.debitMemos;
    }

    @Nullable
    @ApiModelProperty(value="List of invoices")
    public InvoiceListResponse getInvoices() {
        return this.invoices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.id, account.id) && Objects.equals(this.updatedById, account.updatedById) && Objects.equals(this.updatedTime, account.updatedTime) && Objects.equals(this.createdById, account.createdById) && Objects.equals(this.createdTime, account.createdTime) && Objects.equals(this.customFields, account.customFields) && Objects.equals(this.customObjects, account.customObjects) && Objects.equals(this.accountNumber, account.accountNumber) && Objects.equals(this.billingDocumentSettings, account.billingDocumentSettings) && Objects.equals(this.batch, account.batch) && Objects.equals(this.billCycleDay, account.billCycleDay) && Objects.equals(this.billTo, account.billTo) && Objects.equals(this.soldTo, account.soldTo) && Objects.equals(this.communicationProfileId, account.communicationProfileId) && Objects.equals(this.crmId, account.crmId) && Objects.equals(this.defaultPaymentMethodId, account.defaultPaymentMethodId) && Objects.equals(this.name, account.name) && Objects.equals(this.description, account.description) && Objects.equals(this.parentAccountId, account.parentAccountId) && Objects.equals(this.paymentGateway, account.paymentGateway) && Objects.equals(this.paymentTerms, account.paymentTerms) && Objects.equals(this.sequenceSetId, account.sequenceSetId) && Objects.equals(this.autoPay, account.autoPay) && Objects.equals(this.taxCertificate, account.taxCertificate) && Objects.equals(this.taxIdentifier, account.taxIdentifier) && Objects.equals(this.currency, account.currency) && Objects.equals(this.salesRep, account.salesRep) && Objects.equals(this.enabled, account.enabled) && Objects.equals(this.remainingDebitMemoBalance, account.remainingDebitMemoBalance) && Objects.equals(this.remainingInvoiceBalance, account.remainingInvoiceBalance) && Objects.equals(this.remainingCreditMemoBalance, account.remainingCreditMemoBalance) && Objects.equals(this.remainingPaymentBalance, account.remainingPaymentBalance) && Objects.equals(this.billToId, account.billToId) && Objects.equals(this.soldToId, account.soldToId) && Objects.equals(this.defaultPaymentMethod, account.defaultPaymentMethod) && Objects.equals(this.billingDocuments, account.billingDocuments) && Objects.equals(this.payments, account.payments) && Objects.equals(this.paymentMethods, account.paymentMethods) && Objects.equals(this.subscriptions, account.subscriptions) && Objects.equals(this.usageRecords, account.usageRecords) && Objects.equals(this.creditMemos, account.creditMemos) && Objects.equals(this.debitMemos, account.debitMemos) && Objects.equals(this.invoices, account.invoices);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.accountNumber, this.billingDocumentSettings, this.batch, this.billCycleDay, this.billTo, this.soldTo, this.communicationProfileId, this.crmId, this.defaultPaymentMethodId, this.name, this.description, this.parentAccountId, this.paymentGateway, this.paymentTerms, this.sequenceSetId, this.autoPay, this.taxCertificate, this.taxIdentifier, this.currency, this.salesRep, this.enabled, this.remainingDebitMemoBalance, this.remainingInvoiceBalance, this.remainingCreditMemoBalance, this.remainingPaymentBalance, this.billToId, this.soldToId, this.defaultPaymentMethod, this.billingDocuments, this.payments, this.paymentMethods, this.subscriptions, this.usageRecords, this.creditMemos, this.debitMemos, this.invoices);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    billingDocumentSettings: ").append(this.toIndentedString(this.billingDocumentSettings)).append("\n");
        sb.append("    batch: ").append(this.toIndentedString(this.batch)).append("\n");
        sb.append("    billCycleDay: ").append(this.toIndentedString(this.billCycleDay)).append("\n");
        sb.append("    billTo: ").append(this.toIndentedString(this.billTo)).append("\n");
        sb.append("    soldTo: ").append(this.toIndentedString(this.soldTo)).append("\n");
        sb.append("    communicationProfileId: ").append(this.toIndentedString(this.communicationProfileId)).append("\n");
        sb.append("    crmId: ").append(this.toIndentedString(this.crmId)).append("\n");
        sb.append("    defaultPaymentMethodId: ").append(this.toIndentedString(this.defaultPaymentMethodId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    parentAccountId: ").append(this.toIndentedString(this.parentAccountId)).append("\n");
        sb.append("    paymentGateway: ").append(this.toIndentedString(this.paymentGateway)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("    sequenceSetId: ").append(this.toIndentedString(this.sequenceSetId)).append("\n");
        sb.append("    autoPay: ").append(this.toIndentedString(this.autoPay)).append("\n");
        sb.append("    taxCertificate: ").append(this.toIndentedString(this.taxCertificate)).append("\n");
        sb.append("    taxIdentifier: ").append(this.toIndentedString(this.taxIdentifier)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    salesRep: ").append(this.toIndentedString(this.salesRep)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    remainingDebitMemoBalance: ").append(this.toIndentedString(this.remainingDebitMemoBalance)).append("\n");
        sb.append("    remainingInvoiceBalance: ").append(this.toIndentedString(this.remainingInvoiceBalance)).append("\n");
        sb.append("    remainingCreditMemoBalance: ").append(this.toIndentedString(this.remainingCreditMemoBalance)).append("\n");
        sb.append("    remainingPaymentBalance: ").append(this.toIndentedString(this.remainingPaymentBalance)).append("\n");
        sb.append("    billToId: ").append(this.toIndentedString(this.billToId)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    defaultPaymentMethod: ").append(this.toIndentedString(this.defaultPaymentMethod)).append("\n");
        sb.append("    billingDocuments: ").append(this.toIndentedString(this.billingDocuments)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    paymentMethods: ").append(this.toIndentedString(this.paymentMethods)).append("\n");
        sb.append("    subscriptions: ").append(this.toIndentedString(this.subscriptions)).append("\n");
        sb.append("    usageRecords: ").append(this.toIndentedString(this.usageRecords)).append("\n");
        sb.append("    creditMemos: ").append(this.toIndentedString(this.creditMemos)).append("\n");
        sb.append("    debitMemos: ").append(this.toIndentedString(this.debitMemos)).append("\n");
        sb.append("    invoices: ").append(this.toIndentedString(this.invoices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

