/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.UpdateOrderActionRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class OrderActionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OrderActionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrderActionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call updateOrderActionCall(String id, UpdateOrderActionRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateOrderActionRequest localVarPostBody = modifyRequest;
        String localVarPath = "/v1/orderActions/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOrderActionValidateBeforeCall(String id, UpdateOrderActionRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateOrderAction(Async)");
        }
        if (modifyRequest == null) {
            throw new ApiException("Missing the required parameter 'modifyRequest' when calling updateOrderAction(Async)");
        }
        return this.updateOrderActionCall(id, modifyRequest, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected CommonResponse updateOrderAction(String id, UpdateOrderActionRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.updateOrderActionWithHttpInfo(id, modifyRequest, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> updateOrderActionWithHttpInfo(String id, UpdateOrderActionRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.updateOrderActionValidateBeforeCall(id, modifyRequest, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateOrderActionAsync(String id, UpdateOrderActionRequest modifyRequest, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.updateOrderActionValidateBeforeCall(id, modifyRequest, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateOrderActionApi updateOrderActionApi(String id, UpdateOrderActionRequest modifyRequest) {
        return new UpdateOrderActionApi(id, modifyRequest);
    }

    public class UpdateOrderActionApi {
        private final String id;
        private final UpdateOrderActionRequest modifyRequest;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private UpdateOrderActionApi(String id, UpdateOrderActionRequest modifyRequest) {
            this.id = id;
            this.modifyRequest = modifyRequest;
        }

        public UpdateOrderActionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateOrderActionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateOrderActionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateOrderActionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateOrderActionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateOrderActionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OrderActionsApi.this.updateOrderActionCall(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = OrderActionsApi.this.updateOrderActionWithHttpInfo(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return OrderActionsApi.this.updateOrderActionWithHttpInfo(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return OrderActionsApi.this.updateOrderActionAsync(this.id, this.modifyRequest, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }
}

