/*
 * Decompiled with CFR 0.152.
 */
package com.zkejid.constructor.cliarguments.impl;

import com.zkejid.constructor.cliarguments.api.v1.Argument;
import com.zkejid.constructor.cliarguments.api.v1.ArgumentsParser;
import com.zkejid.constructor.cliarguments.api.v1.CliArgumentsException;
import com.zkejid.constructor.cliarguments.api.v1.ParseResult;
import com.zkejid.constructor.cliarguments.impl.ArgumentType;
import com.zkejid.constructor.cliarguments.impl.CommonsCliOptionArgument;
import com.zkejid.constructor.cliarguments.impl.ParseResultImpl;
import com.zkejid.constructor.stringvalue.api.v1.InputValueType;
import com.zkejid.constructor.stringvalue.api.v1.StringValue;
import com.zkejid.constructor.stringvalue.api.v1.StringValueFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommonsHelper;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public class CommonsCliParser
implements ArgumentsParser {
    private final List<CommonsCliOptionArgument> arguments = new ArrayList<CommonsCliOptionArgument>();
    private final List<String> excludedTokens = new ArrayList<String>();
    private final StringValueFactory stringValueFactory;
    private final Set<String> names = new HashSet<String>();

    public CommonsCliParser(StringValueFactory stringValueFactory) {
        Objects.requireNonNull(stringValueFactory, "require stringValueFactory");
        this.stringValueFactory = stringValueFactory;
    }

    public Argument addFlag(String shortName, String longName) {
        this.validateName(shortName, longName);
        Option opt = new Option(shortName, longName, false, "");
        CommonsCliOptionArgument argument = new CommonsCliOptionArgument(opt, ArgumentType.FLAG);
        this.arguments.add(argument);
        return argument;
    }

    public Argument addProperty(String shortName, String longName) {
        this.validateName(shortName, longName);
        Option opt = new Option(shortName, longName, true, "");
        CommonsCliOptionArgument argument = new CommonsCliOptionArgument(opt, ArgumentType.PROPERTY);
        this.arguments.add(argument);
        return argument;
    }

    public ParseResult parse(String[] args) {
        CommandLine cmd = this.safeParse(args);
        List<String> plainArguments = this.getPlainArguments(cmd);
        Map<Argument, StringValue> argumentsParsed = this.getArgumentsParsed(cmd);
        return new ParseResultImpl(plainArguments, argumentsParsed);
    }

    private void validateName(String shortName, String longName) {
        if (shortName == null && longName == null) {
            throw new CliArgumentsException("Either short name or long name should be specified");
        }
        if (shortName != null) {
            if (shortName.isEmpty()) {
                throw new CliArgumentsException("Short name could not be empty string");
            }
            if (shortName.length() != 1) {
                throw new CliArgumentsException("Short name should be 1 symbol long");
            }
            if (this.names.contains(shortName)) {
                throw new CliArgumentsException("Could not use name twice: " + shortName);
            }
            this.names.add(shortName);
        }
        if (longName != null) {
            if (longName.isEmpty()) {
                throw new CliArgumentsException("Long name could not be empty string");
            }
            if (longName.length() < 2) {
                throw new CliArgumentsException("Long name should be at least 2 symbols long");
            }
            if (this.names.contains(longName)) {
                throw new CliArgumentsException("Could not use name twice: " + longName);
            }
            this.names.add(longName);
        }
    }

    private CommandLine safeParse(String[] args) {
        CommandLine cmd = null;
        String[] currentArgs = args;
        DefaultParser parser = new DefaultParser();
        ArrayList<Option> emptyValueProperties = new ArrayList<Option>();
        while (cmd == null) {
            try {
                cmd = parser.parse(this.getOptions(), currentArgs);
            }
            catch (UnrecognizedOptionException e) {
                int oldValue = currentArgs.length;
                String tokenToRemove = e.getOption();
                currentArgs = this.removeUnrecognizedToken(currentArgs, tokenToRemove);
                if (currentArgs.length != oldValue - 1) {
                    throw new CliArgumentsException("Could not remove unrecognized token");
                }
                this.excludedTokens.add(tokenToRemove);
            }
            catch (MissingArgumentException e) {
                Option option = (Option)e.getOption().clone();
                CommonsHelper.addValueToOption(option, "");
                int oldValue = currentArgs.length;
                String tokenToRemove = this.getPropertyTokenFromOption(currentArgs, option);
                currentArgs = this.removeUnrecognizedToken(currentArgs, tokenToRemove);
                if (currentArgs.length != oldValue - 1) {
                    throw new CliArgumentsException("Could not remove token to handle empty argument");
                }
                emptyValueProperties.add(option);
            }
            catch (ParseException e) {
                throw new CliArgumentsException("Not able to parse ", (Throwable)e);
            }
        }
        for (Option option : emptyValueProperties) {
            CommonsHelper.addOptionToCmd(cmd, option);
        }
        this.verifyNoRepeatedOptions(cmd);
        return cmd;
    }

    private void verifyNoRepeatedOptions(CommandLine cmd) {
        Option[] options = cmd.getOptions();
        for (int i = 0; i < options.length; ++i) {
            Option currentOption = options[i];
            for (int j = i + 1; j < options.length; ++j) {
                Option otherOption = options[j];
                if (!otherOption.equals((Object)currentOption)) continue;
                throw new CliArgumentsException("There is a repeat in arguments: " + currentOption);
            }
        }
    }

    private String getPropertyTokenFromOption(String[] currentArgs, Option option) {
        String[] stringArray = currentArgs;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String token;
            String currentToken = token = stringArray[i];
            while (currentToken.startsWith("-")) {
                currentToken = currentToken.substring(1);
            }
            if (!currentToken.equals(option.getOpt()) && !currentToken.equals(option.getLongOpt())) continue;
            return token;
        }
        throw new CliArgumentsException("Could not find property with empty value: " + option);
    }

    private Options getOptions() {
        Options options = new Options();
        for (CommonsCliOptionArgument argument : this.arguments) {
            options.addOption(argument.getOption());
        }
        return options;
    }

    private Map<Argument, StringValue> getArgumentsParsed(CommandLine cmd) {
        HashMap<Argument, StringValue> result = new HashMap<Argument, StringValue>();
        for (CommonsCliOptionArgument argument : this.arguments) {
            StringValue stringValue = this.processArgument(cmd, argument);
            result.put(argument, stringValue);
        }
        return result;
    }

    private StringValue processArgument(CommandLine cmd, CommonsCliOptionArgument argument) {
        ArgumentType type = argument.getType();
        String name = argument.getName();
        if (ArgumentType.FLAG.equals((Object)type)) {
            boolean hasOption = cmd.hasOption(name);
            if (hasOption) {
                return this.stringValueFactory.make("true", InputValueType.SPECIFIED);
            }
            return this.stringValueFactory.make("false", InputValueType.OMITTED);
        }
        if (ArgumentType.PROPERTY.equals((Object)type)) {
            String value = cmd.getOptionValue(name);
            if (value == null) {
                return this.stringValueFactory.make("", InputValueType.OMITTED);
            }
            if (value.isEmpty()) {
                return this.stringValueFactory.make(value, InputValueType.EMPTY_VALUE);
            }
            return this.stringValueFactory.make(value, InputValueType.SPECIFIED);
        }
        throw new CliArgumentsException("Could not get type of " + name);
    }

    private List<String> getPlainArguments(CommandLine cmd) {
        ArrayList<String> plainArguments = new ArrayList<String>();
        plainArguments.addAll(this.excludedTokens);
        plainArguments.addAll(cmd.getArgList());
        return plainArguments;
    }

    private String[] removeUnrecognizedToken(String[] args, String token) {
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        if (!argsList.remove(token)) {
            throw new CliArgumentsException("Not able to remove unexpected token: " + token);
        }
        return argsList.toArray(new String[0]);
    }
}

