/*
 * Decompiled with CFR 0.152.
 */
package com.zhokhov.graphql.datetime;

import com.zhokhov.graphql.datetime.LocalDateTimeConverter;
import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Internal
public class GraphqlLocalDateTimeCoercing
implements Coercing<LocalDateTime, String> {
    private final DateTimeFormatter formatter;
    private final LocalDateTimeConverter converter;

    public GraphqlLocalDateTimeCoercing(boolean zoneConversionEnabled, DateTimeFormatter formatter) {
        this.formatter = formatter;
        this.converter = new LocalDateTimeConverter(zoneConversionEnabled, formatter);
    }

    private LocalDateTime convertImpl(Object input) {
        if (input instanceof String) {
            LocalDateTime localDateTime = this.converter.parseDate((String)input);
            if (localDateTime != null) {
                return localDateTime;
            }
        } else if (input instanceof LocalDateTime) {
            return (LocalDateTime)input;
        }
        return null;
    }

    public String serialize(Object input) {
        if (input instanceof LocalDateTime) {
            return this.converter.formatDate((LocalDateTime)input, this.formatter);
        }
        LocalDateTime result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException("Invalid value '" + input + "' for LocalDateTime");
        }
        return this.converter.formatDate(result, this.formatter);
    }

    public LocalDateTime parseValue(Object input) {
        LocalDateTime result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException("Invalid value '" + input + "' for LocalDateTime");
        }
        return result;
    }

    public LocalDateTime parseLiteral(Object input) {
        String value = ((StringValue)input).getValue();
        LocalDateTime result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException("Invalid value '" + input + "' for LocalDateTime");
        }
        return result;
    }
}

