/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush.key;

import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import com.zerodeplibs.webpush.key.BytesPrivateKeySource;
import com.zerodeplibs.webpush.key.FileUtil;
import com.zerodeplibs.webpush.key.KeyObjectPrivateKeySource;
import com.zerodeplibs.webpush.key.PEMParser;
import com.zerodeplibs.webpush.key.PEMParsers;
import com.zerodeplibs.webpush.key.PrivateKeySource;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.interfaces.ECPrivateKey;

public class PrivateKeySources {
    private PrivateKeySources() {
    }

    public static PrivateKeySource ofPKCS8Bytes(byte[] pkcs8Bytes) {
        return new BytesPrivateKeySource(pkcs8Bytes);
    }

    public static PrivateKeySource ofPEMText(String pemText) {
        return PrivateKeySources.ofPEMText(pemText, PEMParsers.ofStandard("PRIVATE KEY"));
    }

    public static PrivateKeySource ofPEMText(String pemText, PEMParser parser) {
        WebPushPreConditions.checkNotNull(parser, "parser");
        return PrivateKeySources.ofPKCS8Bytes(parser.parse(pemText));
    }

    public static PrivateKeySource ofPEMFile(Path path) throws IOException {
        return PrivateKeySources.getPEMFileSourceBuilder(path).build();
    }

    public static PrivateKeySource ofPEMFile(Path path, PEMParser parser) throws IOException {
        return PrivateKeySources.getPEMFileSourceBuilder(path).parser(parser).build();
    }

    public static PrivateKeySource ofDERFile(Path path) throws IOException {
        return PrivateKeySources.ofPKCS8Bytes(FileUtil.readAllBytes(path));
    }

    public static PrivateKeySource ofECPrivateKey(ECPrivateKey privateKey) {
        return new KeyObjectPrivateKeySource(privateKey);
    }

    public static PEMFileSourceBuilder getPEMFileSourceBuilder(Path path) {
        return new PEMFileSourceBuilder(path);
    }

    public static class PEMFileSourceBuilder {
        private final Path path;
        private Charset charset = StandardCharsets.UTF_8;
        private PEMParser parser = PEMParsers.ofStandard("PRIVATE KEY");

        PEMFileSourceBuilder(Path path) {
            WebPushPreConditions.checkNotNull(path, "path");
            this.path = path;
        }

        public PEMFileSourceBuilder charset(Charset charset) {
            WebPushPreConditions.checkNotNull(charset, "charset");
            this.charset = charset;
            return this;
        }

        public PEMFileSourceBuilder parser(PEMParser parser) {
            WebPushPreConditions.checkNotNull(parser, "parser");
            this.parser = parser;
            return this;
        }

        public PrivateKeySource build() throws IOException {
            return PrivateKeySources.ofPEMText(FileUtil.readAsString(this.path, this.charset), this.parser);
        }
    }
}

