/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush;

import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PushMessage {
    private final byte[] message;

    private PushMessage(byte[] messageBytes) {
        this.message = messageBytes;
    }

    public static PushMessage of(byte[] messageBytes) {
        WebPushPreConditions.checkArgument(messageBytes != null && messageBytes.length > 0, "messageBytes should not be null or empty.");
        return new PushMessage(Arrays.copyOf(messageBytes, messageBytes.length));
    }

    public static PushMessage ofUTF8(String messageText) {
        WebPushPreConditions.checkArgument(messageText != null && messageText.length() > 0, "messageText should not be null or empty.");
        return new PushMessage(messageText.getBytes(StandardCharsets.UTF_8));
    }

    byte[] getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PushMessage)) {
            return false;
        }
        PushMessage message1 = (PushMessage)o;
        return Arrays.equals(this.getMessage(), message1.getMessage());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getMessage());
    }

    public String toString() {
        return "PushMessage{message=" + Arrays.toString(this.message) + "}";
    }
}

