/*
 * Decompiled with CFR 0.152.
 */
package com.zerodeplibs.webpush;

import com.zerodeplibs.webpush.Aes128GcmEncryptedMessage;
import com.zerodeplibs.webpush.EncryptedPushMessage;
import com.zerodeplibs.webpush.MessageEncryption;
import com.zerodeplibs.webpush.MessageEncryptionException;
import com.zerodeplibs.webpush.PushMessage;
import com.zerodeplibs.webpush.UserAgentMessageEncryptionKeyInfo;
import com.zerodeplibs.webpush.internal.WebPushPreConditions;
import com.zerodeplibs.webpush.key.PublicKeySources;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class Aes128GcmMessageEncryption
implements MessageEncryption {
    private final SecureRandom secureRandom = new SecureRandom();
    private final Mac mac;
    private final byte[] keyInfoPref = Aes128GcmMessageEncryption.toInfoBytes("WebPush: info");
    private final byte[] cekInfo = Aes128GcmMessageEncryption.toInfoBytes("Content-Encoding: aes128gcm");
    private final byte[] nonceInfo = Aes128GcmMessageEncryption.toInfoBytes("Content-Encoding: nonce");

    Aes128GcmMessageEncryption() throws NoSuchAlgorithmException {
        this.mac = Mac.getInstance("HmacSHA256");
    }

    private static byte[] toInfoBytes(String text) {
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        byte[] ret = new byte[textBytes.length + 1];
        System.arraycopy(textBytes, 0, ret, 0, textBytes.length);
        ret[ret.length - 1] = 0;
        return ret;
    }

    @Override
    public EncryptedPushMessage encrypt(UserAgentMessageEncryptionKeyInfo userAgentMessageEncryptionKeyInfo, PushMessage pushMessage) {
        WebPushPreConditions.checkNotNull(userAgentMessageEncryptionKeyInfo, "userAgentMessageEncryptionKeyInfo");
        WebPushPreConditions.checkNotNull(pushMessage, "pushMessage");
        try {
            return this.encryptInternal(userAgentMessageEncryptionKeyInfo, pushMessage);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw MessageEncryptionException.withDefaultMessage(e);
        }
    }

    byte[] decrypt(UserAgentMessageEncryptionKeyInfo userAgentMessageEncryptionKeyInfo, Aes128GcmEncryptedMessage encrypted, ECPrivateKey uaPrivate) {
        try {
            return this.decryptInternal(userAgentMessageEncryptionKeyInfo, encrypted, uaPrivate);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw MessageEncryptionException.withDefaultMessage(e);
        }
    }

    private EncryptedPushMessage encryptInternal(UserAgentMessageEncryptionKeyInfo userAgentMessageEncryptionKeyInfo, PushMessage payload) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, NoSuchPaddingException, BadPaddingException {
        ECPublicKey uaPublic = userAgentMessageEncryptionKeyInfo.getPublicKey();
        KeyPair asKeyPair = this.generateAsKeyPair();
        PrivateKey asPrivate = asKeyPair.getPrivate();
        PublicKey asPublic = asKeyPair.getPublic();
        byte[] asPublicUncompressed = PublicKeySources.ofECPublicKey((ECPublicKey)asPublic).extractBytesInUncompressedForm();
        byte[] ecdhSecret = this.calcECDHSecret(asPrivate, uaPublic);
        byte[] salt = new byte[16];
        this.secureRandom.nextBytes(salt);
        CekAndNonce cekAndNonce = this.calcCekAndNonce(salt, ecdhSecret, userAgentMessageEncryptionKeyInfo.getAuthSecret(), userAgentMessageEncryptionKeyInfo.getUncompressedUaPublic(), asPublicUncompressed);
        byte[] cek = cekAndNonce.getCek();
        byte[] nonce = cekAndNonce.getNone();
        byte[] encrypted = this.encryptByAesGcm(nonce, cek, this.concatByteArrays(payload.getMessage(), {2}));
        byte[] header = this.concatByteArrays(salt, this.toRecordSizeBytes(encrypted.length), {(byte)asPublicUncompressed.length}, asPublicUncompressed);
        byte[] encryptedBytes = this.concatByteArrays(header, encrypted);
        return new Aes128GcmEncryptedMessage(encryptedBytes);
    }

    private byte[] decryptInternal(UserAgentMessageEncryptionKeyInfo userAgentMessageEncryptionKeyInfo, Aes128GcmEncryptedMessage encrypted, ECPrivateKey uaPrivate) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        byte[] salt = encrypted.extractSalt();
        byte[] uncompressedAsPublicKeyBytes = encrypted.extractUncompressedAsPublicKeyBytes();
        byte[] content = encrypted.extractContent();
        ECPublicKey asPublic = PublicKeySources.ofUncompressedBytes(uncompressedAsPublicKeyBytes).extract();
        byte[] ecdhSecret = this.calcECDHSecret(uaPrivate, asPublic);
        CekAndNonce cekAndNonce = this.calcCekAndNonce(salt, ecdhSecret, userAgentMessageEncryptionKeyInfo.getAuthSecret(), userAgentMessageEncryptionKeyInfo.getUncompressedUaPublic(), uncompressedAsPublicKeyBytes);
        byte[] cek = cekAndNonce.getCek();
        byte[] nonce = cekAndNonce.getNone();
        byte[] decrypted = this.decryptByAesGcm(nonce, cek, content);
        return this.stripPadding(decrypted);
    }

    private KeyPair generateAsKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        keyPairGenerator.initialize(new ECGenParameterSpec("secp256r1"));
        return keyPairGenerator.genKeyPair();
    }

    private byte[] calcECDHSecret(PrivateKey asPrivate, PublicKey uaPublic) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
        keyAgreement.init(asPrivate);
        keyAgreement.doPhase(uaPublic, true);
        return keyAgreement.generateSecret();
    }

    private CekAndNonce calcCekAndNonce(byte[] salt, byte[] ecdhSecret, byte[] authSecret, byte[] uaPublicUncompressed, byte[] asPublicUncompressed) throws InvalidKeyException {
        byte[] prkKey = this.hmac(authSecret, ecdhSecret);
        byte[] keyInfo = this.concatByteArrays(this.keyInfoPref, uaPublicUncompressed, asPublicUncompressed);
        byte[] ikm = this.hmac(prkKey, this.concatByteArrays(keyInfo, {1}));
        byte[] prk = this.hmac(salt, ikm);
        byte[] cek = this.hmac(prk, this.concatByteArrays(this.cekInfo, {1}));
        cek = Arrays.copyOfRange(cek, 0, 16);
        byte[] nonce = this.hmac(prk, this.concatByteArrays(this.nonceInfo, {1}));
        nonce = Arrays.copyOfRange(nonce, 0, 12);
        return new CekAndNonce(cek, nonce);
    }

    private byte[] hmac(byte[] salt, byte[] message) throws InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(salt, "HmacSHA256");
        this.mac.init(secretKeySpec);
        return this.mac.doFinal(message);
    }

    private byte[] encryptByAesGcm(byte[] iv, byte[] secretKey, byte[] data) throws InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        return this.processByteAesGcm(iv, secretKey, data, 1);
    }

    private byte[] decryptByAesGcm(byte[] iv, byte[] secretKey, byte[] data) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        return this.processByteAesGcm(iv, secretKey, data, 2);
    }

    private byte[] stripPadding(byte[] decryptedBytes) {
        int endIndexExclusive = -1;
        for (int i = decryptedBytes.length - 1; 0 <= i; --i) {
            byte v = decryptedBytes[i];
            if (v == 0) continue;
            if (v != 2) {
                throw new IllegalArgumentException("A single aes128gcm record must contain a padding delimiter whose value is 2.");
            }
            endIndexExclusive = i;
            break;
        }
        if (endIndexExclusive == -1) {
            throw new IllegalArgumentException("The record doesn't contain no non-zero octet.");
        }
        return Arrays.copyOfRange(decryptedBytes, 0, endIndexExclusive);
    }

    private byte[] processByteAesGcm(byte[] iv, byte[] secretKey, byte[] data, int encryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec param = new GCMParameterSpec(128, iv);
        cipher.init(encryptMode, (Key)secretKeySpec, param);
        return cipher.doFinal(data);
    }

    private byte[] toRecordSizeBytes(int size) {
        ByteBuffer bf = ByteBuffer.allocate(4);
        bf.putInt(size);
        return bf.array();
    }

    private byte[] concatByteArrays(byte[] ... byteArrays) {
        int totalLen = Arrays.stream(byteArrays).mapToInt(arr -> ((byte[])arr).length).sum();
        byte[] ret = new byte[totalLen];
        int currentDestStart = 0;
        for (byte[] arr2 : byteArrays) {
            System.arraycopy(arr2, 0, ret, currentDestStart, arr2.length);
            currentDestStart += arr2.length;
        }
        return ret;
    }

    private static class CekAndNonce {
        private final byte[] cek;
        private final byte[] none;

        CekAndNonce(byte[] cek, byte[] none) {
            this.cek = cek;
            this.none = none;
        }

        byte[] getCek() {
            return this.cek;
        }

        byte[] getNone() {
            return this.none;
        }
    }
}

