/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.SignJarParams;
import com.zenjava.javafx.maven.plugin.AbstractJfxToolsMojo;
import com.zenjava.javafx.maven.plugin.FileAssociation;
import com.zenjava.javafx.maven.plugin.NativeLauncher;
import com.zenjava.javafx.maven.plugin.Workarounds;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class NativeMojo
extends AbstractJfxToolsMojo {
    protected String identifier;
    protected String vendor;
    protected File nativeOutputDir;
    private String bundler;
    private Map<String, String> jvmProperties;
    private List<String> jvmArgs;
    private Map<String, String> userJvmArgs;
    private List<String> launcherArguments;
    private String nativeReleaseVersion;
    protected boolean needShortcut;
    protected boolean needMenu;
    protected Map<String, String> bundleArguments;
    protected String appName;
    protected boolean jfxCallFromCLI;
    protected File additionalAppResources;
    protected boolean skipNativeLauncherWorkaround124;
    protected List<NativeLauncher> secondaryLaunchers;
    protected boolean skipNativeLauncherWorkaround167;
    private List<FileAssociation> fileAssociations;
    protected boolean skipJNLPRessourcePathWorkaround182;
    protected File keyStore;
    protected String keyStoreAlias;
    protected String keyStorePassword;
    protected String keyPassword;
    protected String keyStoreType;
    protected boolean skipSigningJarFilesJNLP185;
    protected boolean skipSizeRecalculationForJNLP185;
    protected boolean noBlobSigning;
    protected List<String> customBundlers;
    protected boolean skipNativeLauncherWorkaround205;
    protected Workarounds workarounds = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.jfxCallFromCLI) {
            this.getLog().info((CharSequence)"call from CLI - skipping creation of Native Installers");
            return;
        }
        this.getLog().info((CharSequence)"Building Native Installers");
        this.workarounds = new Workarounds(this.nativeOutputDir, this.getLog());
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(StandardBundlerParam.VERBOSE.getID(), this.verbose);
            Optional.ofNullable(this.identifier).ifPresent(id -> params.put(StandardBundlerParam.IDENTIFIER.getID(), id));
            params.put(StandardBundlerParam.APP_NAME.getID(), this.appName);
            params.put(StandardBundlerParam.VERSION.getID(), this.nativeReleaseVersion);
            params.put(StandardBundlerParam.VENDOR.getID(), this.vendor);
            params.put(StandardBundlerParam.SHORTCUT_HINT.getID(), this.needShortcut);
            params.put(StandardBundlerParam.MENU_HINT.getID(), this.needMenu);
            params.put(StandardBundlerParam.MAIN_CLASS.getID(), this.mainClass);
            Optional.ofNullable(this.jvmProperties).ifPresent(jvmProps -> params.put(StandardBundlerParam.JVM_PROPERTIES.getID(), new HashMap(jvmProps)));
            Optional.ofNullable(this.jvmArgs).ifPresent(jvmOptions -> params.put(StandardBundlerParam.JVM_OPTIONS.getID(), new ArrayList(jvmOptions)));
            Optional.ofNullable(this.userJvmArgs).ifPresent(userJvmOptions -> params.put(StandardBundlerParam.USER_JVM_OPTIONS.getID(), new HashMap(userJvmOptions)));
            Optional.ofNullable(this.launcherArguments).ifPresent(arguments -> params.put(StandardBundlerParam.ARGUMENTS.getID(), new ArrayList(arguments)));
            Optional.ofNullable(this.additionalAppResources).filter(File::exists).ifPresent(appResources -> {
                try {
                    final Path targetFolder = this.jfxAppOutputDir.toPath();
                    final Path sourceFolder = appResources.toPath();
                    Files.walkFileTree(appResources.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path subfolder, BasicFileAttributes attrs) throws IOException {
                            Files.createDirectories(targetFolder.resolve(sourceFolder.relativize(subfolder)), new FileAttribute[0]);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path sourceFile, BasicFileAttributes attrs) throws IOException {
                            Files.copy(sourceFile, targetFolder.resolve(sourceFolder.relativize(sourceFile)), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path source, IOException ioe) throws IOException {
                            NativeMojo.this.getLog().warn((CharSequence)String.format("Couldn't copy additional app resource %s with reason %s", source.toString(), ioe.getLocalizedMessage()));
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path source, IOException ioe) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    this.getLog().warn((Throwable)e);
                }
            });
            HashSet resourceFiles = new HashSet();
            try {
                Files.walk(this.jfxAppOutputDir.toPath(), new FileVisitOption[0]).map(p -> p.toFile()).filter(File::isFile).filter(File::canRead).forEach(f -> {
                    this.getLog().info((CharSequence)String.format("Add %s file to application resources.", f));
                    resourceFiles.add(f);
                });
            }
            catch (IOException e) {
                this.getLog().warn((Throwable)e);
            }
            params.put(StandardBundlerParam.APP_RESOURCES.getID(), new RelativeFileSet(this.jfxAppOutputDir, resourceFiles));
            HashSet duplicateKeys = new HashSet();
            Optional.ofNullable(this.bundleArguments).ifPresent(bArguments -> {
                duplicateKeys.addAll(params.keySet());
                duplicateKeys.retainAll(bArguments.keySet());
                params.putAll((Map<String, Object>)bArguments);
            });
            if (!duplicateKeys.isEmpty()) {
                throw new MojoExecutionException("The following keys in <bundleArguments> duplicate other settings, please remove one or the other: " + ((Object)duplicateKeys).toString());
            }
            ArrayList<String> launcherNames = new ArrayList<String>();
            launcherNames.add(this.appName);
            AtomicBoolean nullLauncherNameFound = new AtomicBoolean(false);
            Optional.ofNullable(this.secondaryLaunchers).filter(list -> !list.isEmpty()).ifPresent(launchers -> {
                this.getLog().info((CharSequence)"Adding configuration for secondary native launcher");
                nullLauncherNameFound.set(launchers.stream().anyMatch(launcher -> launcher.getAppName() == null));
                if (!nullLauncherNameFound.get()) {
                    launcherNames.addAll(launchers.stream().map(launcher -> launcher.getAppName()).collect(Collectors.toList()));
                    params.put(StandardBundlerParam.SECONDARY_LAUNCHERS.getID(), launchers.stream().map(launcher -> {
                        this.getLog().info((CharSequence)("Adding secondary launcher: " + launcher.getAppName()));
                        HashMap<String, Object> secondaryLauncher = new HashMap<String, Object>();
                        this.addToMapWhenNotNull(launcher.getAppName(), StandardBundlerParam.APP_NAME.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getMainClass(), StandardBundlerParam.MAIN_CLASS.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getJfxMainAppJarName(), StandardBundlerParam.MAIN_JAR.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getNativeReleaseVersion(), StandardBundlerParam.VERSION.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getVendor(), StandardBundlerParam.VENDOR.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getIdentifier(), StandardBundlerParam.IDENTIFIER.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.isNeedMenu(), StandardBundlerParam.MENU_HINT.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.isNeedShortcut(), StandardBundlerParam.SHORTCUT_HINT.getID(), secondaryLauncher);
                        this.addToMapWhenNotNull(launcher.getClasspath(), StandardBundlerParam.CLASSPATH.getID(), secondaryLauncher);
                        Optional.ofNullable(launcher.getJvmArgs()).ifPresent(jvmOptions -> secondaryLauncher.put(StandardBundlerParam.JVM_OPTIONS.getID(), new ArrayList(jvmOptions)));
                        Optional.ofNullable(launcher.getJvmProperties()).ifPresent(jvmProps -> secondaryLauncher.put(StandardBundlerParam.JVM_PROPERTIES.getID(), new HashMap(jvmProps)));
                        Optional.ofNullable(launcher.getUserJvmArgs()).ifPresent(userJvmOptions -> secondaryLauncher.put(StandardBundlerParam.USER_JVM_OPTIONS.getID(), new HashMap(userJvmOptions)));
                        Optional.ofNullable(launcher.getLauncherArguments()).ifPresent(arguments -> params.put(StandardBundlerParam.ARGUMENTS.getID(), new ArrayList(arguments)));
                        return secondaryLauncher;
                    }).collect(Collectors.toList()));
                }
            });
            if (nullLauncherNameFound.get()) {
                throw new MojoExecutionException("Not all secondary launchers have been configured properly.");
            }
            HashSet duplicateLauncherNamesCheckSet = new HashSet();
            launcherNames.stream().forEach(launcherName -> duplicateLauncherNamesCheckSet.add(launcherName));
            if (duplicateLauncherNamesCheckSet.size() != launcherNames.size()) {
                throw new MojoExecutionException("Secondary launcher needs to have different name, please adjust appName inside your configuration.");
            }
            Optional.ofNullable(this.fileAssociations).ifPresent(associations -> {
                ArrayList allAssociations = new ArrayList();
                associations.stream().forEach(association -> {
                    HashMap<String, Object> settings = new HashMap<String, Object>();
                    settings.put(StandardBundlerParam.FA_DESCRIPTION.getID(), association.getDescription());
                    settings.put(StandardBundlerParam.FA_ICON.getID(), association.getIcon());
                    settings.put(StandardBundlerParam.FA_EXTENSIONS.getID(), association.getExtensions());
                    settings.put(StandardBundlerParam.FA_CONTENT_TYPE.getID(), association.getContentType());
                    allAssociations.add(settings);
                });
                params.put(StandardBundlerParam.FILE_ASSOCIATIONS.getID(), allAssociations);
            });
            if (this.workarounds.isWorkaroundForBug167Needed()) {
                if (!this.skipNativeLauncherWorkaround167) {
                    this.workarounds.applyWorkaround167(params);
                } else {
                    this.getLog().info((CharSequence)"Skipped workaround for native launcher regarding cfg-file-format.");
                }
            }
            Bundlers bundlers = Bundlers.createBundlersInstance();
            List existingBundlerIds = bundlers.getBundlers().stream().map(existingBundler -> existingBundler.getID()).collect(Collectors.toList());
            Optional.ofNullable(this.customBundlers).ifPresent(customBundlerList -> customBundlerList.stream().map(customBundlerClassName -> {
                try {
                    Class<?> customBundlerClass = Class.forName(customBundlerClassName);
                    Bundler newCustomBundler = (Bundler)customBundlerClass.newInstance();
                    if (existingBundlerIds.contains(newCustomBundler.getID())) {
                        return null;
                    }
                    return newCustomBundler;
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    this.getLog().warn((CharSequence)("There was an exception while creating a new instance of custom bundler: " + customBundlerClassName), (Throwable)ex);
                    return null;
                }
            }).filter(customBundler -> customBundler != null).forEach(customBundler -> bundlers.loadBundler(customBundler)));
            String cfgWorkaround205Marker = "cfgWorkaround205Marker";
            String cfgWorkaround205DoneMarker = "cfgWorkaround205Marker.done";
            boolean foundBundler = false;
            for (Bundler b : bundlers.getBundlers()) {
                try {
                    boolean runBundler = true;
                    if (this.bundler != null && !"ALL".equalsIgnoreCase(this.bundler) && !this.bundler.equalsIgnoreCase(b.getID())) {
                        runBundler = false;
                    }
                    if (System.getProperty("os.name").toLowerCase().startsWith("linux") && this.workarounds.isWorkaroundForBug205Needed() && !"jnlp".equalsIgnoreCase(this.bundler) && !"linux.app".equalsIgnoreCase(this.bundler) && "linux.app".equalsIgnoreCase(b.getID())) {
                        if (!this.skipNativeLauncherWorkaround205) {
                            this.getLog().info((CharSequence)"Detected linux application bundler needs to run before installer bundlers are executed.");
                            runBundler = true;
                            params.put("cfgWorkaround205Marker", "true");
                        } else {
                            this.getLog().info((CharSequence)"Skipped workaround for native linux installer bundlers.");
                        }
                    }
                    if (!runBundler) continue;
                    foundBundler = true;
                    HashMap<String, Object> paramsToBundleWith = new HashMap<String, Object>(params);
                    if (!b.validate(paramsToBundleWith)) continue;
                    b.execute(paramsToBundleWith, this.nativeOutputDir);
                    if (this.workarounds.isWorkaroundForBug124Needed() && "linux.app".equals(b.getID())) {
                        this.getLog().info((CharSequence)"Applying workaround for oracle-jdk-bug since 1.8.0u40 regarding native linux launcher(s).");
                        if (!this.skipNativeLauncherWorkaround124) {
                            this.workarounds.applyWorkaround124(this.appName, this.secondaryLaunchers);
                            if (Boolean.parseBoolean(String.valueOf(params.get("cfgWorkaround205Marker"))) && !Boolean.parseBoolean((String)params.get("cfgWorkaround205Marker.done"))) {
                                this.getLog().info((CharSequence)"Preparing workaround for oracle-jdk-bug since 1.8.0u40 regarding native linux launcher(s) inside native linux installers.");
                                this.workarounds.applyWorkaround205(this.appName, this.secondaryLaunchers, params);
                                params.put("cfgWorkaround205Marker.done", "true");
                            }
                        } else {
                            this.getLog().info((CharSequence)"Skipped workaround for native linux launcher(s).");
                        }
                    }
                    if (!"jnlp".equals(b.getID())) continue;
                    if (this.workarounds.isWorkaroundForBug182Needed()) {
                        this.getLog().info((CharSequence)"Applying workaround for oracle-jdk-bug since 1.8.0u60 regarding jar-path inside generated JNLP-files.");
                        if (!this.skipJNLPRessourcePathWorkaround182) {
                            this.workarounds.fixPathsInsideJNLPFiles();
                        } else {
                            this.getLog().info((CharSequence)"Skipped workaround for jar-paths jar-path inside generated JNLP-files.");
                        }
                    }
                    if (!this.workarounds.isWorkaroundForBug185Needed(params)) continue;
                    this.getLog().info((CharSequence)"Signing jar-files referenced inside generated JNLP-files.");
                    if (!this.skipSigningJarFilesJNLP185) {
                        if (!this.noBlobSigning) {
                            this.getLog().info((CharSequence)"Signing jar-files using BLOB method.");
                            this.signJarFilesUsingBlobSigning();
                        } else {
                            this.getLog().info((CharSequence)"Signing jar-files using jarsigner.");
                            this.signJarFiles();
                        }
                        this.workarounds.applyWorkaround185(this.skipSizeRecalculationForJNLP185);
                        continue;
                    }
                    this.getLog().info((CharSequence)"Skipped signing jar-files referenced inside JNLP-files.");
                }
                catch (UnsupportedPlatformException runBundler) {
                }
                catch (ConfigException e) {
                    this.getLog().info((CharSequence)("Skipping " + b.getName() + " because of configuration error " + e.getMessage() + "\nAdvice to Fix: " + e.getAdvice()));
                }
            }
            if (!foundBundler) {
                this.getLog().warn((CharSequence)("No bundler found for given id " + this.bundler + ". Please check your configuration."));
            }
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("An error occurred while generating native deployment bundles", (Exception)e);
        }
        catch (PackagerException ex) {
            throw new MojoExecutionException("An error occurred while generating native deployment bundles", (Exception)((Object)ex));
        }
    }

    private void addToMapWhenNotNull(Object value, String key, Map<String, Object> map) {
        if (value == null) {
            return;
        }
        map.put(key, value);
    }

    private void signJarFilesUsingBlobSigning() throws MojoFailureException, PackagerException, MojoExecutionException {
        this.checkSigningConfiguration();
        SignJarParams signJarParams = new SignJarParams();
        signJarParams.setVerbose(this.verbose.booleanValue());
        signJarParams.setKeyStore(this.keyStore);
        signJarParams.setAlias(this.keyStoreAlias);
        signJarParams.setStorePass(this.keyStorePassword);
        signJarParams.setKeyPass(this.keyPassword);
        signJarParams.setStoreType(this.keyStoreType);
        signJarParams.addResource(this.nativeOutputDir, this.jfxMainAppJarName);
        this.workarounds.getJARFilesFromJNLPFiles().forEach(jarFile -> signJarParams.addResource(this.nativeOutputDir, jarFile));
        this.getLog().info((CharSequence)"Signing JAR files for jnlp bundle using BLOB-method");
        this.getPackagerLib().signJar(signJarParams);
    }

    private void signJarFiles() throws MojoFailureException, PackagerException, MojoExecutionException {
        this.checkSigningConfiguration();
        AtomicReference exception = new AtomicReference();
        this.workarounds.getJARFilesFromJNLPFiles().stream().map(relativeJarFilePath -> new File(this.nativeOutputDir, (String)relativeJarFilePath)).forEach(jarFile -> {
            try {
                if (exception.get() == null) {
                    this.signJar(jarFile.getAbsoluteFile());
                }
            }
            catch (MojoExecutionException ex) {
                exception.set(ex);
            }
        });
        if (exception.get() != null) {
            throw (MojoExecutionException)((Object)exception.get());
        }
    }

    private void checkSigningConfiguration() throws MojoFailureException {
        if (!this.keyStore.exists()) {
            throw new MojoFailureException("Keystore does not exist, use 'jfx:generate-key-store' command to make one (expected at: " + this.keyStore + ")");
        }
        if (this.keyStoreAlias == null || this.keyStoreAlias.isEmpty()) {
            throw new MojoFailureException("A 'keyStoreAlias' is required for signing JARs");
        }
        if (this.keyStorePassword == null || this.keyStorePassword.isEmpty()) {
            throw new MojoFailureException("A 'keyStorePassword' is required for signing JARs");
        }
        if (this.keyPassword == null) {
            this.keyPassword = this.keyStorePassword;
        }
    }

    private void signJar(File jarFile) throws MojoExecutionException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getEnvironmentRelativeExecutablePath() + "jarsigner");
        command.add("-strict");
        command.add("-keystore");
        command.add(this.keyStore.getAbsolutePath());
        command.add("-storepass");
        command.add(this.keyStorePassword);
        command.add("-keypass");
        command.add(this.keyPassword);
        command.add(jarFile.getAbsolutePath());
        command.add(this.keyStoreAlias);
        if (this.verbose.booleanValue()) {
            command.add("-verbose");
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]).inheritIO().directory(this.project.getBasedir()).command(command);
            this.getLog().info((CharSequence)"Signing JAR files for jnlp bundle using jarsigner-method");
            Process p = pb.start();
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new MojoExecutionException("Signing jar using jarsigner wasn't successful! Please check build-log.");
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("There was an exception while signing jar-file: " + jarFile.getAbsolutePath(), ex);
        }
    }
}

